/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.ETriggerActionTime;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TDmlEventClause;
import gudusoft.gsqlparser.nodes.TDmlEventItem;
import gudusoft.gsqlparser.nodes.TDummy;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.TTriggerEventClause;
import gudusoft.gsqlparser.nodes.TTriggerReferencingClause;
import gudusoft.gsqlparser.stmt.TCreateTriggerStmt;
import gudusoft.gsqlparser.stmt.oracle.TPlsqlCreateTrigger;

public class TTriggeringClause
extends TParseTreeNode {
    private TTriggerReferencingClause referencingClause;
    private TTriggerEventClause eventClause;
    private ETriggerActionTime actionTime;
    private TDmlEventClause dmlEventClause = null;
    private TDummy before_after_insteadOf = null;
    private int fireMode = 2;

    public void setReferencingClause(TTriggerReferencingClause referencingClause) {
        this.referencingClause = referencingClause;
    }

    public TTriggerReferencingClause getReferencingClause() {
        return this.referencingClause;
    }

    public void setEventClause(TTriggerEventClause eventClause) {
        this.eventClause = eventClause;
    }

    public TTriggerEventClause getEventClause() {
        return this.eventClause;
    }

    public void setActionTime(ETriggerActionTime actionTime) {
        this.actionTime = actionTime;
    }

    public void setActionTimeByDummy(TDummy dummy) {
        if (dummy.int1 == 0) {
            this.actionTime = ETriggerActionTime.tatFor;
        } else if (dummy.int1 == 1) {
            this.actionTime = ETriggerActionTime.tatAfter;
        } else if (dummy.int1 == 2) {
            this.actionTime = ETriggerActionTime.tatInsteadOf;
        }
    }

    public ETriggerActionTime getActionTime() {
        return this.actionTime;
    }

    @Override
    public void init(Object arg1) {
        this.eventClause = (TTriggerEventClause)arg1;
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.init(arg1);
        TSourceToken st = (TSourceToken)arg2;
        if (st.toString().equalsIgnoreCase("after")) {
            this.actionTime = ETriggerActionTime.tatAfter;
        } else if (st.toString().equalsIgnoreCase("before")) {
            this.actionTime = ETriggerActionTime.tatBefore;
        }
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        if ((psql instanceof TPlsqlCreateTrigger || psql instanceof TCreateTriggerStmt) && this.eventClause instanceof TDmlEventClause) {
            TDmlEventClause dmlEventClause = (TDmlEventClause)this.eventClause;
            TTable lcTable = new TTable();
            lcTable.setTableType(ETableSource.objectname);
            lcTable.setTableName(dmlEventClause.getTableName());
            TDmlEventItem dmlEventItem = (TDmlEventItem)dmlEventClause.getEventItems().get(0);
            switch (dmlEventItem.getDmlType()) {
                case sstinsert: {
                    lcTable.setEffectType(ETableEffectType.tetTriggerInsert);
                    break;
                }
                case sstupdate: {
                    lcTable.setEffectType(ETableEffectType.tetTriggerUpdate);
                    break;
                }
                case sstdelete: {
                    lcTable.setEffectType(ETableEffectType.tetTriggerDelete);
                    break;
                }
                default: {
                    lcTable.setEffectType(ETableEffectType.tetTriggerOn);
                }
            }
            psql.tables.addTable(lcTable);
        }
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public TDmlEventClause getDmlEventClause() {
        return this.dmlEventClause;
    }

    public int getFireMode() {
        return this.fireMode;
    }

    public void setDmlEventClause(TDmlEventClause dmlEventClause) {
        this.dmlEventClause = dmlEventClause;
    }

    public void setFireMode(int fireMode) {
        this.fireMode = fireMode;
    }
}

