/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.TBaseType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TCTE;
import gudusoft.gsqlparser.nodes.TContainsTable;
import gudusoft.gsqlparser.nodes.TDataChangeTable;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TFlashback;
import gudusoft.gsqlparser.nodes.TFromTableList;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TInformixOuterClause;
import gudusoft.gsqlparser.nodes.TJsonTable;
import gudusoft.gsqlparser.nodes.TMultiTargetList;
import gudusoft.gsqlparser.nodes.TNodeWithAliasClause;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TOpenDatasource;
import gudusoft.gsqlparser.nodes.TOpenQuery;
import gudusoft.gsqlparser.nodes.TOpenRowSet;
import gudusoft.gsqlparser.nodes.TOpenXML;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TPartitionExtensionClause;
import gudusoft.gsqlparser.nodes.TPivotClause;
import gudusoft.gsqlparser.nodes.TPivotedTable;
import gudusoft.gsqlparser.nodes.TPxGranule;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.nodes.TTableHint;
import gudusoft.gsqlparser.nodes.TTableReference;
import gudusoft.gsqlparser.nodes.TTableReferenceList;
import gudusoft.gsqlparser.nodes.TTableSample;
import gudusoft.gsqlparser.nodes.TXmlTable;
import gudusoft.gsqlparser.nodes.bigquery.TUnnestClause;
import gudusoft.gsqlparser.nodes.hive.THiveKeyValueProperty;
import gudusoft.gsqlparser.nodes.hive.THiveLateralView;
import gudusoft.gsqlparser.nodes.teradata.TTDUnpivot;
import gudusoft.gsqlparser.stmt.TMergeSqlStatement;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.hive.THiveFromQuery;

public class TTable
extends TNodeWithAliasClause {
    private TJsonTable jsonTable;
    private TTDUnpivot tdUnpivot;
    private TUnnestClause unnestClause;
    private TResultColumnList columnListInTempTable;
    private TPxGranule pxGranule;
    private TFlashback flashback;
    private int parenthesisCount = 0;
    private int parenthesisAfterAliasCount = 0;
    private boolean tableKeyword = false;
    private boolean onlyKeyword = false;
    private TMergeSqlStatement outputMerge;
    private TPivotedTable pivotedTable;
    private ETableEffectType effectType;
    private TTable linkTable;
    private boolean isLinkTable;
    private TPTNodeList<THiveKeyValueProperty> tableProperties;
    private TPTNodeList<THiveLateralView> lateralViewList;
    private TTableSample tableSample;
    private TPartitionExtensionClause partitionExtensionClause;
    private TInformixOuterClause outerClause;
    private TXmlTable xmlTable;
    private TFromTableList fromTableList;
    private TOpenQuery openquery = null;
    private TPTNodeList<TTableHint> tableHintList;
    private TOpenDatasource openDatasource = null;
    private TOpenXML openXML = null;
    private TOpenRowSet openRowSet = null;
    private TContainsTable containsTable = null;
    private TFunctionCall funcCall = null;
    private TMultiTargetList rowList;
    private TObjectNameList cteColomnReferences = null;
    private TCTE CTE;
    private boolean isCTEName = false;
    public TSelectSqlStatement subquery = null;
    private THiveFromQuery hiveFromQuery;
    private TExpression tableExpr;
    private ETableSource tableType;
    private TObjectName tableName;
    private TObjectNameList linkedColumns = null;
    private TPivotClause pivotClause = null;
    private TObjectNameList objectNameReferences = null;
    public TTableReferenceList tablerefs = new TTableReferenceList();
    private TDataChangeTable datachangeTable = null;

    public void setJsonTable(TJsonTable jsonTable) {
        this.jsonTable = jsonTable;
    }

    public TJsonTable getJsonTable() {
        return this.jsonTable;
    }

    public void setPropertyFromObjectName(TObjectName objectName, ETableEffectType tableEffectType) {
        this.setStartToken(objectName.getStartToken());
        this.setEndToken(objectName.getEndToken());
        this.setGsqlparser(objectName.getGsqlparser());
        this.setEffectType(tableEffectType);
        this.setTableType(ETableSource.objectname);
    }

    public void setTdUnpivot(TTDUnpivot tdUnpivot) {
        this.tdUnpivot = tdUnpivot;
    }

    public TTDUnpivot getTdUnpivot() {
        return this.tdUnpivot;
    }

    public void setUnnestClause(TUnnestClause unnestClause) {
        this.unnestClause = unnestClause;
    }

    public TUnnestClause getUnnestClause() {
        return this.unnestClause;
    }

    public void setColumnListInTempTable(TResultColumnList columnListInTempTable) {
        this.columnListInTempTable = columnListInTempTable;
    }

    public TResultColumnList getColumnListInTempTable() {
        return this.columnListInTempTable;
    }

    public void setPxGranule(TPxGranule pxGranule) {
        this.pxGranule = pxGranule;
    }

    public TPxGranule getPxGranule() {
        return this.pxGranule;
    }

    public void setFlashback(TFlashback flashback) {
        this.flashback = flashback;
    }

    public TFlashback getFlashback() {
        return this.flashback;
    }

    public void setTableKeyword(boolean tableKeyword) {
        this.tableKeyword = tableKeyword;
    }

    public void setOnlyKeyword(boolean onlyKeyword) {
        this.onlyKeyword = onlyKeyword;
    }

    public boolean isTableKeyword() {
        return this.tableKeyword;
    }

    public boolean isOnlyKeyword() {
        return this.onlyKeyword;
    }

    public void setParenthesisCount(int parenthesisCount) {
        this.parenthesisCount = parenthesisCount;
    }

    public void setParenthesisAfterAliasCount(int parenthesisAfterAliasCount) {
        this.parenthesisAfterAliasCount = parenthesisAfterAliasCount;
    }

    public int getParenthesisCount() {
        return this.parenthesisCount;
    }

    public int getParenthesisAfterAliasCount() {
        return this.parenthesisAfterAliasCount;
    }

    public void setOutputMerge(TMergeSqlStatement outputMerge) {
        this.outputMerge = outputMerge;
    }

    public TMergeSqlStatement getOutputMerge() {
        return this.outputMerge;
    }

    public void setPivotedTable(TPivotedTable pivotedTable) {
        this.pivotedTable = pivotedTable;
    }

    public TPivotedTable getPivotedTable() {
        return this.pivotedTable;
    }

    public void setEffectType(ETableEffectType effectType) {
        this.effectType = effectType;
    }

    public ETableEffectType getEffectType() {
        return this.effectType;
    }

    public void setLinkTable(TTable linkTable) {
        this.linkTable = linkTable;
        this.isLinkTable = this.linkTable != null;
    }

    public TTable getLinkTable() {
        return this.linkTable;
    }

    public boolean isLinkTable() {
        return this.isLinkTable;
    }

    public void setLinkTable(boolean isLinkTable) {
        this.isLinkTable = isLinkTable;
    }

    public String getAliasName() {
        if (this.getAliasClause() == null) {
            return "";
        }
        return this.getAliasClause().getAliasName().toString();
    }

    public boolean equalByName(String pTableName) {
        if (this.getAliasClause() != null) {
            return this.getAliasClause().getAliasName().toString().equalsIgnoreCase(pTableName);
        }
        return this.getName().equalsIgnoreCase(pTableName);
    }

    public void setTableProperties(TPTNodeList<THiveKeyValueProperty> tableProperties) {
        this.tableProperties = tableProperties;
    }

    public TPTNodeList<THiveKeyValueProperty> getTableProperties() {
        return this.tableProperties;
    }

    public void setLateralViewList(TPTNodeList<THiveLateralView> lateralViewList) {
        this.lateralViewList = lateralViewList;
    }

    public TPTNodeList<THiveLateralView> getLateralViewList() {
        return this.lateralViewList;
    }

    public void setTableSample(TTableSample tableSample) {
        this.tableSample = tableSample;
    }

    public TTableSample getTableSample() {
        return this.tableSample;
    }

    public void setPartitionExtensionClause(TPartitionExtensionClause partitionExtensionClause) {
        this.partitionExtensionClause = partitionExtensionClause;
    }

    public TPartitionExtensionClause getPartitionExtensionClause() {
        return this.partitionExtensionClause;
    }

    public void setOuterClause(TInformixOuterClause outerClause) {
        this.outerClause = outerClause;
    }

    public TInformixOuterClause getOuterClause() {
        return this.outerClause;
    }

    public void setFromTableList(TFromTableList fromTableList) {
        this.fromTableList = fromTableList;
    }

    public TFromTableList getFromTableList() {
        return this.fromTableList;
    }

    public TXmlTable getXmlTable() {
        return this.xmlTable;
    }

    public void setXmlTable(TXmlTable xmlTable) {
        this.xmlTable = xmlTable;
    }

    public void setTableHintList(TPTNodeList<TTableHint> tableHintList) {
        this.tableHintList = tableHintList;
    }

    public TPTNodeList<TTableHint> getTableHintList() {
        return this.tableHintList;
    }

    public TOpenQuery getOpenquery() {
        return this.openquery;
    }

    public TSelectSqlStatement getSubquery() {
        return this.subquery;
    }

    public void setOpenquery(TOpenQuery openquery) {
        this.openquery = openquery;
    }

    public void setOpenDatasource(TOpenDatasource openDatasource) {
        this.openDatasource = openDatasource;
    }

    public TOpenDatasource getOpenDatasource() {
        return this.openDatasource;
    }

    public void setOpenXML(TOpenXML openXML) {
        this.openXML = openXML;
    }

    public TOpenXML getOpenXML() {
        return this.openXML;
    }

    public TOpenRowSet getOpenRowSet() {
        return this.openRowSet;
    }

    public void setOpenRowSet(TOpenRowSet openRowSet) {
        this.openRowSet = openRowSet;
    }

    public TContainsTable getContainsTable() {
        return this.containsTable;
    }

    public void setContainsTable(TContainsTable containsTable) {
        this.containsTable = containsTable;
    }

    public TFunctionCall getFuncCall() {
        return this.funcCall;
    }

    public void setFuncCall(TFunctionCall funcCall) {
        this.funcCall = funcCall;
    }

    public TMultiTargetList getRowList() {
        return this.rowList;
    }

    public boolean isBaseTable() {
        boolean retval;
        boolean bl = retval = this.tableType == ETableSource.objectname;
        if (retval && this.isCTEName()) {
            retval = false;
        }
        if (retval && this.getFullName().startsWith("@")) {
            retval = false;
        }
        return retval;
    }

    public void setCteColomnReferences(TObjectNameList cteColomnReferences) {
        this.cteColomnReferences = cteColomnReferences;
    }

    public TObjectNameList getCteColomnReferences() {
        return this.cteColomnReferences;
    }

    public void setObjectNameReferences(TObjectNameList objectNameReferences) {
        this.objectNameReferences = objectNameReferences;
    }

    public void setCTE(TCTE CTE) {
        this.CTE = CTE;
    }

    public TCTE getCTE() {
        return this.CTE;
    }

    public boolean isCTEName() {
        return this.isCTEName;
    }

    public void setCTEName(boolean CTEName) {
        this.isCTEName = CTEName;
    }

    public void setHiveFromQuery(THiveFromQuery hiveFromQuery) {
        this.hiveFromQuery = hiveFromQuery;
    }

    public THiveFromQuery getHiveFromQuery() {
        return this.hiveFromQuery;
    }

    public TExpression getTableExpr() {
        return this.tableExpr;
    }

    public void setTableExpr(TExpression tableExpr) {
        this.tableExpr = tableExpr;
    }

    public void setTableType(ETableSource tableType) {
        this.tableType = tableType;
    }

    public ETableSource getTableType() {
        return this.tableType;
    }

    public void setTableName(TObjectName tableName) {
        this.tableName = tableName;
        this.tableType = ETableSource.objectname;
        if (this.getStartToken() == null) {
            this.setStartToken(tableName.getStartToken());
        }
        if (this.getEndToken() == null) {
            this.setEndToken(tableName.getEndToken());
        }
    }

    public TObjectName getTableName() {
        TObjectName ret = this.tableName;
        if (this.tableType == null) {
            return ret;
        }
        switch (this.tableType) {
            case tableExpr: {
                if (this.tableExpr.getExpressionType() != EExpressionType.function_t) break;
                ret = this.tableExpr.getFunctionCall().getFunctionName();
                break;
            }
            case function: {
                ret = this.getFuncCall().getFunctionName();
                break;
            }
            case openrowset: {
                ret = new TObjectName(new TSourceToken("openrowset"), EDbObjectType.table);
                break;
            }
            case rowList: {
                ret = new TObjectName(new TSourceToken("rowlist"), EDbObjectType.table);
                break;
            }
            case subquery: {
                ret = new TObjectName(new TSourceToken("subquery"), EDbObjectType.table);
                break;
            }
            case td_unpivot: {
                ret = new TObjectName(new TSourceToken("td_unpivot"), EDbObjectType.table);
                break;
            }
            case xmltable: {
                ret = new TObjectName(new TSourceToken("xmltable"), EDbObjectType.table);
                break;
            }
            case jsonTable: {
                ret = new TObjectName(new TSourceToken("jsontable"), EDbObjectType.table);
                break;
            }
            case containsTable: {
                if (this.containsTable.getType() == 1) {
                    ret = new TObjectName(new TSourceToken("containsTable"), EDbObjectType.table);
                    break;
                }
                ret = new TObjectName(new TSourceToken("freetexttable"), EDbObjectType.table);
                break;
            }
            case opendatasource: {
                ret = new TObjectName(new TSourceToken("opendatasource"), EDbObjectType.table);
                break;
            }
            case unnest: {
                ret = new TObjectName(new TSourceToken("unnest"), EDbObjectType.table);
                break;
            }
            case openxml: {
                ret = new TObjectName(new TSourceToken("openxml"), EDbObjectType.table);
                break;
            }
            case openquery: {
                ret = new TObjectName(new TSourceToken("openquery"), EDbObjectType.table);
                break;
            }
            case output_merge: {
                ret = new TObjectName(new TSourceToken("merge"), EDbObjectType.table);
            }
        }
        if (ret == null) {
            return new TObjectName(new TSourceToken("unknown"), EDbObjectType.table);
        }
        return ret;
    }

    public TTable(TObjectName pobjectname) {
        this.tableName = pobjectname;
    }

    @Override
    public String toString() {
        String ret = super.toString();
        if (ret != null) {
            return ret;
        }
        if (this.tableName != null) {
            return this.tableName.getObjectString();
        }
        return null;
    }

    public TTable() {
        this.tableName = null;
    }

    public String getName() {
        if (this.tableName != null) {
            return this.tableName.getObjectString();
        }
        return this.getTableName().toString();
    }

    public String getPrefixServer() {
        if (this.tableName != null) {
            return this.tableName.getServerString();
        }
        return "";
    }

    public String getPrefixDatabase() {
        if (this.tableName != null) {
            return this.tableName.getDatabaseString();
        }
        return "";
    }

    public String getPrefixSchema() {
        if (this.tableName != null) {
            return this.tableName.getSchemaString();
        }
        return "";
    }

    public boolean isIncludeColumnAlias() {
        return false;
    }

    public boolean searchColumnInAlias(TObjectName pColumn) {
        if (this.getAliasClause() == null) {
            return false;
        }
        return this.getAliasClause().searchColumn(pColumn);
    }

    public boolean checkTableByName(String pTablename) {
        boolean lcResult = false;
        String b = TBaseType.getTextWithoutQuoted(pTablename);
        if (this.getAliasClause() != null) {
            String a = TBaseType.getTextWithoutQuoted(this.getAliasName());
            lcResult = a.equalsIgnoreCase(b);
        }
        if (lcResult) {
            return true;
        }
        String c = TBaseType.getTextWithoutQuoted(this.getTableName().toString());
        lcResult = c.equalsIgnoreCase(b);
        return lcResult;
    }

    public boolean searchColumn(TSelectSqlStatement select, String tableName, TObjectName pColumn, boolean pMustIn) {
        boolean lcResult = false;
        boolean isSameTable = false;
        isSameTable = tableName.length() == 0 ? true : this.checkTableByName(tableName);
        if (!isSameTable) {
            return lcResult;
        }
        if (this.isBaseTable()) {
            lcResult = select.fireOnMetaDatabaseTableColumn(this.getPrefixServer(), this.getPrefixDatabase(), this.getPrefixSchema(), this.getName(), pColumn.getColumnNameOnly());
        } else if (this.getTableType() == ETableSource.subquery) {
            lcResult = this.isIncludeColumnAlias() ? this.searchColumnInAlias(pColumn) : this.getSubquery().searchColumnInResultSet(pColumn, pMustIn);
        } else if (this.isCTEName()) {
            lcResult = this.getCTE().searchColumnInResultSet(select, this, pColumn, pMustIn);
        }
        if (lcResult) {
            this.getLinkedColumns().addObjectName(pColumn);
            pColumn.setSourceTable(this);
        } else if (pMustIn) {
            this.getLinkedColumns().addObjectName(pColumn);
            pColumn.setSourceTable(this);
            lcResult = true;
        }
        return lcResult;
    }

    public TObjectNameList getLinkedColumns() {
        if (this.linkedColumns == null) {
            this.linkedColumns = new TObjectNameList();
            this.linkedColumns.setObjectType(1);
        }
        return this.linkedColumns;
    }

    public String getFullNameWithAliasString() {
        if (this.getAliasClause() != null) {
            return this.getFullName() + " " + this.getAliasClause().toString();
        }
        return this.getFullName();
    }

    public String getFullName() {
        if (this.tableName == null) {
            return null;
        }
        return this.tableName.toString();
    }

    public TObjectNameList getObjectNameReferences() {
        if (this.objectNameReferences == null) {
            this.objectNameReferences = new TObjectNameList();
            this.objectNameReferences.setObjectType(1);
        }
        return this.objectNameReferences;
    }

    public void setPivotClause(TPivotClause pivotClause) {
        this.pivotClause = pivotClause;
    }

    public TPivotClause getPivotClause() {
        return this.pivotClause;
    }

    public void setDatachangeTable(TDataChangeTable datachangeTable) {
        this.datachangeTable = datachangeTable;
    }

    public TDataChangeTable getDatachangeTable() {
        return this.datachangeTable;
    }

    public boolean isTableRefBelongToThisTable(TTableReference tableref) {
        boolean retval;
        boolean bl = retval = this.tableName == tableref.objectname;
        if (retval) {
            return retval;
        }
        if (this.tableName.getObjectString().equalsIgnoreCase(tableref.objectname.getObjectString())) {
            retval = this.tableName.getSchemaString() == null || tableref.objectname.getSchemaString() == null ? true : this.tableName.getSchemaString().equalsIgnoreCase(tableref.objectname.getSchemaString());
        }
        return retval;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        switch (this.getTableType()) {
            case objectname: {
                this.getTableName().acceptChildren(v);
                if (this.getFlashback() == null) break;
                this.getFlashback().acceptChildren(v);
                break;
            }
            case tableExpr: {
                this.getTableExpr().acceptChildren(v);
                break;
            }
            case subquery: {
                this.getSubquery().acceptChildren(v);
                break;
            }
            case function: {
                this.getFuncCall().acceptChildren(v);
                break;
            }
            case pivoted_table: {
                this.getPivotedTable().acceptChildren(v);
                break;
            }
            case output_merge: {
                break;
            }
            case containsTable: {
                this.getContainsTable().acceptChildren(v);
                break;
            }
            case openrowset: {
                this.getOpenRowSet().acceptChildren(v);
                break;
            }
            case openxml: {
                this.getOpenXML().acceptChildren(v);
                break;
            }
            case opendatasource: {
                this.getOpenDatasource().acceptChildren(v);
                break;
            }
            case openquery: {
                this.getOpenquery().acceptChildren(v);
                break;
            }
            case datachangeTable: {
                this.getDatachangeTable().acceptChildren(v);
                break;
            }
            case rowList: {
                this.getRowList().acceptChildren(v);
                break;
            }
            case xmltable: {
                this.getXmlTable().acceptChildren(v);
                break;
            }
            case jsonTable: {
                this.getJsonTable().acceptChildren(v);
                break;
            }
            case informixOuter: {
                this.getOuterClause().acceptChildren(v);
                break;
            }
            case table_ref_list: {
                this.getFromTableList().acceptChildren(v);
                break;
            }
            case hiveFromQuery: {
                this.getHiveFromQuery().acceptChildren(v);
                break;
            }
        }
        if (this.getPxGranule() != null) {
            this.getPxGranule().acceptChildren(v);
        }
        if (this.getTableSample() != null) {
            this.getTableSample().acceptChildren(v);
        }
        if (this.getAliasClause() != null) {
            this.getAliasClause().acceptChildren(v);
        }
        if (this.getTableHintList() != null) {
            for (int i = 0; i < this.getTableHintList().size(); ++i) {
                TTableHint tableHint = this.getTableHintList().getElement(i);
                tableHint.acceptChildren(v);
            }
        }
        v.postVisit(this);
    }

    public void setRowList(TMultiTargetList rowList) {
        this.rowList = rowList;
    }

    public void setSubquery(TSelectSqlStatement subquery) {
        this.subquery = subquery;
    }

    public void setLinkedColumns(TObjectNameList linkedColumns) {
        this.linkedColumns = linkedColumns;
    }

    public void setTablerefs(TTableReferenceList tablerefs) {
        this.tablerefs = tablerefs;
    }
}

