/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EDataType;
import gudusoft.gsqlparser.EDataTypeAttribute;
import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.EErrorType;
import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSyntaxError;
import gudusoft.gsqlparser.nodes.TAliasClause;
import gudusoft.gsqlparser.nodes.TDatatypeAttribute;
import gudusoft.gsqlparser.nodes.TExplicitDataTypeConversion;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TNodeWithAliasClause;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TQualifyClause;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.TTypeName;
import gudusoft.gsqlparser.nodes.couchbase.TUpdateFor;

public class TResultColumn
extends TNodeWithAliasClause {
    private TQualifyClause qualifyClause;
    private TPTNodeList<TExplicitDataTypeConversion> dataTypeConversionList = null;
    private TObjectNameList targetColumns = null;
    private TExpression expr = null;
    private boolean placeHolder = false;
    private TUpdateFor updateFor;

    public void setQualifyClause(TQualifyClause qualifyClause) {
        this.qualifyClause = qualifyClause;
    }

    public TQualifyClause getQualifyClause() {
        return this.qualifyClause;
    }

    public void setDataTypeConversionList(TPTNodeList<TExplicitDataTypeConversion> dataTypeConversionList) {
        this.expr.setDataTypeConversionList(dataTypeConversionList);
    }

    public TObjectNameList getTargetColumns() {
        if (this.targetColumns == null) {
            this.targetColumns = new TObjectNameList();
        }
        return this.targetColumns;
    }

    public boolean isMatchedUsingAlias(TObjectName pColumn) {
        boolean lcResult = pColumn.getColumnNameOnly().equalsIgnoreCase(this.getColumnAlias());
        return lcResult;
    }

    public boolean isMatchedWithResultColumn(TObjectName pColumn) {
        boolean lcResult = pColumn.getColumnNameOnly().equalsIgnoreCase(this.getColumnAlias());
        if (this.getColumnAlias().length() > 0 && !lcResult) {
            return lcResult;
        }
        if (!lcResult) {
            lcResult = pColumn.getColumnNameOnly().equalsIgnoreCase(this.getColumnNameOnly());
        }
        return lcResult;
    }

    public void TResultColumn() {
    }

    public String getColumnAlias() {
        if (this.getAliasClause() != null) {
            return this.getAliasClause().toString();
        }
        return "";
    }

    public TObjectName getColumnFullname() {
        TObjectName result = null;
        switch (this.expr.getExpressionType()) {
            case sqlserver_proprietary_column_alias_t: {
                if (this.expr.getRightOperand().getExpressionType() != EExpressionType.simple_object_name_t) break;
                result = this.expr.getRightOperand().getObjectOperand();
                break;
            }
            case simple_object_name_t: {
                result = this.expr.getObjectOperand();
                break;
            }
        }
        return result;
    }

    public String getColumnNameOnly() {
        String result = "";
        switch (this.expr.getExpressionType()) {
            case sqlserver_proprietary_column_alias_t: {
                if (this.expr.getRightOperand().getExpressionType() != EExpressionType.simple_object_name_t) break;
                result = this.expr.getRightOperand().getObjectOperand().getColumnNameOnly();
                break;
            }
            case simple_object_name_t: {
                result = this.expr.getObjectOperand().getColumnNameOnly();
                break;
            }
        }
        return result;
    }

    public void setExpr(TExpression expr) {
        this.expr = expr;
    }

    public void setPlaceHolder(boolean placeHolder) {
        this.placeHolder = placeHolder;
    }

    public boolean isPlaceHolder() {
        return this.placeHolder;
    }

    public TExpression getExpr() {
        return this.expr;
    }

    @Override
    public void init(Object arg1) {
        if (arg1 instanceof TExpression) {
            this.expr = (TExpression)arg1;
        }
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.init(arg1);
        if (arg2 instanceof TAliasClause) {
            this.setAliasClause((TAliasClause)arg2);
            if (((TAliasClause)arg2).getAliasName() != null) {
                ((TAliasClause)arg2).getAliasName().setObjectType(2);
            }
        }
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        if (this.isPlaceHolder()) {
            return;
        }
        if (psql.dbvendor == EDbVendor.dbvteradata) {
            TFunctionCall f;
            if (this.expr.getDataTypeConversionList() != null) {
                boolean namedAlias = false;
                TDatatypeAttribute datatypeAttribute = null;
                for (int i = 0; i < this.expr.getDataTypeConversionList().size(); ++i) {
                    TExplicitDataTypeConversion e = this.expr.getDataTypeConversionList().getElement(i);
                    if (e.getDataTypeAttributeList1() == null) continue;
                    for (int j = 0; j < e.getDataTypeAttributeList1().size() && (datatypeAttribute = e.getDataTypeAttributeList1().getElement(j)).getAttributeType() != EDataTypeAttribute.named_t; ++j) {
                        datatypeAttribute = null;
                    }
                    if (datatypeAttribute != null) break;
                }
                if (datatypeAttribute != null && datatypeAttribute.getAttributeType() == EDataTypeAttribute.named_t) {
                    TAliasClause aliasClause = new TAliasClause();
                    if (datatypeAttribute.getValue_literal() != null) {
                        aliasClause.init(datatypeAttribute.getValue_literal());
                        aliasClause.setStartToken(datatypeAttribute.getValue_literal().getStartToken());
                        aliasClause.setEndToken(datatypeAttribute.getValue_literal().getEndToken());
                    } else if (datatypeAttribute.getValue_identifier() != null) {
                        aliasClause.init(datatypeAttribute.getValue_identifier());
                        aliasClause.setStartToken(datatypeAttribute.getValue_identifier());
                        aliasClause.setEndToken(datatypeAttribute.getValue_identifier());
                    }
                    aliasClause.setTeradataNamedAlais(true);
                    aliasClause.setAsToken(datatypeAttribute.getStartToken());
                    this.setAliasClause(aliasClause);
                    namedAlias = true;
                }
                if (!namedAlias) {
                    // empty if block
                }
            }
            if (this.expr.getExpressionType() == EExpressionType.function_t && (f = this.expr.getFunctionCall()).getArgs() != null && f.getArgs().size() == 1 && f.getArgs().getExpression(0).toString().equalsIgnoreCase("date")) {
                this.expr.setExpressionType(EExpressionType.simple_object_name_t);
                f.getFunctionName().setDbObjectType(EDbObjectType.column);
                f.getFunctionName().setPartToken(f.getFunctionName().getObjectToken());
                f.getFunctionName().setObjectToken(null);
                this.expr.setObjectOperand(f.getFunctionName());
                this.expr.setStartToken(f.getFunctionName().getStartToken());
                this.expr.setEndToken(f.getFunctionName().getEndToken());
                TTypeName date1 = new TTypeName();
                date1.init((Object)EDataType.date_t);
                date1.setStartToken(f.getArgs().getExpression(0).getStartToken());
                date1.setEndToken(f.getArgs().getExpression(0).getEndToken());
                TExplicitDataTypeConversion dtc = new TExplicitDataTypeConversion();
                dtc.init(date1);
                dtc.setStartToken(date1.getStartToken());
                dtc.setEndToken(date1.getEndToken());
                TPTNodeList<TExplicitDataTypeConversion> dtcList = new TPTNodeList<TExplicitDataTypeConversion>();
                dtcList.addNode(dtc);
                this.expr.setDataTypeConversionList(dtcList);
            }
        }
        if (plocation == ESqlClause.set) {
            if (this.expr.getExpressionType() == EExpressionType.function_t) {
                try {
                    this.expr.getFunctionCall().getFunctionName().setObjectType(11);
                }
                catch (Exception e) {
                    TSourceToken st = this.expr.getStartToken();
                    psql.parseerrormessagehandle(new TSyntaxError(st.astext, st.lineNo, st.columnNo, "error function call in set clause", EErrorType.spfatalerror, 10099));
                }
                psql.linkColumnToTable(this.expr.getFunctionCall().getFunctionName(), plocation);
            } else if (this.expr.getLeftOperand().getExpressionType() == EExpressionType.simple_object_name_t) {
                this.expr.getLeftOperand().getObjectOperand().setLocation(plocation);
                TTable lcTable = psql.tables.getTable(0);
                if (lcTable.isLinkTable()) {
                    lcTable = lcTable.getLinkTable();
                }
                lcTable.getLinkedColumns().addObjectName(this.expr.getLeftOperand().getObjectOperand());
                this.expr.getLeftOperand().getObjectOperand().setSourceTable(lcTable);
                lcTable.getObjectNameReferences().addObjectName(this.expr.getLeftOperand().getObjectOperand());
                this.expr.getRightOperand().doParse(psql, ESqlClause.setValue);
            } else {
                this.expr.doParse(psql, plocation);
            }
        } else if (!(this.expr.getExpressionType() != EExpressionType.simple_comparison_t || psql.dbvendor != EDbVendor.dbvmssql && psql.dbvendor != EDbVendor.dbvsybase || plocation != ESqlClause.resultColumn && plocation != ESqlClause.insertColumn && plocation != ESqlClause.mergeInsert && plocation != ESqlClause.selectList)) {
            if (this.expr.getComparisonOperator().toString().equalsIgnoreCase("=") && !this.expr.getLeftOperand().toString().startsWith("@")) {
                this.expr.setExpressionType(EExpressionType.sqlserver_proprietary_column_alias_t);
                TAliasClause aliasClause = new TAliasClause();
                if (this.expr.getLeftOperand().getExpressionType() == EExpressionType.simple_object_name_t) {
                    aliasClause.init(this.expr.getLeftOperand().getObjectOperand());
                    aliasClause.setStartToken(this.expr.getLeftOperand().getStartToken());
                    aliasClause.setEndToken(this.expr.getLeftOperand().getEndToken());
                } else if (this.expr.getLeftOperand().getExpressionType() == EExpressionType.simple_constant_t) {
                    aliasClause.init(this.expr.getLeftOperand().getConstantOperand());
                    aliasClause.setStartToken(this.expr.getLeftOperand().getStartToken());
                    aliasClause.setEndToken(this.expr.getLeftOperand().getEndToken());
                }
                this.setAliasClause(aliasClause);
            }
            this.expr.doParse(psql, plocation);
        } else {
            this.expr.doParse(psql, plocation);
        }
        if (this.qualifyClause != null) {
            this.qualifyClause.doParse(psql, plocation);
        }
    }

    public TObjectName getFieldAttr() {
        TObjectName ret = null;
        if (this.expr.getExpressionType() == EExpressionType.simple_object_name_t) {
            ret = this.expr.getObjectOperand();
        }
        return ret;
    }

    public String getPrefixTable() {
        if (this.getFieldAttr() == null) {
            return "";
        }
        return this.getFieldAttr().getTableString();
    }

    public String getPrefixSchema() {
        if (this.getFieldAttr() == null) {
            return "";
        }
        return this.getFieldAttr().getSchemaString();
    }

    public String getPrefixDatabase() {
        if (this.getFieldAttr() == null) {
            return "";
        }
        return this.getFieldAttr().getDatabaseString();
    }

    public String getPrefixServer() {
        if (this.getFieldAttr() == null) {
            return "";
        }
        return this.getFieldAttr().getServerString();
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        this.getExpr().acceptChildren(v);
        if (this.getAliasClause() != null) {
            this.getAliasClause().acceptChildren(v);
        }
        v.postVisit(this);
    }

    public void setTargetColumns(TObjectNameList targetColumns) {
        this.targetColumns = targetColumns;
    }

    public void setUpdateFor(TUpdateFor updateFor) {
        this.updateFor = updateFor;
    }

    public TUpdateFor getUpdateFor() {
        return this.updateFor;
    }
}

