/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TFromTable;
import gudusoft.gsqlparser.nodes.TJoin;
import gudusoft.gsqlparser.nodes.TJoinList;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TPivotClause;
import gudusoft.gsqlparser.nodes.TTable;

public class TPivotedTable
extends TParseTreeNode {
    private TPivotClause pivotClause;
    private TFromTable fromTableSource;
    private TTable tableSource;
    private TPTNodeList<TPivotClause> pivotClauseList;
    private TJoinList joins;

    public TJoinList getJoins() {
        return this.joins;
    }

    public TPTNodeList<TPivotClause> getPivotClauseList() {
        return this.pivotClauseList;
    }

    public void setTableSource(TTable tableSource) {
        this.tableSource = tableSource;
    }

    public TPivotClause getPivotClause() {
        return this.pivotClause;
    }

    public TFromTable getFromTableSource() {
        return this.fromTableSource;
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.joins = new TJoinList();
        this.pivotClauseList = new TPTNodeList();
        this.fromTableSource = (TFromTable)arg1;
        this.pivotClause = (TPivotClause)arg2;
        this.pivotClauseList.addElement(this.pivotClause);
    }

    public TTable getTableSource() {
        return this.tableSource;
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        TJoin lcJoin = null;
        TTable lcTable = null;
        if (this.fromTableSource.getFromtableType() != ETableSource.join) {
            lcJoin = new TJoin();
            this.tableSource = lcTable = psql.analyzeFromTable(this.fromTableSource, true);
            lcTable.setEffectType(ETableEffectType.tetSelect);
            lcJoin.setTable(lcTable);
            lcJoin.setStartToken(lcJoin.getTable().getStartToken());
            lcJoin.setEndToken(lcJoin.getTable().getEndToken());
            lcJoin.setGsqlparser(this.getGsqlparser());
        } else {
            lcJoin = psql.analyzeJoin(this.fromTableSource.getJoinExpr(), null, true);
            lcJoin.doParse(psql, ESqlClause.join);
        }
        this.joins.addJoin(lcJoin);
        this.pivotClauseList.doParse(psql, plocation);
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        this.joins.acceptChildren(v);
        this.pivotClauseList.acceptChildren(v);
        v.postVisit(this);
    }

    public void setPivotClause(TPivotClause pivotClause) {
        this.pivotClause = pivotClause;
    }

    public void setFromTableSource(TFromTable fromTableSource) {
        this.fromTableSource = fromTableSource;
    }

    public void setPivotClauseList(TPTNodeList<TPivotClause> pivotClauseList) {
        this.pivotClauseList = pivotClauseList;
    }

    public void setJoins(TJoinList joins) {
        this.joins = joins;
    }
}

