/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TOrderByItem;
import gudusoft.gsqlparser.nodes.TOrderByItemList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;

public class TOrderBy
extends TParseTreeNode {
    private boolean siblings = false;
    private TExpression resetWhenCondition;
    private TOrderByItemList items = null;

    public void setSiblings(boolean siblings) {
        this.siblings = siblings;
    }

    public boolean isSiblings() {
        return this.siblings;
    }

    public TExpression getResetWhenCondition() {
        return this.resetWhenCondition;
    }

    public TOrderByItemList getItems() {
        if (this.items == null) {
            this.items = new TOrderByItemList();
        }
        return this.items;
    }

    @Override
    public void init(Object arg1) {
        this.items = (TOrderByItemList)arg1;
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.init(arg1);
        this.resetWhenCondition = (TExpression)arg2;
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        this.items.doParse(psql, plocation);
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        this.getItems().acceptChildren(v);
        v.postVisit(this);
    }

    public void addOrderByItem(String item) {
        if (this.items.size() == 0) {
            return;
        }
        TOrderByItem orderBy = new TOrderByItem();
        orderBy.setGsqlparser(this.getGsqlparser());
        orderBy.setString("," + item);
        TSourceToken last_token = this.items.getEndToken();
        orderBy.addAllMyTokensToTokenList(last_token.container, last_token.posinlist + 1);
        for (int i = 0; i < last_token.getNodesEndWithThisToken().size(); ++i) {
            TParseTreeNode node = last_token.getNodesEndWithThisToken().getElement(i);
            if (node instanceof TOrderByItem) continue;
            node.setEndToken(orderBy.getEndToken());
        }
        this.items.addOrderByItem(orderBy);
    }

    public void removeOrderByItem(int index) {
        if (this.items.size() > 1) {
            TSourceToken st = index != this.items.size() - 1 ? this.items.getOrderByItem(index).getEndToken().searchToken(",", 1) : this.items.getOrderByItem(index).getStartToken().searchToken(",", -1);
            this.items.getOrderByItem(index).removeAllMyTokensFromTokenList(st);
        } else if (this.items.size() == 1) {
            this.setString(" ");
        }
        this.items.remove(index);
    }

    public void setResetWhenCondition(TExpression resetWhenCondition) {
        this.resetWhenCondition = resetWhenCondition;
    }

    public void setItems(TOrderByItemList items) {
        this.items = items;
    }
}

