/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.EQuoteType;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TColumnDefinition;
import gudusoft.gsqlparser.nodes.TIndirection;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TResultColumn;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.util.keywordChecker;

public class TObjectName
extends TParseTreeNode {
    private boolean isReservedKeyword = false;
    private TColumnDefinition linkedColumnDef = null;
    private TObjectName namespace;
    private EQuoteType quoteType = EQuoteType.notQuoted;
    private String stringValue;
    public int searchLevel = 0;
    private TResultColumn sourceColumn;
    private TTable sourceTable;
    private TResultColumnList columnsLinkedToStar;
    private TObjectNameList attributes = null;
    private boolean subscripts;
    private TIndirection indirection;
    private boolean tableDetermined = true;
    private EDbObjectType dbObjectType = EDbObjectType.unknown;
    private TSourceToken serverToken = null;
    private TSourceToken databaseToken = null;
    private TSourceToken schemaToken;
    private TSourceToken objectToken;
    private TSourceToken partToken;
    private TSourceToken propertyToken = null;
    private TSourceToken methodToken = null;
    private TSourceToken atsign;
    private TObjectName dblink;
    private TSourceToken packageToken = null;
    private ESqlClause location = ESqlClause.unknown;
    private String schemaString;
    private String objectString;
    private String partString;
    private TSourceToken exclamationmark;
    private Boolean isParsed = false;
    private int numberOfPart = 1;
    private TObjectNameList referencedObjects = null;
    private TSourceToken sortType = null;
    private TSourceToken commentString;
    public static final int ttobjNotAObject = -1;
    public static final int ttobjUnknown = 0;
    public static final int ttobjColumn = 1;
    public static final int ttobjColumnAlias = 2;
    public static final int ttobjTable = 3;
    public static final int ttObjTableAlias = 4;
    public static final int ttobjTableCTE = 5;
    public static final int ttobjTableTemp = 6;
    public static final int ttobjTablePivot = 7;
    public static final int ttobjTableVar = 8;
    public static final int ttobjParameter = 9;
    public static final int ttobjVariable = 10;
    public static final int ttobjColumnMethod = 11;
    public static final int ttobjProcedureName = 12;
    public static final int ttobjFunctionName = 13;
    public static final int ttobjLabelName = 14;
    public static final int ttobjIndexName = 15;
    public static final int ttobjMaterializedViewName = 16;
    public static final int ttobjCursorName = 17;
    public static final int ttobjViewName = 18;
    public static final int ttobjConstraintName = 19;
    public static final int ttobjPropertyName = 20;
    public static final int ttobjTransactionName = 21;
    public static final int ttobjDatabaseName = 22;
    public static final int ttobjStringConstant = 23;
    public static final int ttobjTrigger = 24;
    public static final int ttobjAliasName = 25;
    public static final int ttobjAttribute = 26;
    public static final int ttobjTypeName = 27;
    public static final int ttobjPackage = 28;
    public static final int ttobjSequence = 29;
    public static final int ttobjDatatype = 30;
    public static final int ttobjSchemaName = 31;
    public static final int ttobjServerName = 32;
    public static final int ttobjOperator = 40;
    public static final int ttobjIndexType = 42;
    public static final int ttobjMaterializedView = 44;
    public static final int ttobjMiningModel = 46;
    public static final int ttobjFieldName = 51;
    public static final int ttobjPositionalParameters = 61;
    public static final int ttObjOracleHint = 70;
    public static final int ttObjLibrary = 72;
    public static final int ttobjMixed = 100;
    private int objectType = 0;

    public boolean isReservedKeyword() {
        return this.isReservedKeyword;
    }

    public void setLinkedColumnDef(TColumnDefinition linkedColumnDef) {
        this.linkedColumnDef = linkedColumnDef;
    }

    public TColumnDefinition getLinkedColumnDef() {
        return this.linkedColumnDef;
    }

    public void setNamespace(TObjectName namespace) {
        this.namespace = namespace;
    }

    public TObjectName getNamespace() {
        return this.namespace;
    }

    @Override
    public String toString() {
        String ret = super.toString();
        if (ret != null) {
            return ret;
        }
        if (this.getPartToken() != null) {
            return this.getPartString();
        }
        if (this.getObjectToken() != null) {
            return this.getObjectString();
        }
        return null;
    }

    public void setQuoteType(EQuoteType quoteType) {
        this.quoteType = quoteType;
    }

    public EQuoteType getQuoteType() {
        if (this.toString().startsWith("[")) {
            return EQuoteType.squareBracket;
        }
        if (this.toString().startsWith("\"")) {
            return EQuoteType.doubleQuote;
        }
        return this.quoteType;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setSourceColumn(TResultColumn sourceColumn) {
        this.sourceColumn = sourceColumn;
    }

    public TResultColumn getSourceColumn() {
        return this.sourceColumn;
    }

    public boolean isPrefixedThisTable(TTable pTable) {
        boolean lcResult = false;
        if (this.getTableString().length() == 0) {
            return false;
        }
        if (pTable.getAliasName().length() > 0) {
            lcResult = pTable.getAliasName().toString().equalsIgnoreCase(this.getTableString().toString());
        }
        if (lcResult) {
            return true;
        }
        if ((pTable.isBaseTable() || pTable.isCTEName()) && this.getTableToken() != null && pTable.getTableName().getTableToken() != null) {
            lcResult = this.getTableToken().toUnQuotedString().equalsIgnoreCase(pTable.getTableName().getTableToken().toUnQuotedString());
        }
        return lcResult;
    }

    public boolean isPrefixed() {
        return this.getTableString().length() > 0;
    }

    public boolean isValidColumnName(EDbVendor pDBVendor) {
        TSourceToken pt;
        boolean lcResult = true;
        if (this.getObjectType() == 10 || this.getDbObjectType() == EDbObjectType.variable) {
            return false;
        }
        if (this.getObjectType() == 2) {
            return false;
        }
        if (this.getDbObjectType() == EDbObjectType.xmlElement) {
            return false;
        }
        if (pDBVendor == EDbVendor.dbvsybase && (pt = this.getPartToken()) != null && pt.tokentype == ETokenType.ttdqstring) {
            if (pt.toString().charAt(1) >= '0' && pt.toString().charAt(1) <= '9') {
                lcResult = false;
            } else if (pt.toString().length() == 2) {
                lcResult = false;
            } else if (pt.toString().substring(1, pt.toString().length() - 1).trim().length() == 0) {
                lcResult = false;
            }
        }
        if (this.getPartToken() != null && this.getPartToken().tokentype == ETokenType.ttkeyword) {
            switch (pDBVendor) {
                case dbvmssql: {
                    lcResult = this.getGsqlparser().getFlexer().canBeColumnName(this.getPartToken().tokencode);
                    break;
                }
                case dbvsybase: {
                    lcResult = !keywordChecker.isKeyword(this.getPartToken().toString(), EDbVendor.dbvsybase, "15.7", true);
                    break;
                }
            }
        }
        if (this.toString().startsWith("@") || this.toString().startsWith(":") && this.toString().indexOf(".") == -1) {
            this.setObjectType(-1);
            lcResult = false;
        }
        switch (pDBVendor) {
            case dbvoracle: {
                if (this.getColumnNameOnly().compareToIgnoreCase("rowid") == 0 || this.getColumnNameOnly().compareToIgnoreCase("sysdate") == 0 || this.getColumnNameOnly().compareToIgnoreCase("nextval") == 0 || this.getColumnNameOnly().compareToIgnoreCase("rownum") == 0 || this.getColumnNameOnly().compareToIgnoreCase("level") == 0 || this.getColumnNameOnly().compareToIgnoreCase("user") == 0) {
                    this.setObjectType(-1);
                    lcResult = false;
                }
                if (!this.toString().startsWith(":") || this.toString().indexOf(".") != -1) break;
                this.setObjectType(-1);
                lcResult = false;
                break;
            }
            case dbvmssql: {
                if (this.getColumnNameOnly().compareToIgnoreCase("system_user") != 0) break;
                lcResult = false;
                break;
            }
            case dbvmysql: {
                if (this.toString().startsWith("\"")) {
                    lcResult = false;
                }
                if (!keywordChecker.isKeyword(this.toString(), EDbVendor.dbvmysql, "6.0", true)) break;
                this.isReservedKeyword = true;
                lcResult = false;
                break;
            }
            case dbvteradata: {
                if (this.getObjectString().length() != 0 || this.getColumnNameOnly().compareToIgnoreCase("account") != 0 && this.getColumnNameOnly().compareToIgnoreCase("current_date") != 0 && this.getColumnNameOnly().compareToIgnoreCase("current_role") != 0 && this.getColumnNameOnly().compareToIgnoreCase("current_time") != 0 && this.getColumnNameOnly().compareToIgnoreCase("current_timestamp") != 0 && this.getColumnNameOnly().compareToIgnoreCase("current_user") != 0 && this.getColumnNameOnly().compareToIgnoreCase("database") != 0 && this.getColumnNameOnly().compareToIgnoreCase("date") != 0 && this.getColumnNameOnly().compareToIgnoreCase("profile") != 0 && this.getColumnNameOnly().compareToIgnoreCase("role") != 0 && this.getColumnNameOnly().compareToIgnoreCase("session") != 0 && this.getColumnNameOnly().compareToIgnoreCase("time") != 0 && this.getColumnNameOnly().compareToIgnoreCase("user") != 0 && this.getColumnNameOnly().compareToIgnoreCase("sysdate") != 0) break;
                lcResult = false;
                break;
            }
            case dbvpostgresql: {
                if (!this.toString().startsWith("$") || this.toString().charAt(1) < '0' || this.toString().charAt(1) > '9') break;
                this.setDbObjectType(EDbObjectType.variable);
                lcResult = false;
            }
        }
        return lcResult;
    }

    public void setColumnsLinkedToStar(TResultColumnList columnsLinkedToStar) {
        this.columnsLinkedToStar = columnsLinkedToStar;
    }

    public TResultColumnList getColumnsLinkedToStar() {
        return this.columnsLinkedToStar;
    }

    public void setSourceTable(TTable sourceTable) {
        this.sourceTable = sourceTable;
    }

    public TTable getSourceTable() {
        return this.sourceTable;
    }

    public void TObjectName() {
    }

    public boolean isSubscripts() {
        return this.subscripts;
    }

    public void setIndirection(TIndirection indirection) {
        if (indirection == null) {
            return;
        }
        this.indirection = indirection;
        if (this.getObjectType() == 61) {
            if (indirection.isRealIndices()) {
                this.subscripts = true;
            } else {
                this.setColumnTokenOfPositionalParameters(indirection.getIndices().getElement(0).getAttributeName().getPartToken());
            }
        } else if (indirection.isRealIndices()) {
            if (indirection.getIndices().size() == 1) {
                this.subscripts = true;
            } else if (indirection.getIndices().size() >= 2 && !indirection.getIndices().getElement(0).isRealIndices()) {
                this.setPartTokenOfIndirection(indirection.getIndices().getElement(0).getAttributeName().getPartToken());
                this.subscripts = true;
                this.indirection.getIndices().remove(0);
            }
        } else if (indirection.getIndices().size() == 1) {
            if (indirection.getIndices().getElement((int)0).getStartToken().tokencode != 58 && indirection.getIndices().getElement((int)0).getStartToken().tokencode != 267) {
                this.setPartTokenOfIndirection(indirection.getIndices().getElement(0).getAttributeName().getPartToken());
            }
        } else if (indirection.getIndices().size() == 2 && indirection.getIndices().getElement((int)0).getStartToken().tokencode != 58 && indirection.getIndices().getElement((int)0).getStartToken().tokencode != 267) {
            this.schemaToken = this.partToken;
            this.schemaToken.setDbObjType(31);
            this.objectToken = indirection.getIndices().getElement(0).getAttributeName().getPartToken();
            this.objectToken.setDbObjType(3);
            this.partToken = indirection.getIndices().getElement(1).getAttributeName().getPartToken();
            this.partToken.setDbObjType(1);
        }
    }

    public TIndirection getIndirection() {
        return this.indirection;
    }

    private void setPartTokenOfIndirection(TSourceToken column) {
        this.parseTablename();
        this.partToken = column;
        this.partToken.setDbObjType(1);
    }

    public void setPropertyToken(TSourceToken propertyToken) {
        this.propertyToken = propertyToken;
    }

    public TSourceToken getAtsign() {
        return this.atsign;
    }

    public TSourceToken getMethodToken() {
        return this.methodToken;
    }

    public TSourceToken getPropertyToken() {
        return this.propertyToken;
    }

    public TSourceToken getServerToken() {
        return this.serverToken;
    }

    public TSourceToken getExclamationmark() {
        return this.exclamationmark;
    }

    public TObjectName getDblink() {
        return this.dblink;
    }

    public TSourceToken getDatabaseToken() {
        return this.databaseToken;
    }

    public void setTableDetermined(boolean tableDetermined) {
        this.tableDetermined = tableDetermined;
    }

    public boolean isTableDetermined() {
        return this.tableDetermined;
    }

    public void attributesToPropertyToken(TObjectNameList attributes) {
        if (attributes.size() == 1) {
            this.propertyToken = attributes.getObjectName(0).getPartToken();
        }
    }

    public void setAttributes(TObjectNameList attributes) {
        this.attributes = attributes;
    }

    public TObjectNameList getAttributes() {
        return this.attributes;
    }

    public void setObjectType(int objectType) {
        if (this.objectType == objectType) {
            return;
        }
        this.objectType = objectType;
        switch (this.getObjectType()) {
            case 3: 
            case 6: 
            case 8: {
                this.parseTablename();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.table;
                break;
            }
            case 5: {
                this.parseTablename();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.cte;
                break;
            }
            case 72: {
                this.parseTablename();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.library;
                break;
            }
            case 1: {
                this.partToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.column;
                break;
            }
            case 2: {
                if (this.objectToken == null && this.partToken != null) {
                    this.parseObjectName();
                }
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.column_alias;
                break;
            }
            case 4: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.table_alias;
                break;
            }
            case 9: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.parameter;
                break;
            }
            case 10: {
                this.parseVariableName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.variable;
                break;
            }
            case 11: {
                this.parseColumnMethodName();
                this.partToken.setDbObjType(1);
                this.methodToken.setDbObjType(11);
                this.dbObjectType = EDbObjectType.method;
                break;
            }
            case 12: {
                this.parseFunctionName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.procedure;
                break;
            }
            case 13: {
                this.parseFunctionName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.function;
                break;
            }
            case 14: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.label;
                break;
            }
            case 15: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.index;
                break;
            }
            case 16: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.materializedView;
                break;
            }
            case 18: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.view;
                break;
            }
            case 17: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.cursor;
                break;
            }
            case 19: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.constraint;
                break;
            }
            case 20: {
                this.propertyToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.property;
                break;
            }
            case 21: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.transaction;
                break;
            }
            case 22: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.database;
                break;
            }
            case 23: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                break;
            }
            case 25: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.alias;
                break;
            }
            case 26: {
                this.partToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.attribute;
                break;
            }
            case 27: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.user_defined_type;
                break;
            }
            case 28: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.plsql_package;
                break;
            }
            case 29: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.sequence;
                break;
            }
            case 24: {
                this.parseObjectName();
                this.objectToken.setDbObjType(this.objectType);
                this.dbObjectType = EDbObjectType.trigger;
                break;
            }
        }
    }

    public void setDbObjectType(EDbObjectType dbObjectType) {
        EDbObjectType prev = this.dbObjectType;
        this.dbObjectType = dbObjectType;
        if (prev == EDbObjectType.unknown) {
            switch (dbObjectType) {
                case column: {
                    this.parseColumnName();
                    break;
                }
                case table: {
                    this.parseTablename();
                    break;
                }
                case function: {
                    this.parseFunctionName();
                    break;
                }
                case procedure: 
                case materializedView: {
                    this.parseFunctionName();
                    break;
                }
                case alias: 
                case module: 
                case sequence: {
                    this.parseTablename();
                    break;
                }
            }
        }
    }

    public EDbObjectType getDbObjectType() {
        return this.dbObjectType;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void setAtsign(TSourceToken atsign) {
        this.atsign = atsign;
    }

    public void setDblink(TObjectName dblink) {
        this.dblink = dblink;
    }

    public void setServerToken(TSourceToken serverToken) {
        this.serverToken = serverToken;
    }

    public void setDatabaseToken(TSourceToken databaseToken) {
        this.databaseToken = databaseToken;
    }

    public void setObjectToken(TSourceToken objectToken) {
        this.objectToken = objectToken;
    }

    public void setPartToken(TSourceToken partToken) {
        this.partToken = partToken;
    }

    public void setMethodToken(TSourceToken methodToken) {
        this.methodToken = methodToken;
    }

    public void setSchemaToken(TSourceToken schemaToken) {
        this.schemaToken = schemaToken;
    }

    public void setPackageToken(TSourceToken packageToken) {
        this.packageToken = packageToken;
    }

    public TSourceToken getPackageToken() {
        return this.packageToken;
    }

    public void setLocation(ESqlClause location) {
        this.location = location;
    }

    public ESqlClause getLocation() {
        return this.location;
    }

    public TSourceToken getObjectToken() {
        return this.objectToken;
    }

    public TSourceToken getPartToken() {
        return this.partToken;
    }

    public TSourceToken getSchemaToken() {
        return this.schemaToken;
    }

    public String getPackageString() {
        if (this.getPackageToken() != null) {
            return this.getPackageToken().toString();
        }
        return "";
    }

    public String getServerString() {
        if (this.getServerToken() != null) {
            return this.getServerToken().toString();
        }
        return "";
    }

    public String getDatabaseString() {
        if (this.getDatabaseToken() != null) {
            return this.getDatabaseToken().toString();
        }
        return "";
    }

    public String getSchemaString() {
        if (this.schemaToken != null) {
            return this.schemaToken.astext;
        }
        return "";
    }

    public TSourceToken getTableToken() {
        if (this.objectToken == null) {
            return null;
        }
        return this.objectToken;
    }

    public String getTableString() {
        if (this.objectToken == null) {
            return "";
        }
        return this.objectToken.toString();
    }

    public String getObjectString() {
        if (this.objectToken != null) {
            return this.objectToken.astext;
        }
        return "";
    }

    public String getPartString() {
        if (this.partToken != null) {
            return this.partToken.astext;
        }
        return "";
    }

    public void setExclamationmark(TSourceToken exclamationmark) {
        this.exclamationmark = exclamationmark;
    }

    private void parseObjectName() {
        this.parseTablename();
    }

    private void parseTablename() {
        if (this.databaseToken != null) {
            this.serverToken = this.databaseToken;
            this.serverToken.setDbObjType(32);
        }
        if (this.schemaToken != null) {
            this.databaseToken = this.schemaToken;
            this.databaseToken.setDbObjType(22);
        }
        if (this.objectToken != null) {
            this.schemaToken = this.objectToken;
            this.schemaToken.setDbObjType(31);
        }
        this.objectToken = this.partToken;
        this.partToken = null;
    }

    private void parseVariableName() {
        if (this.databaseToken != null) {
            this.serverToken = this.databaseToken;
            this.serverToken.setDbObjType(32);
        }
        if (this.schemaToken != null) {
            this.databaseToken = this.schemaToken;
            this.databaseToken.setDbObjType(22);
        }
        if (this.objectToken != null) {
            if (this.partToken != null) {
                this.schemaToken = this.objectToken;
                this.schemaToken.setDbObjType(31);
                this.objectToken = this.partToken;
                this.partToken = null;
            }
        } else {
            this.objectToken = this.partToken;
            this.partToken = null;
        }
    }

    private void parseFunctionName() {
        this.parseTablename();
    }

    private void parseColumnMethodName() {
        this.objectType = 11;
        this.methodToken = this.objectToken;
        this.partToken = this.schemaToken;
        this.objectToken = null;
        this.schemaToken = null;
    }

    private void parseColumnName() {
        assert (this.partToken != null);
    }

    public TObjectName() {
    }

    public int getNumberOfPart() {
        return this.numberOfPart;
    }

    public TObjectName(TSourceToken token, EDbObjectType dbObjectType) {
        this.numberOfPart = 1;
        this.setStartToken(this.partToken);
        this.setEndToken(this.partToken);
        switch (dbObjectType) {
            case collation: {
                this.dbObjectType = dbObjectType;
                this.objectToken = token;
                break;
            }
            default: {
                this.partToken = token;
                this.setDbObjectType(dbObjectType);
            }
        }
    }

    public TObjectName(TSourceToken pObjectToken, TSourceToken pPartToken, EDbObjectType dbObjectType) {
        this.partToken = pPartToken;
        this.objectToken = pObjectToken;
        this.numberOfPart = 2;
        this.setStartToken(this.objectToken);
        this.setEndToken(this.partToken);
        this.setDbObjectType(dbObjectType);
    }

    @Override
    public void init(Object arg1) {
        this.partToken = (TSourceToken)arg1;
        this.numberOfPart = 1;
        this.setStartToken(this.partToken);
        this.setEndToken(this.partToken);
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.objectToken = (TSourceToken)arg1;
        this.partToken = (TSourceToken)arg2;
        this.numberOfPart = 2;
        if (this.objectToken != null) {
            this.setStartToken(this.objectToken);
        } else {
            this.setStartToken(this.partToken);
            --this.numberOfPart;
        }
        if (this.partToken != null) {
            this.setEndToken(this.partToken);
        } else {
            this.setEndToken(this.objectToken);
            --this.numberOfPart;
        }
    }

    public void init(EDbObjectType dbObjectType, Object arg1, Object arg2, Object arg3) {
        this.dbObjectType = dbObjectType;
        this.numberOfPart = 3;
        this.setStartToken((TSourceToken)arg1);
        this.setEndToken((TSourceToken)arg3);
        switch (this.dbObjectType) {
            case column: {
                this.schemaToken = (TSourceToken)arg1;
                this.objectToken = (TSourceToken)arg2;
                this.partToken = (TSourceToken)arg3;
                break;
            }
            case table: 
            case function: 
            case procedure: 
            case materializedView: 
            case module: 
            case sequence: {
                this.databaseToken = (TSourceToken)arg1;
                this.schemaToken = (TSourceToken)arg2;
                this.objectToken = (TSourceToken)arg3;
                break;
            }
            case alias: {
                break;
            }
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3) {
        this.schemaToken = (TSourceToken)arg1;
        this.objectToken = (TSourceToken)arg2;
        this.partToken = (TSourceToken)arg3;
        this.numberOfPart = 3;
        this.setStartToken(this.schemaToken);
        this.setEndToken(this.partToken);
        if (this.schemaToken != null) {
            this.schemaToken.setDbObjType(31);
        } else {
            --this.numberOfPart;
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4) {
        this.databaseToken = (TSourceToken)arg1;
        this.schemaToken = (TSourceToken)arg2;
        this.objectToken = (TSourceToken)arg3;
        this.partToken = (TSourceToken)arg4;
        this.numberOfPart = 4;
        this.setStartToken(this.databaseToken);
        this.setEndToken(this.partToken);
        if (this.databaseToken != null) {
            this.databaseToken.setDbObjType(22);
        } else {
            --this.numberOfPart;
        }
        if (this.schemaToken != null) {
            this.schemaToken.setDbObjType(31);
        } else {
            --this.numberOfPart;
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this.serverToken = (TSourceToken)arg1;
        this.databaseToken = (TSourceToken)arg2;
        this.schemaToken = (TSourceToken)arg3;
        this.objectToken = (TSourceToken)arg4;
        this.partToken = (TSourceToken)arg5;
        this.numberOfPart = 5;
        this.setStartToken(this.serverToken);
        this.setEndToken(this.partToken);
        if (this.serverToken != null) {
            this.serverToken.setDbObjType(32);
        } else {
            --this.numberOfPart;
        }
        if (this.databaseToken != null) {
            this.databaseToken.setDbObjType(22);
        } else {
            --this.numberOfPart;
        }
        if (this.schemaToken != null) {
            this.schemaToken.setDbObjType(31);
        } else {
            --this.numberOfPart;
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        this.serverToken = (TSourceToken)arg1;
        this.databaseToken = (TSourceToken)arg2;
        this.schemaToken = (TSourceToken)arg3;
        this.objectToken = (TSourceToken)arg4;
        this.partToken = (TSourceToken)arg5;
        this.propertyToken = (TSourceToken)arg6;
        this.numberOfPart = 6;
        this.setStartToken(this.serverToken);
        this.setEndToken(this.propertyToken);
        if (this.serverToken != null) {
            this.serverToken.setDbObjType(32);
        } else {
            --this.numberOfPart;
        }
        if (this.databaseToken != null) {
            this.databaseToken.setDbObjType(22);
        } else {
            --this.numberOfPart;
        }
        if (this.schemaToken != null) {
            this.schemaToken.setDbObjType(31);
        } else {
            --this.numberOfPart;
        }
    }

    @Override
    public long getColumnNo() {
        long retval = -1L;
        if (this.partToken != null) {
            retval = this.partToken.columnNo;
        }
        if (this.objectToken != null) {
            retval = this.objectToken.columnNo;
        }
        if (this.schemaToken != null) {
            retval = this.schemaToken.columnNo;
        }
        if (this.databaseToken != null) {
            retval = this.databaseToken.columnNo;
        }
        if (this.serverToken != null) {
            retval = this.serverToken.columnNo;
        }
        return retval;
    }

    @Override
    public long getLineNo() {
        long retval = -1L;
        if (this.partToken != null) {
            retval = this.partToken.lineNo;
        }
        if (this.objectToken != null) {
            retval = this.objectToken.lineNo;
        }
        if (this.schemaToken != null) {
            retval = this.schemaToken.lineNo;
        }
        if (this.databaseToken != null) {
            retval = this.databaseToken.lineNo;
        }
        if (this.serverToken != null) {
            retval = this.serverToken.lineNo;
        }
        return retval;
    }

    public TObjectNameList getReferencedObjects() {
        if (this.referencedObjects == null) {
            this.referencedObjects = new TObjectNameList();
        }
        return this.referencedObjects;
    }

    public String getColumnNameOnly() {
        if (this.getPartToken() == null) {
            return "";
        }
        return this.getPartToken().toString();
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setSortType(TSourceToken sortType) {
        this.sortType = sortType;
    }

    public TSourceToken getSortType() {
        return this.sortType;
    }

    public TSourceToken getColumnToken() {
        TSourceToken ret = null;
        if (this.getObjectType() == 1) {
            ret = this.getPartToken();
        }
        return ret;
    }

    public boolean isAttributeNameInObjectName(TSourceToken leftparen, TSourceToken rightparen) {
        boolean ret = false;
        if (this.partToken == null || this.objectToken == null) {
            return ret;
        }
        this.objectType = 1;
        this.attributes = new TObjectNameList();
        TObjectName attr1 = new TObjectName();
        attr1.objectType = 26;
        attr1.init(this.partToken);
        attr1.setEndToken(rightparen);
        this.attributes.addObjectName(attr1);
        this.partToken = this.objectToken;
        if (this.schemaToken != null) {
            this.objectToken = this.schemaToken;
        }
        return true;
    }

    public void mergeObjectName(TObjectName objectName) {
        this.objectToken = this.partToken;
        this.partToken = objectName.getPartToken();
        this.setStartToken(this.objectToken);
        this.setEndToken(this.partToken);
    }

    public void mergeObjectName(TObjectName objectName, TObjectName objectName2) {
        this.schemaToken = this.partToken;
        this.objectToken = objectName.getPartToken();
        this.partToken = objectName2.getPartToken();
        this.setStartToken(this.schemaToken);
        this.setEndToken(this.partToken);
    }

    public void appendObjectName(TObjectName objectName) {
        if (this.databaseToken != null) {
            this.serverToken = this.databaseToken;
        }
        if (this.schemaToken != null) {
            this.databaseToken = this.schemaToken;
        }
        if (this.objectToken != null) {
            this.schemaToken = this.objectToken;
        }
        this.objectToken = this.partToken;
        this.partToken = objectName.getPartToken();
    }

    public void setCommentString(TSourceToken commentString) {
        this.commentString = commentString;
    }

    public TSourceToken getCommentString() {
        return this.commentString;
    }

    public String coordinate() {
        return this.getStartToken().lineNo + "," + this.getEndToken().columnNo;
    }

    private void setColumnTokenOfPositionalParameters(TSourceToken column) {
        this.objectToken = this.partToken;
        this.partToken = column;
    }
}

