/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.EFunctionType;
import gudusoft.gsqlparser.ELiteralType;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.ENodeType;
import gudusoft.gsqlparser.nodes.TColumnReference;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TDatetimeExpression;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TIntervalExpression;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectReference;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TSelectSqlNode;
import gudusoft.gsqlparser.nodes.TTableReference;
import gudusoft.gsqlparser.nodes.hive.THiveVariable;

public class TNodeFactory {
    private TGSqlParser gsqlparser = null;

    public void setGsqlParser(TGSqlParser parser) {
        this.gsqlparser = parser;
    }

    public TColumnReference createColumnReference(TObjectName objectname) {
        TColumnReference retval = (TColumnReference)this.createNode(ENodeType.T_ColumnReference.getId(), objectname);
        return retval;
    }

    public TColumnReference createColumnReference(TSourceToken objectname) {
        TColumnReference retval = (TColumnReference)this.createNode(ENodeType.T_ColumnReference.getId(), objectname);
        return retval;
    }

    public TTableReference createTableReference(TObjectName objectname) {
        TTableReference retval = (TTableReference)this.createNode(ENodeType.T_TableReference.getId(), objectname);
        return retval;
    }

    public TObjectReference createObjectReference(TObjectName objectname, int objecttype) {
        TObjectReference retval = (TObjectReference)this.createNode(ENodeType.T_ObjectReference.getId(), objectname);
        retval.setObjectType(objecttype);
        return retval;
    }

    public TParseTreeNode createIntervalExpression() {
        TIntervalExpression retval = (TIntervalExpression)this.createNode(ENodeType.T_IntervalExression.getId());
        return retval;
    }

    public TParseTreeNode createDatetimeExpression() {
        TDatetimeExpression retval = (TDatetimeExpression)this.createNode(ENodeType.T_DatetimeExression.getId());
        return retval;
    }

    public TParseTreeNode createFunctionCall(EFunctionType eFunctionType, TObjectName functionName) {
        TFunctionCall retval = (TFunctionCall)this.createNode(ENodeType.T_FunctionCall.getId(), functionName, (Object)eFunctionType);
        return retval;
    }

    public TParseTreeNode createSelectSqlNode() {
        TSelectSqlNode retval = (TSelectSqlNode)this.createNode(ENodeType.T_SelectSqlNode.getId());
        return retval;
    }

    public TParseTreeNode createExpression(EExpressionType operatorType) {
        TExpression retval = (TExpression)this.createNode(ENodeType.T_Expression.getId(), (Object)operatorType);
        return retval;
    }

    public TParseTreeNode createExpression(EExpressionType operatorType, TExpression leftOperand, TExpression rightOperand) {
        TExpression retval = (TExpression)this.createNode(ENodeType.T_Expression.getId(), (Object)operatorType);
        retval.setLeftOperand(leftOperand);
        retval.setRightOperand(rightOperand);
        return retval;
    }

    public TParseTreeNode createCompoundExpression(EExpressionType operatorType, TExpression leftOperand, TExpression rightOperand) {
        EExpressionType lcOperatorType = operatorType;
        if (lcOperatorType == EExpressionType.group_comparison_t && leftOperand.getExpressionType() != EExpressionType.list_t) {
            lcOperatorType = EExpressionType.simple_comparison_t;
        }
        TExpression retval = (TExpression)this.createNode(ENodeType.T_Expression.getId(), (Object)lcOperatorType);
        retval.setLeftOperand(leftOperand);
        retval.setRightOperand(rightOperand);
        return retval;
    }

    public TExpression createSimpleExpression(TObjectName or) {
        TExpression retval = (TExpression)this.createNode(ENodeType.T_Expression.getId(), (Object)EExpressionType.simple_object_name_t);
        retval.setObjectOperand(or);
        retval.setStartToken(or);
        retval.setEndToken(or);
        return retval;
    }

    public TObjectName createObjectName(TSourceToken schema, TSourceToken object, TSourceToken part) {
        if (schema == null && object == null && part == null) {
            return null;
        }
        TObjectName retval = (TObjectName)this.createNode(ENodeType.T_ObjectName.getId(), schema, object, part);
        if (part != null) {
            retval.setEndToken(part);
        } else if (object != null) {
            retval.setEndToken(object);
        } else if (schema != null) {
            retval.setEndToken(schema);
        }
        if (schema != null) {
            retval.setStartToken(schema);
        } else if (object != null) {
            retval.setStartToken(object);
        } else if (part != null) {
            retval.setStartToken(part);
        }
        return retval;
    }

    public TObjectName createObjectNameWithPart(TSourceToken part) {
        return this.createObjectName(null, null, part);
    }

    public TObjectName createObjectNameWithObject(TSourceToken object) {
        return this.createObjectName(null, object, null);
    }

    public TObjectName createObjectNameWithPartAndObject(TSourceToken object, TSourceToken part) {
        return this.createObjectName(null, object, part);
    }

    public TParseTreeNode createSimpleExpression(TConstant cnt) {
        TExpression retval = (TExpression)this.createNode(ENodeType.T_Expression.getId(), (Object)EExpressionType.simple_constant_t);
        retval.setConstantOperand(cnt);
        retval.setStartToken(cnt.getStartToken());
        retval.setEndToken(cnt.getEndToken());
        return retval;
    }

    public TParseTreeNode createSimpleExpression(TSourceToken st) {
        TExpression retval = (TExpression)this.createNode(ENodeType.T_Expression.getId(), (Object)EExpressionType.simple_source_token_t);
        retval.setSourcetokenOperand(st);
        retval.setStartToken(st);
        retval.setEndToken(st);
        return retval;
    }

    public TParseTreeNode createSimpleExpression(THiveVariable variable) {
        TExpression retval = (TExpression)this.createNode(ENodeType.T_Expression.getId(), (Object)EExpressionType.hive_variable_t);
        retval.setHive_variable(variable);
        retval.setStartToken(variable);
        retval.setEndToken(variable);
        return retval;
    }

    private ELiteralType getETByNT(ENodeType ent) {
        ELiteralType et = ELiteralType.etString;
        switch (ent) {
            case T_Constant: {
                et = ELiteralType.etString;
                break;
            }
            case T_Constant_Double: 
            case T_Constant_Float: {
                et = ELiteralType.etFloat;
                break;
            }
            case T_Constant_Integer: {
                et = ELiteralType.etNumber;
                break;
            }
            case T_Constant_String: {
                et = ELiteralType.etString;
                break;
            }
            case T_Constant_BindV: {
                break;
            }
            case T_Constant_Boolean: {
                et = ELiteralType.bool;
                break;
            }
            case T_Constant_Date: {
                et = ELiteralType.datetime_date;
                break;
            }
            case T_Constant_Interval: {
                et = ELiteralType.interval;
                break;
            }
            case T_Constant_Null: {
                et = ELiteralType.character_string;
                break;
            }
            case T_Constant_Time: {
                et = ELiteralType.datetime_time;
                break;
            }
            case T_Constant_Timestamp: {
                et = ELiteralType.datetime_timestamp;
                break;
            }
        }
        return et;
    }

    public TParseTreeNode createConstant(TSourceToken st, ENodeType ent) {
        TConstant retval = (TConstant)this.createNode(ENodeType.T_Constant.getId(), (Object)this.getETByNT(ent));
        retval.setStartToken(st);
        retval.setEndToken(st);
        retval.setValueToken(st);
        return retval;
    }

    public TParseTreeNode createNode(int nodeType) {
        Class<?> nodeClass = null;
        TParseTreeNode retval = null;
        String nodeName = this.nodeName(nodeType);
        try {
            nodeClass = Class.forName(nodeName);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.toString() + ", nodename: " + nodeName);
        }
        try {
            retval = (TParseTreeNode)nodeClass.newInstance();
        }
        catch (Exception iae) {
            System.out.println(iae.toString() + ", nodeType: " + nodeType);
        }
        retval.setNodeType(nodeType);
        retval.setGsqlparser(this.gsqlparser);
        return retval;
    }

    public <T> TPTNodeList<T> createPTNodeList(T c) {
        int nodeType = ENodeType.T_PTNodeList.getId();
        TPTNodeList retval = new TPTNodeList();
        retval.setNodeType(nodeType);
        retval.setGsqlparser(this.gsqlparser);
        retval.init(c);
        return retval;
    }

    protected String nodeName(int nodeType) {
        return ENodeType.fromId(nodeType).toString();
    }

    public final TParseTreeNode createNode(int nodeType, Object arg1) {
        TParseTreeNode retval = this.createNode(nodeType);
        retval.init(arg1);
        return retval;
    }

    public final TParseTreeNode createNode(int nodeType, Object arg1, Object arg2) {
        TParseTreeNode retval = this.createNode(nodeType);
        retval.init(arg1, arg2);
        return retval;
    }

    public final TParseTreeNode createNode(int nodeType, Object arg1, Object arg2, Object arg3) {
        TParseTreeNode retval = this.createNode(nodeType);
        retval.init(arg1, arg2, arg3);
        return retval;
    }

    public final TParseTreeNode createNode(int nodeType, Object arg1, Object arg2, Object arg3, Object arg4) {
        TParseTreeNode retval = this.createNode(nodeType);
        retval.init(arg1, arg2, arg3, arg4);
        return retval;
    }

    public final TParseTreeNode createNode(int nodeType, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        TParseTreeNode retval = this.createNode(nodeType);
        retval.init(arg1, arg2, arg3, arg4, arg5);
        return retval;
    }

    public final TParseTreeNode createNode(int nodeType, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        TParseTreeNode retval = this.createNode(nodeType);
        retval.init(arg1, arg2, arg3, arg4, arg5, arg6);
        return retval;
    }
}

