/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TResultColumn;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.nodes.couchbase.TObjectConstruct;
import gudusoft.gsqlparser.nodes.couchbase.TPair;
import gudusoft.gsqlparser.stmt.TMergeSqlStatement;

public class TMergeInsertClause
extends TParseTreeNode {
    private TExpression insertWhereClause;
    private TObjectNameList columnList;
    private TResultColumnList valuelist;
    private TObjectName rowTypeValue;
    private TExpression insertValue;

    public TObjectName getRowTypeValue() {
        return this.rowTypeValue;
    }

    public TObjectNameList getColumnList() {
        return this.columnList;
    }

    public TExpression getInsertWhereClause() {
        return this.insertWhereClause;
    }

    public TResultColumnList getValuelist() {
        return this.valuelist;
    }

    @Override
    public void init(Object arg1) {
        this.insertValue = (TExpression)arg1;
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.init(arg1);
        this.insertWhereClause = (TExpression)arg2;
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3) {
        this.columnList = (TObjectNameList)arg1;
        if (arg2 instanceof TResultColumnList) {
            this.valuelist = (TResultColumnList)arg2;
        } else if (arg2 instanceof TObjectName) {
            this.rowTypeValue = (TObjectName)arg2;
        } else if (arg2 instanceof TObjectNameList) {
            this.valuelist = new TResultColumnList();
            TObjectNameList onList = (TObjectNameList)arg2;
            for (int i = 0; i < onList.size(); ++i) {
                TResultColumn rc = new TResultColumn();
                TExpression retval = new TExpression();
                retval.init((Object)EExpressionType.simple_object_name_t);
                TObjectName objectName = onList.getObjectName(i);
                objectName.setObjectType(1);
                retval.setObjectOperand(objectName);
                retval.setStartToken(objectName);
                retval.setEndToken(objectName);
                rc.init(retval);
                this.valuelist.addResultColumn(rc);
            }
        }
        if (arg3 != null) {
            this.insertWhereClause = (TExpression)arg3;
        }
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        if (this.columnList != null) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                TObjectName crf = this.columnList.getObjectName(i);
                crf.setLocation(ESqlClause.insertColumn);
                psql.getTargetTable().getObjectNameReferences().addObjectName(crf);
                psql.getTargetTable().getLinkedColumns().addObjectName(crf);
                crf.setSourceTable(psql.getTargetTable());
            }
        }
        if (this.valuelist != null) {
            for (int i = 0; i < this.valuelist.size(); ++i) {
                TExpression expression;
                TResultColumn resultColumn = this.valuelist.getResultColumn(i);
                if (resultColumn.getExpr() == null || (expression = resultColumn.getExpr()).getObjectOperand() == null) continue;
                TMergeSqlStatement mergeSqlStatement = (TMergeSqlStatement)psql;
                mergeSqlStatement.getUsingTable().getLinkedColumns().addObjectName(expression.getObjectOperand());
                expression.getObjectOperand().setSourceTable(mergeSqlStatement.getUsingTable());
            }
            this.valuelist.doParse(psql, ESqlClause.insertValues);
        }
        if (this.insertValue != null && this.insertValue.getExpressionType() == EExpressionType.objectConstruct_t) {
            TObjectConstruct objectConstruct = this.insertValue.getObjectConstruct();
            TMergeSqlStatement mergeSqlStatement = (TMergeSqlStatement)psql;
            for (int i = 0; i < objectConstruct.getPairs().size(); ++i) {
                TPair pair = objectConstruct.getPairs().getElement(i);
                if (pair.getKeyName() != null && pair.getKeyName().getExpressionType() == EExpressionType.simple_constant_t) {
                    TObjectName columnName = new TObjectName();
                    TSourceToken newSt = new TSourceToken(pair.getKeyName().getConstantOperand().getValueToken().getTextWithoutQuoted());
                    columnName.setPartToken(newSt);
                    mergeSqlStatement.getTargetTable().getLinkedColumns().addObjectName(columnName);
                    columnName.setSourceTable(mergeSqlStatement.getTargetTable());
                }
                pair.getKeyValue().doParse(psql, plocation);
            }
        }
        if (this.insertWhereClause != null) {
            this.insertWhereClause.doParse(psql, ESqlClause.where);
        }
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.columnList != null) {
            this.columnList.acceptChildren(v);
        }
        if (this.valuelist != null) {
            this.valuelist.acceptChildren(v);
        }
        if (this.insertWhereClause != null) {
            this.insertWhereClause.acceptChildren(v);
        }
        v.postVisit(this);
    }

    public void setInsertWhereClause(TExpression insertWhereClause) {
        this.insertWhereClause = insertWhereClause;
    }

    public void setColumnList(TObjectNameList columnList) {
        this.columnList = columnList;
    }

    public void setValuelist(TResultColumnList valuelist) {
        this.valuelist = valuelist;
    }

    public void setRowTypeValue(TObjectName rowTypeValue) {
        this.rowTypeValue = rowTypeValue;
    }

    public TExpression getInsertValue() {
        return this.insertValue;
    }
}

