/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSymbolTableManager;
import gudusoft.gsqlparser.TSymbolVariable;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TExpressionList;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;

public class TIntoClause
extends TParseTreeNode {
    private boolean bulkCollect = false;
    private TSourceToken filename;
    private TExpressionList exprList = null;
    private TObjectName intoName = null;
    private TObjectNameList variableList = null;

    public void setBulkCollect(boolean bulkCollect) {
        this.bulkCollect = bulkCollect;
    }

    public boolean isBulkCollect() {
        return this.bulkCollect;
    }

    public TObjectNameList getVariableList() {
        return this.variableList;
    }

    public void setIntoName(TObjectName intoName) {
        this.intoName = intoName;
    }

    public TObjectName getIntoName() {
        if (this.intoName != null) {
            return this.intoName;
        }
        return this.exprList.getExpression(0).getObjectOperand();
    }

    public TExpressionList getExprList() {
        return this.exprList;
    }

    public TSourceToken getFilename() {
        return this.filename;
    }

    @Override
    public void init(Object arg1) {
        if (arg1 instanceof TExpressionList) {
            this.exprList = (TExpressionList)arg1;
        } else if (arg1 instanceof TSourceToken) {
            this.filename = (TSourceToken)arg1;
        } else if (arg1 instanceof TObjectNameList) {
            this.variableList = (TObjectNameList)arg1;
            for (int i = 0; i < this.variableList.size(); ++i) {
                this.variableList.getObjectName(i).setDbObjectType(EDbObjectType.variable);
            }
            this.intoName = this.variableList.getObjectName(0);
        }
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        if (this.exprList != null) {
            for (int i = 0; i < this.exprList.size(); ++i) {
                TExpression expr = this.exprList.getExpression(i);
                if (expr.getExpressionType() == EExpressionType.simple_object_name_t) {
                    TObjectName dbObject = expr.getObjectOperand();
                    if (psql.dbvendor == EDbVendor.dbvmssql || psql.dbvendor == EDbVendor.dbvgreenplum || psql.dbvendor == EDbVendor.dbvpostgresql || psql.dbvendor == EDbVendor.dbvsybase || psql.dbvendor == EDbVendor.dbvodbc) {
                        if (dbObject.toString().startsWith("@")) {
                            dbObject.setObjectType(10);
                            continue;
                        }
                        TSymbolVariable symbolVariable = TSymbolTableManager.searchSymbolVariable(psql.getFrameStack(), dbObject.toString());
                        if (symbolVariable != null) {
                            dbObject.setDbObjectType(EDbObjectType.variable);
                            continue;
                        }
                        TTable table = new TTable();
                        dbObject.setObjectType(3);
                        table.setTableName(dbObject);
                        table.setTableType(ETableSource.objectname);
                        table.setEffectType(ETableEffectType.tetSelectInto);
                        psql.addToTables(table);
                        if (!(psql instanceof TSelectSqlStatement)) continue;
                        table.setColumnListInTempTable(((TSelectSqlStatement)psql).getResultColumnList());
                        continue;
                    }
                    dbObject.setObjectType(10);
                    dbObject.setDbObjectType(EDbObjectType.variable);
                    continue;
                }
                expr.doParse(psql, ESqlClause.selectInto);
            }
        }
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setExprList(TExpressionList exprList) {
        this.exprList = exprList;
    }
}

