/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TDummy;
import gudusoft.gsqlparser.nodes.TFromTable;
import gudusoft.gsqlparser.nodes.TMultiTargetList;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;

public class TInsertIntoValue
extends TParseTreeNode {
    private TFromTable fromTable;
    private TMultiTargetList targetList;
    private TObjectNameList columnList;
    private TTable table;

    public TTable getTable() {
        return this.table;
    }

    public TObjectNameList getColumnList() {
        return this.columnList;
    }

    public TMultiTargetList getTargetList() {
        return this.targetList;
    }

    @Override
    public void init(Object arg1) {
        this.fromTable = (TFromTable)arg1;
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.fromTable = (TFromTable)((TDummy)arg1).node1;
        if (((TDummy)arg1).node1 != null) {
            this.columnList = (TObjectNameList)((TDummy)arg1).node2;
        }
        if (arg2 != null) {
            this.targetList = (TMultiTargetList)((TDummy)arg2).list1;
        }
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        this.table = psql.analyzeFromTable(this.fromTable, true);
        if (this.columnList != null) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                TObjectName crf = this.columnList.getObjectName(i);
                crf.setLocation(ESqlClause.insertColumn);
                this.table.getObjectNameReferences().addObjectName(crf);
                this.table.getLinkedColumns().addObjectName(crf);
                crf.setSourceTable(this.table);
            }
        }
        if (this.targetList != null) {
            this.targetList.doParse(psql, ESqlClause.insertValues);
        }
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        this.table.acceptChildren(v);
        if (this.columnList != null) {
            this.columnList.acceptChildren(v);
        }
        if (this.targetList != null) {
            this.targetList.acceptChildren(v);
        }
        v.postVisit(this);
    }

    public void setFromTable(TFromTable fromTable) {
        this.fromTable = fromTable;
    }

    public void setTargetList(TMultiTargetList targetList) {
        this.targetList = targetList;
    }

    public void setColumnList(TObjectNameList columnList) {
        this.columnList = columnList;
    }

    public void setTable(TTable table) {
        this.table = table;
    }
}

