/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.EFunctionType;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TAliasClause;
import gudusoft.gsqlparser.nodes.TContainsTable;
import gudusoft.gsqlparser.nodes.TDataChangeTable;
import gudusoft.gsqlparser.nodes.TDummy;
import gudusoft.gsqlparser.nodes.TDummyList;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TExpressionList;
import gudusoft.gsqlparser.nodes.TFlashback;
import gudusoft.gsqlparser.nodes.TFromTableList;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TInformixOuterClause;
import gudusoft.gsqlparser.nodes.TJoinExpr;
import gudusoft.gsqlparser.nodes.TJsonTable;
import gudusoft.gsqlparser.nodes.TMergeSqlNode;
import gudusoft.gsqlparser.nodes.TMultiTargetList;
import gudusoft.gsqlparser.nodes.TNodeWithAliasClause;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TOpenDatasource;
import gudusoft.gsqlparser.nodes.TOpenQuery;
import gudusoft.gsqlparser.nodes.TOpenRowSet;
import gudusoft.gsqlparser.nodes.TOpenXML;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TPartitionClause;
import gudusoft.gsqlparser.nodes.TPartitionExtensionClause;
import gudusoft.gsqlparser.nodes.TPivotClause;
import gudusoft.gsqlparser.nodes.TPivotedTable;
import gudusoft.gsqlparser.nodes.TPxGranule;
import gudusoft.gsqlparser.nodes.TRelationExpr;
import gudusoft.gsqlparser.nodes.TSelectSqlNode;
import gudusoft.gsqlparser.nodes.TTableHint;
import gudusoft.gsqlparser.nodes.TTableSample;
import gudusoft.gsqlparser.nodes.TXmlTable;
import gudusoft.gsqlparser.nodes.bigquery.TUnnestClause;
import gudusoft.gsqlparser.nodes.hive.THiveFromQuerySqlNode;
import gudusoft.gsqlparser.nodes.hive.THiveKeyValueProperty;
import gudusoft.gsqlparser.nodes.hive.THiveLateralView;
import gudusoft.gsqlparser.nodes.hive.THivePartitionedTableFunction;
import gudusoft.gsqlparser.nodes.teradata.TTDUnpivot;

public class TFromTable
extends TNodeWithAliasClause {
    private TPartitionClause partitionClause;
    private TExpression joinCondition;
    private int parenthesisCount = 0;
    private int parenthesisAfterAliasCount = 0;
    private TPTNodeList<THiveKeyValueProperty> tableProperties;
    private THiveFromQuerySqlNode fromQuerySqlNode;
    private TPartitionExtensionClause partitionExtensionClause;
    private TJsonTable jsonTable;
    private TXmlTable xmlTable;
    private TObjectName tableObjectName;
    private TPTNodeList<TTableHint> tableHintList;
    private TSelectSqlNode subquerynode;
    private TExpression tableExpr;
    private TMultiTargetList rowList;
    private TSourceToken tableonly;
    private boolean tableKeyword = false;
    private boolean onlyKeyword = false;
    private TJoinExpr joinExpr;
    private ETableSource fromtableType;
    private TOpenDatasource openDatasource = null;
    private TOpenXML openXML = null;
    private TOpenRowSet openRowSet = null;
    private TOpenQuery openQuery = null;
    private TContainsTable containsTable = null;
    private TTableSample tableSample;
    private TPxGranule pxGranule;
    private TFlashback flashback;
    private TDataChangeTable datachangeTable = null;
    private TRelationExpr relationExpr;
    private TMergeSqlNode mergeSqlNode;
    private TPivotedTable pivotedTable;
    private TPivotClause pivotClause = null;
    private TFunctionCall funcCall = null;
    private TInformixOuterClause outerClause;
    private TFromTableList fromTableList;
    private THivePartitionedTableFunction partitionedTableFunction;
    private TPTNodeList<THiveLateralView> lateralViewList;
    private TExpressionList joinExprList;
    private TUnnestClause unnestClause;
    private TTDUnpivot tdUnpivot;

    public void setPartitionClause(TPartitionClause partitionClause) {
        this.partitionClause = partitionClause;
    }

    public TPartitionClause getPartitionClause() {
        return this.partitionClause;
    }

    public void setJoinCondition(TExpression joinCondition) {
        this.joinCondition = joinCondition;
    }

    public TExpression getJoinCondition() {
        return this.joinCondition;
    }

    public TPxGranule getPxGranule() {
        return this.pxGranule;
    }

    public void incParenthesisCount() {
        ++this.parenthesisCount;
    }

    public void incParenthesisAfterAliasCount() {
        ++this.parenthesisAfterAliasCount;
    }

    public int getParenthesisCount() {
        return this.parenthesisCount;
    }

    public int getParenthesisAfterAliasCount() {
        return this.parenthesisAfterAliasCount;
    }

    public void setTableProperties(TPTNodeList<THiveKeyValueProperty> tableProperties) {
        this.tableProperties = tableProperties;
    }

    public TPTNodeList<THiveKeyValueProperty> getTableProperties() {
        return this.tableProperties;
    }

    public TPartitionExtensionClause getPartitionExtensionClause() {
        return this.partitionExtensionClause;
    }

    public void setPartitionExtensionClause(TPartitionExtensionClause partitionExtensionClause) {
        this.partitionExtensionClause = partitionExtensionClause;
    }

    public TJsonTable getJsonTable() {
        return this.jsonTable;
    }

    public TXmlTable getXmlTable() {
        return this.xmlTable;
    }

    public TObjectName getTableObjectName() {
        return this.tableObjectName;
    }

    public TExpression getTableExpr() {
        return this.tableExpr;
    }

    public void setTableObjectName(TObjectName tableObjectName) {
        this.tableObjectName = tableObjectName;
        this.tableObjectName.setObjectType(3);
    }

    public TOpenQuery getOpenQuery() {
        return this.openQuery;
    }

    public void setTableHintList(TPTNodeList<TTableHint> tableHintList) {
        this.tableHintList = tableHintList;
    }

    public TPTNodeList<TTableHint> getTableHintList() {
        return this.tableHintList;
    }

    public TSelectSqlNode getSubquerynode() {
        return this.subquerynode;
    }

    public TMultiTargetList getRowList() {
        return this.rowList;
    }

    public boolean isTableKeyword() {
        return this.tableKeyword;
    }

    public boolean isOnlyKeyword() {
        return this.onlyKeyword;
    }

    public TJoinExpr getJoinExpr() {
        return this.joinExpr;
    }

    public ETableSource getFromtableType() {
        return this.fromtableType;
    }

    public TOpenDatasource getOpenDatasource() {
        return this.openDatasource;
    }

    public TOpenRowSet getOpenRowSet() {
        return this.openRowSet;
    }

    public TOpenXML getOpenXML() {
        return this.openXML;
    }

    public TContainsTable getContainsTable() {
        return this.containsTable;
    }

    public void setTableonly(TSourceToken tableonly) {
        this.tableonly = tableonly;
        if (tableonly.toString().equalsIgnoreCase("only")) {
            this.onlyKeyword = true;
        } else if (tableonly.toString().equalsIgnoreCase("table")) {
            this.tableKeyword = true;
            if (this.tableExpr != null) {
                this.fromtableType = ETableSource.tableExpr;
            }
        }
    }

    public void setTableSample(TTableSample tableSample) {
        this.tableSample = tableSample;
    }

    public void setPxGranule(TPxGranule pxGranule) {
        this.pxGranule = pxGranule;
    }

    public void setFlashback(TFlashback flashback) {
        this.flashback = flashback;
    }

    public TFlashback getFlashback() {
        return this.flashback;
    }

    public TTableSample getTableSample() {
        return this.tableSample;
    }

    public TRelationExpr getRelationExpr() {
        return this.relationExpr;
    }

    public TDataChangeTable getDatachangeTable() {
        return this.datachangeTable;
    }

    public TMergeSqlNode getMergeSqlNode() {
        return this.mergeSqlNode;
    }

    public TPivotedTable getPivotedTable() {
        return this.pivotedTable;
    }

    public void setPivotClause(TPivotClause pivotClause) {
        this.pivotClause = pivotClause;
    }

    public TPivotClause getPivotClause() {
        return this.pivotClause;
    }

    public TFunctionCall getFuncCall() {
        return this.funcCall;
    }

    public TFromTableList getFromTableList() {
        return this.fromTableList;
    }

    public TInformixOuterClause getOuterClause() {
        return this.outerClause;
    }

    public THivePartitionedTableFunction getPartitionedTableFunction() {
        return this.partitionedTableFunction;
    }

    public void setLateralViewList(TPTNodeList<THiveLateralView> lateralViewList) {
        this.lateralViewList = lateralViewList;
    }

    public TPTNodeList<THiveLateralView> getLateralViewList() {
        return this.lateralViewList;
    }

    public void setJoinExprList(TExpressionList joinExprList) {
        this.joinExprList = joinExprList;
    }

    public TExpressionList getJoinExprList() {
        return this.joinExprList;
    }

    public THiveFromQuerySqlNode getFromQuerySqlNode() {
        return this.fromQuerySqlNode;
    }

    @Override
    public void init(Object arg1) {
        if (arg1 instanceof TObjectName) {
            this.setTableObjectName((TObjectName)arg1);
            this.fromtableType = ETableSource.objectname;
        } else if (arg1 instanceof TSelectSqlNode) {
            this.subquerynode = (TSelectSqlNode)arg1;
            this.fromtableType = ETableSource.subquery;
        } else if (arg1 instanceof TExpression) {
            this.tableExpr = (TExpression)arg1;
            this.fromtableType = ETableSource.tableExpr;
            if (this.tableExpr.getExpressionType() == EExpressionType.simple_object_name_t) {
                this.setTableObjectName(this.tableExpr.getObjectOperand());
                this.fromtableType = ETableSource.objectname;
            }
        } else if (arg1 instanceof TJoinExpr) {
            this.joinExpr = (TJoinExpr)arg1;
            this.fromtableType = ETableSource.join;
        } else if (arg1 instanceof TDummy) {
            this.initTableDefInDummyNode((TDummy)arg1);
        } else if (arg1 instanceof TContainsTable) {
            this.containsTable = (TContainsTable)arg1;
            this.fromtableType = ETableSource.containsTable;
        } else if (arg1 instanceof TOpenRowSet) {
            this.openRowSet = (TOpenRowSet)arg1;
            this.fromtableType = ETableSource.openrowset;
        } else if (arg1 instanceof TOpenXML) {
            this.openXML = (TOpenXML)arg1;
            this.fromtableType = ETableSource.openxml;
        } else if (arg1 instanceof TOpenDatasource) {
            this.openDatasource = (TOpenDatasource)arg1;
            this.fromtableType = ETableSource.opendatasource;
        } else if (arg1 instanceof TOpenQuery) {
            this.openQuery = (TOpenQuery)arg1;
            this.fromtableType = ETableSource.openquery;
        } else if (arg1 instanceof TDataChangeTable) {
            this.datachangeTable = (TDataChangeTable)arg1;
            this.fromtableType = ETableSource.datachangeTable;
        } else if (arg1 instanceof TRelationExpr) {
            this.relationExpr = (TRelationExpr)arg1;
            this.setTableObjectName(this.relationExpr.getRelationName());
            this.fromtableType = ETableSource.objectname;
        } else if (arg1 instanceof TFunctionCall) {
            this.funcCall = (TFunctionCall)arg1;
            this.fromtableType = ETableSource.function;
        } else if (arg1 instanceof TMultiTargetList) {
            this.rowList = (TMultiTargetList)arg1;
            this.fromtableType = ETableSource.rowList;
        } else if (arg1 instanceof TXmlTable) {
            this.xmlTable = (TXmlTable)arg1;
            this.fromtableType = ETableSource.xmltable;
        } else if (arg1 instanceof TInformixOuterClause) {
            this.outerClause = (TInformixOuterClause)arg1;
            this.fromtableType = ETableSource.informixOuter;
        } else if (arg1 instanceof TFromTableList) {
            this.fromtableType = ETableSource.table_ref_list;
            this.fromTableList = (TFromTableList)arg1;
        } else if (arg1 instanceof THivePartitionedTableFunction) {
            this.partitionedTableFunction = (THivePartitionedTableFunction)arg1;
        } else if (arg1 instanceof THiveFromQuerySqlNode) {
            this.fromQuerySqlNode = (THiveFromQuerySqlNode)arg1;
            this.fromtableType = ETableSource.hiveFromQuery;
        } else if (arg1 instanceof TPivotedTable) {
            this.pivotedTable = (TPivotedTable)arg1;
            this.fromtableType = ETableSource.pivoted_table;
        } else if (arg1 instanceof TMergeSqlNode) {
            this.mergeSqlNode = (TMergeSqlNode)arg1;
            this.fromtableType = ETableSource.output_merge;
        } else if (arg1 instanceof TTDUnpivot) {
            this.tdUnpivot = (TTDUnpivot)arg1;
            this.fromtableType = ETableSource.td_unpivot;
        } else if (arg1 instanceof TUnnestClause) {
            this.unnestClause = (TUnnestClause)arg1;
            this.fromtableType = ETableSource.unnest;
        } else if (arg1 instanceof TJsonTable) {
            this.jsonTable = (TJsonTable)arg1;
            this.fromtableType = ETableSource.jsonTable;
        }
    }

    public TUnnestClause getUnnestClause() {
        return this.unnestClause;
    }

    public TTDUnpivot getTdUnpivot() {
        return this.tdUnpivot;
    }

    private TPTNodeList<TTableHint> nameListToTableHint(Object arg1, boolean isSybaseIndexHint) {
        TPTNodeList<TTableHint> hints = new TPTNodeList<TTableHint>();
        if (arg1 instanceof TObjectNameList) {
            TObjectNameList columns = (TObjectNameList)arg1;
            for (int i = 0; i < columns.size(); ++i) {
                TObjectName column = columns.getObjectName(i);
                if (!isSybaseIndexHint && !this.isSQLServerHint(column.toString())) {
                    hints.removeAllElements();
                    break;
                }
                TTableHint tableHint = new TTableHint();
                tableHint.setHint(column);
                if (i == 0) {
                    tableHint.setStartToken(column.getStartToken());
                }
                if (i == columns.size() - 1) {
                    tableHint.setEndToken(column.getStartToken());
                }
                hints.addElement(tableHint);
            }
        } else if (arg1 instanceof TExpressionList) {
            TExpressionList expressionList = (TExpressionList)arg1;
            for (int i = 0; i < expressionList.size(); ++i) {
                TExpression expression = expressionList.getExpression(i);
                if (!isSybaseIndexHint && !this.isSQLServerHint(expression.toString())) {
                    hints.removeAllElements();
                    break;
                }
                TTableHint tableHint = new TTableHint();
                tableHint.setHint(expression.getObjectOperand());
                if (i == 0) {
                    tableHint.setStartToken(expression.getStartToken());
                }
                if (i == expressionList.size() - 1) {
                    tableHint.setEndToken(expression.getStartToken());
                }
                hints.addElement(tableHint);
            }
        }
        if (hints.size() > 0) {
            return hints;
        }
        return null;
    }

    private boolean isSQLServerHint(String pstr) {
        boolean retval = false;
        String[] hints = new String[]{"fastfirstrow", "holdlock", "nolock", "nowait", "paglock", "readcommitted", "readcommittedlock", "readpast", "readuncommitted", "repeatableread", "rowlock", "serializable", "tablock", "tablockx", "updlock", "xlock", "keepidentity", "keepdefaults", "ignore_constraints", "ignore_triggers", "index"};
        for (int i = 0; i < 21; ++i) {
            if (hints[i].compareToIgnoreCase(pstr) != 0) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private void initTableDefInDummyNode(TDummy pdummy) {
        this.fromtableType = ETableSource.objectname;
        if (pdummy.int1 == 0) {
            this.setTableObjectName((TObjectName)pdummy.node1);
        } else if (pdummy.int1 == 1) {
            if (pdummy.list1 == null) {
                this.funcCall = new TFunctionCall();
                this.funcCall.init((TObjectName)pdummy.node1, (Object)EFunctionType.udf_t);
                this.funcCall.setArgs(null);
                this.fromtableType = ETableSource.function;
            } else {
                this.tableHintList = this.nameListToTableHint((TExpressionList)pdummy.list1, false);
                if (this.tableHintList != null) {
                    this.setTableObjectName((TObjectName)pdummy.node1);
                } else {
                    this.funcCall = new TFunctionCall();
                    this.funcCall.init((TObjectName)pdummy.node1, (Object)EFunctionType.udf_t);
                    this.funcCall.setArgs((TExpressionList)pdummy.list1);
                    this.fromtableType = ETableSource.function;
                    this.funcCall.setStartToken(pdummy.getStartToken());
                    this.funcCall.setEndToken(pdummy.getEndToken());
                }
            }
        } else if (pdummy.int1 == 2) {
            this.setTableObjectName((TObjectName)pdummy.node1);
            this.tableHintList = this.nameListToTableHint(pdummy.list1, false);
        } else if (pdummy.int1 == 3) {
            this.setTableObjectName((TObjectName)pdummy.node1);
            this.tableHintList = (TPTNodeList)pdummy.node3;
        }
        if (pdummy.node2 != null) {
            this.setAliasClause((TAliasClause)pdummy.node2);
            if (this.getAliasClause().isSybaseIndexHint()) {
                this.tableHintList = this.getAliasClause().getTableHints();
                this.getAliasClause().setEndToken(this.getAliasClause().getAliasName().getEndToken());
            } else if (this.getAliasClause().getColumns() != null) {
                this.tableHintList = this.nameListToTableHint(this.getAliasClause().getColumns(), this.getAliasClause().isSybaseIndexHint());
                if (this.tableHintList != null) {
                    this.getAliasClause().setEndToken(this.getAliasClause().getAliasName().getEndToken());
                }
            }
        }
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.init(arg1);
        if (arg2 != null) {
            this.setAliasClause((TAliasClause)arg2);
        }
    }

    public void setTableProperties(TDummyList tableProperties) {
        for (int i = 0; i < tableProperties.size(); ++i) {
            TDummy dummy = tableProperties.getDummyItem(i);
            TParseTreeNode node = dummy.node1;
            if (!(node instanceof TAliasClause)) continue;
            this.setAliasClause((TAliasClause)node);
        }
    }

    public void setParenthesisCount(int parenthesisCount) {
        this.parenthesisCount = parenthesisCount;
    }

    public void setParenthesisAfterAliasCount(int parenthesisAfterAliasCount) {
        this.parenthesisAfterAliasCount = parenthesisAfterAliasCount;
    }

    public void setXmlTable(TXmlTable xmlTable) {
        this.xmlTable = xmlTable;
    }

    public void setTableExpr(TExpression tableExpr) {
        this.tableExpr = tableExpr;
    }

    public void setRowList(TMultiTargetList rowList) {
        this.rowList = rowList;
    }

    public void setTableKeyword(boolean tableKeyword) {
        this.tableKeyword = tableKeyword;
    }

    public void setOnlyKeyword(boolean onlyKeyword) {
        this.onlyKeyword = onlyKeyword;
    }

    public void setJoinExpr(TJoinExpr joinExpr) {
        this.joinExpr = joinExpr;
    }

    public void setFromtableType(ETableSource fromtableType) {
        this.fromtableType = fromtableType;
    }

    public void setOpenDatasource(TOpenDatasource openDatasource) {
        this.openDatasource = openDatasource;
    }

    public void setOpenXML(TOpenXML openXML) {
        this.openXML = openXML;
    }

    public void setOpenRowSet(TOpenRowSet openRowSet) {
        this.openRowSet = openRowSet;
    }

    public void setOpenQuery(TOpenQuery openQuery) {
        this.openQuery = openQuery;
    }

    public void setContainsTable(TContainsTable containsTable) {
        this.containsTable = containsTable;
    }

    public void setDatachangeTable(TDataChangeTable datachangeTable) {
        this.datachangeTable = datachangeTable;
    }

    public void setRelationExpr(TRelationExpr relationExpr) {
        this.relationExpr = relationExpr;
    }

    public void setPivotedTable(TPivotedTable pivotedTable) {
        this.pivotedTable = pivotedTable;
    }

    public void setFuncCall(TFunctionCall funcCall) {
        this.funcCall = funcCall;
    }

    public void setOuterClause(TInformixOuterClause outerClause) {
        this.outerClause = outerClause;
    }

    public void setFromTableList(TFromTableList fromTableList) {
        this.fromTableList = fromTableList;
    }

    public void setPartitionedTableFunction(THivePartitionedTableFunction partitionedTableFunction) {
        this.partitionedTableFunction = partitionedTableFunction;
    }
}

