/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EComparisonType;
import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.EQuantifierType;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.IExpressionVisitor;
import gudusoft.gsqlparser.nodes.TAliasClause;
import gudusoft.gsqlparser.nodes.TAnalyticFunction;
import gudusoft.gsqlparser.nodes.TArrayAccess;
import gudusoft.gsqlparser.nodes.TCaseExpression;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TDatetimeExpression;
import gudusoft.gsqlparser.nodes.TExplicitDataTypeConversion;
import gudusoft.gsqlparser.nodes.TExpressionList;
import gudusoft.gsqlparser.nodes.TFlattenVisitor;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TInExpr;
import gudusoft.gsqlparser.nodes.TIndirection;
import gudusoft.gsqlparser.nodes.TIntervalExpression;
import gudusoft.gsqlparser.nodes.TNewVariantTypeArgumentList;
import gudusoft.gsqlparser.nodes.TObjectAccess;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TOutputFormatPhraseList;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TSelectSqlNode;
import gudusoft.gsqlparser.nodes.TTypeName;
import gudusoft.gsqlparser.nodes.TWindowDef;
import gudusoft.gsqlparser.nodes.couchbase.TArrayConstruct;
import gudusoft.gsqlparser.nodes.couchbase.TCollectionArray;
import gudusoft.gsqlparser.nodes.couchbase.TCollectionCondition;
import gudusoft.gsqlparser.nodes.couchbase.TNamedParameter;
import gudusoft.gsqlparser.nodes.couchbase.TObjectConstruct;
import gudusoft.gsqlparser.nodes.couchbase.TPositionalParameter;
import gudusoft.gsqlparser.nodes.hive.THiveVariable;
import gudusoft.gsqlparser.nodes.searchColumnVisitor;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import java.util.ArrayList;
import java.util.Stack;

public class TExpression
extends TParseTreeNode {
    private TCollectionArray collectionArray;
    private TCollectionCondition collectionCondition;
    private TNamedParameter namedParameter;
    private TPositionalParameter positionalParameter;
    private TObjectConstruct objectConstruct;
    private TArrayConstruct arrayConstruct;
    private boolean onlyAndOrIsNonLeaf = false;
    private TFlattenVisitor flattenVisitor;
    private TAliasClause exprAlias;
    private TPTNodeList<TExplicitDataTypeConversion> dataTypeConversionList = null;
    private TExplicitDataTypeConversion dataTypeConversion;
    private TAnalyticFunction over_clause;
    private TObjectName sequenceName;
    private THiveVariable hive_variable = null;
    private boolean isSymmetric = false;
    private TObjectAccess objectAccess = null;
    private TSourceToken operatorToken = null;
    private TSourceToken notToken = null;
    private boolean notOperator = false;
    private TSourceToken leadingPrecision;
    private TSourceToken fractionalSecondsPrecision;
    private Object val = null;
    private TNewVariantTypeArgumentList newVariantTypeArgumentList = null;
    private TTypeName typeName;
    private TObjectName fieldName;
    private boolean subscripts;
    private TIndirection indirection;
    private boolean notModifier;
    private TOutputFormatPhraseList outputFormatPhraseList;
    private TIntervalExpression intervalExpr = null;
    private TExpressionList exprList = null;
    private TObjectNameList fieldList;
    private TInExpr inExpr = null;
    private boolean isOracleOuterJoin = false;
    private TExpression parentExpr;
    private TExpression leftOperand;
    private TExpression rightOperand;
    private TArrayAccess arrayAccess = null;
    private EExpressionType expressionType = EExpressionType.not_initialized_yet_t;
    private TObjectName objectOperand;
    private TConstant constantOperand;
    private TSourceToken sourcetokenOperand;
    private TCaseExpression caseExpression;
    private TSelectSqlNode subQueryNode = null;
    private TSelectSqlStatement subQuery = null;
    private boolean isSubQueryInStmt = false;
    private TFunctionCall functionCall;
    private TDatetimeExpression datetimeExpression;
    private TIntervalExpression intervalExpression;
    private TExpression betweenOperand;
    private TExpression likeEscapeOperand;
    private EComparisonType comparisonType = EComparisonType.unknown;
    private TSourceToken comparisonOperator = null;
    private TSourceToken quantifier = null;
    private EQuantifierType quantifierType = EQuantifierType.none;
    private Stack exprStack = null;
    private boolean visitSubTree = true;
    public static final int BigAndOrNestLevel = 100;
    public static final int unknown = 0;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int TIMES = 3;
    public static final int DIVIDE = 4;
    public static final int CONCATENATE = 5;
    public static final int MODULO = 6;
    public static final int ASSIGNMENT = 7;
    public static final int BITWISE_AND = 8;
    public static final int BITWISE_OR = 9;
    public static final int BITWISE_XOR = 10;
    public static final int BITWISE_EXCLUSIVE_OR = 11;
    public static final int SCOPE_RESOLUTION = 12;
    public static final int EXPONENTIATE = 13;
    public static final int compoundAssignment = 14;
    public static final int simpleObjectname = 15;
    public static final int simpleConstant = 16;
    public static final int simpleSourcetoken = 17;
    public static final int compoundParenthesis = 18;
    public static final int compoundUnaryPlus = 19;
    public static final int compoundUnaryMinus = 20;
    public static final int compoundPrior = 21;
    public static final int caseExprOperator = 22;
    public static final int cursorExprOperator = 23;
    public static final int funcationCallOperator = 24;
    public static final int datetimeExprOperator = 25;
    public static final int intervalExprOperator = 26;
    public static final int modelExprOperator = 27;
    public static final int subqueryExprOperator = 28;
    public static final int typeconstructorExprOperator = 29;
    public static final int objectaccessExprOperator = 30;
    public static final int placeholderExprOperator = 32;
    public static final int in_expr = 34;
    public static final int expr_list = 35;
    public static final int dummyOperator = 37;
    public static final int simple_comparison_conditions = 40;
    public static final int group_comparison_conditions = 41;
    public static final int in_conditions = 42;
    public static final int floating_point_conditions = 43;
    public static final int pattern_matching_conditions = 45;
    public static final int null_conditions = 46;
    public static final int between_conditions = 47;
    public static final int exists_condition = 48;
    public static final int isoftype_condition = 49;
    public static final int logical_conditions_and = 50;
    public static final int logical_conditions_or = 51;
    public static final int logical_conditions_xor = 52;
    public static final int logical_conditions_not = 53;
    public static final int logical_conditions_is = 54;
    public static final int RANGE = 55;
    public static final int POWER = 56;
    public static final int at_time_zone = 100;
    public static final int at_local = 101;
    public static final int day_to_second = 102;
    public static final int year_to_month = 103;
    public static final int interval_expression = 104;
    public static final int new_structured_type = 110;
    public static final int new_variant_type = 111;
    public static final int period_ldiff = 115;
    public static final int period_rdiff = 117;
    public static final int period_p_intersect = 119;
    public static final int period_p_normalize = 121;
    public static final int until_changed = 123;
    public static final int is_document = 133;
    public static final int is_distinct_from = 135;
    public static final int true_false_unknown = 137;
    public static final int COLLATE = 223;
    public static final int LEFTJOIN_OP = 224;
    public static final int RIGHTJOIN_OP = 225;
    public static final int ref_arrow = 226;
    public static final int typecast = 227;
    public static final int arrayaccess = 228;
    public static final int connect_by_root = 229;
    public static final int sqlserver_proprietary_column_alias = 230;
    public static final int mysql_binary_operator = 300;
    public static final int left_shift = 301;
    public static final int right_shift = 302;
    public static final int multisetExprOperator = 310;
    public static final int fieldSelection = 501;
    public static final int arrayConstructor = 505;
    public static final int rowConstructor = 509;
    public static final int factorial = 515;
    public static final int squareRoot = 517;
    public static final int cubeRoot = 519;
    public static final int factorialPrefix = 521;
    public static final int absoluteValue = 523;
    public static final int BITWISE_SHIFT_LEFT = 525;
    public static final int BITWISE_SHIFT_RIGHT = 527;
    public static final int BITWISE_NOT = 529;
    public static final int compoundUnaryBitwiseNot = 222;
    public static final int member_of = 541;
    public static final int nextValueOf = 601;
    public static final int UnknownOperator = 901;
    public static final int UnknownUnaryOperator = 905;
    public static final int UnknownUnaryOperatorRight = 909;

    public TCollectionCondition getCollectionCondition() {
        return this.collectionCondition;
    }

    public TCollectionArray getCollectionArray() {
        return this.collectionArray;
    }

    public TNamedParameter getNamedParameter() {
        return this.namedParameter;
    }

    public TPositionalParameter getPositionalParameter() {
        return this.positionalParameter;
    }

    public TArrayConstruct getArrayConstruct() {
        return this.arrayConstruct;
    }

    public TObjectConstruct getObjectConstruct() {
        return this.objectConstruct;
    }

    public TExpressionList searchColumn(String columnName) {
        TExpressionList resultList = new TExpressionList();
        this.inOrderTraverse(new searchColumnVisitor(columnName, resultList));
        return resultList;
    }

    public TSourceToken getAndOrTokenBeforeExpr() {
        TSourceToken lcToken = this.getStartToken();
        if (lcToken == null) {
            return null;
        }
        TSourceToken lcPrevToken = lcToken.prevSolidToken();
        if (lcPrevToken.tokencode == 319 || lcPrevToken.tokencode == 320) {
            return lcPrevToken;
        }
        return null;
    }

    public ArrayList getFlattedAndOrExprs() {
        if (this.expressionType != EExpressionType.logical_and_t && this.expressionType != EExpressionType.logical_or_t) {
            return null;
        }
        if (this.flattenVisitor.getFlattedAndOrExprs().size() == 0) {
            this.onlyAndOrIsNonLeaf = true;
            this.inOrderTraverse(this.flattenVisitor);
            this.onlyAndOrIsNonLeaf = false;
        }
        return this.flattenVisitor.getFlattedAndOrExprs();
    }

    public void setTokenToIdentifier() {
        if (this.getExpressionType() == EExpressionType.simple_object_name_t) {
            if (this.getObjectOperand().getEndToken() != null) {
                this.getObjectOperand().getEndToken().tokencode = 264;
                this.getObjectOperand().getEndToken().tokentype = ETokenType.ttidentifier;
            }
        } else if (this.getExpressionType() == EExpressionType.simple_source_token_t) {
            this.getSourcetokenOperand().tokencode = 264;
            this.getSourcetokenOperand().tokentype = ETokenType.ttidentifier;
        }
    }

    public void setComparisonType(EComparisonType comparisonType) {
        this.comparisonType = comparisonType;
    }

    public static EComparisonType getComparisonType(TSourceToken comparisonOperator) {
        String tokenStr = comparisonOperator.astext;
        EComparisonType ret = EComparisonType.equals;
        switch (comparisonOperator.tokencode) {
            case 290: {
                if (tokenStr.startsWith("!") && tokenStr.endsWith("=")) {
                    ret = EComparisonType.notEqualToExclamation;
                    break;
                }
                if (tokenStr.startsWith("^") && tokenStr.endsWith("=")) {
                    ret = EComparisonType.notEqualToCaret;
                    break;
                }
                if (!tokenStr.startsWith("<") || !tokenStr.endsWith(">")) break;
                ret = EComparisonType.notEqualToBrackets;
                break;
            }
            case 293: {
                ret = EComparisonType.greaterThanOrEqualTo;
                break;
            }
            case 294: {
                ret = EComparisonType.lessThanOrEqualTo;
                break;
            }
            case 291: {
                ret = EComparisonType.notGreaterThan;
                if (!tokenStr.startsWith("^")) break;
                ret = EComparisonType.notGreaterThanToCaret;
                break;
            }
            case 292: {
                ret = EComparisonType.notLessThan;
                if (!tokenStr.startsWith("^")) break;
                ret = EComparisonType.notLessThanToCaret;
                break;
            }
            case 61: {
                ret = EComparisonType.equals;
                if (tokenStr.indexOf("=", 1) <= 0 || !tokenStr.startsWith("<") || !tokenStr.endsWith(">")) break;
                ret = EComparisonType.nullSafeEquals;
                break;
            }
            case 62: {
                ret = EComparisonType.greaterThan;
                break;
            }
            case 60: {
                ret = EComparisonType.lessThan;
                break;
            }
        }
        return ret;
    }

    public TAliasClause getExprAlias() {
        return this.exprAlias;
    }

    public void setExprAlias(TAliasClause exprAlias) {
        this.exprAlias = exprAlias;
    }

    public void setDataTypeConversionList(TPTNodeList<TExplicitDataTypeConversion> dataTypeConversionList) {
        this.dataTypeConversionList = dataTypeConversionList;
    }

    public TPTNodeList<TExplicitDataTypeConversion> getDataTypeConversionList() {
        return this.dataTypeConversionList;
    }

    public void setDataTypeConversion(TExplicitDataTypeConversion dataTypeConversion) {
        this.dataTypeConversion = dataTypeConversion;
    }

    public TExplicitDataTypeConversion getDataTypeConversion() {
        if (this.dataTypeConversionList == null) {
            return null;
        }
        return this.dataTypeConversionList.getElement(0);
    }

    public TObjectName getSequenceName() {
        return this.sequenceName;
    }

    public TAnalyticFunction getOver_clause() {
        return this.over_clause;
    }

    public THiveVariable getHive_variable() {
        return this.hive_variable;
    }

    public void setHive_variable(THiveVariable hive_variable) {
        this.hive_variable = hive_variable;
    }

    public void setSymmetric(boolean symmetric) {
        this.isSymmetric = symmetric;
    }

    public boolean isSymmetric() {
        return this.isSymmetric;
    }

    public void setObjectAccess(TObjectAccess objectAccess) {
        this.objectAccess = objectAccess;
    }

    public TObjectAccess getObjectAccess() {
        return this.objectAccess;
    }

    public boolean isNotOperator() {
        return this.notOperator;
    }

    public void setNotToken(TSourceToken notToken) {
        this.notToken = notToken;
        this.notOperator = this.notToken != null;
    }

    public TSourceToken getNotToken() {
        return this.notToken;
    }

    public TExpression() {
    }

    public TExpression(TObjectName objectOperand) {
        this.expressionType = EExpressionType.simple_object_name_t;
        this.objectOperand = objectOperand;
    }

    public TExpression(TConstant constantOperand) {
        this.expressionType = EExpressionType.simple_constant_t;
        this.constantOperand = constantOperand;
    }

    public TExpression(TFunctionCall functionCall) {
        this.expressionType = EExpressionType.function_t;
        this.functionCall = functionCall;
    }

    public TExpression(EExpressionType pExpressionType) {
        this.expressionType = pExpressionType;
    }

    public TExpression(EExpressionType pExpressionType, TExpression pLeft, TExpression pRight) {
        this(pExpressionType);
        this.leftOperand = pLeft;
        this.rightOperand = pRight;
    }

    public TExpression(EExpressionType pExpressionType, TExpression pLeft, TExpression pRight, EComparisonType pComparisonType) {
        this(pExpressionType, pLeft, pRight);
        this.comparisonType = pComparisonType;
    }

    @Override
    public void init(Object arg1) {
        this.expressionType = (EExpressionType)((Object)arg1);
        if (this.expressionType == EExpressionType.logical_and_t || this.expressionType == EExpressionType.logical_or_t) {
            this.flattenVisitor = new TFlattenVisitor();
        }
    }

    public void setLeadingPrecision(TSourceToken leadingPrecision) {
        this.leadingPrecision = leadingPrecision;
    }

    public void setFractionalSecondsPrecision(TSourceToken fractionalSecondsPrecision) {
        this.fractionalSecondsPrecision = fractionalSecondsPrecision;
    }

    public TSourceToken getLeadingPrecision() {
        return this.leadingPrecision;
    }

    public TSourceToken getFractionalSecondsPrecision() {
        return this.fractionalSecondsPrecision;
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.init(arg1);
        switch (this.expressionType) {
            case next_value_for_t: {
                this.sequenceName = (TObjectName)arg2;
                break;
            }
            case array_constructor_t: {
                if (arg2 instanceof TSelectSqlNode) {
                    this.subQueryNode = (TSelectSqlNode)arg2;
                    break;
                }
                if (arg2 instanceof TExpressionList) {
                    this.exprList = (TExpressionList)arg2;
                    break;
                }
                if (!(arg2 instanceof TArrayConstruct)) break;
                this.arrayConstruct = (TArrayConstruct)arg2;
                break;
            }
            case objectConstruct_t: {
                this.objectConstruct = (TObjectConstruct)arg2;
                break;
            }
            case namedParameter_t: {
                this.namedParameter = (TNamedParameter)arg2;
                break;
            }
            case positionalParameter_t: {
                this.positionalParameter = (TPositionalParameter)arg2;
                break;
            }
            case collectionArray_t: {
                this.collectionArray = (TCollectionArray)arg2;
                break;
            }
            case collectionCondition_t: {
                this.collectionCondition = (TCollectionCondition)arg2;
                break;
            }
            case year_to_month_t: 
            case day_to_second_t: 
            case at_local_t: {
                this.leftOperand = (TExpression)arg2;
                break;
            }
            case unnest_t: {
                this.leftOperand = (TExpression)arg2;
                break;
            }
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3) {
        this.init(arg1);
        switch (this.expressionType) {
            case next_value_for_t: {
                this.sequenceName = (TObjectName)arg2;
                if (arg3 == null) break;
                if (arg3 instanceof TExpression) {
                    this.leftOperand = (TExpression)arg3;
                    break;
                }
                if (!(arg3 instanceof TAnalyticFunction)) break;
                this.over_clause = (TAnalyticFunction)arg3;
                break;
            }
            case assignment_t: {
                this.leftOperand = (TExpression)arg2;
                this.rightOperand = (TExpression)arg3;
                break;
            }
            default: {
                this.leftOperand = (TExpression)arg2;
                this.rightOperand = (TExpression)arg3;
            }
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4) {
        this.init(arg1);
        this.operatorToken = (TSourceToken)arg2;
        switch (this.expressionType) {
            case simple_object_name_t: {
                this.objectOperand = (TObjectName)arg3;
                this.setStartToken(this.objectOperand);
                this.setEndToken(this.objectOperand);
                break;
            }
            case simple_source_token_t: {
                this.sourcetokenOperand = (TSourceToken)arg3;
                this.setStartToken(this.sourcetokenOperand);
                this.setEndToken(this.sourcetokenOperand);
                break;
            }
            case simple_constant_t: {
                this.constantOperand = (TConstant)arg3;
                this.setStartToken(this.constantOperand);
                this.setEndToken(this.constantOperand);
                break;
            }
            case function_t: 
            case type_constructor_t: {
                this.functionCall = (TFunctionCall)arg3;
                break;
            }
            case arrayaccess_t: {
                this.arrayAccess = (TArrayAccess)arg3;
                break;
            }
            case list_t: 
            case collection_constructor_list_t: 
            case collection_constructor_multiset_t: 
            case collection_constructor_set_t: {
                this.exprList = (TExpressionList)arg3;
                break;
            }
            case field_doubt_t: {
                TExpression l = (TExpression)arg3;
                if (l.getExpressionType() == EExpressionType.simple_object_name_t) {
                    TObjectName objectName = l.getObjectOperand();
                    objectName.setSchemaToken(objectName.getObjectToken());
                    objectName.setObjectToken(objectName.getPartToken());
                    objectName.setPartToken((TSourceToken)arg4);
                    this.expressionType = EExpressionType.simple_object_name_t;
                    this.objectOperand = l.getObjectOperand();
                    break;
                }
                this.expressionType = EExpressionType.field_t;
                break;
            }
            default: {
                if (arg3 != null) {
                    this.leftOperand = (TExpression)arg3;
                    this.leftOperand.setParentExpr(this);
                }
                if (arg4 == null) break;
                this.rightOperand = (TExpression)arg4;
                this.rightOperand.setParentExpr(this);
            }
        }
    }

    public void setOperatorToken(TSourceToken operatorToken) {
        this.operatorToken = operatorToken;
        if (this.getExpressionType() == EExpressionType.unknown_t) {
            if (this.operatorToken.toString().equalsIgnoreCase("%")) {
                this.expressionType = EExpressionType.arithmetic_modulo_t;
            } else if (this.operatorToken.toString().equalsIgnoreCase("&")) {
                this.expressionType = EExpressionType.bitwise_and_t;
            } else if (this.operatorToken.toString().equalsIgnoreCase("|")) {
                this.expressionType = EExpressionType.bitwise_or_t;
            } else if (this.operatorToken.toString().equalsIgnoreCase("#")) {
                this.expressionType = EExpressionType.bitwise_xor_t;
            } else if (this.operatorToken.toString().equalsIgnoreCase("<<")) {
                this.expressionType = EExpressionType.left_shift_t;
            } else if (this.operatorToken.toString().equalsIgnoreCase(">>")) {
                this.expressionType = EExpressionType.right_shift_t;
            }
        } else if (this.getExpressionType() == EExpressionType.unary_left_unknown_t) {
            if (this.operatorToken.toString().equalsIgnoreCase("|/")) {
                this.expressionType = EExpressionType.unary_squareroot_t;
            } else if (this.operatorToken.toString().equalsIgnoreCase("||/")) {
                this.expressionType = EExpressionType.unary_cuberoot_t;
            } else if (this.operatorToken.toString().equalsIgnoreCase("!!")) {
                this.expressionType = EExpressionType.unary_factorialprefix_t;
            } else if (this.operatorToken.toString().equalsIgnoreCase("@")) {
                this.expressionType = EExpressionType.unary_absolutevalue_t;
            } else if (this.operatorToken.toString().equalsIgnoreCase("~")) {
                this.expressionType = EExpressionType.unary_bitwise_not_t;
            }
        }
    }

    public TSourceToken getOperatorToken() {
        return this.operatorToken;
    }

    public void setVal(Object val) {
        this.val = val;
    }

    public Object getVal() {
        return this.val;
    }

    public TConstant getConstantOperand() {
        return this.constantOperand;
    }

    public void setNewVariantTypeArgumentList(TNewVariantTypeArgumentList newVariantTypeArgumentList) {
        this.newVariantTypeArgumentList = newVariantTypeArgumentList;
    }

    public TNewVariantTypeArgumentList getNewVariantTypeArgumentList() {
        return this.newVariantTypeArgumentList;
    }

    public void setTypeName(TTypeName typeName) {
        this.typeName = typeName;
    }

    public TTypeName getTypeName() {
        return this.typeName;
    }

    public TObjectName getFieldName() {
        return this.fieldName;
    }

    public void setIndirection(TIndirection indirection) {
        if (indirection != null) {
            if (indirection.isRealIndices()) {
                this.subscripts = true;
            } else {
                this.setExpressionType(EExpressionType.fieldselection_t);
                this.fieldName = indirection.getIndices().getElement(0).getAttributeName();
                this.fieldName.setObjectType(51);
            }
            this.indirection = indirection;
        }
    }

    public boolean isSubscripts() {
        return this.subscripts;
    }

    public TIndirection getIndirection() {
        return this.indirection;
    }

    public boolean isNotModifier() {
        boolean bl = this.notModifier = this.getOperatorToken() != null;
        if (this.notModifier) {
            this.notModifier = this.getOperatorToken().tokencode == 321;
        }
        return this.notModifier;
    }

    public void setOutputFormatPhraseList(TOutputFormatPhraseList outputFormatPhraseList) {
        this.outputFormatPhraseList = outputFormatPhraseList;
    }

    public TOutputFormatPhraseList getOutputFormatPhraseList() {
        return this.outputFormatPhraseList;
    }

    public TExpressionList getExprList() {
        return this.exprList;
    }

    public void setIntervalExpr(TIntervalExpression intervalExpr) {
        this.intervalExpr = intervalExpr;
    }

    public TIntervalExpression getIntervalExpr() {
        return this.intervalExpr;
    }

    public void setFieldList(TObjectNameList fieldList) {
        this.fieldList = fieldList;
    }

    public TObjectNameList getFieldList() {
        return this.fieldList;
    }

    public void setInExpr(TInExpr inExpr) {
        this.inExpr = inExpr;
    }

    public TInExpr getInExpr() {
        return this.inExpr;
    }

    public void setExprList(TExpressionList exprList) {
        this.exprList = exprList;
    }

    public void setOracleOuterJoin(boolean oracleOuterJoin) {
        this.isOracleOuterJoin = oracleOuterJoin;
    }

    public boolean isOracleOuterJoin() {
        return this.isOracleOuterJoin;
    }

    public TExpression getParentExpr() {
        return this.parentExpr;
    }

    public void setParentExpr(TExpression parentExpr) {
        this.parentExpr = parentExpr;
    }

    public void setLeftOperand(TExpression leftOperand) {
        this.leftOperand = leftOperand;
        if (leftOperand != null) {
            leftOperand.setParentExpr(this);
        }
    }

    public void setRightOperand(TExpression rightOperand) {
        this.rightOperand = rightOperand;
        if (rightOperand != null) {
            rightOperand.setParentExpr(this);
        }
    }

    public TExpression getRightOperand() {
        return this.rightOperand;
    }

    public TExpression getLeftOperand() {
        return this.leftOperand;
    }

    public TExpression getLikeEscapeOperand() {
        return this.likeEscapeOperand;
    }

    public TExpression getBetweenOperand() {
        return this.betweenOperand;
    }

    public TArrayAccess getArrayAccess() {
        return this.arrayAccess;
    }

    public EExpressionType getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(EExpressionType exprType) {
        this.expressionType = exprType;
    }

    public void setObjectOperand(TObjectName objectOperand) {
        this.objectOperand = objectOperand;
    }

    public TObjectName getObjectOperand() {
        return this.objectOperand;
    }

    public void setConstantOperand(TConstant constantOperand) {
        this.constantOperand = constantOperand;
    }

    public TSourceToken getSourcetokenOperand() {
        return this.sourcetokenOperand;
    }

    public void setSourcetokenOperand(TSourceToken sourcetokenOperand) {
        this.sourcetokenOperand = sourcetokenOperand;
    }

    public void setCaseExpression(TCaseExpression caseExpression) {
        this.caseExpression = caseExpression;
    }

    public TCaseExpression getCaseExpression() {
        return this.caseExpression;
    }

    public void setArrayAccess(TArrayAccess arrayAccess) {
        this.arrayAccess = arrayAccess;
    }

    public void setSubQueryNode(TSelectSqlNode subQueryNode) {
        this.subQueryNode = subQueryNode;
    }

    public void setSubQuery(TSelectSqlStatement subQuery) {
        this.subQuery = subQuery;
    }

    public TSelectSqlStatement getSubQuery() {
        return this.subQuery;
    }

    public void setSubQueryInStmt(boolean subQueryInStmt) {
        this.isSubQueryInStmt = subQueryInStmt;
    }

    public TFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public void setFunctionCall(TFunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public void setDatetimeExpression(TDatetimeExpression datetimeExpression) {
        this.datetimeExpression = datetimeExpression;
    }

    public void setIntervalExpression(TIntervalExpression intervalExpression) {
        this.intervalExpression = intervalExpression;
    }

    public void setBetweenOperand(TExpression betweenOperand) {
        this.betweenOperand = betweenOperand;
    }

    public void setLikeEscapeOperand(TExpression likeEscapeOperand) {
        this.likeEscapeOperand = likeEscapeOperand;
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        switch (this.expressionType) {
            case simple_object_name_t: {
                psql.linkColumnReferenceToTable(this.objectOperand, plocation);
                psql.linkColumnToTable(this.objectOperand, plocation);
                break;
            }
            case group_t: {
                this.inExpr.doParse(psql, plocation);
                break;
            }
            case list_t: 
            case collection_constructor_list_t: 
            case collection_constructor_multiset_t: 
            case collection_constructor_set_t: {
                if (this.exprList == null) break;
                this.exprList.doParse(psql, plocation);
                break;
            }
            case function_t: 
            case type_constructor_t: 
            case new_structured_type_t: {
                if (this.functionCall.getArgs() != null) {
                    for (int i = 0; i < this.functionCall.getArgs().size(); ++i) {
                        this.functionCall.getArgs().getExpression(i).setParentExpr(this);
                    }
                }
                this.functionCall.doParse(psql, plocation);
                break;
            }
            case cursor_t: 
            case subquery_t: 
            case multiset_t: {
                if (this.subQuery == null) {
                    this.subQuery = new TSelectSqlStatement(psql.dbvendor);
                    this.subQuery.rootNode = this.subQueryNode;
                }
                if (!this.isSubQueryInStmt) {
                    this.subQuery.doParseStatement(psql);
                } else {
                    this.subQuery.parsestatement(psql, false);
                }
                this.subQuery.setLocation(plocation);
                break;
            }
            case case_t: {
                this.caseExpression.doParse(psql, plocation);
                break;
            }
            case pattern_matching_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                if (this.likeEscapeOperand == null) break;
                this.likeEscapeOperand.doParse(psql, plocation);
                break;
            }
            case exists_t: {
                if (this.subQuery == null) {
                    this.subQuery = new TSelectSqlStatement(psql.dbvendor);
                    this.subQuery.rootNode = this.subQueryNode;
                }
                if (!this.isSubQueryInStmt) {
                    this.subQuery.doParseStatement(psql);
                    break;
                }
                this.subQuery.parsestatement(psql, false);
                break;
            }
            case new_variant_type_t: {
                this.newVariantTypeArgumentList.doParse(psql, plocation);
                break;
            }
            case unary_plus_t: 
            case unary_minus_t: 
            case unary_prior_t: {
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case arithmetic_plus_t: 
            case arithmetic_minus_t: 
            case arithmetic_times_t: 
            case arithmetic_divide_t: 
            case power_t: 
            case range_t: 
            case concatenate_t: 
            case period_ldiff_t: 
            case period_rdiff_t: 
            case period_p_intersect_t: 
            case period_p_normalize_t: 
            case contains_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case assignment_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case sqlserver_proprietary_column_alias_t: {
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case arithmetic_modulo_t: 
            case bitwise_exclusive_or_t: 
            case bitwise_or_t: 
            case bitwise_and_t: 
            case bitwise_xor_t: 
            case exponentiate_t: 
            case scope_resolution_t: 
            case at_time_zone_t: 
            case member_of_t: 
            case arithmetic_exponentiation_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case year_to_month_t: 
            case day_to_second_t: 
            case at_local_t: {
                this.leftOperand.doParse(psql, plocation);
                break;
            }
            case parenthesis_t: {
                this.leftOperand.doParse(psql, plocation);
                break;
            }
            case simple_comparison_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case group_comparison_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case in_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case floating_point_t: {
                this.leftOperand.doParse(psql, plocation);
                break;
            }
            case logical_xor_t: 
            case is_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case logical_not_t: {
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case null_t: {
                this.leftOperand.doParse(psql, plocation);
                break;
            }
            case between_t: {
                this.betweenOperand.doParse(psql, plocation);
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case is_of_type_t: {
                this.leftOperand.doParse(psql, plocation);
                break;
            }
            case collate_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case left_join_t: 
            case right_join_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case ref_arrow_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case typecast_t: {
                this.leftOperand.doParse(psql, plocation);
                break;
            }
            case arrayaccess_t: {
                this.arrayAccess.doParse(psql, plocation);
                break;
            }
            case unary_connect_by_root_t: {
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case interval_t: {
                this.intervalExpr.doParse(psql, plocation);
                break;
            }
            case unary_binary_operator_t: {
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case left_shift_t: 
            case right_shift_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case array_constructor_t: {
                if (this.subQueryNode != null && this.subQuery == null) {
                    this.subQuery = new TSelectSqlStatement(psql.dbvendor);
                    this.subQuery.rootNode = this.subQueryNode;
                    this.subQuery.doParseStatement(psql);
                    break;
                }
                if (this.exprList != null) {
                    this.exprList.doParse(psql, plocation);
                    break;
                }
                if (this.arrayConstruct == null) break;
                this.arrayConstruct.doParse(psql, plocation);
                break;
            }
            case objectConstruct_t: {
                this.objectConstruct.doParse(psql, plocation);
                break;
            }
            case row_constructor_t: {
                if (this.exprList == null) break;
                this.exprList.doParse(psql, plocation);
                break;
            }
            case namedParameter_t: {
                this.namedParameter.doParse(psql, plocation);
                break;
            }
            case positionalParameter_t: {
                this.positionalParameter.doParse(psql, plocation);
                break;
            }
            case collectionArray_t: {
                this.collectionArray.doParse(psql, plocation);
                break;
            }
            case collectionCondition_t: {
                this.collectionCondition.doParse(psql, plocation);
                break;
            }
            case unary_squareroot_t: 
            case unary_cuberoot_t: 
            case unary_factorialprefix_t: 
            case unary_absolutevalue_t: 
            case unary_bitwise_not_t: {
                this.getRightOperand().doParse(psql, plocation);
                break;
            }
            case unary_factorial_t: {
                this.getLeftOperand().doParse(psql, plocation);
                break;
            }
            case bitwise_shift_left_t: 
            case bitwise_shift_right_t: {
                this.getLeftOperand().doParse(psql, plocation);
                this.getRightOperand().doParse(psql, plocation);
                break;
            }
            case multiset_union_t: 
            case multiset_union_distinct_t: 
            case multiset_intersect_t: 
            case multiset_intersect_distinct_t: 
            case multiset_except_t: 
            case multiset_except_distinct_t: {
                this.getLeftOperand().doParse(psql, plocation);
                this.getRightOperand().doParse(psql, plocation);
                break;
            }
            case json_get_text: 
            case json_get_text_at_path: 
            case json_get_object: 
            case json_get_object_at_path: 
            case json_left_contain: 
            case json_right_contain: 
            case json_exist: 
            case json_any_exist: 
            case json_all_exist: {
                this.getLeftOperand().doParse(psql, plocation);
                this.getRightOperand().doParse(psql, plocation);
                break;
            }
            case interpolate_previous_value_t: {
                this.getLeftOperand().doParse(psql, plocation);
                this.getRightOperand().doParse(psql, plocation);
                break;
            }
            case logical_and_t: 
            case logical_or_t: {
                if (this.getFlattedAndOrExprs().size() > 100) {
                    for (int k = 0; k < this.getFlattedAndOrExprs().size(); ++k) {
                        TExpression lcExpr = (TExpression)this.getFlattedAndOrExprs().get(k);
                        lcExpr.doParse(psql, plocation);
                    }
                    break;
                }
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case submultiset_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case overlaps_t: {
                this.leftOperand.doParse(psql, plocation);
                this.rightOperand.doParse(psql, plocation);
                break;
            }
            case is_a_set_t: {
                this.leftOperand.doParse(psql, plocation);
                break;
            }
            case unnest_t: {
                this.leftOperand.doParse(psql, plocation);
                break;
            }
            case array_t: {
                if (this.getExprList() == null) break;
                this.getExprList().doParse(psql, plocation);
                break;
            }
        }
    }

    public void setQuantifierType(EQuantifierType quantifierType) {
        this.quantifierType = quantifierType;
    }

    public EQuantifierType getQuantifierType() {
        return this.quantifierType;
    }

    public EComparisonType getComparisonType() {
        return this.comparisonType;
    }

    public TSourceToken getQuantifier() {
        return this.quantifier;
    }

    public TSourceToken getComparisonOperator() {
        return this.comparisonOperator;
    }

    public void setComparisonOperator(TSourceToken comparisonOperator) {
        if (comparisonOperator == null) {
            return;
        }
        this.comparisonOperator = comparisonOperator;
        this.operatorToken = comparisonOperator;
        this.comparisonType = TExpression.getComparisonType(comparisonOperator);
        if (comparisonOperator.toString().equalsIgnoreCase("=") && this.expressionType == EExpressionType.simple_comparison_t && this.leftOperand.toString().startsWith("@")) {
            this.expressionType = EExpressionType.assignment_t;
        }
    }

    public void setQuantifier(TSourceToken quantifier) {
        if (quantifier == null) {
            return;
        }
        this.quantifier = quantifier;
        switch (this.quantifier.tokencode) {
            case 339: {
                this.quantifierType = EQuantifierType.all;
                break;
            }
            default: {
                if (this.quantifier.toString().equalsIgnoreCase("any")) {
                    this.quantifierType = EQuantifierType.any;
                    break;
                }
                if (!this.quantifier.toString().equalsIgnoreCase("some")) break;
                this.quantifierType = EQuantifierType.some;
            }
        }
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        switch (this.expressionType) {
            case simple_object_name_t: {
                this.objectOperand.acceptChildren(v);
                break;
            }
            case list_t: 
            case collection_constructor_list_t: 
            case collection_constructor_multiset_t: 
            case collection_constructor_set_t: {
                if (this.exprList == null) break;
                for (int i = 0; i < this.exprList.size(); ++i) {
                    this.exprList.getExpression(i).acceptChildren(v);
                }
                break;
            }
            case function_t: 
            case type_constructor_t: 
            case new_structured_type_t: {
                this.functionCall.acceptChildren(v);
                break;
            }
            case cursor_t: 
            case subquery_t: 
            case multiset_t: {
                this.subQuery.acceptChildren(v);
                break;
            }
            case case_t: {
                this.caseExpression.acceptChildren(v);
                break;
            }
            case pattern_matching_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                if (this.likeEscapeOperand == null) break;
                this.likeEscapeOperand.acceptChildren(v);
                break;
            }
            case exists_t: {
                this.subQuery.acceptChildren(v);
                break;
            }
            case new_variant_type_t: {
                this.newVariantTypeArgumentList.acceptChildren(v);
                break;
            }
            case unary_plus_t: 
            case unary_minus_t: 
            case unary_prior_t: {
                this.rightOperand.acceptChildren(v);
                break;
            }
            case arithmetic_plus_t: 
            case arithmetic_minus_t: 
            case arithmetic_times_t: 
            case arithmetic_divide_t: 
            case power_t: 
            case range_t: 
            case concatenate_t: 
            case period_ldiff_t: 
            case period_rdiff_t: 
            case period_p_intersect_t: 
            case period_p_normalize_t: 
            case contains_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case assignment_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case sqlserver_proprietary_column_alias_t: {
                this.rightOperand.acceptChildren(v);
                break;
            }
            case arithmetic_modulo_t: 
            case bitwise_exclusive_or_t: 
            case bitwise_or_t: 
            case bitwise_and_t: 
            case bitwise_xor_t: 
            case exponentiate_t: 
            case scope_resolution_t: 
            case at_time_zone_t: 
            case member_of_t: 
            case arithmetic_exponentiation_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case year_to_month_t: 
            case day_to_second_t: 
            case at_local_t: {
                this.leftOperand.acceptChildren(v);
                break;
            }
            case parenthesis_t: {
                this.leftOperand.acceptChildren(v);
                break;
            }
            case simple_comparison_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case group_comparison_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case in_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case floating_point_t: {
                this.leftOperand.acceptChildren(v);
                break;
            }
            case logical_xor_t: 
            case is_t: 
            case logical_and_t: 
            case logical_or_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case logical_not_t: {
                this.rightOperand.acceptChildren(v);
                break;
            }
            case null_t: {
                this.leftOperand.acceptChildren(v);
                break;
            }
            case between_t: {
                if (this.betweenOperand != null) {
                    this.betweenOperand.acceptChildren(v);
                }
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case is_of_type_t: {
                this.leftOperand.acceptChildren(v);
                break;
            }
            case collate_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case left_join_t: 
            case right_join_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case ref_arrow_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case typecast_t: {
                this.leftOperand.acceptChildren(v);
                break;
            }
            case arrayaccess_t: {
                this.arrayAccess.acceptChildren(v);
                break;
            }
            case unary_connect_by_root_t: {
                this.rightOperand.acceptChildren(v);
                break;
            }
            case interval_t: {
                this.intervalExpr.acceptChildren(v);
                break;
            }
            case unary_binary_operator_t: {
                this.rightOperand.acceptChildren(v);
                break;
            }
            case left_shift_t: 
            case right_shift_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case array_constructor_t: {
                if (this.subQuery != null) {
                    this.subQuery.acceptChildren(v);
                    break;
                }
                if (this.exprList != null) {
                    this.exprList.acceptChildren(v);
                    break;
                }
                if (this.arrayConstruct == null) break;
                this.arrayConstruct.acceptChildren(v);
                break;
            }
            case row_constructor_t: {
                if (this.exprList == null) break;
                this.exprList.acceptChildren(v);
                break;
            }
            case unary_squareroot_t: 
            case unary_cuberoot_t: 
            case unary_factorialprefix_t: 
            case unary_absolutevalue_t: 
            case unary_bitwise_not_t: {
                this.getRightOperand().acceptChildren(v);
                break;
            }
            case unary_factorial_t: {
                this.getLeftOperand().acceptChildren(v);
                break;
            }
            case bitwise_shift_left_t: 
            case bitwise_shift_right_t: {
                this.getLeftOperand().acceptChildren(v);
                this.getRightOperand().acceptChildren(v);
                break;
            }
            case multiset_union_t: 
            case multiset_union_distinct_t: 
            case multiset_intersect_t: 
            case multiset_intersect_distinct_t: 
            case multiset_except_t: 
            case multiset_except_distinct_t: {
                this.getLeftOperand().acceptChildren(v);
                this.getRightOperand().acceptChildren(v);
                break;
            }
            case json_get_text: 
            case json_get_text_at_path: 
            case json_get_object: 
            case json_get_object_at_path: 
            case json_left_contain: 
            case json_right_contain: 
            case json_exist: 
            case json_any_exist: 
            case json_all_exist: {
                this.getLeftOperand().acceptChildren(v);
                this.getRightOperand().acceptChildren(v);
                break;
            }
            case interpolate_previous_value_t: {
                this.getLeftOperand().acceptChildren(v);
                this.getRightOperand().acceptChildren(v);
                break;
            }
            case submultiset_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case overlaps_t: {
                this.leftOperand.acceptChildren(v);
                this.rightOperand.acceptChildren(v);
                break;
            }
            case is_a_set_t: {
                this.leftOperand.acceptChildren(v);
                break;
            }
            case array_t: {
                if (this.getExprList() == null) break;
                this.getExprList().acceptChildren(v);
                break;
            }
        }
        v.postVisit(this);
    }

    public boolean isLeaf() {
        return this.isLeafExpr(this);
    }

    public boolean isLeafExpr(TParseTreeNode pnode) {
        boolean ret = true;
        if (pnode == null) {
            return ret;
        }
        if (!(pnode instanceof TExpression)) {
            return ret;
        }
        TExpression e = (TExpression)pnode;
        if (this.onlyAndOrIsNonLeaf && e.getExpressionType() != EExpressionType.logical_and_t && e.getExpressionType() != EExpressionType.logical_or_t) {
            return ret;
        }
        switch (e.getExpressionType()) {
            case simple_object_name_t: 
            case simple_source_token_t: 
            case simple_constant_t: 
            case function_t: 
            case type_constructor_t: 
            case arrayaccess_t: 
            case list_t: 
            case collection_constructor_list_t: 
            case collection_constructor_multiset_t: 
            case collection_constructor_set_t: 
            case group_t: 
            case new_structured_type_t: 
            case cursor_t: 
            case subquery_t: 
            case multiset_t: 
            case case_t: 
            case exists_t: 
            case new_variant_type_t: 
            case member_of_t: 
            case is_of_type_t: 
            case interval_t: 
            case submultiset_t: 
            case object_access_t: 
            case place_holder_t: {
                return ret;
            }
        }
        if (e.getLeftOperand() != null) {
            boolean bl = ret = !(e.getLeftOperand() instanceof TExpression);
        }
        if (e.getRightOperand() != null) {
            ret = !(e.getRightOperand() instanceof TExpression);
        }
        return ret;
    }

    private Stack getExprStack() {
        if (this.exprStack == null) {
            this.exprStack = new Stack();
        }
        return this.exprStack;
    }

    public void setVisitSubTree(boolean visitSubTree) {
        this.visitSubTree = visitSubTree;
    }

    public boolean isVisitSubTree() {
        return this.visitSubTree;
    }

    private boolean checkIsVisitSubTree(TParseTreeNode node) {
        boolean ret;
        boolean bl = ret = !this.isLeafExpr(node);
        if (ret) {
            ret = ((TExpression)node).isVisitSubTree();
        }
        return ret;
    }

    public void setWindowSpecification(TWindowDef windowSpecification) {
        if (this.getExpressionType() != EExpressionType.function_t) {
            return;
        }
        this.getFunctionCall().setWindowDef(windowSpecification);
    }

    public void preOrderTraverse(IExpressionVisitor ev) {
        if (this.isLeaf()) {
            ev.exprVisit(this, true);
        } else {
            this.getExprStack().push(this);
        }
        TParseTreeNode node = null;
        while (this.getExprStack().size() > 0) {
            node = (TParseTreeNode)this.getExprStack().peek();
            while (node != null) {
                if (!ev.exprVisit(node, this.isLeafExpr(node))) {
                    return;
                }
                if (this.isLeafExpr(node)) {
                    this.getExprStack().push(null);
                } else if (!this.checkIsVisitSubTree(node)) {
                    this.getExprStack().push(null);
                } else {
                    this.getExprStack().push(((TExpression)node).getLeftOperand());
                }
                node = (TParseTreeNode)this.getExprStack().peek();
            }
            this.getExprStack().pop();
            if (this.getExprStack().size() <= 0) continue;
            node = (TParseTreeNode)this.getExprStack().pop();
            if (this.isLeafExpr(node)) {
                this.getExprStack().push(null);
                continue;
            }
            if (!this.checkIsVisitSubTree(node)) {
                this.getExprStack().push(null);
                continue;
            }
            this.getExprStack().push(((TExpression)node).getRightOperand());
        }
    }

    public void inOrderTraverse(IExpressionVisitor ev) {
        if (this.isLeaf()) {
            ev.exprVisit(this, true);
        } else {
            this.getExprStack().push(this);
        }
        TParseTreeNode node = null;
        while (this.getExprStack().size() > 0) {
            node = (TParseTreeNode)this.getExprStack().peek();
            while (node != null) {
                if (this.isLeafExpr(node)) {
                    this.getExprStack().push(null);
                } else {
                    this.getExprStack().push(((TExpression)node).getLeftOperand());
                }
                node = (TParseTreeNode)this.getExprStack().peek();
            }
            this.getExprStack().pop();
            if (this.getExprStack().size() <= 0) continue;
            node = (TParseTreeNode)this.getExprStack().pop();
            if (!ev.exprVisit(node, this.isLeafExpr(node))) {
                return;
            }
            if (this.isLeafExpr(node)) {
                this.getExprStack().push(null);
                continue;
            }
            this.getExprStack().push(((TExpression)node).getRightOperand());
        }
    }

    public void postOrderTraverse(IExpressionVisitor ev) {
        boolean ctNone = false;
        boolean ctL = true;
        int ctR = 2;
        if (this.isLeaf()) {
            ev.exprVisit(this, true);
        } else {
            this.getExprStack().push(this);
        }
        TParseTreeNode node = null;
        while (this.getExprStack().size() > 0) {
            node = (TParseTreeNode)this.getExprStack().peek();
            while (node != null) {
                if (this.isLeafExpr(node)) {
                    this.getExprStack().push(null);
                } else {
                    this.getExprStack().push(((TExpression)node).getLeftOperand());
                }
                if ((node = (TParseTreeNode)this.getExprStack().peek()) == null) continue;
                node.setDummyTag(1);
            }
            this.getExprStack().pop();
            node = (TParseTreeNode)this.getExprStack().peek();
            while (this.getExprStack().size() > 0 && node.getDummyTag() == 2) {
                node = (TParseTreeNode)this.getExprStack().pop();
                node.setDummyTag(0);
                if (!ev.exprVisit(node, this.isLeafExpr(node))) {
                    return;
                }
                if (this.getExprStack().size() <= 0) break;
                node = (TParseTreeNode)this.getExprStack().peek();
            }
            if (this.getExprStack().size() <= 0) continue;
            node = (TParseTreeNode)this.getExprStack().peek();
            node.setDummyTag(2);
            if (this.isLeafExpr(node)) {
                this.getExprStack().push(null);
                continue;
            }
            this.getExprStack().push(((TExpression)node).getRightOperand());
        }
    }

    public void addANDCondition(String condition) {
        this.setString("(" + this.toString() + ") and " + condition);
    }

    public void addORCondition(String condition) {
        this.setString("(" + this.toString() + ") or " + condition);
    }

    public void remove2() {
        if (this.parentExpr == null) {
            this.removeAllMyTokensFromTokenList(null);
        } else if (this.parentExpr.getExpressionType() == EExpressionType.logical_and_t || this.parentExpr.getExpressionType() == EExpressionType.logical_or_t) {
            this.removeAllMyTokensFromTokenList(this.parentExpr.getOperatorToken());
            if (this.parentExpr.getLeftOperand().getStartToken() == null && this.parentExpr.getRightOperand().getStartToken() == null) {
                this.parentExpr.remove2();
            }
        } else if (this.parentExpr.getExpressionType() == EExpressionType.parenthesis_t) {
            this.removeAllMyTokensFromTokenList(null);
            this.parentExpr.remove2();
        } else {
            this.removeAllMyTokensFromTokenList(null);
        }
    }

    public void remove() {
        if (this.getExpressionType() == EExpressionType.removed_t) {
            return;
        }
        this.setExpressionType(EExpressionType.removed_t);
        TExpression parentExpr = this.getParentExpr();
        if (parentExpr == null) {
            return;
        }
        switch (parentExpr.getExpressionType()) {
            case list_t: {
                parentExpr.remove();
                break;
            }
            case pattern_matching_t: {
                parentExpr.remove();
                break;
            }
            case unary_plus_t: 
            case unary_minus_t: 
            case unary_prior_t: {
                parentExpr.remove();
                break;
            }
            case arithmetic_plus_t: 
            case arithmetic_minus_t: 
            case arithmetic_times_t: 
            case arithmetic_divide_t: 
            case power_t: 
            case range_t: 
            case period_ldiff_t: 
            case period_rdiff_t: 
            case period_p_intersect_t: 
            case period_p_normalize_t: 
            case contains_t: {
                parentExpr.remove();
                break;
            }
            case assignment_t: {
                parentExpr.remove();
                break;
            }
            case sqlserver_proprietary_column_alias_t: {
                parentExpr.remove();
                break;
            }
            case arithmetic_modulo_t: 
            case bitwise_exclusive_or_t: 
            case bitwise_or_t: 
            case bitwise_and_t: 
            case bitwise_xor_t: 
            case exponentiate_t: 
            case scope_resolution_t: 
            case at_time_zone_t: 
            case member_of_t: 
            case arithmetic_exponentiation_t: 
            case submultiset_t: 
            case overlaps_t: {
                parentExpr.remove();
                break;
            }
            case year_to_month_t: 
            case day_to_second_t: 
            case at_local_t: {
                parentExpr.remove();
                break;
            }
            case parenthesis_t: {
                parentExpr.remove();
                break;
            }
            case simple_comparison_t: {
                parentExpr.remove();
                break;
            }
            case group_comparison_t: {
                parentExpr.remove();
                break;
            }
            case in_t: {
                parentExpr.remove();
                break;
            }
            case floating_point_t: {
                parentExpr.remove();
                break;
            }
            case logical_xor_t: 
            case is_t: {
                parentExpr.remove();
                break;
            }
            case logical_not_t: {
                parentExpr.remove();
                break;
            }
            case null_t: {
                parentExpr.remove();
                break;
            }
            case between_t: {
                parentExpr.remove();
                break;
            }
            case is_of_type_t: {
                parentExpr.remove();
                break;
            }
            case collate_t: {
                parentExpr.remove();
                break;
            }
            case left_join_t: 
            case right_join_t: {
                parentExpr.remove();
                break;
            }
            case ref_arrow_t: {
                parentExpr.remove();
                break;
            }
            case typecast_t: {
                parentExpr.remove();
                break;
            }
            case arrayaccess_t: {
                parentExpr.remove();
                break;
            }
            case unary_connect_by_root_t: {
                parentExpr.remove();
                break;
            }
            case interval_t: {
                parentExpr.remove();
                break;
            }
            case unary_binary_operator_t: {
                parentExpr.remove();
                break;
            }
            case left_shift_t: 
            case right_shift_t: {
                parentExpr.remove();
                break;
            }
            case array_constructor_t: {
                parentExpr.remove();
                break;
            }
            case objectConstruct_t: {
                parentExpr.remove();
                break;
            }
            case row_constructor_t: {
                parentExpr.remove();
                break;
            }
            case namedParameter_t: {
                parentExpr.remove();
                break;
            }
            case positionalParameter_t: {
                parentExpr.remove();
                break;
            }
            case collectionArray_t: {
                parentExpr.remove();
                break;
            }
            case collectionCondition_t: {
                parentExpr.remove();
                break;
            }
            case unary_squareroot_t: 
            case unary_cuberoot_t: 
            case unary_factorialprefix_t: 
            case unary_absolutevalue_t: 
            case unary_bitwise_not_t: {
                parentExpr.remove();
                break;
            }
            case unary_factorial_t: {
                parentExpr.remove();
                break;
            }
            case bitwise_shift_left_t: 
            case bitwise_shift_right_t: {
                parentExpr.remove();
                break;
            }
            case multiset_union_t: 
            case multiset_union_distinct_t: 
            case multiset_intersect_t: 
            case multiset_intersect_distinct_t: 
            case multiset_except_t: 
            case multiset_except_distinct_t: {
                parentExpr.remove();
                break;
            }
            case json_get_text: 
            case json_get_text_at_path: 
            case json_get_object: 
            case json_get_object_at_path: 
            case json_left_contain: 
            case json_right_contain: 
            case json_exist: 
            case json_any_exist: 
            case json_all_exist: {
                parentExpr.remove();
                break;
            }
            case interpolate_previous_value_t: {
                parentExpr.remove();
                break;
            }
            case concatenate_t: 
            case logical_and_t: 
            case logical_or_t: {
                if (this == parentExpr.getLeftOperand()) {
                    parentExpr.getRightOperand().copyTo(parentExpr);
                    break;
                }
                if (this != parentExpr.getRightOperand()) break;
                parentExpr.getLeftOperand().copyTo(parentExpr);
                break;
            }
            case unnest_t: {
                this.leftOperand.remove();
                break;
            }
            default: {
                parentExpr.remove();
            }
        }
    }

    public void copyTo(TExpression target) {
        target.setExpressionType(this.getExpressionType());
        target.setLeftOperand(this.getLeftOperand());
        target.setRightOperand(this.getRightOperand());
        target.setObjectOperand(this.getObjectOperand());
        target.setFunctionCall(this.getFunctionCall());
        target.setSubQuery(this.getSubQuery());
        target.setConstantOperand(this.getConstantOperand());
        target.setExprList(this.getExprList());
        target.setOperatorToken(this.getOperatorToken());
        target.setComparisonOperator(this.getComparisonOperator());
        target.setBetweenOperand(this.getBetweenOperand());
        target.setCaseExpression(this.getCaseExpression());
        target.setLikeEscapeOperand(this.getLikeEscapeOperand());
        target.setNotToken(this.getNotToken());
        target.setQuantifier(this.getQuantifier());
        target.setQuantifierType(this.getQuantifierType());
    }

    public static TExpression mergeObjectNameList(TExpression expr, TObjectNameList objectNameList) {
        TExpression ret = null;
        if (expr.expressionType == EExpressionType.simple_object_name_t) {
            TObjectName objectName = expr.getObjectOperand();
            objectName.appendObjectName(objectNameList.getObjectName(0));
            ret = expr;
        }
        return ret;
    }
}

