/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EConstraintType;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TAutomaticProperty;
import gudusoft.gsqlparser.nodes.TColumnWithSortOrder;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TIndexColName;
import gudusoft.gsqlparser.nodes.TKeyAction;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.stmt.TCreateTableSqlStatement;

public class TConstraint
extends TParseTreeNode {
    private TObjectName indexName;
    private EConstraintType constraint_type;
    private TObjectName constraintName = null;
    private TPTNodeList<TKeyAction> keyActions;
    private TObjectName commentObject;
    private int constraintLevel = 2;
    private TExpression defaultExpression = null;
    private boolean clustered = false;
    private boolean nonClustered = false;
    private TPTNodeList<TColumnWithSortOrder> columnList = null;
    private TExpression checkCondition = null;
    private TPTNodeList<TAutomaticProperty> automaticProperties = null;
    private TPTNodeList<TIndexColName> indexCols;
    private TObjectName referencedObject = null;
    private TObjectNameList referencedColumnList = null;
    private TExpression seed;
    private TExpression increment;

    public TObjectName getIndexName() {
        return this.indexName;
    }

    public void setCommentObject(TObjectName commentObject) {
        this.commentObject = commentObject;
    }

    public TObjectName getCommentObject() {
        return this.commentObject;
    }

    public void setKeyActions(TPTNodeList<TKeyAction> keyActions) {
        this.keyActions = keyActions;
    }

    public TPTNodeList<TKeyAction> getKeyActions() {
        return this.keyActions;
    }

    public void setConstraintLevel(int constraintLevel) {
        this.constraintLevel = constraintLevel;
    }

    public int getConstraintLevel() {
        return this.constraintLevel;
    }

    public void setDefaultExpression(TExpression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public TExpression getDefaultExpression() {
        return this.defaultExpression;
    }

    public void setConstraintName(TObjectName constraintName) {
        this.constraintName = constraintName;
    }

    public TObjectName getConstraintName() {
        return this.constraintName;
    }

    public void setConstraint_type(EConstraintType constraint_type) {
        this.constraint_type = constraint_type;
    }

    public EConstraintType getConstraint_type() {
        return this.constraint_type;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public void setClusteredToken(TSourceToken clusteredToken) {
        if (clusteredToken == null) {
            return;
        }
        if (clusteredToken.toString().equalsIgnoreCase("clustered")) {
            this.clustered = true;
        } else if (clusteredToken.toString().equalsIgnoreCase("nonclustered")) {
            this.nonClustered = true;
        }
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean isNonClustered() {
        return this.nonClustered;
    }

    public void setNonClustered(boolean nonClustered) {
        this.nonClustered = nonClustered;
    }

    public void setAutomaticProperties(TPTNodeList<TAutomaticProperty> automaticProperties) {
        this.automaticProperties = automaticProperties;
    }

    public TPTNodeList<TAutomaticProperty> getAutomaticProperties() {
        return this.automaticProperties;
    }

    public TExpression getCheckCondition() {
        return this.checkCondition;
    }

    public TPTNodeList<TColumnWithSortOrder> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(TPTNodeList<TColumnWithSortOrder> columnList) {
        this.columnList = columnList;
    }

    public TPTNodeList<TIndexColName> getIndexCols() {
        return this.indexCols;
    }

    @Override
    public void init(Object arg1) {
        if (arg1 instanceof TExpression) {
            this.checkCondition = (TExpression)arg1;
        } else if (arg1 instanceof TPTNodeList) {
            this.columnList = (TPTNodeList)arg1;
        } else if (arg1 instanceof TObjectNameList) {
            this.columnList = new TPTNodeList();
            TObjectNameList onl = (TObjectNameList)arg1;
            for (int i = 0; i < onl.size(); ++i) {
                this.columnList.addElement(new TColumnWithSortOrder(onl.getObjectName(i)));
            }
        }
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.constraint_type = (EConstraintType)((Object)arg1);
        switch (this.constraint_type) {
            case table_index: {
                this.indexName = (TObjectName)arg2;
                break;
            }
        }
    }

    public void setReferencedColumnList(TObjectNameList referencedColumnList) {
        this.referencedColumnList = referencedColumnList;
    }

    public TObjectNameList getReferencedColumnList() {
        return this.referencedColumnList;
    }

    public void setReferencedObject(TObjectName referencedObject) {
        this.referencedObject = referencedObject;
    }

    public TObjectName getReferencedObject() {
        return this.referencedObject;
    }

    public void setIncrement(TExpression increment) {
        this.increment = increment;
    }

    public void setSeed(TExpression seed) {
        this.seed = seed;
    }

    public TExpression getIncrement() {
        return this.increment;
    }

    public TExpression getSeed() {
        return this.seed;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        switch (this.getConstraint_type()) {
            case primary_key: 
            case unique: {
                if (this.getColumnList() == null) break;
                for (int i = 0; i < this.getColumnList().size(); ++i) {
                    this.getColumnList().getElement(i).setOwnerConstraint(this);
                    if (psql instanceof TCreateTableSqlStatement) {
                        this.getColumnList().getElement(i).setOwnerTable(psql.tables.getTable(0));
                        psql.tables.getTable(0).getLinkedColumns().addObjectName(this.getColumnList().getElement(i).getColumnName());
                        this.getColumnList().getElement(i).getColumnName().setSourceTable(psql.tables.getTable(0));
                    }
                    psql.getIndexColumns().addElement(this.getColumnList().getElement(i));
                }
                break;
            }
            case foreign_key: 
            case reference: {
                if (this.getColumnList() != null) {
                    for (int i = 0; i < this.getColumnList().size(); ++i) {
                        this.getColumnList().getElement(i).setOwnerConstraint(this);
                        if (psql instanceof TCreateTableSqlStatement) {
                            this.getColumnList().getElement(i).setOwnerTable(psql.tables.getTable(0));
                        }
                        psql.getIndexColumns().addElement(this.getColumnList().getElement(i));
                    }
                }
                TTable lcTable = null;
                if (this.referencedObject != null) {
                    this.referencedObject.setObjectType(3);
                    lcTable = new TTable(this.referencedObject);
                    lcTable.setPropertyFromObjectName(this.referencedObject, ETableEffectType.tetConstraintReference);
                    psql.addToTables(lcTable);
                }
                if (this.referencedColumnList == null) break;
                for (int i = 0; i < this.referencedColumnList.size(); ++i) {
                    this.referencedColumnList.getObjectName(i).setLocation(ESqlClause.constraintRef);
                    lcTable.getLinkedColumns().addObjectName(this.referencedColumnList.getObjectName(i));
                }
                break;
            }
        }
    }

    public void setCheckCondition(TExpression checkCondition) {
        this.checkCondition = checkCondition;
    }

    public void setIndexCols(TPTNodeList<TIndexColName> indexCols) {
        this.indexCols = indexCols;
    }
}

