/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TColumnAttributes;
import gudusoft.gsqlparser.nodes.TConstraint;
import gudusoft.gsqlparser.nodes.TConstraintList;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTypeName;

public class TColumnDefinition
extends TParseTreeNode {
    private TSourceToken xmlTableColumnPath;
    private TColumnAttributes columnAttributes;
    private TObjectName comment;
    private TObjectName columnName;
    private TObjectNameList columnReferences = null;
    private TTypeName datatype = null;
    private TConstraintList constraints = null;
    private TExpression defaultExpression = null;
    private boolean isNull = false;
    private boolean isRowGuidCol = false;
    private String encoding = null;
    private String collationName = null;
    private TExpression seed;
    private TExpression increment;
    private boolean isIdentity = false;
    private TExpression computedColumnExpression = null;

    public void setXmlTableColumnPath(TSourceToken xmlTableColumnPath) {
        this.xmlTableColumnPath = xmlTableColumnPath;
    }

    public TSourceToken getXmlTableColumnPath() {
        return this.xmlTableColumnPath;
    }

    public TColumnAttributes getColumnAttributes() {
        return this.columnAttributes;
    }

    public void setColumnAttributes(TColumnAttributes pcolumnAttributes) {
        this.columnAttributes = pcolumnAttributes;
    }

    public TObjectName getComment() {
        return this.comment;
    }

    public void setComment(TObjectName comment) {
        this.comment = comment;
    }

    private TObjectNameList getColumnReferences() {
        if (this.columnReferences == null) {
            this.columnReferences = new TObjectNameList();
        }
        return this.columnReferences;
    }

    public TColumnDefinition() {
    }

    public TColumnDefinition(TObjectName columnName) {
        this.columnName = columnName;
    }

    @Override
    public void init(Object arg1) {
        this.columnName = (TObjectName)arg1;
        this.columnName.setObjectType(1);
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.columnName = (TObjectName)arg1;
        this.columnName.setObjectType(1);
        if (arg2 != null) {
            this.datatype = (TTypeName)arg2;
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3) {
        this.columnName = (TObjectName)arg1;
        this.columnName.setObjectType(1);
        if (arg2 != null) {
            this.datatype = (TTypeName)arg2;
        }
        this.constraints = (TConstraintList)arg3;
    }

    public TObjectName getColumnName() {
        return this.columnName;
    }

    public void setColumnName(TObjectName columnName) {
        this.columnName = columnName;
    }

    public void setColumnReferences(TObjectNameList columnReferences) {
        this.columnReferences = columnReferences;
    }

    public void setDatatype(TTypeName datatype) {
        this.datatype = datatype;
    }

    public void setConstraints(TConstraintList constraints) {
        this.constraints = constraints;
    }

    public void setRowGuidCol(boolean isRowGuidCol) {
        this.isRowGuidCol = isRowGuidCol;
    }

    public void setSeed(TExpression seed) {
        this.seed = seed;
    }

    public void setIncrement(TExpression increment) {
        this.increment = increment;
    }

    public void setIdentity(boolean isIdentity) {
        this.isIdentity = isIdentity;
    }

    public TTypeName getDatatype() {
        return this.datatype;
    }

    public void addNewConstraint(TConstraint pConstraint) {
        if (this.constraints == null) {
            this.constraints = new TConstraintList();
        }
        this.constraints.addConstraint(pConstraint);
    }

    public TConstraintList getConstraints() {
        return this.constraints;
    }

    public void setDefaultExpression(TExpression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public TExpression getDefaultExpression() {
        return this.defaultExpression;
    }

    public void setNull(boolean aNull) {
        this.isNull = aNull;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isRowGuidCol() {
        return this.isRowGuidCol;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public TExpression getIncrement() {
        return this.increment;
    }

    public TExpression getSeed() {
        return this.seed;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public void setComputedColumnExpression(TExpression computedColumnExpression) {
        this.computedColumnExpression = computedColumnExpression;
    }

    public TExpression getComputedColumnExpression() {
        return this.computedColumnExpression;
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        int i;
        if (this.constraints == null) {
            return;
        }
        block14: for (i = this.constraints.size() - 1; i >= 0; --i) {
            this.constraints.getConstraint(i).setConstraintLevel(1);
            switch (this.constraints.getConstraint(i).getConstraint_type()) {
                case fake_collate: {
                    this.collationName = this.constraints.getConstraint(i).getEndToken().toString();
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_null: {
                    this.setNull(true);
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_rowguidcol: {
                    this.isRowGuidCol = true;
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_identity: {
                    this.isIdentity = true;
                    this.seed = this.constraints.getConstraint(i).getSeed();
                    this.increment = this.constraints.getConstraint(i).getIncrement();
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_comment: {
                    this.comment = this.constraints.getConstraint(i).getCommentObject();
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_maked_with: {
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_fuzzy_search_index: {
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_load_unit: {
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_column_generated_as_expr: {
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_column_generated_as_identity: {
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_db2: {
                    this.defaultExpression = this.constraints.getConstraint(i).getDefaultExpression();
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
                case fake_default_expr: {
                    this.defaultExpression = this.constraints.getConstraint(i).getDefaultExpression();
                    this.constraints.removeElementAt(i);
                    continue block14;
                }
            }
        }
        for (i = 0; i < this.constraints.size(); ++i) {
            this.constraints.getConstraint(i).doParse(psql, plocation);
        }
    }
}

