/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TDeleteSqlNode;
import gudusoft.gsqlparser.nodes.TInsertSqlNode;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TSelectSqlNode;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.TUpdateSqlNode;
import gudusoft.gsqlparser.stmt.TDeleteSqlStatement;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.TUpdateSqlStatement;

public class TCTE
extends TParseTreeNode {
    private TSelectSqlNode selectNode;
    private TSelectSqlStatement subquery;
    private TInsertSqlNode insertSqlNode;
    private TInsertSqlStatement insertStmt;
    private TUpdateSqlNode updateSqlNode;
    private TUpdateSqlStatement updateStmt;
    private TDeleteSqlNode deleteSqlNode;
    private TDeleteSqlStatement deleteStmt;
    private TCustomSqlStatement preparableStmt;
    private TObjectName tableName;
    private TObjectNameList columnList = null;

    public boolean searchColumnInResultSet(TCustomSqlStatement pSql, TTable pTable, TObjectName pColumn, boolean pMustIn) {
        boolean lcResult = false;
        if (this.getColumnList() != null) {
            for (int i = 0; i < this.getColumnList().size() && !(lcResult = this.getColumnList().getObjectName(i).toString().equalsIgnoreCase(pColumn.getColumnNameOnly())); ++i) {
            }
            return lcResult;
        }
        for (TCustomSqlStatement lcStmt = pSql; lcStmt != null; lcStmt = lcStmt.getParentStmt()) {
            if (lcStmt != this.getSubquery()) continue;
            pTable.getLinkedColumns().addObjectName(pColumn);
            pColumn.setSourceTable(pTable);
            lcResult = true;
            break;
        }
        if (lcResult) {
            return true;
        }
        if (this.getSubquery() == null) {
            return false;
        }
        lcResult = this.getSubquery().searchColumnInResultSet(pColumn, pMustIn);
        return lcResult;
    }

    public TCustomSqlStatement getPreparableStmt() {
        this.preparableStmt = null;
        if (this.subquery != null) {
            this.preparableStmt = this.subquery;
        } else if (this.updateStmt != null) {
            this.preparableStmt = this.updateStmt;
        } else if (this.deleteStmt != null) {
            this.preparableStmt = this.deleteStmt;
        } else if (this.insertStmt != null) {
            this.preparableStmt = this.insertStmt;
        }
        return this.preparableStmt;
    }

    public TUpdateSqlStatement getUpdateStmt() {
        return this.updateStmt;
    }

    public TInsertSqlStatement getInsertStmt() {
        return this.insertStmt;
    }

    public TDeleteSqlStatement getDeleteStmt() {
        return this.deleteStmt;
    }

    public TObjectName getTableName() {
        return this.tableName;
    }

    public void setColumnList(TObjectNameList columnList) {
        this.columnList = columnList;
    }

    public TSelectSqlStatement getSubquery() {
        return this.subquery;
    }

    public TObjectNameList getColumnList() {
        return this.columnList;
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.tableName = (TObjectName)arg1;
        this.tableName.setObjectType(5);
        if (arg2 instanceof TSelectSqlNode) {
            this.selectNode = (TSelectSqlNode)arg2;
        } else if (arg2 instanceof TInsertSqlNode) {
            this.insertSqlNode = (TInsertSqlNode)arg2;
        } else if (arg2 instanceof TUpdateSqlNode) {
            this.updateSqlNode = (TUpdateSqlNode)arg2;
        } else if (arg2 instanceof TDeleteSqlNode) {
            this.deleteSqlNode = (TDeleteSqlNode)arg2;
        }
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        if (this.selectNode != null) {
            this.subquery = new TSelectSqlStatement(psql.dbvendor);
            this.subquery.rootNode = this.selectNode;
            this.subquery.setQueryOfCTE(true);
            this.subquery.doParseStatement(psql);
        } else if (this.insertSqlNode != null) {
            this.insertStmt = new TInsertSqlStatement(psql.dbvendor);
            this.insertStmt.rootNode = this.insertSqlNode;
            this.insertStmt.doParseStatement(psql);
        } else if (this.deleteSqlNode != null) {
            this.deleteStmt = new TDeleteSqlStatement(psql.dbvendor);
            this.deleteStmt.rootNode = this.deleteSqlNode;
            this.deleteStmt.doParseStatement(psql);
        } else if (this.updateSqlNode != null) {
            this.updateStmt = new TUpdateSqlStatement(psql.dbvendor);
            this.updateStmt.rootNode = this.updateSqlNode;
            this.updateStmt.doParseStatement(psql);
        }
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setSubquery(TSelectSqlStatement subquery) {
        this.subquery = subquery;
    }

    public void setInsertStmt(TInsertSqlStatement insertStmt) {
        this.insertStmt = insertStmt;
    }

    public void setUpdateStmt(TUpdateSqlStatement updateStmt) {
        this.updateStmt = updateStmt;
    }

    public void setDeleteStmt(TDeleteSqlStatement deleteStmt) {
        this.deleteStmt = deleteStmt;
    }

    public void setPreparableStmt(TCustomSqlStatement preparableStmt) {
        this.preparableStmt = preparableStmt;
    }

    public void setTableName(TObjectName tableName) {
        this.tableName = tableName;
    }
}

