/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser;

import gudusoft.gsqlparser.TScope;
import java.util.Stack;

public class TStackFrame {
    TStackFrame parentFrame = null;
    TScope scope = null;

    public void setParentFrame(TStackFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public TStackFrame getParentFrame() {
        return this.parentFrame;
    }

    public TScope getScope() {
        return this.scope;
    }

    public TStackFrame(TScope scope) {
        this.scope = scope;
    }

    protected boolean contains(String variableName) {
        if (this.scope != null) {
            return this.scope.getVariable(variableName) != null;
        }
        return false;
    }

    public void popStack(Stack<TStackFrame> frameStack) {
        frameStack.pop();
    }

    public void pushStack(Stack<TStackFrame> frameStack) {
        if (frameStack == null) {
            return;
        }
        if (frameStack.size() == 0) {
            frameStack.push(this);
            return;
        }
        if (frameStack.size() == 1) {
            this.parentFrame = frameStack.peek();
            frameStack.push(this);
            return;
        }
        for (int i = frameStack.size() - 1; i > 0; --i) {
            TStackFrame f = (TStackFrame)frameStack.get(i);
            if (this.scope.enclosingScope == f.scope.enclosingScope) {
                this.parentFrame = f.parentFrame;
                break;
            }
            if (this.scope.enclosingScope != f.scope) continue;
            this.parentFrame = f;
            break;
        }
        if (this.parentFrame == null) {
            this.parentFrame = frameStack.peek();
        }
        frameStack.push(this);
    }
}

