/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser;

import gudusoft.gsqlparser.ETokenStatus;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TBaseType;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.TSourceToken;
import java.util.ArrayList;
import java.util.Iterator;

public class TSourceTokenList
implements Iterator<TSourceToken> {
    int iteratorpos = -1;
    private TGSqlParser gsqlparser = null;
    ArrayList items = new ArrayList();
    int curpos = -1;

    public void set(int index, TSourceToken st) {
        st.setGsqlparser(this.gsqlparser);
        this.items.set(index, st);
    }

    public TGSqlParser getGsqlparser() {
        return this.gsqlparser;
    }

    public void setGsqlparser(TGSqlParser gsqlparser) {
        this.gsqlparser = gsqlparser;
    }

    public void resetiterator() {
        this.iteratorpos = -1;
    }

    @Override
    public boolean hasNext() {
        boolean ret;
        boolean bl = ret = this.iteratorpos < this.items.size() - 1;
        if (ret) {
            ++this.iteratorpos;
        }
        return ret;
    }

    @Override
    public TSourceToken next() {
        return (TSourceToken)this.items.get(this.iteratorpos);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public TSourceTokenList() {
        this.resetiterator();
    }

    public TSourceToken get(int index) {
        return (TSourceToken)this.items.get(index);
    }

    public void add(TSourceToken st) {
        st.setGsqlparser(this.gsqlparser);
        this.items.add(st);
    }

    public void add(int index, TSourceToken st) {
        st.setGsqlparser(this.gsqlparser);
        this.items.add(index, st);
    }

    public void remove(int index) {
        this.items.remove(index);
    }

    public void remove(TSourceToken st) {
        this.items.remove(st);
    }

    public int size() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
    }

    boolean isnonsolidtoken(TSourceToken st, boolean pcmtissolidtoken) {
        boolean ret = false;
        switch (st.tokentype) {
            case ttwhitespace: 
            case ttreturn: {
                ret = true;
                break;
            }
            case ttsimplecomment: 
            case ttbracketedcomment: {
                if (pcmtissolidtoken) break;
                ret = true;
            }
        }
        return ret;
    }

    public TSourceToken nextsolidtoken(TSourceToken ptoken, int pstep, boolean pcmtissolidtoken) {
        Object ret = null;
        if (ptoken == null) {
            return null;
        }
        if (ptoken.posinlist == -1) {
            return null;
        }
        return this.nextsolidtoken(ptoken.posinlist, pstep, pcmtissolidtoken);
    }

    public TSourceToken nextsolidtoken(int ptokenpos, int pstep, boolean pcmtissolidtoken) {
        TSourceToken lctoken;
        int i;
        TSourceToken ret = null;
        if (this.items == null) {
            return ret;
        }
        if (ptokenpos < 0) {
            return ret;
        }
        if (ptokenpos > this.size() - 1) {
            return ret;
        }
        if (pstep > 0 && ptokenpos == this.size() - 1) {
            return ret;
        }
        if (!pcmtissolidtoken) {
            // empty if block
        }
        int step = 0;
        if (pstep > 0) {
            for (i = ptokenpos + 1; i < this.size(); ++i) {
                lctoken = this.get(i);
                if (this.isnonsolidtoken(lctoken, pcmtissolidtoken) || ++step != pstep) continue;
                ret = this.get(i);
                break;
            }
        }
        if (pstep < 0) {
            for (i = ptokenpos - 1; i >= 0; --i) {
                lctoken = this.get(i);
                if (this.isnonsolidtoken(lctoken, pcmtissolidtoken) || ++step != Math.abs(pstep)) continue;
                ret = this.get(i);
                break;
            }
        }
        return ret;
    }

    public int nextObjectNameToken(int ptokenpos, int pstep, boolean pcmtissolidtoken) {
        TSourceToken lctoken;
        int i;
        int ret = -1;
        boolean waitForNextSolidToken = false;
        if (this.items == null) {
            return ret;
        }
        if (ptokenpos < 0) {
            return ret;
        }
        if (ptokenpos > this.size() - 1) {
            return ret;
        }
        if (pstep > 0 && ptokenpos == this.size() - 1) {
            return ret;
        }
        int step = 0;
        if (pstep > 0) {
            for (i = ptokenpos + 1; i < this.size(); ++i) {
                lctoken = this.get(i);
                if (this.isnonsolidtoken(lctoken, pcmtissolidtoken)) continue;
                if (lctoken.tokencode == 46) {
                    waitForNextSolidToken = true;
                    continue;
                }
                if (ret == -1) {
                    ret = i;
                    continue;
                }
                if (waitForNextSolidToken) {
                    waitForNextSolidToken = false;
                    ret = i;
                    continue;
                }
                if (++step == pstep) break;
            }
        }
        if (pstep < 0) {
            for (i = ptokenpos - 1; i >= 0; --i) {
                lctoken = this.get(i);
                if (this.isnonsolidtoken(lctoken, pcmtissolidtoken)) continue;
                if (lctoken.tokencode == 46) {
                    waitForNextSolidToken = true;
                    continue;
                }
                if (ret == -1) {
                    ret = i;
                    continue;
                }
                if (waitForNextSolidToken) {
                    waitForNextSolidToken = false;
                    ret = i;
                    continue;
                }
                if (++step == Math.abs(pstep)) break;
            }
        }
        return ret;
    }

    int solidtokenafterpos(int piindex, String psstr, int scope, String ignoretoken) {
        int ret = 0;
        if (this.items == null) {
            return ret;
        }
        if (piindex < 0) {
            return ret;
        }
        if (piindex > this.size() - 2) {
            return ret;
        }
        int step = 0;
        for (int i = piindex + 1; i < this.size(); ++i) {
            if (this.get(i).isnonsolidtoken() || ignoretoken.length() > 0 && TBaseType.mycomparetext(this.get((int)i).astext, ignoretoken) == 0) continue;
            if (TBaseType.mycomparetext(psstr, this.get((int)i).astext) == 0) {
                ret = i;
            }
            if (ret > 0 || ++step >= scope) break;
        }
        return ret;
    }

    public int solidtokenafterpos(int pStart, int pTokenCode, int pSteps, String pIgnoreThisString) {
        int ret = 0;
        if (this.items == null) {
            return ret;
        }
        if (pStart < 0) {
            return ret;
        }
        if (pStart > this.size() - 2) {
            return ret;
        }
        int step = 0;
        for (int i = pStart + 1; i < this.size(); ++i) {
            if (this.get(i).isnonsolidtoken() || pIgnoreThisString.length() > 0 && TBaseType.mycomparetext(this.get((int)i).astext, pIgnoreThisString) == 0) continue;
            if (pTokenCode == this.get((int)i).tokencode) {
                ret = i;
            }
            if (ret > 0 || ++step >= pSteps) break;
        }
        return ret;
    }

    public TSourceToken solidtokenbefore(int pStart) {
        return this.nextsolidtoken(pStart, -1, false);
    }

    public boolean sqlplusaftercurtoken() {
        return this.sqlplusaftertoken(this.curpos) > 0;
    }

    int sqlplusaftertoken(int pStart) {
        int ret = 0;
        if (this.items == null) {
            return ret;
        }
        if (pStart < 0 || pStart + 1 > this.size() - 1) {
            return ret;
        }
        for (int i = pStart + 1; i < this.size(); ++i) {
            if (this.get(i).isnonsolidtoken()) continue;
            if (this.get((int)i).tokencode != 273) break;
            ret = i;
            break;
        }
        return ret;
    }

    public boolean returnaftercurtoken(boolean ignorecmt) {
        return this.returnaftertoken(this.curpos, ignorecmt) > 0;
    }

    int returnaftertoken(int pStart, boolean ignorecomment) {
        int ret = 0;
        int j = 0;
        if (this.items == null) {
            return ret;
        }
        if (pStart < 0 || pStart + 1 > this.size() - 1) {
            return ret;
        }
        for (int i = pStart + 1; i < this.size(); ++i) {
            j = i;
            if (this.get((int)i).tokentype != ETokenType.ttwhitespace && (this.get((int)i).tokentype != ETokenType.ttsimplecomment && this.get((int)i).tokentype != ETokenType.ttbracketedcomment || !ignorecomment)) break;
        }
        if (this.get((int)j).tokentype == ETokenType.ttreturn) {
            ret = j - pStart;
        }
        return ret;
    }

    public boolean returnbeforecurtoken(boolean ignorecomment) {
        int i;
        boolean ret = false;
        if (this.items == null) {
            return ret;
        }
        if (this.curpos <= 0) {
            return ret;
        }
        if (this.curpos > this.size() - 1) {
            return ret;
        }
        for (int j = i = this.curpos - 1; j >= 0; --j) {
            if (this.get((int)j).tokentype == ETokenType.ttwhitespace || ignorecomment && (this.get((int)j).tokentype == ETokenType.ttsimplecomment || this.get((int)j).tokentype == ETokenType.ttbracketedcomment)) continue;
            if (this.get((int)j).tokentype != ETokenType.ttreturn) break;
            ret = true;
            break;
        }
        return ret;
    }

    public TSourceToken searchToken(int targetTokenCode, String targetTokenText, TSourceToken startToken, int range) {
        int i;
        TSourceToken ret = null;
        if (this.items == null) {
            return ret;
        }
        int ptokenpos = startToken.posinlist;
        if (ptokenpos < 0 || ptokenpos > this.size() - 1 && range > 0) {
            return ret;
        }
        if (range > 0 && ptokenpos == this.size() - 1) {
            return ret;
        }
        if (range < 0 && ptokenpos == 0) {
            return ret;
        }
        if (range == 0) {
            if (targetTokenCode > 0) {
                if (startToken.tokencode == targetTokenCode) {
                    ret = startToken;
                }
            } else if (startToken.toString().equalsIgnoreCase(targetTokenText)) {
                ret = startToken;
            }
            return ret;
        }
        TSourceToken lctoken = null;
        if (range > 0) {
            for (i = ptokenpos + 1; i < this.size(); ++i) {
                lctoken = this.get(i);
                if (this.isnonsolidtoken(lctoken, false)) continue;
                if (--range < 0) break;
                if (targetTokenCode > 0) {
                    if (lctoken.tokencode != targetTokenCode) continue;
                    ret = lctoken;
                    break;
                }
                if (!lctoken.toString().equalsIgnoreCase(targetTokenText)) continue;
                ret = lctoken;
                break;
            }
            range = 0;
        }
        if (range < 0) {
            for (i = ptokenpos - 1; i >= 0; --i) {
                lctoken = this.get(i);
                if (this.isnonsolidtoken(lctoken, false)) continue;
                if (++range > 0) break;
                if (targetTokenCode > 0) {
                    if (lctoken.tokencode != targetTokenCode) continue;
                    ret = lctoken;
                    break;
                }
                if (!lctoken.toString().equalsIgnoreCase(targetTokenText)) continue;
                ret = lctoken;
                break;
            }
        }
        return ret;
    }

    public void setTokenStatus(ETokenStatus ps, int pstart, int pend) {
        if (pstart < 0) {
            return;
        }
        if (pend > this.size() - 1) {
            return;
        }
        for (int i = pstart; i <= pend; ++i) {
            this.get((int)i).tokenstatus = ps;
        }
    }

    public int indexOf(TSourceToken pst) {
        return this.items.indexOf(pst);
    }
}

