/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser;

import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ETokenStatus;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.nodes.TParseTreeNodeList;

public class TSourceToken {
    private TGSqlParser gsqlparser = null;
    public int tokencode;
    public long lineNo;
    public long columnNo;
    public long offset;
    public ETokenType tokentype;
    public TSourceTokenList container;
    public int posinlist;
    public String astext;
    private ETokenStatus statusForRewrite = ETokenStatus.tsoriginal;
    public ETokenStatus tokenstatus;
    public String dolqstart;
    String prevsourcecode;
    boolean insqlpluscmd;
    private TParseTreeNodeList NodesEndWithThisToken = null;
    private TParseTreeNodeList NodesStartFromThisToken = null;
    public TCustomSqlStatement stmt;
    public int tag;
    private EDbObjectType dbObjectType = EDbObjectType.unknown;
    private int dbObjType = 0;
    public TSourceToken alternativeToken = null;
    private EDbVendor dbvendor;
    private TSourceTokenList tokensBefore = null;
    private TSourceTokenList tokensAfter = null;
    private TSourceToken replaceToken = null;
    private TSourceToken linkToken = null;

    public ETokenStatus getTokenstatus() {
        return this.tokenstatus;
    }

    public String getQuotedString() {
        String pstr = this.toString();
        if (pstr.startsWith("'")) {
            return pstr.substring(1, pstr.length() - 1);
        }
        if (pstr.startsWith("$")) {
            return pstr.substring(this.dolqstart.length(), pstr.length() - this.dolqstart.length());
        }
        return "";
    }

    public String getTextWithoutQuoted() {
        if (this.toString().startsWith("'") || this.toString().startsWith("[") || this.toString().startsWith("\"")) {
            return this.toString().substring(1, this.toString().length() - 1);
        }
        return this.toString();
    }

    public TSourceToken() {
    }

    public TSourceToken(String s) {
        this.astext = s;
    }

    public String toScript() {
        return this.astext;
    }

    public TGSqlParser getGsqlparser() {
        return this.gsqlparser;
    }

    public void setGsqlparser(TGSqlParser gsqlparser) {
        this.gsqlparser = gsqlparser;
    }

    public void setTokenstatus(ETokenStatus tokenstatus) {
        this.tokenstatus = tokenstatus;
    }

    public TParseTreeNodeList getNodesEndWithThisToken() {
        if (this.NodesEndWithThisToken == null) {
            this.NodesEndWithThisToken = new TParseTreeNodeList();
        }
        return this.NodesEndWithThisToken;
    }

    public TParseTreeNodeList getNodesStartFromThisToken() {
        if (this.NodesStartFromThisToken == null) {
            this.NodesStartFromThisToken = new TParseTreeNodeList();
        }
        return this.NodesStartFromThisToken;
    }

    public void setDbObjType(int dbObjType) {
        this.dbObjType = dbObjType;
    }

    public int getDbObjType() {
        return this.dbObjType;
    }

    public void setDbObjectType(EDbObjectType dbObjectType) {
        this.dbObjectType = dbObjectType;
    }

    public EDbObjectType getDbObjectType() {
        return this.dbObjectType;
    }

    public void setAlternativeToken(TSourceToken alternativeToken) {
        this.alternativeToken = alternativeToken;
    }

    public TSourceToken getAlternativeToken() {
        return this.alternativeToken;
    }

    public void setDbvendor(EDbVendor dbvendor) {
        this.dbvendor = dbvendor;
    }

    public EDbVendor getDbvendor() {
        return this.dbvendor;
    }

    public void setString(String str) {
        this.astext = str;
    }

    public String toString() {
        return this.astext;
    }

    public String toStringDebug() {
        String ret = this.lineNo + "," + this.columnNo + "," + this.astext.length() + "," + this.offset + "," + this.tokencode + " " + (Object)((Object)this.tokentype);
        ret = this.tokencode == 257 ? ret + " multi line comment" : (this.tokencode == 258 ? ret + " single line comment" : (this.tokencode == 259 ? ret + " space" : (this.tokencode == 260 ? ret + " newline" : ret + " " + this.astext)));
        return ret;
    }

    public static boolean isnonsolidtoken(ETokenType tokentype) {
        return tokentype == ETokenType.ttwhitespace || tokentype == ETokenType.ttreturn || tokentype == ETokenType.ttsimplecomment || tokentype == ETokenType.ttbracketedcomment;
    }

    public boolean isnonsolidtoken() {
        return !this.issolidtoken();
    }

    public boolean issolidtoken() {
        return !TSourceToken.isnonsolidtoken(this.tokentype);
    }

    public TSourceTokenList getTokensAfter() {
        if (this.tokensAfter == null) {
            this.tokensAfter = new TSourceTokenList();
        }
        return this.tokensAfter;
    }

    public TSourceTokenList getTokensBefore() {
        if (this.tokensBefore == null) {
            this.tokensBefore = new TSourceTokenList();
        }
        return this.tokensBefore;
    }

    public void setReplaceToken(TSourceToken replaceToken) {
        this.replaceToken = replaceToken;
    }

    public TSourceToken getReplaceToken() {
        return this.replaceToken;
    }

    public TSourceToken nextToken() {
        TSourceToken ret = null;
        if (this.container == null) {
            return ret;
        }
        if (this.posinlist >= this.container.size() - 1) {
            return null;
        }
        return this.container.get(this.posinlist + 1);
    }

    public TSourceToken searchToken(int targetTokenCode, int range) {
        TSourceToken ret = null;
        if (this.container == null) {
            return ret;
        }
        return this.container.searchToken(targetTokenCode, "", this, range);
    }

    public TSourceToken searchToken(String targetTokenText, int range) {
        TSourceToken ret = null;
        if (this.container == null) {
            return ret;
        }
        return this.container.searchToken(0, targetTokenText, this, range);
    }

    public TSourceToken searchTokenAfterObjectName() {
        TSourceToken ret = null;
        if (this.container == null) {
            return ret;
        }
        int i = this.container.nextObjectNameToken(this.posinlist, 1, false);
        if (i == -1) {
            return ret;
        }
        return this.container.get(i).nextSolidToken();
    }

    public TSourceToken nextSolidToken() {
        TSourceToken ret = null;
        if (this.container == null) {
            return ret;
        }
        return this.container.nextsolidtoken(this, 1, false);
    }

    public TSourceToken nextSolidToken(boolean treatCommentAsSolidToken) {
        TSourceToken ret = null;
        if (this.container == null) {
            return ret;
        }
        return this.container.nextsolidtoken(this, 1, treatCommentAsSolidToken);
    }

    public TSourceToken prevSolidToken() {
        TSourceToken ret = null;
        if (this.container == null) {
            return ret;
        }
        return this.container.nextsolidtoken(this, -1, false);
    }

    public TSourceToken prevSolidToken(boolean treatCommentAsSolidToken) {
        TSourceToken ret = null;
        if (this.container == null) {
            return ret;
        }
        return this.container.nextsolidtoken(this, -1, treatCommentAsSolidToken);
    }

    public boolean firstTokenOfLine() {
        TSourceToken st = this.prevSolidToken();
        if (st == null) {
            return true;
        }
        return st.lineNo != this.lineNo;
    }

    public boolean lastTokenOfLine() {
        TSourceToken st = this.nextSolidToken();
        if (st == null) {
            return true;
        }
        return st.lineNo != this.lineNo;
    }

    public int removeMeFromTokenList() {
        int ret = -1;
        TSourceTokenList stList = this.container;
        if (stList == null) {
            return ret;
        }
        int pos = this.posinlist;
        stList.remove(pos);
        for (int i = pos; i < stList.size(); ++i) {
            stList.get((int)i).posinlist = i;
        }
        return 1;
    }

    public void setLinkToken(TSourceToken linkToken) {
        this.linkToken = linkToken;
        linkToken.linkToken = this;
    }

    public TSourceToken getLinkToken() {
        return this.linkToken;
    }

    public String toUnQuotedString() {
        if (this.tokentype == ETokenType.ttdqstring || this.tokentype == ETokenType.ttdbstring || this.tokentype == ETokenType.ttbrstring) {
            return this.toString().substring(1, this.toString().length() - 1);
        }
        if (this.dbvendor == EDbVendor.dbvmysql && this.toString().startsWith("`")) {
            return this.toString().substring(1, this.toString().length() - 1);
        }
        return this.toString();
    }
}

