/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.EErrorType;
import gudusoft.gsqlparser.EFindSqlStateType;
import gudusoft.gsqlparser.ESqlPlusCmd;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETokenStatus;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.IMetaDatabase;
import gudusoft.gsqlparser.ITokenHandle;
import gudusoft.gsqlparser.TBaseType;
import gudusoft.gsqlparser.TCustomLexer;
import gudusoft.gsqlparser.TCustomParser;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGlobalScope;
import gudusoft.gsqlparser.TLexerBigquery;
import gudusoft.gsqlparser.TLexerCouchbase;
import gudusoft.gsqlparser.TLexerDax;
import gudusoft.gsqlparser.TLexerDb2;
import gudusoft.gsqlparser.TLexerGreenplum;
import gudusoft.gsqlparser.TLexerHana;
import gudusoft.gsqlparser.TLexerHive;
import gudusoft.gsqlparser.TLexerImpala;
import gudusoft.gsqlparser.TLexerInformix;
import gudusoft.gsqlparser.TLexerMdx;
import gudusoft.gsqlparser.TLexerMssql;
import gudusoft.gsqlparser.TLexerMysql;
import gudusoft.gsqlparser.TLexerNetezza;
import gudusoft.gsqlparser.TLexerOdbc;
import gudusoft.gsqlparser.TLexerOpenedge;
import gudusoft.gsqlparser.TLexerOracle;
import gudusoft.gsqlparser.TLexerPostgresql;
import gudusoft.gsqlparser.TLexerRedshift;
import gudusoft.gsqlparser.TLexerSnowflake;
import gudusoft.gsqlparser.TLexerSybase;
import gudusoft.gsqlparser.TLexerTeradata;
import gudusoft.gsqlparser.TLexerVertica;
import gudusoft.gsqlparser.TParserBigquery;
import gudusoft.gsqlparser.TParserCouchbase;
import gudusoft.gsqlparser.TParserDax;
import gudusoft.gsqlparser.TParserDb2Sql;
import gudusoft.gsqlparser.TParserGreenplum;
import gudusoft.gsqlparser.TParserHana;
import gudusoft.gsqlparser.TParserHive;
import gudusoft.gsqlparser.TParserImpala;
import gudusoft.gsqlparser.TParserInformix;
import gudusoft.gsqlparser.TParserMdx;
import gudusoft.gsqlparser.TParserMssqlSql;
import gudusoft.gsqlparser.TParserMysqlSql;
import gudusoft.gsqlparser.TParserNetezza;
import gudusoft.gsqlparser.TParserOdbc;
import gudusoft.gsqlparser.TParserOpenedge;
import gudusoft.gsqlparser.TParserOraclePLSql;
import gudusoft.gsqlparser.TParserOracleSql;
import gudusoft.gsqlparser.TParserPostgresql;
import gudusoft.gsqlparser.TParserRedshift;
import gudusoft.gsqlparser.TParserSnowflake;
import gudusoft.gsqlparser.TParserSybase;
import gudusoft.gsqlparser.TParserTeradata;
import gudusoft.gsqlparser.TParserVertica;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.TSqlCmds;
import gudusoft.gsqlparser.TStackFrame;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.TSyntaxError;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TDatatypeAttribute;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TTypeName;
import gudusoft.gsqlparser.sqlenv.TSQLEnv;
import gudusoft.gsqlparser.stmt.TCommonStoredProcedureSqlStatement;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.TUnknownSqlStatement;
import gudusoft.gsqlparser.stmt.dax.TDaxEvaluateStmt;
import gudusoft.gsqlparser.stmt.dax.TDaxExprStmt;
import gudusoft.gsqlparser.stmt.dax.TDaxStmt;
import gudusoft.gsqlparser.stmt.greenplum.TSlashCommand;
import gudusoft.gsqlparser.stmt.mssql.TMssqlBlock;
import gudusoft.gsqlparser.stmt.mssql.TMssqlCreateProcedure;
import gudusoft.gsqlparser.stmt.mssql.TMssqlExecute;
import gudusoft.gsqlparser.stmt.mysql.TMySQLSource;
import gudusoft.gsqlparser.stmt.oracle.TPlsqlCreatePackage;
import gudusoft.gsqlparser.stmt.oracle.TSqlplusCmdStatement;
import gudusoft.gsqlparser.stmt.teradata.TTeradataBTEQCmd;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Stack;

public class TGSqlParser {
    private Stack<TStackFrame> frameStack = null;
    FileInputStream streamFromSqlFile = null;
    InputStreamReader sqlStreamReader = null;
    static final int stored_procedure_nested_level = 1024;
    public String sqltext;
    public String sqlfilename;
    private BufferedInputStream sqlInputStream;
    public TSourceTokenList sourcetokenlist;
    public TStatementList sqlstatements;
    private ArrayList<TSyntaxError> syntaxErrors;
    private boolean enablePartialParsing = false;
    private static String userName;
    private static String machineId;
    private static String licenseKey;
    private static String licenseType;
    private static boolean licenseOK;
    private static String licenseMessage;
    private EDbVendor dbVendor;
    private String errormessage;
    private TCustomLexer flexer;
    TCustomParser fparser;
    TCustomParser fplsqlparser;
    BufferedReader finputstream = null;
    TCustomSqlStatement gcurrentsqlstatement;
    TCustomSqlStatement nextStmt;
    TSqlCmds sqlcmds;
    HashMap sqlpluskeywordList;
    char delimiterchar;
    String defaultDelimiterStr;
    private ITokenHandle tokenHandle = null;
    private IMetaDatabase metaDatabase = null;
    char curdelimiterchar;
    String userDelimiterStr = "";
    private TSQLEnv sqlEnv = null;

    public static EDbVendor getDBVendorByName(String dbVendorName) {
        EDbVendor vendor = dbVendorName.contains("access") ? EDbVendor.dbvaccess : (dbVendorName.contains("ansi") ? EDbVendor.dbvansi : (dbVendorName.contains("bigquery") ? EDbVendor.dbvbigquery : (dbVendorName.contains("couchbase") ? EDbVendor.dbvcouchbase : (dbVendorName.contains("dax") ? EDbVendor.dbvdax : (dbVendorName.contains("db2") ? EDbVendor.dbvdb2 : (dbVendorName.contains("firebird") ? EDbVendor.dbvfirebird : (dbVendorName.contains("generic") ? EDbVendor.dbvgeneric : (dbVendorName.contains("greenplum") ? EDbVendor.dbvgreenplum : (dbVendorName.contains("hana") ? EDbVendor.dbvhana : (dbVendorName.contains("hive") ? EDbVendor.dbvhive : (dbVendorName.contains("impala") ? EDbVendor.dbvimpala : (dbVendorName.contains("informix") ? EDbVendor.dbvinformix : (dbVendorName.contains("mdx") ? EDbVendor.dbvmdx : (dbVendorName.contains("mssql") || dbVendorName.contains("sqlserver") ? EDbVendor.dbvmssql : (dbVendorName.contains("mysql") ? EDbVendor.dbvmysql : (dbVendorName.contains("netezza") ? EDbVendor.dbvnetezza : (dbVendorName.contains("odbc") ? EDbVendor.dbvodbc : (dbVendorName.contains("openedge") ? EDbVendor.dbvopenedge : (dbVendorName.contains("oracle") ? EDbVendor.dbvoracle : (dbVendorName.contains("postgresql") || dbVendorName.contains("postgres") ? EDbVendor.dbvpostgresql : (dbVendorName.contains("redshift") ? EDbVendor.dbvredshift : (dbVendorName.contains("snowflake") ? EDbVendor.dbvsnowflake : (dbVendorName.contains("sybase") ? EDbVendor.dbvsybase : (dbVendorName.contains("teradata") ? EDbVendor.dbvteradata : (dbVendorName.contains("vertica") ? EDbVendor.dbvvertica : EDbVendor.dbvoracle)))))))))))))))))))))))));
        return vendor;
    }

    public Stack<TStackFrame> getFrameStack() {
        if (this.frameStack == null) {
            this.frameStack = new Stack();
        }
        return this.frameStack;
    }

    public void setFrameStack(Stack<TStackFrame> frameStack) {
        this.frameStack = frameStack;
    }

    void closeFileStream() {
        if (this.streamFromSqlFile != null) {
            try {
                this.streamFromSqlFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public TSourceTokenList getSourcetokenlist() {
        return this.sourcetokenlist;
    }

    public TStatementList getSqlstatements() {
        return this.sqlstatements;
    }

    public void setSqltext(String sqltext) {
        this.sqltext = sqltext;
        this.sqlfilename = "";
        this.sqlInputStream = null;
    }

    public String getSqltext() {
        return this.sqltext;
    }

    public void setSqlfilename(String sqlfilename) {
        this.sqlfilename = sqlfilename;
        this.sqltext = "";
        this.sqlInputStream = null;
    }

    public String getSqlfilename() {
        return this.sqlfilename;
    }

    public void setSqlInputStream(InputStream sqlInputStream) {
        this.sqlInputStream = sqlInputStream instanceof BufferedInputStream ? (BufferedInputStream)sqlInputStream : new BufferedInputStream(sqlInputStream);
        this.sqlfilename = "";
        this.sqltext = "";
    }

    public InputStream getSqlInputStream() {
        return this.sqlInputStream;
    }

    public ArrayList<TSyntaxError> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    public EDbVendor getDbVendor() {
        return this.dbVendor;
    }

    public void setEnablePartialParsing(boolean enablePartialParsing) {
        this.enablePartialParsing = enablePartialParsing;
    }

    private boolean isEnablePartialParsing() {
        return this.enablePartialParsing;
    }

    public static String getUserName() {
        return userName;
    }

    public static String getMachineId() {
        return machineId;
    }

    public static String getLicenseMessage() {
        return licenseMessage;
    }

    public static String getLicenseType() {
        return licenseType;
    }

    public TCustomLexer getFlexer() {
        return this.flexer;
    }

    public void setTokenHandle(ITokenHandle tokenHandle) {
        this.tokenHandle = tokenHandle;
    }

    public void setMetaDatabase(IMetaDatabase metaDatabase) {
        this.metaDatabase = metaDatabase;
    }

    public IMetaDatabase getMetaDatabase() {
        return this.metaDatabase;
    }

    public void freeParseTable() {
        this.flexer.yystack = null;
        this.flexer.yytextbuf = null;
        this.flexer.buf = null;
    }

    public TGSqlParser(EDbVendor pdbvendor) {
        this.dbVendor = pdbvendor;
        this.sqltext = "";
        this.sqlfilename = "";
        this.delimiterchar = (char)59;
        this.defaultDelimiterStr = ";";
        switch (pdbvendor) {
            case dbvmssql: 
            case dbvaccess: {
                this.flexer = new TLexerMssql();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserMssqlSql(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvsybase: {
                this.flexer = new TLexerSybase();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserSybase(null);
                this.fparser.lexer = this.flexer;
                this.enablePartialParsing = false;
                break;
            }
            case dbvinformix: {
                this.flexer = new TLexerInformix();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserInformix(null);
                this.fparser.lexer = this.flexer;
                this.enablePartialParsing = false;
                break;
            }
            case dbvoracle: {
                this.delimiterchar = (char)47;
                this.flexer = new TLexerOracle();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserOracleSql(null);
                this.fplsqlparser = new TParserOraclePLSql(null);
                this.fparser.lexer = this.flexer;
                this.fplsqlparser.lexer = this.flexer;
                this.fplsqlparser.getNf().setGsqlParser(this);
                break;
            }
            case dbvdb2: {
                this.delimiterchar = (char)64;
                this.flexer = new TLexerDb2();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserDb2Sql(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvmysql: {
                this.delimiterchar = (char)36;
                this.defaultDelimiterStr = "$";
                this.flexer = new TLexerMysql();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserMysqlSql(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvteradata: {
                this.delimiterchar = (char)47;
                this.flexer = new TLexerTeradata();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserTeradata(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvpostgresql: {
                this.delimiterchar = (char)47;
                this.flexer = new TLexerPostgresql();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserPostgresql(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvredshift: {
                this.delimiterchar = (char)47;
                this.flexer = new TLexerRedshift();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserRedshift(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvgreenplum: {
                this.delimiterchar = (char)47;
                this.flexer = new TLexerGreenplum();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserGreenplum(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvmdx: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerMdx();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserMdx(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvnetezza: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerNetezza();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserNetezza(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvhive: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerHive();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserHive(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvimpala: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerImpala();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserImpala(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvhana: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerHana();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserHana(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvdax: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerDax();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserDax(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvodbc: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerOdbc();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserOdbc(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvvertica: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerVertica();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserVertica(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvopenedge: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerOpenedge();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserOpenedge(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvcouchbase: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerCouchbase();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserCouchbase(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvsnowflake: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerSnowflake();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserSnowflake(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvbigquery: {
                this.delimiterchar = (char)59;
                this.flexer = new TLexerBigquery();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserBigquery(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            case dbvansi: 
            case dbvgeneric: {
                this.flexer = new TLexerMssql();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserMssqlSql(null);
                this.fparser.lexer = this.flexer;
                break;
            }
            default: {
                this.flexer = new TLexerMssql();
                this.flexer.delimiterchar = this.delimiterchar;
                this.flexer.defaultDelimiterStr = this.defaultDelimiterStr;
                this.fparser = new TParserMssqlSql(null);
                this.fparser.lexer = this.flexer;
            }
        }
        this.fparser.getNf().setGsqlParser(this);
        this.sourcetokenlist = new TSourceTokenList();
        this.sourcetokenlist.setGsqlparser(this);
        this.sqlstatements = new TStatementList();
        this.sqlcmds = new TSqlCmds();
        this.sqlpluskeywordList = new HashMap();
        this.syntaxErrors = new ArrayList();
        this.errormessage = "";
    }

    public TSelectSqlStatement parseSubquery(String subquery) {
        return TGSqlParser.parseSubquery(this.dbVendor, subquery);
    }

    public static TSelectSqlStatement parseSubquery(EDbVendor dbVendor, String subquery) {
        TGSqlParser localParser = new TGSqlParser(dbVendor);
        localParser.sqltext = subquery;
        int iRet = localParser.doparse();
        if (iRet != 0) {
            return null;
        }
        return (TSelectSqlStatement)localParser.sqlstatements.get(0);
    }

    public TExpression parseExpression(String expr) {
        return TGSqlParser.parseExpression(this.dbVendor, expr);
    }

    public static TExpression parseExpression(EDbVendor dbVendor, String expr) {
        TGSqlParser localParser = new TGSqlParser(dbVendor);
        localParser.sqltext = "select 1 from t where " + TBaseType.newline + expr;
        int iRet = localParser.doparse();
        if (iRet != 0) {
            return null;
        }
        return ((TSelectSqlStatement)localParser.sqlstatements.get(0)).getWhereClause().getCondition();
    }

    public TFunctionCall parseFunctionCall(String newFunction) {
        return TGSqlParser.parseFunctionCall(this.dbVendor, newFunction);
    }

    public static TFunctionCall parseFunctionCall(EDbVendor dbVendor, String newFunction) {
        TGSqlParser localParser = new TGSqlParser(dbVendor);
        localParser.sqltext = "select" + TBaseType.newline + newFunction + TBaseType.newline + "from t";
        int iRet = localParser.doparse();
        if (iRet != 0) {
            return null;
        }
        return ((TSelectSqlStatement)localParser.sqlstatements.get(0)).getResultColumnList().getResultColumn(0).getExpr().getFunctionCall();
    }

    public TObjectName parseObjectName(String newObjectName) {
        return TGSqlParser.parseObjectName(this.dbVendor, newObjectName);
    }

    public static TObjectName parseObjectName(EDbVendor dbVendor, String newObjectName) {
        TGSqlParser localParser = new TGSqlParser(dbVendor);
        localParser.sqltext = "select" + TBaseType.newline + newObjectName + TBaseType.newline + "from t";
        int iRet = localParser.doparse();
        if (iRet != 0) {
            return null;
        }
        TObjectName lcResult = null;
        TExpression e = ((TSelectSqlStatement)localParser.sqlstatements.get(0)).getResultColumnList().getResultColumn(0).getExpr();
        switch (e.getExpressionType()) {
            case simple_object_name_t: {
                lcResult = e.getObjectOperand();
                break;
            }
            case simple_constant_t: {
                lcResult = new TObjectName();
                lcResult.init(e.getConstantOperand().getValueToken());
                break;
            }
        }
        return lcResult;
    }

    public TConstant parseConstant(String newConstant) {
        return TGSqlParser.parseConstant(this.dbVendor, newConstant);
    }

    public static TConstant parseConstant(EDbVendor dbVendor, String newConstant) {
        TGSqlParser localParser = new TGSqlParser(dbVendor);
        localParser.sqltext = "select" + TBaseType.newline + newConstant + TBaseType.newline + "from t";
        int iRet = localParser.doparse();
        if (iRet != 0) {
            return null;
        }
        return ((TSelectSqlStatement)localParser.sqlstatements.get(0)).getResultColumnList().getResultColumn(0).getExpr().getConstantOperand();
    }

    public int getErrorCount() {
        return this.syntaxErrors.size();
    }

    public String getErrormessage() {
        String s = "";
        String hint = "Syntax error";
        for (int i = 0; i < this.syntaxErrors.size(); ++i) {
            TSyntaxError t = this.syntaxErrors.get(i);
            if (t.hint.length() > 0) {
                hint = t.hint;
            }
            s = s + hint + "(" + t.errorno + ") near: " + t.tokentext;
            s = s + "(" + t.lineNo;
            s = s + "," + t.columnNo + ")";
            if (i == this.syntaxErrors.size() - 1) continue;
            s = s + TBaseType.linebreak;
        }
        if (this.errormessage.length() > 0) {
            s = this.errormessage + TBaseType.linebreak + s;
        }
        return s;
    }

    public int checkSyntax() {
        return this.doparse();
    }

    public int parse() {
        return this.doparse();
    }

    void setdelimiterchar(char ch) {
        this.delimiterchar = ch;
        this.flexer.delimiterchar = ch;
    }

    boolean includesqlstatementtype(ESqlStatementType search, ESqlStatementType[] src) {
        boolean ret = false;
        for (int i = 0; i < src.length; ++i) {
            if (src[i] != search) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private int getfileEncodingType(BufferedInputStream fr) {
        int ret = 0;
        try {
            byte[] bom = new byte[4];
            fr.mark(bom.length + 1);
            fr.read(bom, 0, bom.length);
            if (bom[0] == -1 && bom[1] == -2 || bom[0] == -2 && bom[1] == -1) {
                ret = 1;
                if (bom[2] == -1 && bom[3] == -2 || bom[2] == -2 && bom[3] == -1) {
                    ret = 2;
                }
            } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                ret = 3;
            }
            fr.reset();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    private int getfileEncodingType(String fn) {
        int ret = 0;
        try {
            FileInputStream fr = new FileInputStream(this.sqlfilename);
            ret = this.getfileEncodingType(new BufferedInputStream(fr));
            fr.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    int readsql() {
        int ret = 0;
        this.syntaxErrors.clear();
        licenseType = "dist";
        userName = "dist";
        try {
            if (this.finputstream != null) {
                this.finputstream.close();
            }
            if (this.flexer == null) {
                ret = -1;
                this.errormessage = "requested database not supported:" + this.dbVendor.toString();
                return ret;
            }
            if (this.flexer.yyinput != null) {
                this.flexer.yyinput.close();
            }
        }
        catch (IOException e) {
            ret = -1;
            this.errormessage = "requested database not supported";
        }
        if (this.sqltext.length() > 0) {
            this.finputstream = new BufferedReader(new StringReader(this.sqltext));
        } else if (this.sqlfilename.length() > 0) {
            try {
                int encodingtype = this.getfileEncodingType(this.sqlfilename);
                this.streamFromSqlFile = new FileInputStream(this.sqlfilename);
                this.sqlStreamReader = encodingtype == 1 ? new InputStreamReader((InputStream)this.streamFromSqlFile, "UTF-16") : (encodingtype == 2 ? new InputStreamReader((InputStream)this.streamFromSqlFile, "UTF-32") : (encodingtype == 3 ? new InputStreamReader((InputStream)this.streamFromSqlFile, "UTF-8") : new InputStreamReader((InputStream)this.streamFromSqlFile, Charset.defaultCharset().name())));
                this.finputstream = new BufferedReader(this.sqlStreamReader);
                if (encodingtype == 3) {
                    this.finputstream.skip(1L);
                }
            }
            catch (FileNotFoundException e) {
                ret = -1;
                this.errormessage = e.toString();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.sqlInputStream != null) {
            int encodingtype = this.getfileEncodingType(this.sqlInputStream);
            BufferedInputStream fr = this.sqlInputStream;
            InputStreamReader isr = null;
            try {
                isr = encodingtype == 1 ? new InputStreamReader((InputStream)fr, "UTF-16") : (encodingtype == 2 ? new InputStreamReader((InputStream)fr, "UTF-32") : (encodingtype == 3 ? new InputStreamReader((InputStream)fr, "UTF-8") : new InputStreamReader((InputStream)fr, Charset.defaultCharset().name())));
                this.finputstream = new BufferedReader(isr);
                if (encodingtype == 3) {
                    this.finputstream.skip(1L);
                }
            }
            catch (FileNotFoundException e) {
                ret = -1;
                this.errormessage = e.toString();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.finputstream == null) {
            ret = -1;
        }
        if (ret == 0) {
            this.flexer.yyinput = this.finputstream;
        }
        this.sourcetokenlist.clear();
        this.sourcetokenlist.curpos = -1;
        return ret;
    }

    TSourceToken getanewsourcetoken() {
        TSourceToken pst;
        block8: {
            TSourceToken prevst;
            pst = null;
            while (true) {
                if (this.flexer.yylexwrap(pst = new TSourceToken("")) == 0) {
                    pst = null;
                    break block8;
                }
                pst.setDbvendor(this.dbVendor);
                pst.tokenstatus = ETokenStatus.tsoriginal;
                if (pst.tokentype == ETokenType.ttreturn) {
                    pst.astext = this.towinlinebreak(pst.astext);
                }
                if (pst.tokentype == ETokenType.ttwhitespace && this.sourcetokenlist.curpos >= 0) {
                    prevst = this.sourcetokenlist.get(this.sourcetokenlist.curpos);
                    if (prevst.tokentype == ETokenType.ttreturn) {
                        prevst.astext = prevst.astext + pst.astext;
                        continue;
                    }
                }
                if (pst.tokentype != ETokenType.ttreturn || this.sourcetokenlist.curpos < 0) break block8;
                prevst = this.sourcetokenlist.get(this.sourcetokenlist.curpos);
                if (prevst.tokentype != ETokenType.ttreturn) break;
                prevst.astext = prevst.astext + pst.astext;
            }
            if (prevst.tokentype == ETokenType.ttwhitespace) {
                // empty if block
            }
        }
        if (pst != null) {
            pst.container = this.sourcetokenlist;
            ++this.sourcetokenlist.curpos;
            pst.posinlist = this.sourcetokenlist.curpos;
            if (this.tokenHandle != null) {
                this.tokenHandle.processToken(pst);
            }
        }
        return pst;
    }

    String towinlinebreak(String s) {
        return s;
    }

    void checkconstarinttoken(TSourceToken lcprevtoken) {
        TSourceToken lcPPToken;
        TSourceTokenList lcStList = lcprevtoken.container;
        if (TBaseType.assigned(lcStList) && TBaseType.assigned(lcPPToken = lcStList.nextsolidtoken(lcprevtoken.posinlist, -2, false)) && lcPPToken.tokencode == this.flexer.getkeywordvalue("constraint")) {
            lcPPToken.tokencode = 298;
        }
    }

    TSourceToken getprevtoken(TSourceToken ptoken) {
        TSourceTokenList lcstlist = ptoken.container;
        if (TBaseType.assigned(lcstlist) && ptoken.posinlist > 0 && lcstlist.size() > ptoken.posinlist - 1) {
            if (lcstlist.get((int)(ptoken.posinlist - 1)).tokentype != ETokenType.ttwhitespace && lcstlist.get((int)(ptoken.posinlist - 1)).tokentype != ETokenType.ttreturn && lcstlist.get((int)(ptoken.posinlist - 1)).tokentype != ETokenType.ttsimplecomment && lcstlist.get((int)(ptoken.posinlist - 1)).tokentype != ETokenType.ttbracketedcomment) {
                return lcstlist.get(ptoken.posinlist - 1);
            }
            return lcstlist.nextsolidtoken(ptoken.posinlist - 1, -1, false);
        }
        return null;
    }

    void doinformixtexttotokenlist() {
        TSourceToken lcprevtoken = null;
        int lcsteps = 0;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        boolean lcinopenrowset = false;
        int lcnested = 0;
        while (yychar > 0) {
            TSourceToken lctoken;
            if (asourcetoken.tokencode == 464) {
                lcinopenrowset = true;
                lcnested = 0;
            } else if (asourcetoken.tokentype == ETokenType.ttleftparenthesis) {
                if (lcsteps > 0 && TBaseType.assigned(lcprevtoken)) {
                    if (lcprevtoken.tokencode == 513) {
                        lcprevtoken.tokencode = 299;
                    } else if (lcprevtoken.tokencode == 516) {
                        lcprevtoken.tokencode = 297;
                    } else if (lcprevtoken.tokencode == 514) {
                        lcprevtoken.tokencode = 300;
                    } else if (lcprevtoken.tokencode == 338) {
                        lcprevtoken.tokencode = 295;
                    }
                    lcprevtoken = null;
                    lcsteps = 0;
                }
                if (lcinopenrowset) {
                    ++lcnested;
                }
            } else if (asourcetoken.tokentype == ETokenType.ttrightparenthesis) {
                if (lcinopenrowset) {
                    if (lcnested > 0) {
                        --lcnested;
                    }
                    if (lcnested == 0) {
                        lcinopenrowset = false;
                    }
                }
            } else if (asourcetoken.tokentype == ETokenType.ttsemicolon) {
                if (lcinopenrowset) {
                    asourcetoken.tokentype = ETokenType.ttsemicolon2;
                } else {
                    TSourceToken lctoken2 = asourcetoken.searchToken(351, -1);
                    if (lctoken2 != null) {
                        asourcetoken.tokencode = 531;
                        asourcetoken.tokentype = ETokenType.ttsemicolon3;
                    } else {
                        TSourceToken lctoken3;
                        lctoken2 = asourcetoken.searchToken(456, -1);
                        if (lctoken2 == null) {
                            lctoken2 = asourcetoken.searchToken(462, -1);
                        }
                        if (lctoken2 != null && (lctoken3 = asourcetoken.searchToken(351, -2)) != null) {
                            asourcetoken.tokencode = 531;
                            asourcetoken.tokentype = ETokenType.ttsemicolon3;
                        }
                    }
                }
            } else if (asourcetoken.tokentype == ETokenType.ttperiod) {
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.tokencode == 463) {
                    lctoken.tokencode = 264;
                    lctoken.tokentype = ETokenType.ttidentifier;
                }
            } else if (asourcetoken.tokencode == 308) {
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.tokencode == 473) {
                    lctoken.tokencode = 296;
                }
            } else if (asourcetoken.tokencode == 512) {
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.tokencode == 481) {
                    lctoken.tokencode = 537;
                }
            } else if (asourcetoken.tokencode == 463) {
                boolean iskeywordgo = true;
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.lineNo == asourcetoken.lineNo) {
                    iskeywordgo = false;
                }
                if (iskeywordgo) {
                    lcinopenrowset = false;
                    lcnested = 0;
                    lcprevtoken = asourcetoken;
                } else {
                    asourcetoken.tokencode = 264;
                    asourcetoken.tokentype = ETokenType.ttidentifier;
                }
            } else if (asourcetoken.tokencode == 513) {
                lcsteps = 2;
                lcprevtoken = asourcetoken;
            } else if (asourcetoken.tokencode == 516) {
                lcsteps = 2;
                lcprevtoken = asourcetoken;
            } else if (asourcetoken.tokencode == 514) {
                lcsteps = 1;
                lcprevtoken = asourcetoken;
            } else if (asourcetoken.issolidtoken() && lcsteps > 0 && !TBaseType.mysametext("clustered", asourcetoken.astext) && !TBaseType.mysametext("nonclustered", asourcetoken.astext)) {
                --lcsteps;
            }
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken != null) {
                yychar = asourcetoken.tokencode;
                continue;
            }
            yychar = 0;
        }
    }

    void domssqlsqltexttotokenlist() {
        TSourceToken lcprevtoken = null;
        int lcsteps = 0;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        boolean lcinopenrowset = false;
        int lcnested = 0;
        while (yychar > 0) {
            TSourceToken lctoken;
            if (asourcetoken.tokencode == 464) {
                lcinopenrowset = true;
                lcnested = 0;
            } else if (asourcetoken.tokentype == ETokenType.ttleftparenthesis) {
                if (lcsteps > 0 && TBaseType.assigned(lcprevtoken)) {
                    if (lcprevtoken.tokencode == 513) {
                        lcprevtoken.tokencode = 299;
                        this.checkconstarinttoken(lcprevtoken);
                    } else if (lcprevtoken.tokencode == 516) {
                        lcprevtoken.tokencode = 297;
                        this.checkconstarinttoken(lcprevtoken);
                    } else if (lcprevtoken.tokencode == 514) {
                        lcprevtoken.tokencode = 300;
                        this.checkconstarinttoken(lcprevtoken);
                    }
                    lcprevtoken = null;
                    lcsteps = 0;
                }
                if (lcinopenrowset) {
                    ++lcnested;
                }
            } else if (asourcetoken.tokentype == ETokenType.ttrightparenthesis) {
                if (lcinopenrowset) {
                    if (lcnested > 0) {
                        --lcnested;
                    }
                    if (lcnested == 0) {
                        lcinopenrowset = false;
                    }
                }
            } else if (asourcetoken.tokentype == ETokenType.ttsemicolon) {
                if (lcinopenrowset) {
                    asourcetoken.tokentype = ETokenType.ttsemicolon2;
                } else {
                    TSourceToken lctoken2 = asourcetoken.searchToken(351, -1);
                    if (lctoken2 != null) {
                        asourcetoken.tokencode = 531;
                        asourcetoken.tokentype = ETokenType.ttsemicolon3;
                    } else {
                        TSourceToken lctoken3;
                        lctoken2 = asourcetoken.searchToken(456, -1);
                        if (lctoken2 == null) {
                            lctoken2 = asourcetoken.searchToken(462, -1);
                        }
                        if (lctoken2 != null && (lctoken3 = asourcetoken.searchToken(351, -2)) != null) {
                            asourcetoken.tokencode = 531;
                            asourcetoken.tokentype = ETokenType.ttsemicolon3;
                        }
                    }
                }
                lctoken = this.getprevtoken(asourcetoken);
                if (lctoken != null && lctoken.tokentype == ETokenType.ttsemicolon) {
                    asourcetoken.tokencode = 259;
                }
            } else if (asourcetoken.tokentype == ETokenType.ttperiod) {
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.tokencode == 463) {
                    lctoken.tokencode = 264;
                    lctoken.tokentype = ETokenType.ttidentifier;
                }
            } else if (asourcetoken.tokencode == 308) {
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.tokencode == 473) {
                    lctoken.tokencode = 296;
                }
            } else if (asourcetoken.tokencode == 463) {
                boolean iskeywordgo = true;
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.lineNo == asourcetoken.lineNo) {
                    iskeywordgo = false;
                }
                if (iskeywordgo) {
                    lcinopenrowset = false;
                    lcnested = 0;
                    lcprevtoken = asourcetoken;
                } else {
                    asourcetoken.tokencode = 264;
                    asourcetoken.tokentype = ETokenType.ttidentifier;
                }
            } else if (asourcetoken.tokencode == 513) {
                lcsteps = 2;
                lcprevtoken = asourcetoken;
            } else if (asourcetoken.tokencode == 516) {
                lcsteps = 2;
                lcprevtoken = asourcetoken;
            } else if (asourcetoken.tokencode == 514) {
                lcsteps = 1;
                lcprevtoken = asourcetoken;
            } else if (asourcetoken.issolidtoken() && lcsteps > 0 && !TBaseType.mysametext("clustered", asourcetoken.astext) && !TBaseType.mysametext("nonclustered", asourcetoken.astext) && !TBaseType.mysametext("hash", asourcetoken.astext)) {
                --lcsteps;
            }
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken != null) {
                yychar = asourcetoken.tokencode;
                continue;
            }
            yychar = 0;
        }
    }

    void dosybasesqltexttotokenlist() {
        TSourceToken lcprevtoken = null;
        int lcsteps = 0;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        boolean lcinopenrowset = false;
        int lcnested = 0;
        while (yychar > 0) {
            TSourceToken lctoken;
            if (asourcetoken.tokencode == 464) {
                lcinopenrowset = true;
                lcnested = 0;
            } else if (asourcetoken.tokentype == ETokenType.ttleftparenthesis) {
                if (lcsteps > 0 && TBaseType.assigned(lcprevtoken)) {
                    if (lcprevtoken.tokencode == 513) {
                        lcprevtoken.tokencode = 299;
                        this.checkconstarinttoken(lcprevtoken);
                    } else if (lcprevtoken.tokencode == 516) {
                        lcprevtoken.tokencode = 297;
                        this.checkconstarinttoken(lcprevtoken);
                    } else if (lcprevtoken.tokencode == 514) {
                        lcprevtoken.tokencode = 300;
                        this.checkconstarinttoken(lcprevtoken);
                    }
                    lcprevtoken = null;
                    lcsteps = 0;
                }
                if (lcinopenrowset) {
                    ++lcnested;
                }
            } else if (asourcetoken.tokentype == ETokenType.ttrightparenthesis) {
                if (lcinopenrowset) {
                    if (lcnested > 0) {
                        --lcnested;
                    }
                    if (lcnested == 0) {
                        lcinopenrowset = false;
                    }
                }
            } else if (asourcetoken.tokentype == ETokenType.ttsemicolon) {
                if (lcinopenrowset) {
                    asourcetoken.tokentype = ETokenType.ttsemicolon2;
                } else {
                    TSourceToken lctoken2 = asourcetoken.searchToken(351, -1);
                    if (lctoken2 != null) {
                        asourcetoken.tokencode = 531;
                        asourcetoken.tokentype = ETokenType.ttsemicolon3;
                    } else {
                        TSourceToken lctoken3;
                        lctoken2 = asourcetoken.searchToken(456, -1);
                        if (lctoken2 == null) {
                            lctoken2 = asourcetoken.searchToken(462, -1);
                        }
                        if (lctoken2 != null && (lctoken3 = asourcetoken.searchToken(351, -2)) != null) {
                            asourcetoken.tokencode = 531;
                            asourcetoken.tokentype = ETokenType.ttsemicolon3;
                        }
                    }
                }
            } else if (asourcetoken.tokentype == ETokenType.ttperiod) {
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.tokencode == 463) {
                    lctoken.tokencode = 264;
                    lctoken.tokentype = ETokenType.ttidentifier;
                }
            } else if (asourcetoken.tokencode == 308) {
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.tokencode == 473) {
                    lctoken.tokencode = 296;
                }
            } else if (asourcetoken.tokencode == 560) {
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.tokencode == 559) {
                    lctoken.tokencode = 287;
                }
            } else if (asourcetoken.tokencode == 304) {
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && (lctoken.tokencode == 321 || lctoken.tokencode == 319 || lctoken.tokencode == 320 || lctoken.tokencode == 305)) {
                    asourcetoken.tokencode = 288;
                }
            } else if (asourcetoken.tokencode == 463) {
                boolean iskeywordgo = true;
                lctoken = this.getprevtoken(asourcetoken);
                if (TBaseType.assigned(lctoken) && lctoken.lineNo == asourcetoken.lineNo) {
                    iskeywordgo = false;
                }
                if (iskeywordgo) {
                    lcinopenrowset = false;
                    lcnested = 0;
                    lcprevtoken = asourcetoken;
                } else {
                    asourcetoken.tokencode = 264;
                    asourcetoken.tokentype = ETokenType.ttidentifier;
                }
            } else if (asourcetoken.tokencode == 513) {
                lcsteps = 2;
                lcprevtoken = asourcetoken;
            } else if (asourcetoken.tokencode == 516) {
                lcsteps = 2;
                lcprevtoken = asourcetoken;
            } else if (asourcetoken.tokencode == 514) {
                lcsteps = 1;
                lcprevtoken = asourcetoken;
            } else if (asourcetoken.issolidtoken() && lcsteps > 0 && !TBaseType.mysametext("clustered", asourcetoken.astext) && !TBaseType.mysametext("nonclustered", asourcetoken.astext)) {
                --lcsteps;
            }
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken != null) {
                yychar = asourcetoken.tokencode;
                continue;
            }
            yychar = 0;
        }
    }

    boolean IsValidPlaceForDivToSqlplusCmd(TSourceTokenList pstlist, int pPos) {
        boolean ret = false;
        if (pPos <= 0 || pPos > pstlist.size() - 1) {
            return ret;
        }
        TSourceToken lcst = pstlist.get(pPos - 1);
        if (lcst.tokentype != ETokenType.ttreturn) {
            return ret;
        }
        if (lcst.astext.charAt(lcst.astext.length() - 1) != ' ') {
            ret = true;
        }
        return ret;
    }

    boolean isvalidsqlpluscmdInPostgresql(String astr) {
        return false;
    }

    TSourceToken getprevsolidtoken(TSourceToken ptoken) {
        TSourceToken ret = null;
        TSourceTokenList lctokenlist = ptoken.container;
        if (lctokenlist != null && ptoken.posinlist > 0 && lctokenlist.size() > ptoken.posinlist - 1) {
            ret = lctokenlist.get((int)(ptoken.posinlist - 1)).tokentype != ETokenType.ttwhitespace && lctokenlist.get((int)(ptoken.posinlist - 1)).tokentype != ETokenType.ttreturn && lctokenlist.get((int)(ptoken.posinlist - 1)).tokentype != ETokenType.ttsimplecomment && lctokenlist.get((int)(ptoken.posinlist - 1)).tokentype != ETokenType.ttbracketedcomment ? lctokenlist.get(ptoken.posinlist - 1) : lctokenlist.nextsolidtoken(ptoken.posinlist - 1, -1, false);
        }
        return ret;
    }

    void doredshifttexttotokenlist() {
        boolean insqlpluscmd = false;
        boolean isvalidplace = true;
        boolean waitingreturnforfloatdiv = false;
        boolean waitingreturnforsemicolon = false;
        boolean continuesqlplusatnewline = false;
        TSourceToken lct = null;
        Object prevst = null;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            switch (yychar) {
                case 257: 
                case 258: 
                case 259: {
                    if (!insqlpluscmd) break;
                    asourcetoken.insqlpluscmd = true;
                    break;
                }
                case 260: {
                    if (insqlpluscmd) {
                        insqlpluscmd = false;
                        isvalidplace = true;
                        if (continuesqlplusatnewline) {
                            insqlpluscmd = true;
                            isvalidplace = false;
                            asourcetoken.insqlpluscmd = true;
                        }
                    }
                    if (waitingreturnforsemicolon) {
                        isvalidplace = true;
                    }
                    if (waitingreturnforfloatdiv) {
                        isvalidplace = true;
                        lct.tokencode = 273;
                        if (lct.tokentype != ETokenType.ttslash) {
                            lct.tokentype = ETokenType.ttsqlpluscmd;
                        }
                    }
                    this.flexer.insqlpluscmd = insqlpluscmd;
                    break;
                }
                default: {
                    TSourceToken stPercent;
                    continuesqlplusatnewline = false;
                    waitingreturnforsemicolon = false;
                    waitingreturnforfloatdiv = false;
                    if (insqlpluscmd) {
                        asourcetoken.insqlpluscmd = true;
                        if (asourcetoken.astext.equalsIgnoreCase("-")) {
                            continuesqlplusatnewline = true;
                        }
                    } else {
                        if (asourcetoken.tokentype == ETokenType.ttsemicolon) {
                            waitingreturnforsemicolon = true;
                        }
                        if (asourcetoken.tokentype == ETokenType.ttslash && (isvalidplace || this.IsValidPlaceForDivToSqlplusCmd(this.sourcetokenlist, asourcetoken.posinlist))) {
                            lct = asourcetoken;
                            waitingreturnforfloatdiv = true;
                        }
                        if (isvalidplace && this.isvalidsqlpluscmdInPostgresql(asourcetoken.astext)) {
                            asourcetoken.tokencode = 273;
                            if (asourcetoken.tokentype != ETokenType.ttslash) {
                                asourcetoken.tokentype = ETokenType.ttsqlpluscmd;
                            }
                            this.flexer.insqlpluscmd = insqlpluscmd = true;
                        }
                    }
                    isvalidplace = false;
                    if (asourcetoken.tokencode != 534 || (stPercent = asourcetoken.searchToken(37, -1)) == null) break;
                    stPercent.tokencode = 296;
                }
            }
            if ((asourcetoken = this.getanewsourcetoken()) != null) {
                yychar = asourcetoken.tokencode;
            } else {
                yychar = 0;
                if (waitingreturnforfloatdiv) {
                    lct.tokencode = 273;
                    if (lct.tokentype != ETokenType.ttslash) {
                        lct.tokentype = ETokenType.ttsqlpluscmd;
                    }
                }
            }
            if (yychar != 0 || prevst == null) continue;
        }
    }

    void dopostgresqltexttotokenlist() {
        boolean insqlpluscmd = false;
        boolean isvalidplace = true;
        boolean waitingreturnforfloatdiv = false;
        boolean waitingreturnforsemicolon = false;
        boolean continuesqlplusatnewline = false;
        TSourceToken lct = null;
        TSourceToken prevst = null;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            switch (yychar) {
                case 257: 
                case 258: 
                case 259: {
                    if (!insqlpluscmd) break;
                    asourcetoken.insqlpluscmd = true;
                    break;
                }
                case 260: {
                    if (insqlpluscmd) {
                        insqlpluscmd = false;
                        isvalidplace = true;
                        if (continuesqlplusatnewline) {
                            insqlpluscmd = true;
                            isvalidplace = false;
                            asourcetoken.insqlpluscmd = true;
                        }
                    }
                    if (waitingreturnforsemicolon) {
                        isvalidplace = true;
                    }
                    if (waitingreturnforfloatdiv) {
                        isvalidplace = true;
                        lct.tokencode = 273;
                        if (lct.tokentype != ETokenType.ttslash) {
                            lct.tokentype = ETokenType.ttsqlpluscmd;
                        }
                    }
                    this.flexer.insqlpluscmd = insqlpluscmd;
                    break;
                }
                default: {
                    TSourceToken stDo;
                    TSourceToken stPercent;
                    TSourceToken stKeep;
                    TSourceToken lcprevst;
                    continuesqlplusatnewline = false;
                    waitingreturnforsemicolon = false;
                    waitingreturnforfloatdiv = false;
                    if (insqlpluscmd) {
                        asourcetoken.insqlpluscmd = true;
                        if (asourcetoken.astext.equalsIgnoreCase("-")) {
                            continuesqlplusatnewline = true;
                        }
                    } else {
                        if (asourcetoken.tokentype == ETokenType.ttsemicolon) {
                            waitingreturnforsemicolon = true;
                        }
                        if (asourcetoken.tokentype == ETokenType.ttslash && (isvalidplace || this.IsValidPlaceForDivToSqlplusCmd(this.sourcetokenlist, asourcetoken.posinlist))) {
                            lct = asourcetoken;
                            waitingreturnforfloatdiv = true;
                        }
                        if (isvalidplace && this.isvalidsqlpluscmdInPostgresql(asourcetoken.astext)) {
                            asourcetoken.tokencode = 273;
                            if (asourcetoken.tokentype != ETokenType.ttslash) {
                                asourcetoken.tokentype = ETokenType.ttsqlpluscmd;
                            }
                            this.flexer.insqlpluscmd = insqlpluscmd = true;
                        }
                    }
                    isvalidplace = false;
                    if (prevst != null) {
                        if (prevst.tokencode == 345 && asourcetoken.tokencode != this.flexer.getkeywordvalue("JOIN")) {
                            prevst.tokencode = 264;
                        }
                        if (prevst.tokencode == 321 && asourcetoken.tokencode == this.flexer.getkeywordvalue("DEFERRABLE")) {
                            prevst.tokencode = this.flexer.getkeywordvalue("NOT_DEFERRABLE");
                        }
                    }
                    prevst = asourcetoken.tokencode == 345 ? asourcetoken : (asourcetoken.tokencode == 321 ? asourcetoken : null);
                    if ((asourcetoken.tokencode == this.flexer.getkeywordvalue("DIRECT_LOAD") || asourcetoken.tokencode == this.flexer.getkeywordvalue("ALL")) && (lcprevst = this.getprevsolidtoken(asourcetoken)) != null && lcprevst.tokencode == 306) {
                        lcprevst.tokencode = 285;
                    }
                    if (asourcetoken.tokencode == 534 && (stKeep = asourcetoken.searchToken(532, -2)) != null) {
                        stKeep.tokencode = 533;
                    }
                    if (asourcetoken.tokencode == 548 && (stPercent = asourcetoken.searchToken(37, -1)) != null) {
                        stPercent.tokencode = 296;
                    }
                    if (asourcetoken.tokencode == 298 && (stPercent = asourcetoken.searchToken(61, -1)) != null) {
                        asourcetoken.tokencode = 264;
                    }
                    if (asourcetoken.tokencode != 304 || (stDo = asourcetoken.searchToken(501, -1)) == null) break;
                    asourcetoken.tokencode = 551;
                }
            }
            if ((asourcetoken = this.getanewsourcetoken()) != null) {
                yychar = asourcetoken.tokencode;
            } else {
                yychar = 0;
                if (waitingreturnforfloatdiv) {
                    lct.tokencode = 273;
                    if (lct.tokentype != ETokenType.ttslash) {
                        lct.tokentype = ETokenType.ttsqlpluscmd;
                    }
                }
            }
            if (yychar != 0 || prevst == null || prevst.tokencode != 345) continue;
            prevst.tokencode = 264;
        }
    }

    void dosnowflakesqltexttotokenlist() {
        boolean insqlpluscmd = false;
        boolean isvalidplace = true;
        boolean waitingreturnforfloatdiv = false;
        boolean waitingreturnforsemicolon = false;
        boolean continuesqlplusatnewline = false;
        TSourceToken lct = null;
        TSourceToken prevst = null;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            switch (yychar) {
                case 257: 
                case 258: 
                case 259: {
                    if (!insqlpluscmd) break;
                    asourcetoken.insqlpluscmd = true;
                    break;
                }
                case 260: {
                    if (insqlpluscmd) {
                        insqlpluscmd = false;
                        isvalidplace = true;
                        if (continuesqlplusatnewline) {
                            insqlpluscmd = true;
                            isvalidplace = false;
                            asourcetoken.insqlpluscmd = true;
                        }
                    }
                    if (waitingreturnforsemicolon) {
                        isvalidplace = true;
                    }
                    if (waitingreturnforfloatdiv) {
                        isvalidplace = true;
                        lct.tokencode = 273;
                        if (lct.tokentype != ETokenType.ttslash) {
                            lct.tokentype = ETokenType.ttsqlpluscmd;
                        }
                    }
                    this.flexer.insqlpluscmd = insqlpluscmd;
                    break;
                }
                default: {
                    continuesqlplusatnewline = false;
                    waitingreturnforsemicolon = false;
                    waitingreturnforfloatdiv = false;
                    if (insqlpluscmd) {
                        asourcetoken.insqlpluscmd = true;
                        if (asourcetoken.astext.equalsIgnoreCase("-")) {
                            continuesqlplusatnewline = true;
                        }
                    } else {
                        if (asourcetoken.tokentype == ETokenType.ttsemicolon) {
                            waitingreturnforsemicolon = true;
                        }
                        if (asourcetoken.tokentype == ETokenType.ttslash && (isvalidplace || this.IsValidPlaceForDivToSqlplusCmd(this.sourcetokenlist, asourcetoken.posinlist))) {
                            lct = asourcetoken;
                            waitingreturnforfloatdiv = true;
                        }
                        if (isvalidplace && this.isvalidsqlpluscmdInPostgresql(asourcetoken.astext)) {
                            asourcetoken.tokencode = 273;
                            if (asourcetoken.tokentype != ETokenType.ttslash) {
                                asourcetoken.tokentype = ETokenType.ttsqlpluscmd;
                            }
                            this.flexer.insqlpluscmd = insqlpluscmd = true;
                        }
                    }
                    isvalidplace = false;
                    if (prevst != null) {
                        if (prevst.tokencode == 345 && asourcetoken.tokencode != this.flexer.getkeywordvalue("JOIN")) {
                            prevst.tokencode = 264;
                        }
                        if (prevst.tokencode == 321 && asourcetoken.tokencode == this.flexer.getkeywordvalue("DEFERRABLE")) {
                            prevst.tokencode = this.flexer.getkeywordvalue("NOT_DEFERRABLE");
                        }
                    }
                    prevst = asourcetoken.tokencode == 345 ? asourcetoken : (asourcetoken.tokencode == 321 ? asourcetoken : null);
                }
            }
            if ((asourcetoken = this.getanewsourcetoken()) != null) {
                yychar = asourcetoken.tokencode;
            } else {
                yychar = 0;
                if (waitingreturnforfloatdiv) {
                    lct.tokencode = 273;
                    if (lct.tokentype != ETokenType.ttslash) {
                        lct.tokentype = ETokenType.ttsqlpluscmd;
                    }
                }
            }
            if (yychar != 0 || prevst == null || prevst.tokencode != 345) continue;
            prevst.tokencode = 264;
        }
    }

    void doverticatexttotokenlist() {
        this.dopostgresqltexttotokenlist();
    }

    void docouchbasesqltexttotokenlist() {
        this.dopostgresqltexttotokenlist();
    }

    void dobigquerysqltexttotokenlist() {
        this.domysqltexttotokenlist();
    }

    void dogreenplumtexttotokenlist() {
        boolean insqlpluscmd = false;
        boolean isvalidplace = true;
        boolean waitingreturnforfloatdiv = false;
        boolean waitingreturnforsemicolon = false;
        boolean continuesqlplusatnewline = false;
        TSourceToken lct = null;
        TSourceToken prevst = null;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            switch (yychar) {
                case 257: 
                case 258: 
                case 259: {
                    if (!insqlpluscmd) break;
                    asourcetoken.insqlpluscmd = true;
                    break;
                }
                case 260: {
                    if (insqlpluscmd) {
                        insqlpluscmd = false;
                        isvalidplace = true;
                        if (continuesqlplusatnewline) {
                            insqlpluscmd = true;
                            isvalidplace = false;
                            asourcetoken.insqlpluscmd = true;
                        }
                    }
                    if (waitingreturnforsemicolon) {
                        isvalidplace = true;
                    }
                    if (waitingreturnforfloatdiv) {
                        isvalidplace = true;
                        lct.tokencode = 273;
                        if (lct.tokentype != ETokenType.ttslash) {
                            lct.tokentype = ETokenType.ttsqlpluscmd;
                        }
                    }
                    this.flexer.insqlpluscmd = insqlpluscmd;
                    break;
                }
                default: {
                    TSourceToken stPercent;
                    TSourceToken stKeep;
                    TSourceToken lcprevst;
                    continuesqlplusatnewline = false;
                    waitingreturnforsemicolon = false;
                    waitingreturnforfloatdiv = false;
                    if (insqlpluscmd) {
                        asourcetoken.insqlpluscmd = true;
                        if (asourcetoken.astext.equalsIgnoreCase("-")) {
                            continuesqlplusatnewline = true;
                        }
                    } else {
                        if (asourcetoken.tokentype == ETokenType.ttsemicolon) {
                            waitingreturnforsemicolon = true;
                        }
                        if (asourcetoken.tokentype == ETokenType.ttslash && (isvalidplace || this.IsValidPlaceForDivToSqlplusCmd(this.sourcetokenlist, asourcetoken.posinlist))) {
                            lct = asourcetoken;
                            waitingreturnforfloatdiv = true;
                        }
                        if (isvalidplace && this.isvalidsqlpluscmdInPostgresql(asourcetoken.astext)) {
                            asourcetoken.tokencode = 273;
                            if (asourcetoken.tokentype != ETokenType.ttslash) {
                                asourcetoken.tokentype = ETokenType.ttsqlpluscmd;
                            }
                            this.flexer.insqlpluscmd = insqlpluscmd = true;
                        }
                    }
                    isvalidplace = false;
                    if (prevst != null) {
                        if (prevst.tokencode == 345 && asourcetoken.tokencode != this.flexer.getkeywordvalue("JOIN")) {
                            prevst.tokencode = 264;
                        }
                        if (prevst.tokencode == 321 && asourcetoken.tokencode == this.flexer.getkeywordvalue("DEFERRABLE")) {
                            prevst.tokencode = this.flexer.getkeywordvalue("NOT_DEFERRABLE");
                        }
                    }
                    prevst = asourcetoken.tokencode == 345 ? asourcetoken : (asourcetoken.tokencode == 321 ? asourcetoken : null);
                    if ((asourcetoken.tokencode == this.flexer.getkeywordvalue("DIRECT_LOAD") || asourcetoken.tokencode == this.flexer.getkeywordvalue("ALL")) && (lcprevst = this.getprevsolidtoken(asourcetoken)) != null && lcprevst.tokencode == 306) {
                        lcprevst.tokencode = 285;
                    }
                    if (asourcetoken.tokencode == 534 && (stKeep = asourcetoken.searchToken(532, -2)) != null) {
                        stKeep.tokencode = 533;
                    }
                    if (asourcetoken.tokencode != 550 || (stPercent = asourcetoken.searchToken(37, -1)) == null) break;
                    stPercent.tokencode = 296;
                }
            }
            if ((asourcetoken = this.getanewsourcetoken()) != null) {
                yychar = asourcetoken.tokencode;
            } else {
                yychar = 0;
                if (waitingreturnforfloatdiv) {
                    lct.tokencode = 273;
                    if (lct.tokentype != ETokenType.ttslash) {
                        lct.tokentype = ETokenType.ttsqlpluscmd;
                    }
                }
            }
            if (yychar != 0 || prevst == null || prevst.tokencode != 345) continue;
            prevst.tokencode = 264;
        }
    }

    void donetezzatexttotokenlist() {
        boolean insqlpluscmd = false;
        boolean isvalidplace = true;
        boolean waitingreturnforfloatdiv = false;
        boolean waitingreturnforsemicolon = false;
        boolean continuesqlplusatnewline = false;
        TSourceToken lct = null;
        TSourceToken prevst = null;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            switch (yychar) {
                case 257: 
                case 258: 
                case 259: {
                    if (!insqlpluscmd) break;
                    asourcetoken.insqlpluscmd = true;
                    break;
                }
                case 260: {
                    if (insqlpluscmd) {
                        insqlpluscmd = false;
                        isvalidplace = true;
                        if (continuesqlplusatnewline) {
                            insqlpluscmd = true;
                            isvalidplace = false;
                            asourcetoken.insqlpluscmd = true;
                        }
                    }
                    if (waitingreturnforsemicolon) {
                        isvalidplace = true;
                    }
                    if (waitingreturnforfloatdiv) {
                        isvalidplace = true;
                        lct.tokencode = 273;
                        if (lct.tokentype != ETokenType.ttslash) {
                            lct.tokentype = ETokenType.ttsqlpluscmd;
                        }
                    }
                    this.flexer.insqlpluscmd = insqlpluscmd;
                    break;
                }
                default: {
                    TSourceToken stKeep;
                    TSourceToken lcprevst;
                    continuesqlplusatnewline = false;
                    waitingreturnforsemicolon = false;
                    waitingreturnforfloatdiv = false;
                    if (insqlpluscmd) {
                        asourcetoken.insqlpluscmd = true;
                        if (asourcetoken.astext.equalsIgnoreCase("-")) {
                            continuesqlplusatnewline = true;
                        }
                    } else {
                        if (asourcetoken.tokentype == ETokenType.ttsemicolon) {
                            waitingreturnforsemicolon = true;
                        }
                        if (asourcetoken.tokentype == ETokenType.ttslash && (isvalidplace || this.IsValidPlaceForDivToSqlplusCmd(this.sourcetokenlist, asourcetoken.posinlist))) {
                            lct = asourcetoken;
                            waitingreturnforfloatdiv = true;
                        }
                        if (isvalidplace && this.isvalidsqlpluscmdInPostgresql(asourcetoken.astext)) {
                            asourcetoken.tokencode = 273;
                            if (asourcetoken.tokentype != ETokenType.ttslash) {
                                asourcetoken.tokentype = ETokenType.ttsqlpluscmd;
                            }
                            this.flexer.insqlpluscmd = insqlpluscmd = true;
                        }
                    }
                    isvalidplace = false;
                    if (prevst != null) {
                        if (prevst.tokencode == 345 && asourcetoken.tokencode != this.flexer.getkeywordvalue("JOIN")) {
                            prevst.tokencode = 264;
                        }
                        if (prevst.tokencode == 321 && asourcetoken.tokencode == this.flexer.getkeywordvalue("DEFERRABLE")) {
                            prevst.tokencode = this.flexer.getkeywordvalue("NOT_DEFERRABLE");
                        }
                    }
                    prevst = asourcetoken.tokencode == 345 ? asourcetoken : (asourcetoken.tokencode == 321 ? asourcetoken : null);
                    if ((asourcetoken.tokencode == this.flexer.getkeywordvalue("DIRECT_LOAD") || asourcetoken.tokencode == this.flexer.getkeywordvalue("ALL")) && (lcprevst = this.getprevsolidtoken(asourcetoken)) != null && lcprevst.tokencode == 306) {
                        lcprevst.tokencode = 285;
                    }
                    if (asourcetoken.tokencode != 534 || (stKeep = asourcetoken.searchToken(532, -2)) == null) break;
                    stKeep.tokencode = 533;
                }
            }
            if ((asourcetoken = this.getanewsourcetoken()) != null) {
                yychar = asourcetoken.tokencode;
            } else {
                yychar = 0;
                if (waitingreturnforfloatdiv) {
                    lct.tokencode = 273;
                    if (lct.tokentype != ETokenType.ttslash) {
                        lct.tokentype = ETokenType.ttsqlpluscmd;
                    }
                }
            }
            if (yychar != 0 || prevst == null || prevst.tokencode != 345) continue;
            prevst.tokencode = 264;
        }
    }

    private int countLines(String s) {
        int pos = 0;
        int lf = 0;
        int cr = 0;
        while (pos < s.length()) {
            if (s.charAt(pos) == '\r') {
                ++cr;
                ++pos;
                continue;
            }
            if (s.charAt(pos) == '\n') {
                ++lf;
                ++pos;
                continue;
            }
            if (s.charAt(pos) != ' ') break;
            ++pos;
        }
        if (lf >= cr) {
            return lf;
        }
        return cr;
    }

    void dooraclesqltexttotokenlist() {
        boolean insqlpluscmd = false;
        boolean isvalidplace = true;
        boolean waitingreturnforfloatdiv = false;
        boolean waitingreturnforsemicolon = false;
        boolean continuesqlplusatnewline = false;
        TSourceToken lct = null;
        TSourceToken prevst = null;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            switch (yychar) {
                case 257: 
                case 258: 
                case 259: {
                    if (!insqlpluscmd) break;
                    asourcetoken.insqlpluscmd = true;
                    break;
                }
                case 260: {
                    if (insqlpluscmd) {
                        insqlpluscmd = false;
                        isvalidplace = true;
                        if (continuesqlplusatnewline) {
                            insqlpluscmd = true;
                            isvalidplace = false;
                            asourcetoken.insqlpluscmd = true;
                        }
                    }
                    if (waitingreturnforsemicolon) {
                        isvalidplace = true;
                    }
                    if (waitingreturnforfloatdiv) {
                        isvalidplace = true;
                        lct.tokencode = 273;
                        if (lct.tokentype != ETokenType.ttslash) {
                            lct.tokentype = ETokenType.ttsqlpluscmd;
                        }
                    }
                    if (this.countLines(asourcetoken.toString()) > 1) {
                        isvalidplace = true;
                    }
                    this.flexer.insqlpluscmd = insqlpluscmd;
                    break;
                }
                default: {
                    TSourceToken lcpp;
                    TSourceToken stType;
                    TSourceToken stFull;
                    TSourceToken lcprevst;
                    continuesqlplusatnewline = false;
                    waitingreturnforsemicolon = false;
                    waitingreturnforfloatdiv = false;
                    if (insqlpluscmd) {
                        asourcetoken.insqlpluscmd = true;
                        if (asourcetoken.astext.equalsIgnoreCase("-")) {
                            continuesqlplusatnewline = true;
                        }
                    } else {
                        if (asourcetoken.tokentype == ETokenType.ttsemicolon) {
                            waitingreturnforsemicolon = true;
                        }
                        if (asourcetoken.tokentype == ETokenType.ttslash && (isvalidplace || this.IsValidPlaceForDivToSqlplusCmd(this.sourcetokenlist, asourcetoken.posinlist))) {
                            lct = asourcetoken;
                            waitingreturnforfloatdiv = true;
                        }
                        if (TSqlplusCmdStatement.searchCmd(asourcetoken.astext, asourcetoken.nextToken()) != ESqlPlusCmd.spcUnknown) {
                            TSourceToken lnbreak;
                            if (isvalidplace) {
                                asourcetoken.tokencode = 273;
                                if (asourcetoken.tokentype != ETokenType.ttslash) {
                                    asourcetoken.tokentype = ETokenType.ttsqlpluscmd;
                                }
                                this.flexer.insqlpluscmd = insqlpluscmd = true;
                            } else if (asourcetoken.tokencode == 481 && this.sourcetokenlist.returnbeforecurtoken(true)) {
                                asourcetoken.tokencode = 273;
                                if (asourcetoken.tokentype != ETokenType.ttslash) {
                                    asourcetoken.tokentype = ETokenType.ttsqlpluscmd;
                                }
                                this.flexer.insqlpluscmd = insqlpluscmd = true;
                            } else if (this.sourcetokenlist.returnbeforecurtoken(true) && this.countLines((lnbreak = this.sourcetokenlist.get(this.sourcetokenlist.curpos - 1)).toString()) > 1) {
                                asourcetoken.tokencode = 273;
                                if (asourcetoken.tokentype != ETokenType.ttslash) {
                                    asourcetoken.tokentype = ETokenType.ttsqlpluscmd;
                                }
                                this.flexer.insqlpluscmd = insqlpluscmd = true;
                            }
                        }
                    }
                    isvalidplace = false;
                    if (prevst != null) {
                        if (prevst.tokencode == 345) {
                            if (asourcetoken.tokencode != this.flexer.getkeywordvalue("JOIN")) {
                                prevst.tokencode = 264;
                            }
                        } else if (prevst.tokencode == 321 && asourcetoken.tokencode == this.flexer.getkeywordvalue("DEFERRABLE")) {
                            prevst.tokencode = this.flexer.getkeywordvalue("NOT_DEFERRABLE");
                        }
                    }
                    prevst = asourcetoken.tokencode == 345 ? asourcetoken : (asourcetoken.tokencode == 321 ? asourcetoken : null);
                    if (asourcetoken.tokencode == this.flexer.getkeywordvalue("DIRECT_LOAD") || asourcetoken.tokencode == this.flexer.getkeywordvalue("ALL")) {
                        lcprevst = this.getprevsolidtoken(asourcetoken);
                        if (lcprevst == null || lcprevst.tokencode != 306) break;
                        lcprevst.tokencode = 285;
                        break;
                    }
                    if (asourcetoken.tokencode == 534) {
                        TSourceToken stKeep = asourcetoken.searchToken(532, -2);
                        if (stKeep == null) break;
                        stKeep.tokencode = 533;
                        break;
                    }
                    if (asourcetoken.tokencode == 346) {
                        TSourceToken stMatch = asourcetoken.searchToken(538, -1);
                        if (stMatch == null) break;
                        asourcetoken.tokencode = 279;
                        break;
                    }
                    if (asourcetoken.tokencode == 324) {
                        stFull = asourcetoken.searchToken(346, -1);
                        if (stFull != null) {
                            stFull.tokencode = 279;
                            break;
                        }
                        TSourceToken stNatural = asourcetoken.searchToken(539, -4);
                        if (stNatural == null) break;
                        stNatural.tokencode = 276;
                        break;
                    }
                    if (asourcetoken.tokencode == 347) {
                        stFull = asourcetoken.searchToken(346, -1);
                        if (stFull == null) break;
                        stFull.tokencode = 279;
                        break;
                    }
                    if (asourcetoken.tokencode == 525) {
                        stType = asourcetoken.searchToken(541, -2);
                        if (stType == null) break;
                        stType.tokencode = 540;
                        break;
                    }
                    if (asourcetoken.tokencode == 341) {
                        stType = asourcetoken.searchToken(541, -2);
                        if (stType == null) break;
                        stType.tokencode = 540;
                        break;
                    }
                    if (asourcetoken.tokencode == 543) {
                        stType = asourcetoken.searchToken(541, -2);
                        if (stType == null) break;
                        stType.tokencode = 540;
                        break;
                    }
                    if (asourcetoken.tokencode == 541) {
                        TSourceToken stPrev = asourcetoken.searchToken(314, -1);
                        if (stPrev != null) {
                            asourcetoken.tokencode = 540;
                        }
                        if (asourcetoken.tokencode == 541 && (stPrev = asourcetoken.searchToken(542, -1)) != null) {
                            asourcetoken.tokencode = 540;
                        }
                        if (asourcetoken.tokencode == 541 && (stPrev = asourcetoken.searchToken(542, -1)) != null) {
                            asourcetoken.tokencode = 540;
                        }
                        if (asourcetoken.tokencode == 541 && (stPrev = asourcetoken.searchToken(307, -1)) != null) {
                            asourcetoken.tokencode = 540;
                        }
                        if (asourcetoken.tokencode == 541 && (stPrev = asourcetoken.searchToken(505, -1)) != null) {
                            asourcetoken.tokencode = 540;
                        }
                        if (asourcetoken.tokencode != 541 || (stPrev = asourcetoken.searchToken(37, -1)) == null) break;
                        asourcetoken.tokencode = 540;
                        break;
                    }
                    if (asourcetoken.tokencode == 340 || asourcetoken.tokencode == 512) {
                        lcprevst = this.getprevsolidtoken(asourcetoken);
                        if (lcprevst == null || lcprevst.tokencode != 273 || !lcprevst.toString().equalsIgnoreCase("connect")) break;
                        lcprevst.tokencode = 481;
                        lcprevst.tokentype = ETokenType.ttkeyword;
                        this.flexer.insqlpluscmd = false;
                        continuesqlplusatnewline = false;
                        waitingreturnforsemicolon = false;
                        waitingreturnforfloatdiv = false;
                        isvalidplace = false;
                        insqlpluscmd = false;
                        break;
                    }
                    if (asourcetoken.tokencode != 325 || (lcprevst = this.getprevsolidtoken(asourcetoken)) == null || !lcprevst.astext.equalsIgnoreCase("a") || (lcpp = this.getprevsolidtoken(lcprevst)) == null || lcpp.tokencode != 321 && lcpp.tokencode != 525) break;
                    lcprevst.tokencode = 565;
                    asourcetoken.tokencode = 566;
                }
            }
            if ((asourcetoken = this.getanewsourcetoken()) != null) {
                yychar = asourcetoken.tokencode;
            } else {
                yychar = 0;
                if (waitingreturnforfloatdiv) {
                    lct.tokencode = 273;
                    if (lct.tokentype != ETokenType.ttslash) {
                        lct.tokentype = ETokenType.ttsqlpluscmd;
                    }
                }
            }
            if (yychar != 0 || prevst == null || prevst.tokencode != 345) continue;
            prevst.tokencode = 264;
        }
    }

    void dodb2sqltexttotokenlist() {
        boolean insqlpluscmd = false;
        boolean isvalidplace = true;
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            switch (yychar) {
                case 260: {
                    insqlpluscmd = false;
                    isvalidplace = true;
                    break;
                }
                case 258: {
                    if (asourcetoken.astext.toLowerCase().indexOf("scriptoptions") >= 0) {
                        asourcetoken.tokencode = 281;
                        asourcetoken.tokentype = ETokenType.ttidentifier;
                    }
                    if (!insqlpluscmd) break;
                    asourcetoken.insqlpluscmd = true;
                    break;
                }
                default: {
                    TSourceToken lcprevst;
                    if ((asourcetoken.tokencode == 530 || asourcetoken.tokencode == 531 || asourcetoken.tokencode == 532 || asourcetoken.tokencode == 533) && (lcprevst = this.getprevsolidtoken(asourcetoken)) != null && lcprevst.tokencode == 311) {
                        lcprevst.tokencode = 534;
                    }
                    if (insqlpluscmd) {
                        asourcetoken.insqlpluscmd = true;
                    } else if (isvalidplace && TBaseType.mycomparetext(asourcetoken.astext.toLowerCase(), "echo") == 0) {
                        asourcetoken.tokencode = 273;
                        if (asourcetoken.tokentype != ETokenType.ttslash) {
                            asourcetoken.tokentype = ETokenType.ttsqlpluscmd;
                        }
                        asourcetoken.insqlpluscmd = true;
                        insqlpluscmd = true;
                    }
                    isvalidplace = false;
                }
            }
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken == null) break;
            yychar = asourcetoken.tokencode;
        }
    }

    void doteradatatexttotokenlist() {
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            TSourceToken lcprevst;
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken == null) break;
            if (asourcetoken.tokencode == 552 || asourcetoken.tokencode == 553) {
                lcprevst = this.getprevsolidtoken(asourcetoken);
                if (lcprevst != null && lcprevst.tokencode == 321) {
                    lcprevst.tokencode = 285;
                }
            } else if (asourcetoken.tokencode == 59 && (lcprevst = this.getprevsolidtoken(asourcetoken)) != null && lcprevst.tokencode == 59) {
                asourcetoken.tokencode = 273;
            }
            yychar = asourcetoken.tokencode;
        }
    }

    void docommonsqltexttotokenlist() {
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken == null) break;
            yychar = asourcetoken.tokencode;
        }
    }

    void doodbcsqltexttotokenlist() {
        boolean insideODBC = false;
        TSourceToken odbcPrefix = null;
        this.domssqlsqltexttotokenlist();
        for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken ast = this.sourcetokenlist.get(i);
            if (ast.tokencode == 123 || ast.tokencode == 277) {
                insideODBC = true;
                odbcPrefix = ast;
            }
            if (ast.tokencode == 125 || ast.tokencode == 278) {
                insideODBC = false;
                odbcPrefix = null;
            }
            if (!(ast.tokencode != 531 && ast.tokencode != 532 && ast.tokencode != 533 && ast.tokencode != 535 && ast.tokencode != 534 || insideODBC)) {
                ast.tokencode = 264;
            }
            if (ast.tokencode != 468 || !insideODBC) continue;
            odbcPrefix.setLinkToken(ast);
        }
    }

    void dodaxsqltexttotokenlist() {
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken == null) break;
            yychar = asourcetoken.tokencode;
        }
    }

    void dohanasqltexttotokenlist() {
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken == null) break;
            yychar = asourcetoken.tokencode;
        }
    }

    void dohivetexttotokenlist() {
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            TSourceToken token;
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken == null) break;
            if (asourcetoken.tokencode == 534 && (token = asourcetoken.searchToken(41, -1)) != null) {
                asourcetoken.tokencode = 264;
            }
            yychar = asourcetoken.tokencode;
        }
    }

    void doimpalatexttotokenlist() {
        this.dohivetexttotokenlist();
    }

    void checkMySQLCommentToken(TSourceToken cmtToken) {
    }

    void domysqltexttotokenlist() {
        boolean startDelimiter = false;
        this.flexer.tmpDelimiter = "";
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        this.checkMySQLCommentToken(asourcetoken);
        if (asourcetoken.tokencode == 536) {
            startDelimiter = true;
        }
        while (yychar > 0) {
            TSourceToken lcprevst;
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken == null) break;
            this.checkMySQLCommentToken(asourcetoken);
            if (asourcetoken.tokencode == 260 && startDelimiter) {
                startDelimiter = false;
                this.flexer.tmpDelimiter = this.sourcetokenlist.get((int)(this.sourcetokenlist.size() - 1)).astext;
            }
            if (asourcetoken.tokencode == 536) {
                startDelimiter = true;
            }
            if (asourcetoken.tokencode == 537 && (lcprevst = this.getprevsolidtoken(asourcetoken)) != null && lcprevst.tokencode == 311) {
                lcprevst.tokencode = 279;
            }
            if ((asourcetoken.tokencode == 548 || asourcetoken.tokencode == 549 || asourcetoken.tokencode == 550) && (lcprevst = this.getprevsolidtoken(asourcetoken)) != null && lcprevst.tokencode != 123) {
                asourcetoken.tokencode = 264;
            }
            yychar = asourcetoken.tokencode;
        }
    }

    void doMdxtexttotokenlist() {
        TSourceToken asourcetoken = this.getanewsourcetoken();
        if (asourcetoken == null) {
            return;
        }
        int yychar = asourcetoken.tokencode;
        while (yychar > 0) {
            this.sourcetokenlist.add(asourcetoken);
            asourcetoken = this.getanewsourcetoken();
            if (asourcetoken == null) break;
            yychar = asourcetoken.tokencode;
        }
    }

    void dosqltexttotokenlist() {
        switch (this.dbVendor) {
            case dbvmssql: {
                this.domssqlsqltexttotokenlist();
                break;
            }
            case dbvinformix: {
                this.doinformixtexttotokenlist();
                break;
            }
            case dbvsybase: {
                this.dosybasesqltexttotokenlist();
                break;
            }
            case dbvoracle: {
                this.dooraclesqltexttotokenlist();
                break;
            }
            case dbvdb2: {
                this.dodb2sqltexttotokenlist();
                break;
            }
            case dbvteradata: {
                this.doteradatatexttotokenlist();
                break;
            }
            case dbvpostgresql: {
                this.dopostgresqltexttotokenlist();
                break;
            }
            case dbvredshift: {
                this.doredshifttexttotokenlist();
                break;
            }
            case dbvgreenplum: {
                this.dogreenplumtexttotokenlist();
                break;
            }
            case dbvmdx: {
                this.doMdxtexttotokenlist();
                break;
            }
            case dbvnetezza: {
                this.donetezzatexttotokenlist();
                break;
            }
            case dbvhive: {
                this.dohivetexttotokenlist();
                break;
            }
            case dbvimpala: {
                this.doimpalatexttotokenlist();
                break;
            }
            case dbvmysql: {
                this.domysqltexttotokenlist();
                break;
            }
            case dbvhana: {
                this.dohanasqltexttotokenlist();
                break;
            }
            case dbvdax: {
                this.dodaxsqltexttotokenlist();
                break;
            }
            case dbvodbc: {
                this.doodbcsqltexttotokenlist();
                break;
            }
            case dbvvertica: {
                this.doverticatexttotokenlist();
                break;
            }
            case dbvopenedge: {
                this.domssqlsqltexttotokenlist();
                break;
            }
            case dbvcouchbase: {
                this.docouchbasesqltexttotokenlist();
                break;
            }
            case dbvsnowflake: {
                this.dosnowflakesqltexttotokenlist();
                break;
            }
            case dbvbigquery: {
                this.dobigquerysqltexttotokenlist();
                break;
            }
            default: {
                this.docommonsqltexttotokenlist();
            }
        }
        this.closeFileStream();
    }

    void doongetrawsqlstatementevent(TCustomSqlStatement pcsqlstatement) {
        pcsqlstatement.setGsqlparser(this);
        pcsqlstatement.parser = this.fparser;
        pcsqlstatement.plsqlparser = this.fplsqlparser;
        pcsqlstatement.setStartToken(pcsqlstatement.sourcetokenlist.get(0));
        pcsqlstatement.setEndToken(pcsqlstatement.sourcetokenlist.get(pcsqlstatement.sourcetokenlist.size() - 1));
        this.sqlstatements.add(pcsqlstatement);
    }

    int doredshiftgetrawsqlstatements() {
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block6: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block6;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block6;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block6;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block6;
                    }
                    if (ast.tokencode == 273) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block6;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block6;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block6;
                }
                case stsqlplus: {
                    if (ast.insqlpluscmd) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block6;
                    }
                    gst = EFindSqlStateType.stnormal;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block6;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block6;
                    }
                    if (this.sourcetokenlist.sqlplusaftercurtoken()) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block6;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsqlplus || gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    int doverticagetrawsqlstatements() {
        int waitingEnd = 0;
        boolean foundEnd = false;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block7: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken st1;
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokencode == 394) {
                TSourceToken st12 = ast.nextSolidToken();
                if (st12 != null && st12.tokencode == 40) {
                    ast.tokencode = 532;
                }
            } else if ((ast.tokencode == 533 || ast.tokencode == 534) && (st1 = ast.nextSolidToken()) != null && st1.tokencode != 40) {
                ast.tokencode = 264;
            }
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block7;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block7;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block7;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block7;
                    }
                    if (ast.tokencode == 273) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        if (this.gcurrentsqlstatement.isverticaplsql()) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            foundEnd = true;
                            if (ast.tokencode != 351 && ast.tokencode != 479 && ast.searchToken(479, 4) == null) continue block7;
                            waitingEnd = 1;
                            continue block7;
                        }
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsqlplus: {
                    if (ast.insqlpluscmd) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    gst = EFindSqlStateType.stnormal;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block7;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (this.sourcetokenlist.sqlplusaftercurtoken()) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case ststoredprocedure: {
                    if (ast.tokencode == 351) {
                        ++waitingEnd;
                        foundEnd = false;
                    } else if (ast.tokencode == 305) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 316) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 490) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 313) {
                        foundEnd = true;
                        if (--waitingEnd < 0) {
                            waitingEnd = 0;
                        }
                    }
                    if (ast.tokentype == ETokenType.ttslash && ast.tokencode == 273) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else if (ast.tokentype == ETokenType.ttperiod && this.sourcetokenlist.returnaftercurtoken(false) && this.sourcetokenlist.returnbeforecurtoken(false)) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (ast.tokentype == ETokenType.ttsemicolon && waitingEnd == 0 && foundEnd && this.gcurrentsqlstatement.VerticaStatementCanBeSeparatedByBeginEndPair()) {
                            gst = EFindSqlStateType.stnormal;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        }
                    }
                    if (ast.tokencode != 273) continue block7;
                    int m = this.flexer.getkeywordvalue(ast.astext);
                    ast.tokencode = m != 0 ? m : 264;
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsqlplus || gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    int dobigquerygetrawsqlstatements() {
        int errorcount = 0;
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        boolean waitingDelimiter = false;
        this.userDelimiterStr = this.defaultDelimiterStr;
        block7: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken st1;
            TSourceToken ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokencode == 529) {
                TSourceToken st12 = ast.nextSolidToken();
                if (st12 != null && st12.tokencode == 40) {
                    ast.tokencode = 530;
                }
            } else if (ast.tokencode == 395 && (st1 = ast.nextSolidToken()) != null && st1.tokencode == 262) {
                ast.tokencode = 531;
            }
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block7;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block7;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (!TBaseType.assigned(this.gcurrentsqlstatement)) continue block7;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                        ESqlStatementType[] ses = new ESqlStatementType[]{ESqlStatementType.sstmysqlcreateprocedure, ESqlStatementType.sstmysqlcreatefunction, ESqlStatementType.sstcreatetrigger};
                        if (this.includesqlstatementtype(this.gcurrentsqlstatement.sqlstatementtype, ses)) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            waitingDelimiter = false;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.curdelimiterchar = (char)59;
                        } else {
                            gst = EFindSqlStateType.stsql;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                    }
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) continue block7;
                    this.errormessage = "error when tokenlize:" + ast.astext + "(" + ast.lineNo + "," + ast.columnNo + ")";
                    errorcount = 1;
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsqlplus: {
                    if (ast.tokencode == 260) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon && this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmysqldelimiter) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (ast.toString().equalsIgnoreCase(this.userDelimiterStr)) {
                        gst = EFindSqlStateType.stnormal;
                        ast.tokencode = 59;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode != 260 || this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmysqldelimiter) continue block7;
                    gst = EFindSqlStateType.stnormal;
                    this.userDelimiterStr = "";
                    for (int k = 0; k < this.gcurrentsqlstatement.sourcetokenlist.size(); ++k) {
                        TSourceToken st = this.gcurrentsqlstatement.sourcetokenlist.get(k);
                        if (st.tokencode == 536 || st.tokencode == 260 || st.tokencode == 259) continue;
                        this.userDelimiterStr = this.userDelimiterStr + st.toString();
                    }
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block7;
                }
                case ststoredprocedure: {
                    TSourceToken lcprevtoken;
                    if (waitingDelimiter) {
                        if (this.userDelimiterStr.equalsIgnoreCase(ast.toString())) {
                            gst = EFindSqlStateType.stnormal;
                            this.gcurrentsqlstatement.semicolonended = ast;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            continue block7;
                        }
                        if (this.userDelimiterStr.startsWith(ast.toString())) {
                            TSourceToken st;
                            int k;
                            String lcstr = ast.toString();
                            for (k = ast.posinlist + 1; k < ast.container.size(); ++k) {
                                st = ast.container.get(k);
                                if (st.tokencode == 536 || st.tokencode == 260 || st.tokencode == 259) break;
                                lcstr = lcstr + st.toString();
                            }
                            if (this.userDelimiterStr.equalsIgnoreCase(lcstr)) {
                                for (k = ast.posinlist; k < ast.container.size(); ++k) {
                                    st = ast.container.get(k);
                                    if (st.tokencode == 536 || st.tokencode == 260 || st.tokencode == 259) break;
                                    ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                                }
                                gst = EFindSqlStateType.stnormal;
                                this.gcurrentsqlstatement.semicolonended = ast;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                continue block7;
                            }
                        }
                    }
                    if (ast.tokencode == 351) {
                        waitingDelimiter = true;
                    }
                    if (this.userDelimiterStr.equals(";") || !waitingDelimiter) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (ast.tokentype != ETokenType.ttsemicolon) continue block7;
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (ast.toString().equals(this.userDelimiterStr)) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (ast.tokentype == ETokenType.ttsemicolon && this.userDelimiterStr.equals(";") && (lcprevtoken = ast.container.nextsolidtoken(ast, -1, false)) != null && lcprevtoken.tokencode == 313) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                }
            }
        }
        if (TBaseType.assigned(this.gcurrentsqlstatement) && (gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return errorcount;
    }

    int docouchbasegetrawsqlstatements() {
        int waitingEnd = 0;
        boolean foundEnd = false;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block7: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block7;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block7;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block7;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block7;
                    }
                    if (ast.tokencode == 273) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsqlplus: {
                    if (ast.insqlpluscmd) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    gst = EFindSqlStateType.stnormal;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block7;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (this.sourcetokenlist.sqlplusaftercurtoken()) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case ststoredprocedure: {
                    if (ast.tokencode == 351) {
                        ++waitingEnd;
                        foundEnd = false;
                    } else if (ast.tokencode == 305) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 316) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 490) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 313) {
                        foundEnd = true;
                        if (--waitingEnd < 0) {
                            waitingEnd = 0;
                        }
                    }
                    if (ast.tokentype == ETokenType.ttslash && ast.tokencode == 273) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else if (ast.tokentype == ETokenType.ttperiod && this.sourcetokenlist.returnaftercurtoken(false) && this.sourcetokenlist.returnbeforecurtoken(false)) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (ast.tokentype == ETokenType.ttsemicolon && waitingEnd == 0 && foundEnd && this.gcurrentsqlstatement.VerticaStatementCanBeSeparatedByBeginEndPair()) {
                            gst = EFindSqlStateType.stnormal;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        }
                    }
                    if (ast.tokencode != 273) continue block7;
                    int m = this.flexer.getkeywordvalue(ast.astext);
                    ast.tokencode = m != 0 ? m : 264;
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsqlplus || gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    int dopostgresqlgetrawsqlstatements() {
        int waitingEnd = 0;
        boolean foundEnd = false;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block7: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block7;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block7;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block7;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block7;
                    }
                    if (ast.tokencode == 273) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        if (this.gcurrentsqlstatement.ispgplsql()) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            foundEnd = false;
                            if (ast.tokencode != 351 && ast.tokencode != 479 && ast.searchToken(479, 4) == null) continue block7;
                            waitingEnd = 1;
                            continue block7;
                        }
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsqlplus: {
                    if (ast.insqlpluscmd) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    gst = EFindSqlStateType.stnormal;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block7;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (this.sourcetokenlist.sqlplusaftercurtoken()) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case ststoredprocedure: {
                    if (ast.tokencode == 351) {
                        ++waitingEnd;
                    } else if (ast.tokencode == 305) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 316) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 490) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 313) {
                        foundEnd = true;
                        if (--waitingEnd < 0) {
                            waitingEnd = 0;
                        }
                    }
                    if (ast.tokentype == ETokenType.ttslash && ast.tokencode == 273) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else if (ast.tokentype == ETokenType.ttperiod && this.sourcetokenlist.returnaftercurtoken(false) && this.sourcetokenlist.returnbeforecurtoken(false)) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (ast.tokentype == ETokenType.ttsemicolon && waitingEnd == 0 && foundEnd) {
                            gst = EFindSqlStateType.stnormal;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        }
                    }
                    if (ast.tokencode != 273) continue block7;
                    int m = this.flexer.getkeywordvalue(ast.astext);
                    ast.tokencode = m != 0 ? m : 264;
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsqlplus || gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    int dosnowflakegetrawsqlstatements() {
        int waitingEnd = 0;
        boolean foundEnd = false;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block7: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken stLparen;
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokencode == 344 || ast.tokencode == 343) {
                TSourceToken stLparen2 = ast.searchToken(40, 1);
                if (stLparen2 != null) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 538 && (stLparen = ast.searchToken(40, 1)) != null) {
                ast.tokencode = 539;
            }
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block7;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block7;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block7;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block7;
                    }
                    if (ast.tokencode == 273) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        if (this.gcurrentsqlstatement.ispgplsql()) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            foundEnd = false;
                            if (ast.tokencode != 351 && ast.tokencode != 479 && ast.searchToken(479, 4) == null) continue block7;
                            waitingEnd = 1;
                            continue block7;
                        }
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsqlplus: {
                    if (ast.insqlpluscmd) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    gst = EFindSqlStateType.stnormal;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block7;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (this.sourcetokenlist.sqlplusaftercurtoken()) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case ststoredprocedure: {
                    if (ast.tokencode == 351) {
                        ++waitingEnd;
                    } else if (ast.tokencode == 305) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 316) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 490) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 313) {
                        foundEnd = true;
                        if (--waitingEnd < 0) {
                            waitingEnd = 0;
                        }
                    }
                    if (ast.tokentype == ETokenType.ttslash && ast.tokencode == 273) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else if (ast.tokentype == ETokenType.ttperiod && this.sourcetokenlist.returnaftercurtoken(false) && this.sourcetokenlist.returnbeforecurtoken(false)) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (ast.tokentype == ETokenType.ttsemicolon && waitingEnd == 0 && foundEnd && this.gcurrentsqlstatement.OracleStatementCanBeSeparatedByBeginEndPair()) {
                            gst = EFindSqlStateType.stnormal;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        }
                    }
                    if (ast.tokencode != 273) continue block7;
                    int m = this.flexer.getkeywordvalue(ast.astext);
                    ast.tokencode = m != 0 ? m : 264;
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsqlplus || gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    int dogreenplumgetrawsqlstatements() {
        int waitingEnd = 0;
        boolean foundEnd = false;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block7: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken st1;
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokencode == 394 && (st1 = ast.nextSolidToken()) != null && st1.tokencode == 40) {
                ast.tokencode = 552;
            }
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block7;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block7;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block7;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block7;
                    }
                    if (ast.tokencode == 92) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSlashCommand(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        if (this.gcurrentsqlstatement.ispgplsql()) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            foundEnd = false;
                            if (ast.tokencode != 351 && ast.tokencode != 479 && ast.searchToken(479, 4) == null) continue block7;
                            waitingEnd = 1;
                            continue block7;
                        }
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsqlplus: {
                    if (ast.tokencode == 260) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    }
                    if (ast.tokencode == 92) {
                        TSourceToken nextst = ast.searchToken(92, 1);
                        if (nextst != null) {
                            gst = EFindSqlStateType.stnormal;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            continue block7;
                        }
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSlashCommand(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (this.sourcetokenlist.sqlplusaftercurtoken()) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case ststoredprocedure: {
                    if (ast.tokencode == 351) {
                        ++waitingEnd;
                    } else if (ast.tokencode == 305) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 316) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 490) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 313) {
                        foundEnd = true;
                        if (--waitingEnd < 0) {
                            waitingEnd = 0;
                        }
                    }
                    if (ast.tokentype == ETokenType.ttslash && ast.tokencode == 273) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else if (ast.tokentype == ETokenType.ttperiod && this.sourcetokenlist.returnaftercurtoken(false) && this.sourcetokenlist.returnbeforecurtoken(false)) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (ast.tokentype == ETokenType.ttsemicolon && waitingEnd == 0 && foundEnd && this.gcurrentsqlstatement.OracleStatementCanBeSeparatedByBeginEndPair()) {
                            gst = EFindSqlStateType.stnormal;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        }
                    }
                    if (ast.tokencode != 273) continue block7;
                    int m = this.flexer.getkeywordvalue(ast.astext);
                    ast.tokencode = m != 0 ? m : 264;
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsqlplus || gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    private boolean isTypeCastToken(TSourceToken ast) {
        boolean istypecasetoken = false;
        TSourceToken st = ast.searchToken(40, 1);
        if (st != null) {
            TSourceToken nst = st.searchToken(263, 1);
            istypecasetoken = nst == null;
        }
        return istypecasetoken;
    }

    int donetezzagetrawsqlstatements() {
        int waitingEnd = 0;
        boolean foundEnd = false;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block7: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokencode == 360) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 532;
                }
            } else if (ast.tokencode == 361) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 533;
                }
            } else if (ast.tokencode == 357) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 534;
                }
            } else if (ast.tokencode == 367) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 535;
                }
            } else if (ast.tokencode == 374) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 536;
                }
            } else if (ast.tokencode == 368) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 537;
                }
            } else if (ast.tokencode == 372) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 538;
                }
            } else if (ast.tokencode == 355) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 540;
                }
            } else if (ast.tokencode == 379) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 541;
                }
            } else if (ast.tokencode == 380) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 542;
                }
            } else if (ast.tokencode == 382) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 543;
                }
            } else if (ast.tokencode == 381) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 544;
                }
            } else if (ast.tokencode == 394) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 545;
                }
            } else if (ast.tokencode == 393) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 546;
                }
            } else if (ast.tokencode == 395) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 547;
                }
            } else if (ast.tokencode == 416) {
                if (this.isTypeCastToken(ast)) {
                    ast.tokencode = 548;
                }
            } else if (ast.tokencode == 375 && this.isTypeCastToken(ast)) {
                ast.tokencode = 549;
            }
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block7;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block7;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block7;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block7;
                    }
                    if (ast.tokencode == 273) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        if (this.gcurrentsqlstatement.isnzplsql()) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            foundEnd = false;
                            if (ast.tokencode != 351 && ast.tokencode != 479 && ast.searchToken(479, 4) == null) continue block7;
                            waitingEnd = 1;
                            continue block7;
                        }
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsqlplus: {
                    if (ast.insqlpluscmd) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    gst = EFindSqlStateType.stnormal;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block7;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (this.sourcetokenlist.sqlplusaftercurtoken()) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case ststoredprocedure: {
                    if (ast.tokencode == 351) {
                        ++waitingEnd;
                    } else if (ast.tokencode == 305) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 316) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 490) {
                        if (ast.searchToken(313, -1) == null) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 313) {
                        foundEnd = true;
                        if (--waitingEnd < 0) {
                            waitingEnd = 0;
                        }
                    }
                    if (ast.tokentype == ETokenType.ttslash && ast.tokencode == 273) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else if (ast.tokentype == ETokenType.ttperiod && this.sourcetokenlist.returnaftercurtoken(false) && this.sourcetokenlist.returnbeforecurtoken(false)) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    } else {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (ast.tokentype == ETokenType.ttsemicolon && waitingEnd == 0 && foundEnd && this.gcurrentsqlstatement.OracleStatementCanBeSeparatedByBeginEndPair()) {
                            gst = EFindSqlStateType.stnormal;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        }
                    }
                    if (ast.tokencode != 273) continue block7;
                    int m = this.flexer.getkeywordvalue(ast.astext);
                    ast.tokencode = m != 0 ? m : 264;
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsqlplus || gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    int dooraclegetrawsqlstatements() {
        int[] waitingEnds = new int[1024];
        stored_procedure_type[] sptype = new stored_procedure_type[1024];
        stored_procedure_status[] procedure_status = new stored_procedure_status[1024];
        boolean endBySlashOnly = true;
        int nestedProcedures = 0;
        int nestedParenthesis = 0;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block23: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokencode == 427) {
                TSourceToken stMatch = ast.searchToken(317, 1);
                if (stMatch != null) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 548) {
                TSourceToken stBy = ast.searchToken(340, -1);
                ast.tokencode = stBy == null ? 264 : 547;
            } else if (ast.tokencode == 549) {
                TSourceToken stDot;
                TSourceToken stRightParen = ast.searchToken(41, -1);
                if (stRightParen != null) {
                    ast.tokencode = 264;
                }
                if ((stDot = ast.searchToken(46, 1)) != null) {
                    ast.tokencode = 264;
                }
                TSourceToken stNext = ast.searchTokenAfterObjectName();
                stDot = ast.searchToken(46, 1);
                if (stDot == null && stNext != null && stNext.tokencode == 40) {
                    ast.tokencode = 558;
                }
            } else if (ast.tokencode == 550) {
                TSourceToken stLeftParen = ast.searchToken(40, 1);
                if (stLeftParen == null) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 552) {
                TSourceToken stNext = ast.searchToken(551, 1);
                TSourceToken stPrev = ast.searchToken(310, -1);
                if (stPrev == null) {
                    stPrev = ast.searchToken(559, -1);
                }
                if (stNext == null && stPrev == null) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 303) {
                TSourceToken stPrev = ast.searchToken(46, -1);
                if (stPrev != null) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 554) {
                TSourceToken stPrev = ast.searchToken(428, -1);
                if (stPrev != null) {
                    stPrev.tokencode = 553;
                }
            } else if (ast.tokencode == 555) {
                TSourceToken stPrev = ast.searchToken(347, -1);
                if (stPrev != null) {
                    stPrev.tokencode = 281;
                }
            } else if (ast.tokencode == 556) {
                TSourceToken stNext = ast.searchToken("(", 2);
                if (stNext != null) {
                    ast.tokencode = 557;
                }
            } else if (ast.tokencode == 513) {
                TSourceToken stNext = ast.searchToken("key", 1);
                if (stNext == null) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 561) {
                TSourceToken stNext = ast.searchToken(562, 2);
                if (stNext == null) {
                    stNext = ast.searchToken(563, 2);
                }
                if (stNext != null) {
                    ast.tokencode = 564;
                }
            } else if (ast.tokencode == 531) {
                TSourceToken stNext = ast.searchToken("(", 2);
                if (stNext == null) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 515) {
                TSourceToken stNext = ast.nextSolidToken();
                if (stNext == null) {
                    ast.tokencode = 264;
                } else if (stNext.tokencode != 264) {
                    ast.tokencode = 264;
                }
            }
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block23;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block23;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block23;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block23;
                    }
                    if (ast.tokencode == 273) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block23;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        if (this.gcurrentsqlstatement.isoracleplsql()) {
                            nestedProcedures = 0;
                            gst = EFindSqlStateType.ststoredprocedure;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            switch (this.gcurrentsqlstatement.sqlstatementtype) {
                                case sstplsql_createprocedure: {
                                    sptype[nestedProcedures] = stored_procedure_type.procedure;
                                    break;
                                }
                                case sstplsql_createfunction: {
                                    sptype[nestedProcedures] = stored_procedure_type.function;
                                    break;
                                }
                                case sstplsql_createpackage: {
                                    sptype[nestedProcedures] = stored_procedure_type.package_spec;
                                    if (ast.searchToken(526, 5) == null) break;
                                    sptype[nestedProcedures] = stored_procedure_type.package_body;
                                    break;
                                }
                                case sst_block_with_label: {
                                    sptype[nestedProcedures] = stored_procedure_type.block_with_declare;
                                    if (ast.tokencode != 351) break;
                                    sptype[nestedProcedures] = stored_procedure_type.block_with_begin;
                                    break;
                                }
                                case sstplsql_createtrigger: {
                                    sptype[nestedProcedures] = stored_procedure_type.create_trigger;
                                    break;
                                }
                                case sstoraclecreatelibrary: {
                                    sptype[nestedProcedures] = stored_procedure_type.create_library;
                                    break;
                                }
                                case sstplsql_createtype_placeholder: {
                                    gst = EFindSqlStateType.stsql;
                                    break;
                                }
                                default: {
                                    sptype[nestedProcedures] = stored_procedure_type.others;
                                }
                            }
                            if (sptype[0] == stored_procedure_type.block_with_declare) {
                                endBySlashOnly = false;
                                procedure_status[0] = stored_procedure_status.is_as;
                            } else if (sptype[0] == stored_procedure_type.block_with_begin) {
                                endBySlashOnly = false;
                                procedure_status[0] = stored_procedure_status.body;
                            } else if (sptype[0] == stored_procedure_type.procedure) {
                                endBySlashOnly = false;
                                procedure_status[0] = stored_procedure_status.start;
                            } else if (sptype[0] == stored_procedure_type.function) {
                                endBySlashOnly = false;
                                procedure_status[0] = stored_procedure_status.start;
                            } else if (sptype[0] == stored_procedure_type.package_spec) {
                                endBySlashOnly = false;
                                procedure_status[0] = stored_procedure_status.start;
                            } else if (sptype[0] == stored_procedure_type.package_body) {
                                endBySlashOnly = false;
                                procedure_status[0] = stored_procedure_status.start;
                            } else if (sptype[0] == stored_procedure_type.create_trigger) {
                                endBySlashOnly = false;
                                procedure_status[0] = stored_procedure_status.start;
                            } else if (sptype[0] == stored_procedure_type.create_library) {
                                endBySlashOnly = false;
                                procedure_status[0] = stored_procedure_status.bodyend;
                            } else {
                                endBySlashOnly = true;
                                procedure_status[0] = stored_procedure_status.bodyend;
                            }
                            if (ast.tokencode != 351 && ast.tokencode != 479 && ast.searchToken(479, 4) == null) continue block23;
                            waitingEnds[nestedProcedures] = 1;
                            continue block23;
                        }
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        nestedParenthesis = 0;
                        continue block23;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block23;
                }
                case stsqlplus: {
                    if (ast.insqlpluscmd) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block23;
                    }
                    gst = EFindSqlStateType.stnormal;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block23;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block23;
                    }
                    if (this.sourcetokenlist.sqlplusaftercurtoken()) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block23;
                    }
                    if (ast.tokencode == 40) {
                        ++nestedParenthesis;
                    }
                    if (ast.tokencode == 41 && --nestedParenthesis < 0) {
                        nestedParenthesis = 0;
                    }
                    Boolean findNewStmt = false;
                    TCustomSqlStatement lcStmt = null;
                    if (nestedParenthesis == 0 && this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstcreatetable && (lcStmt = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement)) != null) {
                        findNewStmt = true;
                        if (lcStmt.sqlstatementtype == ESqlStatementType.sstselect) {
                            TSourceToken prevst = ast.prevSolidToken();
                            if (prevst.tokencode == 341 || prevst.tokencode == 40) {
                                findNewStmt = false;
                            }
                        }
                    }
                    if (findNewStmt.booleanValue()) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = lcStmt;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block23;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block23;
                }
                case ststoredprocedure: {
                    if (procedure_status[nestedProcedures] != stored_procedure_status.bodyend) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                    }
                    switch (procedure_status[nestedProcedures]) {
                        case start: {
                            if (ast.tokencode == 341 || ast.tokencode == 525) {
                                if (sptype[nestedProcedures] == stored_procedure_type.create_trigger || sptype[0] == stored_procedure_type.package_spec && nestedProcedures > 0) break;
                                procedure_status[nestedProcedures] = stored_procedure_status.is_as;
                                if (ast.searchToken("language", 1) == null) break;
                                if (nestedProcedures == 0) {
                                    gst = EFindSqlStateType.stsql;
                                    break;
                                }
                                procedure_status[nestedProcedures] = stored_procedure_status.body;
                                --nestedProcedures;
                                break;
                            }
                            if (ast.tokencode == 351) {
                                if (sptype[nestedProcedures] == stored_procedure_type.create_trigger) {
                                    int n = nestedProcedures;
                                    waitingEnds[n] = waitingEnds[n] + 1;
                                }
                                if (nestedProcedures > 0) {
                                    --nestedProcedures;
                                }
                                procedure_status[nestedProcedures] = stored_procedure_status.body;
                                break;
                            }
                            if (ast.tokencode == 313) {
                                if (nestedProcedures <= 0 || waitingEnds[nestedProcedures - 1] != 1 || sptype[nestedProcedures - 1] != stored_procedure_type.package_body && sptype[nestedProcedures - 1] != stored_procedure_type.package_spec) break;
                                procedure_status[--nestedProcedures] = stored_procedure_status.bodyend;
                                break;
                            }
                            if (ast.tokencode == 477 || ast.tokencode == 478) {
                                if (nestedProcedures <= 0 || waitingEnds[nestedProcedures] != 0 || procedure_status[nestedProcedures - 1] != stored_procedure_status.is_as) break;
                                --nestedProcedures;
                                waitingEnds[++nestedProcedures] = 0;
                                procedure_status[nestedProcedures] = stored_procedure_status.start;
                                break;
                            }
                            if (sptype[nestedProcedures] == stored_procedure_type.create_trigger && ast.tokencode == 315) {
                                procedure_status[nestedProcedures] = stored_procedure_status.is_as;
                                break;
                            }
                            if (sptype[nestedProcedures] == stored_procedure_type.create_trigger && ast.tokentype == ETokenType.ttslash && ast.tokencode == 273) {
                                ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            if (sptype[nestedProcedures] == stored_procedure_type.create_trigger) {
                                TSourceToken compoundSt;
                                if (ast.tokencode != 545 || (compoundSt = ast.searchToken(560, -1)) == null) break;
                                procedure_status[nestedProcedures] = stored_procedure_status.body;
                                int n = nestedProcedures;
                                waitingEnds[n] = waitingEnds[n] + 1;
                                break;
                            }
                            if (sptype[nestedProcedures] != stored_procedure_type.function || ast.tokencode != 528 || ast.searchToken("aggregate", -1) == null && ast.searchToken("pipelined", -1) == null) break;
                            if (nestedProcedures == 0) {
                                gst = EFindSqlStateType.stsql;
                                break;
                            }
                            procedure_status[nestedProcedures] = stored_procedure_status.body;
                            --nestedProcedures;
                            break;
                        }
                        case is_as: {
                            if (ast.tokencode == 477 || ast.tokencode == 478) {
                                waitingEnds[++nestedProcedures] = 0;
                                procedure_status[nestedProcedures] = stored_procedure_status.start;
                                if (nestedProcedures <= 1023) break;
                                gst = EFindSqlStateType.sterror;
                                --nestedProcedures;
                                break;
                            }
                            if (ast.tokencode == 351) {
                                if (nestedProcedures != 0 || sptype[nestedProcedures] != stored_procedure_type.package_body && sptype[nestedProcedures] != stored_procedure_type.package_spec) {
                                    int n = nestedProcedures;
                                    waitingEnds[n] = waitingEnds[n] + 1;
                                }
                                procedure_status[nestedProcedures] = stored_procedure_status.body;
                                break;
                            }
                            if (ast.tokencode == 313) {
                                if (nestedProcedures == 0 && waitingEnds[nestedProcedures] == 1 && (sptype[nestedProcedures] == stored_procedure_type.package_body || sptype[nestedProcedures] == stored_procedure_type.package_spec)) {
                                    procedure_status[nestedProcedures] = stored_procedure_status.bodyend;
                                    int n = nestedProcedures;
                                    waitingEnds[n] = waitingEnds[n] - 1;
                                    break;
                                }
                                int n = nestedProcedures;
                                waitingEnds[n] = waitingEnds[n] - 1;
                                break;
                            }
                            if (ast.tokencode != 316 || ast.searchToken(59, 1) != null) break;
                            int n = nestedProcedures;
                            waitingEnds[n] = waitingEnds[n] + 1;
                            break;
                        }
                        case body: {
                            if (ast.tokencode == 351) {
                                int n = nestedProcedures;
                                waitingEnds[n] = waitingEnds[n] + 1;
                                break;
                            }
                            if (ast.tokencode == 305) {
                                if (ast.searchToken(59, 2) != null) break;
                                int n = nestedProcedures;
                                waitingEnds[n] = waitingEnds[n] + 1;
                                break;
                            }
                            if (ast.tokencode == 316) {
                                if (ast.searchToken(59, 2) != null || ast.searchToken(313, -1) != null) break;
                                int n = nestedProcedures;
                                waitingEnds[n] = waitingEnds[n] + 1;
                                break;
                            }
                            if (ast.tokencode == 490) {
                                if (ast.searchToken(313, -1) != null && ast.searchToken(59, 2) != null) break;
                                int n = nestedProcedures;
                                waitingEnds[n] = waitingEnds[n] + 1;
                                break;
                            }
                            if (ast.tokencode == 313) {
                                int n = nestedProcedures;
                                waitingEnds[n] = waitingEnds[n] - 1;
                                if (waitingEnds[nestedProcedures] != 0) break;
                                if (nestedProcedures == 0) {
                                    procedure_status[nestedProcedures] = stored_procedure_status.bodyend;
                                    break;
                                }
                                procedure_status[--nestedProcedures] = stored_procedure_status.is_as;
                                break;
                            }
                            if (waitingEnds[nestedProcedures] != 0 || ast.tokentype != ETokenType.ttslash || ast.tokencode != 273) break;
                            ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                            gst = EFindSqlStateType.stnormal;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            break;
                        }
                        case bodyend: {
                            if (ast.tokentype == ETokenType.ttslash && ast.tokencode == 273) {
                                ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            if (ast.tokentype == ETokenType.ttperiod && this.sourcetokenlist.returnaftercurtoken(false) && this.sourcetokenlist.returnbeforecurtoken(false)) {
                                ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            if (ast.searchToken(479, 1) != null && !endBySlashOnly) {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            if (ast.searchToken(477, 1) != null && !endBySlashOnly) {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            if (ast.searchToken(478, 1) != null && !endBySlashOnly) {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            if (ast.searchToken(307, 1) != null && ast.searchToken(479, 4) != null && !endBySlashOnly) {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            if (ast.searchToken(307, 1) != null && ast.searchToken(546, 4) != null && !endBySlashOnly) {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            if (ast.searchToken(426, 1) != null && ast.searchToken(545, 2) != null && !endBySlashOnly) {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            if (ast.searchToken(301, 1) != null && !endBySlashOnly) {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stnormal;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                break;
                            }
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            break;
                        }
                        case end: {
                            break;
                        }
                    }
                    if (ast.tokencode == 273) {
                        int m = this.flexer.getkeywordvalue(ast.astext);
                        ast.tokencode = m != 0 ? m : (ast.tokentype == ETokenType.ttslash ? 47 : 264);
                    }
                    int wrapped_keyword_max_pos = 20;
                    if (ast.tokencode != 535 || ast.posinlist - this.gcurrentsqlstatement.sourcetokenlist.get((int)0).posinlist >= 20) continue block23;
                    if (this.gcurrentsqlstatement instanceof TCommonStoredProcedureSqlStatement) {
                        ((TCommonStoredProcedureSqlStatement)this.gcurrentsqlstatement).setWrapped(true);
                    }
                    if (!(this.gcurrentsqlstatement instanceof TPlsqlCreatePackage) || ast.prevSolidToken() == null) continue block23;
                    ((TPlsqlCreatePackage)this.gcurrentsqlstatement).setPackageName(this.fparser.getNf().createObjectNameWithPart(ast.prevSolidToken()));
                    continue block23;
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsqlplus || gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    int domdxgetrawsqlstatements() {
        int waitingEnd = 0;
        boolean foundEnd = false;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block6: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block6;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block6;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block6;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block6;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmdxscope) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            foundEnd = false;
                            waitingEnd = 1;
                            continue block6;
                        }
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block6;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block6;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block6;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block6;
                }
                case ststoredprocedure: {
                    if (ast.tokencode == 305) {
                        ++waitingEnd;
                    } else if (ast.tokencode == 316) {
                        ++waitingEnd;
                    } else if (ast.tokencode == 524) {
                        if (lcprevsolidtoken.tokencode != 313) {
                            ++waitingEnd;
                        }
                    } else if (ast.tokencode == 313) {
                        foundEnd = true;
                        if (--waitingEnd < 0) {
                            waitingEnd = 0;
                        }
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokentype != ETokenType.ttsemicolon || waitingEnd != 0 || !foundEnd) continue block6;
                    gst = EFindSqlStateType.stnormal;
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    int doimpalagetrawsqlstatements() {
        return this.dohivegetrawsqlstatements();
    }

    int dohivegetrawsqlstatements() {
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block5: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block5;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block5;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (this.gcurrentsqlstatement != null) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block5;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block5;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.gcurrentsqlstatement != null) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block5;
                    }
                    this.syntaxErrors.add(new TSyntaxError(ast.astext, ast.lineNo, ast.columnNo < 0L ? 0L : ast.columnNo, "Error when tokenlize", EErrorType.spwarning, 10200));
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block5;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block5;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                }
            }
        }
        if (this.gcurrentsqlstatement != null && (gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return this.syntaxErrors.size();
    }

    int dosybasegetrawsqlstatements() {
        int errorcount = 0;
        int case_end_nest = 0;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        int lcblocklevel = 0;
        int lctrycatchlevel = 0;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block28: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokenstatus == ETokenStatus.tsignoredbygetrawstatement) {
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            if (gst == EFindSqlStateType.ststoredprocedurebody && ast.tokencode != 463 && ast.tokencode != 307 && ast.tokencode != 426) {
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            TCustomSqlStatement lcnextsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
            switch (gst) {
                case sterror: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = lcnextsqlstatement;
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        gst = EFindSqlStateType.stsql;
                        continue block28;
                    }
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block28;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block28;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (!TBaseType.assigned(lcprevsolidtoken) || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block28;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block28;
                    }
                    this.gcurrentsqlstatement = lcnextsqlstatement;
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstmssqlcreateprocedure: 
                            case sstmssqlcreatefunction: 
                            case sstcreatetrigger: 
                            case sstmssqlalterprocedure: 
                            case sstmssqlalterfunction: 
                            case sstmssqlaltertrigger: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.ststoredprocedure;
                                break;
                            }
                            case sstmssqlbegintry: 
                            case sstmssqlbegincatch: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.sttrycatch;
                                lctrycatchlevel = 0;
                                break;
                            }
                            case sstmssqlgo: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                gst = EFindSqlStateType.stnormal;
                                break;
                            }
                            default: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqllabel) {
                                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                    gst = EFindSqlStateType.stnormal;
                                    break;
                                }
                                gst = EFindSqlStateType.stsql;
                                break;
                            }
                        }
                    } else if (ast.tokencode == 351) {
                        this.gcurrentsqlstatement = new TMssqlBlock(this.dbVendor);
                        this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstmssqlblock;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        gst = EFindSqlStateType.stblock;
                    } else if (this.sqlstatements.size() == 0) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement = new TMssqlExecute(this.dbVendor);
                        ast.tokencode = 566;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                    } else if (this.sqlstatements.get((int)(this.sqlstatements.size() - 1)).sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement = new TMssqlExecute(this.dbVendor);
                        ast.tokencode = 566;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                    }
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) continue block28;
                    this.errormessage = "error when tokenlize:" + ast.astext + "(" + ast.lineNo + "," + ast.columnNo + ")";
                    errorcount = 1;
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block28;
                }
                case stblock: {
                    TSourceToken lcnextsolidtoken;
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            lcnextsqlstatement = null;
                        }
                    }
                    if (gst != EFindSqlStateType.stblock) continue block28;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode == 351) {
                        lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false);
                        if (TBaseType.assigned(lcnextsolidtoken)) {
                            if (TBaseType.mysametext(lcnextsolidtoken.astext, "tran") || TBaseType.mysametext(lcnextsolidtoken.astext, "transaction") || TBaseType.mysametext(lcnextsolidtoken.astext, "distributed") || TBaseType.mysametext(lcnextsolidtoken.astext, "dialog") || TBaseType.mysametext(lcnextsolidtoken.astext, "conversation")) continue block28;
                            ++lcblocklevel;
                            continue block28;
                        }
                        ++lcblocklevel;
                        continue block28;
                    }
                    if (ast.tokencode == 316) {
                        ++lcblocklevel;
                        continue block28;
                    }
                    if (ast.tokencode != 313) continue block28;
                    boolean lcisendconversation = false;
                    lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false);
                    if (TBaseType.assigned(lcnextsolidtoken) && lcnextsolidtoken.tokencode == this.flexer.getkeywordvalue("conversation".toUpperCase())) {
                        lcisendconversation = true;
                    }
                    if (lcisendconversation) continue block28;
                    if (lcblocklevel == 0) {
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif && TBaseType.assigned(lcnextsolidtoken)) {
                            TSourceToken lcnnextsolidtoken;
                            if (lcnextsolidtoken.tokencode == 349) {
                                gst = EFindSqlStateType.stsql;
                            } else if (lcnextsolidtoken.tokentype == ETokenType.ttsemicolon && TBaseType.assigned(lcnnextsolidtoken = this.sourcetokenlist.nextsolidtoken(lcnextsolidtoken.posinlist, 1, false)) && lcnnextsolidtoken.tokencode == 349) {
                                gst = EFindSqlStateType.stsql;
                            }
                        }
                        if (gst == EFindSqlStateType.stsql) continue block28;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block28;
                    }
                    --lcblocklevel;
                    continue block28;
                }
                case sttrycatch: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegintry || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegincatch) {
                                ++lctrycatchlevel;
                            }
                            lcnextsqlstatement = null;
                        }
                    }
                    if (gst != EFindSqlStateType.sttrycatch) continue block28;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode != 456 && ast.tokencode != 462 || !TBaseType.assigned(lcprevsolidtoken) || lcprevsolidtoken.tokencode != 313) continue block28;
                    if (lctrycatchlevel == 0) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block28;
                    }
                    --lctrycatchlevel;
                    continue block28;
                }
                case stsql: {
                    TSourceToken lcnextsolidtoken;
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        boolean lcstillinsql = false;
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif && TBaseType.assigned(lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false)) && lcnextsolidtoken.tokencode == 349) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            lcstillinsql = true;
                        }
                        if (lcstillinsql) continue block28;
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block28;
                    }
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                            continue block28;
                        }
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstmssqlif: 
                            case sstmssqlwhile: {
                                if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegincatch || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegintry) {
                                    this.gcurrentsqlstatement.addtokentolist(ast);
                                    gst = EFindSqlStateType.stblock;
                                    lcblocklevel = 1;
                                    lcnextsqlstatement = null;
                                    continue block28;
                                }
                                if (this.gcurrentsqlstatement.dummytag != 1) break;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.gcurrentsqlstatement.dummytag = lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlwhile ? 1 : 0;
                                lcnextsqlstatement = null;
                                continue block28;
                            }
                            case sstmssqlalterqueue: {
                                if (lcnextsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlexec) break;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                lcnextsqlstatement = null;
                                continue block28;
                            }
                            case sstmssqlcreateschema: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                lcnextsqlstatement = null;
                                continue block28;
                            }
                        }
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = lcnextsqlstatement;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstmssqlcreateprocedure: 
                            case sstmssqlcreatefunction: 
                            case sstcreatetrigger: 
                            case sstmssqlalterprocedure: 
                            case sstmssqlalterfunction: 
                            case sstmssqlaltertrigger: {
                                gst = EFindSqlStateType.ststoredprocedure;
                                continue block28;
                            }
                            case sstmssqlbegintry: 
                            case sstmssqlbegincatch: {
                                gst = EFindSqlStateType.sttrycatch;
                                lctrycatchlevel = 0;
                                continue block28;
                            }
                            case sstmssqlgo: {
                                gst = EFindSqlStateType.stnormal;
                                continue block28;
                            }
                        }
                        gst = EFindSqlStateType.stsql;
                        continue block28;
                    }
                    if (ast.tokencode == 351) {
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif || this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlwhile) {
                            gst = EFindSqlStateType.stblock;
                            lcblocklevel = 0;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            continue block28;
                        }
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqldeclare) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = new TMssqlBlock(this.dbVendor);
                            this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstmssqlblock;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            gst = EFindSqlStateType.stblock;
                            continue block28;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block28;
                    }
                    if (ast.tokencode == 316) {
                        ++case_end_nest;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block28;
                    }
                    if (ast.tokencode == 313) {
                        if (case_end_nest > 0) {
                            --case_end_nest;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block28;
                    }
                    if (ast.tokencode == 349) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlif && this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlwhile || case_end_nest != 0) continue block28;
                        this.gcurrentsqlstatement.dummytag = 1;
                        continue block28;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlset || ast.tokencode != 323) continue block28;
                    gst = EFindSqlStateType.stnormal;
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block28;
                }
                case ststoredprocedure: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            gst = EFindSqlStateType.ststoredprocedurebody;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            lcnextsqlstatement = null;
                        }
                    }
                    if (gst != EFindSqlStateType.ststoredprocedure) continue block28;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode != 351) continue block28;
                    gst = EFindSqlStateType.stblock;
                    continue block28;
                }
                case ststoredprocedurebody: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        switch (lcnextsqlstatement.sqlstatementtype) {
                            case sstmssqlgo: {
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = lcnextsqlstatement;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                gst = EFindSqlStateType.stnormal;
                                break;
                            }
                            case sstmssqlcreateprocedure: 
                            case sstmssqlcreatefunction: 
                            case sstcreatetrigger: 
                            case sstmssqlalterprocedure: 
                            case sstmssqlalterfunction: 
                            case sstmssqlaltertrigger: {
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = lcnextsqlstatement;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.ststoredprocedure;
                                break;
                            }
                            default: {
                                lcnextsqlstatement = null;
                            }
                        }
                    }
                    if (gst != EFindSqlStateType.ststoredprocedurebody) continue block28;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                }
            }
        }
        if (TBaseType.assigned(this.gcurrentsqlstatement) && gst != EFindSqlStateType.stnormal) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return errorcount;
    }

    int doinformixgetrawsqlstatements() {
        int errorcount = 0;
        int case_end_nest = 0;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        int lcblocklevel = 0;
        int lctrycatchlevel = 0;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        block30: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokenstatus == ETokenStatus.tsignoredbygetrawstatement) {
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            if (gst == EFindSqlStateType.ststoredprocedurebody && ast.tokencode != 463 && ast.tokencode != 307 && ast.tokencode != 426) {
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            TCustomSqlStatement lcnextsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
            switch (gst) {
                case sterror: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = lcnextsqlstatement;
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        gst = EFindSqlStateType.stsql;
                        continue block30;
                    }
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block30;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block30;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (!TBaseType.assigned(lcprevsolidtoken) || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block30;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block30;
                    }
                    this.gcurrentsqlstatement = lcnextsqlstatement;
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstcreatetrigger: 
                            case sstinformixCreateProcedure: 
                            case sstinformixCreateFunction: 
                            case sstinformixAlterProcedure: 
                            case sstinformixAlterFunction: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.ststoredprocedure;
                                break;
                            }
                            case sstmssqlbegintry: 
                            case sstmssqlbegincatch: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.sttrycatch;
                                lctrycatchlevel = 0;
                                break;
                            }
                            case sstmssqlgo: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                gst = EFindSqlStateType.stnormal;
                                break;
                            }
                            case sstinformixExecute: {
                                gst = EFindSqlStateType.stExec;
                                break;
                            }
                            default: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stsql;
                                break;
                            }
                        }
                    } else if (ast.tokencode == 351) {
                        this.gcurrentsqlstatement = new TMssqlBlock(this.dbVendor);
                        this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstmssqlblock;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        gst = EFindSqlStateType.stblock;
                    } else if (this.sqlstatements.size() == 0) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement = new TMssqlExecute(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                    } else if (this.sqlstatements.get((int)(this.sqlstatements.size() - 1)).sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement = new TMssqlExecute(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                    }
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) continue block30;
                    this.errormessage = "error when tokenlize:" + ast.astext + "(" + ast.lineNo + "," + ast.columnNo + ")";
                    errorcount = 1;
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block30;
                }
                case stExec: {
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    if (ast.tokentype != ETokenType.ttsemicolon) continue block30;
                    gst = EFindSqlStateType.stnormal;
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block30;
                }
                case stblock: {
                    TSourceToken lcnextsolidtoken;
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            lcnextsqlstatement = null;
                        }
                    }
                    if (gst != EFindSqlStateType.stblock) continue block30;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode == 351) {
                        lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false);
                        if (TBaseType.assigned(lcnextsolidtoken)) {
                            if (TBaseType.mysametext(lcnextsolidtoken.astext, "tran") || TBaseType.mysametext(lcnextsolidtoken.astext, "transaction") || TBaseType.mysametext(lcnextsolidtoken.astext, "distributed") || TBaseType.mysametext(lcnextsolidtoken.astext, "dialog") || TBaseType.mysametext(lcnextsolidtoken.astext, "conversation")) continue block30;
                            ++lcblocklevel;
                            continue block30;
                        }
                        ++lcblocklevel;
                        continue block30;
                    }
                    if (ast.tokencode == 316) {
                        ++lcblocklevel;
                        continue block30;
                    }
                    if (ast.tokencode != 313) continue block30;
                    boolean lcisendconversation = false;
                    lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false);
                    if (TBaseType.assigned(lcnextsolidtoken) && lcnextsolidtoken.tokencode == this.flexer.getkeywordvalue("conversation".toUpperCase())) {
                        lcisendconversation = true;
                    }
                    if (lcisendconversation) continue block30;
                    if (lcblocklevel == 0) {
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif && TBaseType.assigned(lcnextsolidtoken)) {
                            TSourceToken lcnnextsolidtoken;
                            if (lcnextsolidtoken.tokencode == 349) {
                                gst = EFindSqlStateType.stsql;
                            } else if (lcnextsolidtoken.tokentype == ETokenType.ttsemicolon && TBaseType.assigned(lcnnextsolidtoken = this.sourcetokenlist.nextsolidtoken(lcnextsolidtoken.posinlist, 1, false)) && lcnnextsolidtoken.tokencode == 349) {
                                gst = EFindSqlStateType.stsql;
                            }
                        }
                        if (gst == EFindSqlStateType.stsql) continue block30;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block30;
                    }
                    --lcblocklevel;
                    continue block30;
                }
                case sttrycatch: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegintry || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegincatch) {
                                ++lctrycatchlevel;
                            }
                            lcnextsqlstatement = null;
                        }
                    }
                    if (gst != EFindSqlStateType.sttrycatch) continue block30;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode != 456 && ast.tokencode != 462 || !TBaseType.assigned(lcprevsolidtoken) || lcprevsolidtoken.tokencode != 313) continue block30;
                    if (lctrycatchlevel == 0) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block30;
                    }
                    --lctrycatchlevel;
                    continue block30;
                }
                case stsql: {
                    TSourceToken lcnextsolidtoken;
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        boolean lcstillinsql = false;
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif && TBaseType.assigned(lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false)) && lcnextsolidtoken.tokencode == 349) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            lcstillinsql = true;
                        }
                        if (lcstillinsql) continue block30;
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block30;
                    }
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                            continue block30;
                        }
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstmssqlif: 
                            case sstmssqlwhile: {
                                if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegincatch || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegintry) {
                                    this.gcurrentsqlstatement.addtokentolist(ast);
                                    gst = EFindSqlStateType.stblock;
                                    lcblocklevel = 1;
                                    lcnextsqlstatement = null;
                                    continue block30;
                                }
                                if (this.gcurrentsqlstatement.dummytag != 1) break;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.gcurrentsqlstatement.dummytag = lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlwhile ? 1 : 0;
                                lcnextsqlstatement = null;
                                continue block30;
                            }
                            case sstmssqlalterqueue: {
                                if (lcnextsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlexec) break;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                lcnextsqlstatement = null;
                                continue block30;
                            }
                            case sstmssqlcreateschema: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                lcnextsqlstatement = null;
                                continue block30;
                            }
                        }
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = lcnextsqlstatement;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstcreatetrigger: 
                            case sstinformixCreateProcedure: 
                            case sstinformixCreateFunction: 
                            case sstinformixAlterProcedure: 
                            case sstinformixAlterFunction: {
                                gst = EFindSqlStateType.ststoredprocedure;
                                continue block30;
                            }
                            case sstmssqlbegintry: 
                            case sstmssqlbegincatch: {
                                gst = EFindSqlStateType.sttrycatch;
                                lctrycatchlevel = 0;
                                continue block30;
                            }
                            case sstmssqlgo: {
                                gst = EFindSqlStateType.stnormal;
                                continue block30;
                            }
                        }
                        gst = EFindSqlStateType.stsql;
                        continue block30;
                    }
                    if (ast.tokencode == 351) {
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif || this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlwhile) {
                            gst = EFindSqlStateType.stblock;
                            lcblocklevel = 0;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            continue block30;
                        }
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqldeclare) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = new TMssqlBlock(this.dbVendor);
                            this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstmssqlblock;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            gst = EFindSqlStateType.stblock;
                            continue block30;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block30;
                    }
                    if (ast.tokencode == 316) {
                        ++case_end_nest;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block30;
                    }
                    if (ast.tokencode == 313) {
                        if (case_end_nest > 0) {
                            --case_end_nest;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block30;
                    }
                    if (ast.tokencode == 349) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlif && this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlwhile || case_end_nest != 0) continue block30;
                        this.gcurrentsqlstatement.dummytag = 1;
                        continue block30;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block30;
                }
                case ststoredprocedure: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            gst = EFindSqlStateType.ststoredprocedurebody;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            lcnextsqlstatement = null;
                        }
                    }
                    if (gst != EFindSqlStateType.ststoredprocedure) continue block30;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode != 477 && ast.tokencode != 478 || ast.searchToken(313, -1) == null) continue block30;
                    gst = EFindSqlStateType.stsql;
                    continue block30;
                }
                case ststoredprocedurebody: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        switch (lcnextsqlstatement.sqlstatementtype) {
                            case sstmssqlgo: {
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = lcnextsqlstatement;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                gst = EFindSqlStateType.stnormal;
                                break;
                            }
                            case sstcreatetrigger: 
                            case sstinformixCreateProcedure: 
                            case sstinformixCreateFunction: 
                            case sstinformixAlterProcedure: 
                            case sstinformixAlterFunction: {
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = lcnextsqlstatement;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.ststoredprocedure;
                                break;
                            }
                            default: {
                                lcnextsqlstatement = null;
                            }
                        }
                    }
                    if (gst != EFindSqlStateType.ststoredprocedurebody) continue block30;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                }
            }
        }
        if (TBaseType.assigned(this.gcurrentsqlstatement) && gst != EFindSqlStateType.stnormal) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return errorcount;
    }

    int domssqlgetrawsqlstatements() {
        int errorcount = 0;
        int case_end_nest = 0;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        int lcblocklevel = 0;
        int lctrycatchlevel = 0;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        int lcMergeInSelectNested = 0;
        boolean lcMergeInSelect = false;
        block28: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken st1;
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (lcMergeInSelect) {
                if (ast.tokencode == 40) {
                    ++lcMergeInSelectNested;
                }
                if (ast.tokencode == 41 && --lcMergeInSelectNested == 0) {
                    lcMergeInSelect = false;
                }
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            if (ast.tokenstatus == ETokenStatus.tsignoredbygetrawstatement) {
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            if (ast.tokencode == 353) {
                st1 = ast.searchToken(40, 1);
                if (st1 == null && (st1 = ast.searchToken(301, 1)) == null) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 418) {
                st1 = ast.nextSolidToken();
                if (st1.tokencode == 324) {
                    ast.tokencode = 287;
                }
                if (lcprevsolidtoken != null && lcprevsolidtoken.tokencode == 40) {
                    lcMergeInSelect = true;
                    ++lcMergeInSelectNested;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue;
                }
            } else if (ast.tokencode == 558) {
                if (lcprevsolidtoken != null && lcprevsolidtoken.tokencode == 46 && (st1 = ast.searchToken(40, 1)) != null) {
                    ast.tokencode = 553;
                }
            } else if (ast.tokencode == 559) {
                if (lcprevsolidtoken != null && lcprevsolidtoken.tokencode == 46 && (st1 = ast.searchToken(40, 1)) != null) {
                    ast.tokencode = 554;
                }
            } else if (ast.tokencode == 560) {
                if (lcprevsolidtoken != null && lcprevsolidtoken.tokencode == 46 && (st1 = ast.searchToken(40, 1)) != null) {
                    ast.tokencode = 555;
                }
            } else if (ast.tokencode == 561) {
                if (lcprevsolidtoken != null && lcprevsolidtoken.tokencode == 46 && (st1 = ast.searchToken(40, 1)) != null) {
                    ast.tokencode = 556;
                }
            } else if (ast.tokencode == 562) {
                if (lcprevsolidtoken != null && lcprevsolidtoken.tokencode == 46 && (st1 = ast.searchToken(40, 1)) != null) {
                    ast.tokencode = 557;
                }
            } else if (ast.tokencode == 306) {
                st1 = ast.nextSolidToken();
                if (st1 != null && st1.tokencode == 564) {
                    ast.tokencode = 285;
                }
            } else if (ast.tokencode == 566) {
                st1 = ast.nextSolidToken();
                if (st1 != null && st1.tokencode == 46) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 334 && lcprevsolidtoken != null && (lcprevsolidtoken.tokencode == 567 || lcprevsolidtoken.tokencode == 568)) {
                ast.tokencode = 569;
            }
            if (this.dbVendor == EDbVendor.dbvopenedge) {
                if (ast.tokencode == 333) {
                    st1 = ast.searchToken(340, 1);
                    if (st1 == null) {
                        ast.tokencode = 264;
                    }
                } else if (ast.tokencode == 311 && (st1 = ast.searchToken(499, 1)) != null) {
                    ast.tokencode = 529;
                }
            }
            if (gst == EFindSqlStateType.ststoredprocedurebody && ast.tokencode != 463 && ast.tokencode != 307 && ast.tokencode != 426) {
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            TCustomSqlStatement lcnextsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
            switch (gst) {
                case sterror: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = lcnextsqlstatement;
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        gst = EFindSqlStateType.stsql;
                        continue block28;
                    }
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block28;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block28;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (!TBaseType.assigned(lcprevsolidtoken) || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block28;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block28;
                    }
                    this.gcurrentsqlstatement = lcnextsqlstatement;
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstmssqlcreateprocedure: 
                            case sstmssqlcreatefunction: 
                            case sstcreatetrigger: 
                            case sstmssqlalterprocedure: 
                            case sstmssqlalterfunction: 
                            case sstmssqlaltertrigger: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.ststoredprocedure;
                                break;
                            }
                            case sstmssqlbegintry: 
                            case sstmssqlbegincatch: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.sttrycatch;
                                lctrycatchlevel = 0;
                                break;
                            }
                            case sstmssqlgo: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                gst = EFindSqlStateType.stnormal;
                                break;
                            }
                            default: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stsql;
                                break;
                            }
                        }
                    } else if (ast.tokencode == 351) {
                        this.gcurrentsqlstatement = new TMssqlBlock(this.dbVendor);
                        this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstmssqlblock;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        gst = EFindSqlStateType.stblock;
                    } else if (this.sqlstatements.size() == 0) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement = new TMssqlExecute(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                    } else if (this.sqlstatements.get((int)(this.sqlstatements.size() - 1)).sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement = new TMssqlExecute(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                    }
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) continue block28;
                    this.errormessage = "error when tokenlize:" + ast.astext + "(" + ast.lineNo + "," + ast.columnNo + ")";
                    errorcount = 1;
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block28;
                }
                case stblock: {
                    TSourceToken lcnextsolidtoken;
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            lcnextsqlstatement = null;
                        }
                    }
                    if (gst != EFindSqlStateType.stblock) continue block28;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode == 351) {
                        lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false);
                        if (TBaseType.assigned(lcnextsolidtoken)) {
                            if (TBaseType.mysametext(lcnextsolidtoken.astext, "tran") || TBaseType.mysametext(lcnextsolidtoken.astext, "transaction") || TBaseType.mysametext(lcnextsolidtoken.astext, "distributed") || TBaseType.mysametext(lcnextsolidtoken.astext, "dialog") || TBaseType.mysametext(lcnextsolidtoken.astext, "conversation")) continue block28;
                            ++lcblocklevel;
                            continue block28;
                        }
                        ++lcblocklevel;
                        continue block28;
                    }
                    if (ast.tokencode == 316) {
                        ++lcblocklevel;
                        continue block28;
                    }
                    if (ast.tokencode != 313) continue block28;
                    boolean lcisendconversation = false;
                    lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false);
                    if (TBaseType.assigned(lcnextsolidtoken) && lcnextsolidtoken.tokencode == this.flexer.getkeywordvalue("conversation".toUpperCase())) {
                        lcisendconversation = true;
                    }
                    if (lcisendconversation) continue block28;
                    if (lcblocklevel == 0) {
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif && TBaseType.assigned(lcnextsolidtoken)) {
                            TSourceToken lcnnextsolidtoken;
                            if (lcnextsolidtoken.tokencode == 349) {
                                gst = EFindSqlStateType.stsql;
                            } else if (lcnextsolidtoken.tokentype == ETokenType.ttsemicolon && TBaseType.assigned(lcnnextsolidtoken = this.sourcetokenlist.nextsolidtoken(lcnextsolidtoken.posinlist, 1, false)) && lcnnextsolidtoken.tokencode == 349) {
                                gst = EFindSqlStateType.stsql;
                            }
                        }
                        if (gst == EFindSqlStateType.stsql) continue block28;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block28;
                    }
                    --lcblocklevel;
                    continue block28;
                }
                case sttrycatch: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegintry || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegincatch) {
                                ++lctrycatchlevel;
                            }
                            lcnextsqlstatement = null;
                        }
                    }
                    if (gst != EFindSqlStateType.sttrycatch) continue block28;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode != 456 && ast.tokencode != 462 || !TBaseType.assigned(lcprevsolidtoken) || lcprevsolidtoken.tokencode != 313) continue block28;
                    if (lctrycatchlevel == 0) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block28;
                    }
                    --lctrycatchlevel;
                    continue block28;
                }
                case stsql: {
                    TSourceToken lcnextsolidtoken;
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        boolean lcstillinsql = false;
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif && TBaseType.assigned(lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false)) && lcnextsolidtoken.tokencode == 349) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            lcstillinsql = true;
                        }
                        if (lcstillinsql) continue block28;
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block28;
                    }
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                            continue block28;
                        }
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstmssqlif: 
                            case sstmssqlwhile: {
                                if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegincatch || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlbegintry) {
                                    this.gcurrentsqlstatement.addtokentolist(ast);
                                    gst = EFindSqlStateType.stblock;
                                    lcblocklevel = 1;
                                    lcnextsqlstatement = null;
                                    continue block28;
                                }
                                if (this.gcurrentsqlstatement.dummytag != 1) break;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.gcurrentsqlstatement.dummytag = lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlwhile ? 1 : 0;
                                lcnextsqlstatement = null;
                                continue block28;
                            }
                            case sstmssqlalterqueue: {
                                if (lcnextsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlexec) break;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                lcnextsqlstatement = null;
                                continue block28;
                            }
                            case sstmssqlcreateschema: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                lcnextsqlstatement = null;
                                continue block28;
                            }
                        }
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = lcnextsqlstatement;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstmssqlcreateprocedure: 
                            case sstmssqlcreatefunction: 
                            case sstcreatetrigger: 
                            case sstmssqlalterprocedure: 
                            case sstmssqlalterfunction: 
                            case sstmssqlaltertrigger: {
                                gst = EFindSqlStateType.ststoredprocedure;
                                continue block28;
                            }
                            case sstmssqlbegintry: 
                            case sstmssqlbegincatch: {
                                gst = EFindSqlStateType.sttrycatch;
                                lctrycatchlevel = 0;
                                continue block28;
                            }
                            case sstmssqlgo: {
                                gst = EFindSqlStateType.stnormal;
                                continue block28;
                            }
                        }
                        gst = EFindSqlStateType.stsql;
                        continue block28;
                    }
                    if (ast.tokencode == 351) {
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif || this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlwhile) {
                            gst = EFindSqlStateType.stblock;
                            lcblocklevel = 0;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            continue block28;
                        }
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqldeclare) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = new TMssqlBlock(this.dbVendor);
                            this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstmssqlblock;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            gst = EFindSqlStateType.stblock;
                            continue block28;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block28;
                    }
                    if (ast.tokencode == 316) {
                        ++case_end_nest;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block28;
                    }
                    if (ast.tokencode == 313) {
                        if (case_end_nest > 0) {
                            --case_end_nest;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block28;
                    }
                    if (ast.tokencode == 349) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlif && this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlwhile || case_end_nest != 0) continue block28;
                        this.gcurrentsqlstatement.dummytag = 1;
                        continue block28;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block28;
                }
                case ststoredprocedure: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            gst = EFindSqlStateType.ststoredprocedurebody;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            lcnextsqlstatement = null;
                        }
                    }
                    if (gst != EFindSqlStateType.ststoredprocedure) continue block28;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode != 351) continue block28;
                    gst = EFindSqlStateType.stblock;
                    continue block28;
                }
                case ststoredprocedurebody: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        switch (lcnextsqlstatement.sqlstatementtype) {
                            case sstmssqlgo: {
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = lcnextsqlstatement;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                gst = EFindSqlStateType.stnormal;
                                break;
                            }
                            case sstmssqlcreateprocedure: 
                            case sstmssqlcreatefunction: 
                            case sstcreatetrigger: 
                            case sstmssqlalterprocedure: 
                            case sstmssqlalterfunction: 
                            case sstmssqlaltertrigger: {
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = lcnextsqlstatement;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.ststoredprocedure;
                                break;
                            }
                            default: {
                                lcnextsqlstatement = null;
                            }
                        }
                    }
                    if (gst != EFindSqlStateType.ststoredprocedurebody) continue block28;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                }
            }
        }
        if (TBaseType.assigned(this.gcurrentsqlstatement) && gst != EFindSqlStateType.stnormal) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return errorcount;
    }

    private TCustomSqlStatement startDaxStmt(TSourceToken currToken, TCustomSqlStatement currStmt) {
        TDaxStmt newStmt = null;
        if (currToken == null) {
            return null;
        }
        if (currToken.tokencode == 61 && currToken.firstTokenOfLine()) {
            currToken.tokencode = 276;
            newStmt = new TDaxExprStmt(EDbVendor.dbvdax);
        } else if (currToken.tokencode == 529 && currToken.firstTokenOfLine()) {
            newStmt = new TDaxEvaluateStmt(EDbVendor.dbvdax);
            ((TDaxEvaluateStmt)newStmt).setStartWithDefine(true);
        } else if (currToken.tokencode == 530 && currToken.firstTokenOfLine()) {
            TDaxEvaluateStmt tmp;
            if (currStmt != null && currStmt instanceof TDaxEvaluateStmt && (tmp = (TDaxEvaluateStmt)currStmt).isStartWithDefine()) {
                return null;
            }
            newStmt = new TDaxEvaluateStmt(EDbVendor.dbvdax);
        }
        if (newStmt == null) {
            boolean isFirst = currToken.firstTokenOfLine();
            TSourceToken prevToken = currToken.prevSolidToken();
            if (isFirst && prevToken == null) {
                newStmt = new TDaxExprStmt(EDbVendor.dbvdax);
            }
        }
        return newStmt;
    }

    int doodbcgetrawsqlstatements() {
        return this.domssqlgetrawsqlstatements();
    }

    int dodaxgetrawsqlstatements() {
        this.gcurrentsqlstatement = null;
        TCustomSqlStatement tmpStmt = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        int errorcount = 0;
        int nestedParens = 0;
        block5: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken st1;
            TSourceToken ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if ((ast.tokencode == 531 || ast.tokencode == 532 || ast.tokencode == 533 || ast.tokencode == 534 || ast.tokencode == 535) && (st1 = ast.searchToken("(", 1)) == null) {
                ast.tokencode = 264;
            }
            if (ast.tokencode == 40) {
                ++nestedParens;
            }
            if (ast.tokencode == 41) {
                --nestedParens;
            }
            if (nestedParens > 0) {
                if (this.gcurrentsqlstatement == null) continue;
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            switch (gst) {
                case sterror: {
                    tmpStmt = this.startDaxStmt(ast, this.gcurrentsqlstatement);
                    if (tmpStmt != null) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = tmpStmt;
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        gst = EFindSqlStateType.stsql;
                        continue block5;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block5;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (!TBaseType.assigned(this.gcurrentsqlstatement)) continue block5;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block5;
                    }
                    this.gcurrentsqlstatement = this.startDaxStmt(ast, this.gcurrentsqlstatement);
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block5;
                    }
                    this.errormessage = "error when tokenlize:" + ast.astext + "(" + ast.lineNo + "," + ast.columnNo + ")";
                    errorcount = 1;
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block5;
                }
                case stsql: {
                    tmpStmt = this.startDaxStmt(ast, this.gcurrentsqlstatement);
                    if (tmpStmt != null) {
                        gst = EFindSqlStateType.stsql;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = tmpStmt;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block5;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                }
            }
        }
        if (TBaseType.assigned(this.gcurrentsqlstatement) && (gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return errorcount;
    }

    int dohanagetrawsqlstatements() {
        int errorcount = 0;
        int case_end_nest = 0;
        if (TBaseType.assigned(this.sqlstatements)) {
            this.sqlstatements.clear();
        }
        if (!TBaseType.assigned(this.sourcetokenlist)) {
            return -1;
        }
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        int lcblocklevel = 0;
        boolean lctrycatchlevel = false;
        TSourceToken lcprevsolidtoken = null;
        TSourceToken ast = null;
        int lcMergeInSelectNested = 0;
        boolean lcMergeInSelect = false;
        block23: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken st1;
            if (ast != null && ast.issolidtoken()) {
                lcprevsolidtoken = ast;
            }
            ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (lcMergeInSelect) {
                if (ast.tokencode == 40) {
                    ++lcMergeInSelectNested;
                }
                if (ast.tokencode == 41 && --lcMergeInSelectNested == 0) {
                    lcMergeInSelect = false;
                }
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            if (ast.tokenstatus == ETokenStatus.tsignoredbygetrawstatement) {
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            if (ast.tokencode == 353) {
                st1 = ast.searchToken(40, 1);
                if (st1 == null && (st1 = ast.searchToken(301, 1)) == null) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 418) {
                st1 = ast.nextSolidToken();
                if (st1.tokencode == 324) {
                    ast.tokencode = 287;
                }
                if (lcprevsolidtoken != null && lcprevsolidtoken.tokencode == 40) {
                    lcMergeInSelect = true;
                    ++lcMergeInSelectNested;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue;
                }
            } else if (ast.tokencode == 341) {
                st1 = ast.nextSolidToken();
                if (st1.tokencode == 534) {
                    ast.tokencode = 531;
                }
            } else if (ast.tokencode == 394) {
                st1 = ast.nextSolidToken();
                if (st1.tokencode == 262) {
                    ast.tokencode = 535;
                }
            } else if (ast.tokencode == 393) {
                st1 = ast.nextSolidToken();
                if (st1.tokencode == 262) {
                    ast.tokencode = 536;
                }
            } else if (ast.tokencode == 395) {
                st1 = ast.nextSolidToken();
                if (st1.tokencode == 262) {
                    ast.tokencode = 537;
                }
            } else if (ast.tokencode == 311) {
                st1 = ast.nextSolidToken();
                if (st1.toString().equalsIgnoreCase("structured")) {
                    ast.tokencode = 538;
                } else if (st1.toString().equalsIgnoreCase("cache")) {
                    ast.tokencode = 539;
                } else if (st1.toString().equalsIgnoreCase("static")) {
                    ast.tokencode = 539;
                } else if (st1.toString().equalsIgnoreCase("dynamic")) {
                    ast.tokencode = 539;
                }
                if (st1.toString().equalsIgnoreCase("check")) {
                    ast.tokencode = 540;
                }
            } else if (ast.tokencode == 542 && (st1 = ast.nextSolidToken()).toString().equalsIgnoreCase("priority")) {
                ast.tokencode = 543;
            }
            if (gst == EFindSqlStateType.ststoredprocedurebody && ast.tokencode != 463 && ast.tokencode != 307 && ast.tokencode != 426) {
                this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                continue;
            }
            TCustomSqlStatement lcnextsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
            switch (gst) {
                case sterror: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = lcnextsqlstatement;
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        gst = EFindSqlStateType.stsql;
                        continue block23;
                    }
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block23;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block23;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (!TBaseType.assigned(lcprevsolidtoken) || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block23;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block23;
                    }
                    this.gcurrentsqlstatement = lcnextsqlstatement;
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstcreatetrigger: 
                            case sstcreateprocedure: 
                            case sstcreatefunction: 
                            case sstalterprocedure: 
                            case sstalterfunction: 
                            case sstaltertrigger: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.ststoredprocedure;
                                break;
                            }
                            case sstmssqlgo: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                gst = EFindSqlStateType.stnormal;
                                break;
                            }
                            default: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.stsql;
                                break;
                            }
                        }
                    } else if (ast.tokencode == 351) {
                        this.gcurrentsqlstatement = new TMssqlBlock(this.dbVendor);
                        this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstmssqlblock;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        gst = EFindSqlStateType.stblock;
                    } else if (this.sqlstatements.size() == 0) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement = new TMssqlExecute(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                    } else if (this.sqlstatements.get((int)(this.sqlstatements.size() - 1)).sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                        gst = EFindSqlStateType.stsql;
                        this.gcurrentsqlstatement = new TMssqlExecute(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                    }
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) continue block23;
                    this.errormessage = "error when tokenlize:" + ast.astext + "(" + ast.lineNo + "," + ast.columnNo + ")";
                    errorcount = 1;
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block23;
                }
                case stblock: {
                    TSourceToken lcnextsolidtoken;
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        } else {
                            lcnextsqlstatement = null;
                        }
                    }
                    if (lcblocklevel == -1 && ast.tokencode == 59) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block23;
                    }
                    if (gst != EFindSqlStateType.stblock) continue block23;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode == 351) {
                        lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false);
                        if (TBaseType.assigned(lcnextsolidtoken)) {
                            if (TBaseType.mysametext(lcnextsolidtoken.astext, "tran") || TBaseType.mysametext(lcnextsolidtoken.astext, "transaction")) continue block23;
                            ++lcblocklevel;
                            continue block23;
                        }
                        ++lcblocklevel;
                        continue block23;
                    }
                    if (ast.tokencode == 316) {
                        ++lcblocklevel;
                        continue block23;
                    }
                    if (ast.tokencode != 313) continue block23;
                    boolean lcisendconversation = false;
                    lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false);
                    if (lcisendconversation) continue block23;
                    if (lcblocklevel == 0) {
                        TSourceToken lcnnextsolidtoken;
                        if (this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlif || !TBaseType.assigned(lcnextsolidtoken)) continue block23;
                        if (lcnextsolidtoken.tokencode == 349) {
                            gst = EFindSqlStateType.stsql;
                            continue block23;
                        }
                        if (lcnextsolidtoken.tokentype != ETokenType.ttsemicolon || !TBaseType.assigned(lcnnextsolidtoken = this.sourcetokenlist.nextsolidtoken(lcnextsolidtoken.posinlist, 1, false)) || lcnnextsolidtoken.tokencode != 349) continue block23;
                        gst = EFindSqlStateType.stsql;
                        continue block23;
                    }
                    --lcblocklevel;
                    continue block23;
                }
                case stsql: {
                    TSourceToken lcnextsolidtoken;
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        boolean lcstillinsql = false;
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif && TBaseType.assigned(lcnextsolidtoken = this.sourcetokenlist.nextsolidtoken(i, 1, false)) && lcnextsolidtoken.tokencode == 349) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            lcstillinsql = true;
                        }
                        if (lcstillinsql) continue block23;
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block23;
                    }
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlgo) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                            continue block23;
                        }
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstmssqlif: 
                            case sstmssqlwhile: {
                                if (this.gcurrentsqlstatement.dummytag != 1) break;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.gcurrentsqlstatement.dummytag = lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlwhile ? 1 : 0;
                                lcnextsqlstatement = null;
                                continue block23;
                            }
                            case sstcreateschema: {
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                lcnextsqlstatement = null;
                                continue block23;
                            }
                        }
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = lcnextsqlstatement;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        switch (this.gcurrentsqlstatement.sqlstatementtype) {
                            case sstcreatetrigger: 
                            case sstcreateprocedure: 
                            case sstcreatefunction: 
                            case sstalterprocedure: 
                            case sstalterfunction: 
                            case sstaltertrigger: {
                                gst = EFindSqlStateType.ststoredprocedure;
                                continue block23;
                            }
                        }
                        gst = EFindSqlStateType.stsql;
                        continue block23;
                    }
                    if (ast.tokencode == 351) {
                        if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlif || this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstmssqlwhile) {
                            gst = EFindSqlStateType.stblock;
                            lcblocklevel = 0;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            continue block23;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block23;
                    }
                    if (ast.tokencode == 316) {
                        ++case_end_nest;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block23;
                    }
                    if (ast.tokencode == 313) {
                        if (case_end_nest > 0) {
                            --case_end_nest;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block23;
                    }
                    if (ast.tokencode == 349) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlif && this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmssqlwhile || case_end_nest != 0) continue block23;
                        this.gcurrentsqlstatement.dummytag = 1;
                        continue block23;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block23;
                }
                case ststoredprocedure: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        if (lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstalterfunction || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstcreateprocedure || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstcreatefunction || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstcreatetrigger || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstalterprocedure || lcnextsqlstatement.sqlstatementtype == ESqlStatementType.sstaltertrigger) {
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            this.gcurrentsqlstatement = lcnextsqlstatement;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            gst = EFindSqlStateType.ststoredprocedure;
                            continue block23;
                        }
                        gst = EFindSqlStateType.ststoredprocedurebody;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        lcnextsqlstatement = null;
                    }
                    if (gst != EFindSqlStateType.ststoredprocedure) continue block23;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode == 351) {
                        gst = EFindSqlStateType.ststoredprocedurebody;
                        continue block23;
                    }
                    if (ast.tokencode != 545) continue block23;
                    gst = EFindSqlStateType.ststoredprocedurebody;
                    continue block23;
                }
                case ststoredprocedurebody: {
                    if (TBaseType.assigned(lcnextsqlstatement)) {
                        switch (lcnextsqlstatement.sqlstatementtype) {
                            case sstmssqlgo: {
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = lcnextsqlstatement;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                gst = EFindSqlStateType.stnormal;
                                break;
                            }
                            case sstcreatetrigger: 
                            case sstcreateprocedure: 
                            case sstcreatefunction: 
                            case sstalterprocedure: 
                            case sstalterfunction: 
                            case sstaltertrigger: {
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                this.gcurrentsqlstatement = lcnextsqlstatement;
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                gst = EFindSqlStateType.ststoredprocedure;
                                break;
                            }
                            default: {
                                lcnextsqlstatement = null;
                            }
                        }
                    }
                    if (gst != EFindSqlStateType.ststoredprocedurebody) continue block23;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                }
            }
        }
        if (TBaseType.assigned(this.gcurrentsqlstatement) && gst != EFindSqlStateType.stnormal) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return errorcount;
    }

    int domysqlgetrawsqlstatements() {
        int errorcount = 0;
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        boolean waitingDelimiter = false;
        this.userDelimiterStr = this.defaultDelimiterStr;
        block7: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken leftParen;
            TSourceToken ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokencode == 394) {
                TSourceToken st1 = ast.nextSolidToken();
                if (st1 != null) {
                    if (st1.tokencode == 40) {
                        ast.tokencode = 538;
                    } else if (st1.tokencode == 262) {
                        ast.tokencode = 539;
                    }
                }
            } else if (ast.tokencode == 393) {
                TSourceToken st1 = ast.nextSolidToken();
                if (st1 != null && st1.tokencode == 262) {
                    ast.tokencode = 540;
                }
            } else if (ast.tokencode == 395) {
                TSourceToken st1 = ast.nextSolidToken();
                if (st1 != null) {
                    if (st1.tokencode == 262) {
                        ast.tokencode = 553;
                    } else if (st1.tokencode == 264 && st1.toString().startsWith("\"")) {
                        ast.tokencode = 553;
                        st1.tokencode = 262;
                    }
                }
            } else if (ast.tokencode == 541) {
                boolean isIdent = true;
                TSourceToken st1 = ast.nextSolidToken();
                if (st1 != null && st1.tokencode == 40) {
                    isIdent = false;
                }
                if ((st1 = ast.prevSolidToken()) != null && (st1.tokencode == 542 || st1.tokencode == 552)) {
                    isIdent = false;
                }
                if (isIdent) {
                    ast.tokencode = 264;
                }
            } else if (ast.tokencode == 416 && (leftParen = ast.searchToken(40, 1)) != null) {
                boolean commaToken = false;
                for (int k = leftParen.posinlist + 1; k < ast.container.size() && ast.container.get((int)k).tokencode != 41; ++k) {
                    if (ast.container.get((int)k).tokencode != 44) continue;
                    commaToken = true;
                    break;
                }
                if (commaToken) {
                    ast.tokencode = 544;
                }
            }
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block7;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block7;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (!TBaseType.assigned(this.gcurrentsqlstatement)) continue block7;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    if (ast.firstTokenOfLine() && (ast.tokencode == 543 || ast.tokencode == 288)) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TMySQLSource(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                        ESqlStatementType[] ses = new ESqlStatementType[]{ESqlStatementType.sstmysqlcreateprocedure, ESqlStatementType.sstmysqlcreatefunction, ESqlStatementType.sstcreatetrigger};
                        if (this.includesqlstatementtype(this.gcurrentsqlstatement.sqlstatementtype, ses)) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            waitingDelimiter = false;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.curdelimiterchar = (char)59;
                        } else {
                            gst = EFindSqlStateType.stsql;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                    }
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) continue block7;
                    this.errormessage = "error when tokenlize:" + ast.astext + "(" + ast.lineNo + "," + ast.columnNo + ")";
                    errorcount = 1;
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsqlplus: {
                    if (ast.tokencode == 260) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon && this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmysqldelimiter) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (ast.toString().equalsIgnoreCase(this.userDelimiterStr)) {
                        gst = EFindSqlStateType.stnormal;
                        ast.tokencode = 59;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode != 260 || this.gcurrentsqlstatement.sqlstatementtype != ESqlStatementType.sstmysqldelimiter) continue block7;
                    gst = EFindSqlStateType.stnormal;
                    this.userDelimiterStr = "";
                    for (int k = 0; k < this.gcurrentsqlstatement.sourcetokenlist.size(); ++k) {
                        TSourceToken st = this.gcurrentsqlstatement.sourcetokenlist.get(k);
                        if (st.tokencode == 536 || st.tokencode == 260 || st.tokencode == 259 || st.tokencode == 325) continue;
                        this.userDelimiterStr = this.userDelimiterStr + st.toString();
                    }
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block7;
                }
                case ststoredprocedure: {
                    TSourceToken lcprevtoken;
                    if (waitingDelimiter) {
                        if (this.userDelimiterStr.equalsIgnoreCase(ast.toString())) {
                            gst = EFindSqlStateType.stnormal;
                            this.gcurrentsqlstatement.semicolonended = ast;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            continue block7;
                        }
                        if (this.userDelimiterStr.startsWith(ast.toString())) {
                            int k;
                            String lcstr = ast.toString();
                            for (k = ast.posinlist + 1; k < ast.container.size(); ++k) {
                                TSourceToken st = ast.container.get(k);
                                if (st.tokencode == 536 || st.tokencode == 260 || st.tokencode == 259) break;
                                lcstr = lcstr + st.toString();
                            }
                            if (this.userDelimiterStr.equalsIgnoreCase(lcstr)) {
                                for (k = ast.posinlist; k < ast.container.size(); ++k) {
                                    TSourceToken st = ast.container.get(k);
                                    if (st.tokencode == 536 || st.tokencode == 260 || st.tokencode == 259) break;
                                    ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                                }
                                gst = EFindSqlStateType.stnormal;
                                this.gcurrentsqlstatement.semicolonended = ast;
                                this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                                continue block7;
                            }
                        }
                    }
                    if (ast.tokencode == 351) {
                        waitingDelimiter = true;
                    }
                    if (this.userDelimiterStr.equals(";") || !waitingDelimiter) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (ast.tokentype != ETokenType.ttsemicolon) continue block7;
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (ast.toString().equals(this.userDelimiterStr)) {
                        ast.tokenstatus = ETokenStatus.tsignorebyyacc;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    if (ast.tokentype == ETokenType.ttsemicolon && this.userDelimiterStr.equals(";") && (lcprevtoken = ast.container.nextsolidtoken(ast, -1, false)) != null && lcprevtoken.tokencode == 313) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                }
            }
        }
        if (TBaseType.assigned(this.gcurrentsqlstatement) && (gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return errorcount;
    }

    int dodb2getrawsqlstatements() {
        this.gcurrentsqlstatement = null;
        EFindSqlStateType gst = EFindSqlStateType.stnormal;
        int errorcount = 0;
        int waitingEnds = 0;
        boolean waitingForFirstBegin = false;
        block7: for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
            TSourceToken st1;
            TSourceToken ast = this.sourcetokenlist.get(i);
            this.sourcetokenlist.curpos = i;
            if (ast.tokencode == 315) {
                st1 = ast.searchToken("global", 1);
                if (st1 != null) {
                    ast.tokencode = 535;
                }
            } else if ((ast.tokencode == 396 || ast.tokencode == 536 || ast.tokencode == 540) && (st1 = ast.searchToken(46, 1)) != null) {
                ast.tokencode = 264;
            }
            switch (gst) {
                case sterror: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block7;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block7;
                }
                case stnormal: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (!TBaseType.assigned(this.gcurrentsqlstatement)) continue block7;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    if (ast.tokencode == 273) {
                        gst = EFindSqlStateType.stsqlplus;
                        this.gcurrentsqlstatement = new TSqlplusCmdStatement(this.dbVendor);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                        ESqlStatementType[] ses = new ESqlStatementType[]{ESqlStatementType.sstdb2declarecursor, ESqlStatementType.sstdb2createprocedure, ESqlStatementType.sstdb2createfunction, ESqlStatementType.sstcreatetrigger};
                        if (this.includesqlstatementtype(this.gcurrentsqlstatement.sqlstatementtype, ses)) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            waitingEnds = 1;
                            waitingForFirstBegin = true;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstdb2createprocedure || this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstdb2createfunction || this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstcreatetrigger) {
                                this.curdelimiterchar = (char)59;
                            }
                        } else if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstdb2scriptOption) {
                            gst = EFindSqlStateType.stnormal;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        } else {
                            gst = EFindSqlStateType.stsql;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                    }
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) continue block7;
                    this.errormessage = "error when tokenlize:" + ast.astext + "(" + ast.lineNo + "," + ast.columnNo + ")";
                    errorcount = 1;
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case stsqlplus: {
                    if (ast.insqlpluscmd) {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block7;
                    }
                    gst = EFindSqlStateType.stnormal;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block7;
                }
                case stsql: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block7;
                }
                case ststoredprocedure: {
                    this.nextStmt = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (this.nextStmt != null && (this.nextStmt.sqlstatementtype == ESqlStatementType.sstdb2createprocedure || this.nextStmt.sqlstatementtype == ESqlStatementType.sstdb2createfunction || this.nextStmt.sqlstatementtype == ESqlStatementType.sstcreatetrigger)) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        this.gcurrentsqlstatement = this.nextStmt;
                        gst = EFindSqlStateType.ststoredprocedure;
                        waitingEnds = 1;
                        waitingForFirstBegin = true;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.curdelimiterchar = (char)59;
                        continue block7;
                    }
                    if (this.curdelimiterchar != this.delimiterchar && (ast.tokencode == 351 || ast.tokencode == 315)) {
                        this.curdelimiterchar = this.delimiterchar;
                    }
                    if (this.curdelimiterchar == ';') {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (ast.tokentype != ETokenType.ttsemicolon) continue block7;
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement._semicolon = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    char ch = ast.astext.length() == 1 ? ast.astext.charAt(0) : (ast.astext.length() > 1 && ast.issolidtoken() ? ast.astext.charAt(ast.astext.length() - 1) : (char)' ');
                    if (ch == this.curdelimiterchar) {
                        if (ast.astext.length() > 1) {
                            String lcstr = ast.astext.substring(0, ast.astext.length() - 1);
                            int c = this.flexer.getkeywordvalue(lcstr);
                            if (c > 0) {
                                ast.tokencode = c;
                            }
                        } else {
                            this.gcurrentsqlstatement._semicolon = ast;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block7;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode == 316 || ast.tokencode == 305 || ast.tokencode == 460 || ast.tokencode == 494 || ast.tokencode == 490) {
                        TSourceToken nextst = ast.nextSolidToken();
                        if (nextst != null && nextst.tokencode != 59) {
                            ++waitingEnds;
                        }
                    } else if (ast.tokencode == 351) {
                        if (waitingForFirstBegin) {
                            waitingForFirstBegin = false;
                        } else {
                            ++waitingEnds;
                        }
                    } else if (ast.tokencode == 313) {
                        --waitingEnds;
                    }
                    if (ast.tokentype != ETokenType.ttsemicolon || waitingEnds != 0) continue block7;
                    gst = EFindSqlStateType.stnormal;
                    this.gcurrentsqlstatement._semicolon = ast;
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    continue block7;
                }
            }
        }
        if (TBaseType.assigned(this.gcurrentsqlstatement) && (gst == EFindSqlStateType.stsqlplus || gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return errorcount;
    }

    /*
     * Unable to fully structure code
     */
    int doteradatagetrawsqlstatements() {
        this.gcurrentsqlstatement = null;
        gst = EFindSqlStateType.stnormal;
        lcNestedParens = 0;
        lcprevst = null;
        lcnextst = null;
        lcnextst2 = null;
        lcprevsolidtoken = null;
        ast = null;
        lcprevst2 = null;
        errorcount = 0;
        inBTEQComment = false;
        isContinueBTEQCmd = false;
        block16: for (i = 0; i < this.sourcetokenlist.size(); ++i) {
            block90: {
                block91: {
                    block92: {
                        if (ast != null && ast.issolidtoken()) {
                            lcprevsolidtoken = ast;
                        }
                        ast = this.sourcetokenlist.get(i);
                        this.sourcetokenlist.curpos = i;
                        if (ast.tokencode == 393 || ast.tokencode == 394 || ast.tokencode == 395) break block90;
                        if (ast.tokencode != 40) break block91;
                        lcnextst = this.sourcetokenlist.nextsolidtoken(i, 1, false);
                        lcprevst = this.getprevsolidtoken(ast);
                        if (lcprevst != null && lcprevst.tokencode == 560) {
                            lcnextst = null;
                        }
                        if (lcprevst != null && TFunctionCall.isBuiltIn(lcprevst.toString(), EDbVendor.dbvteradata) && lcprevst.tokencode != 313 && lcprevst.tokencode != 393 && lcprevst.tokencode != 394 && lcprevst.tokencode != 395 && !lcprevst.toString().equalsIgnoreCase("current_date") && !lcprevst.toString().equalsIgnoreCase("current_time") && !lcprevst.toString().equalsIgnoreCase("current_timestamp")) {
                            lcnextst = null;
                        }
                        if (lcnextst == null) break block90;
                        dataType = TTypeName.searchTypeByName(lcnextst.toString());
                        if (dataType == null || lcprevst == null || lcprevst.tokencode == 559) break block92;
                        ast.tokencode = 558;
                        lcnextst = this.sourcetokenlist.nextsolidtoken(i, 2, false);
                        lcnextst2 = this.sourcetokenlist.nextsolidtoken(i, 3, false);
                        if (lcnextst == null || lcnextst2 == null) break block90;
                        switch (1.$SwitchMap$gudusoft$gsqlparser$EDataType[dataType.ordinal()]) {
                            case 1: {
                                if (lcprevst.tokencode != 262 && lcprevst.tokencode != 263) {
                                    if (lcprevst.tokencode == 261 || lcprevst.tokencode == 41 || lcprevst.tokencode == 561 || lcprevst.tokencode == 313) ** break;
                                    if (lcnextst.tokencode != 44 || TDatatypeAttribute.searchDataTypeAttributeByName(lcnextst2.toString()) == null) {
                                        lcprevst2 = this.sourcetokenlist.nextsolidtoken(i, -2, false);
                                        if (lcprevst2 != null && lcprevst2.tokencode == 528) ** break;
                                        ast.tokencode = 40;
                                        ** break;
                                    }
                                }
                                break block90;
                            }
                            case 2: 
                            case 3: 
                            case 4: {
                                if (lcnextst.tokencode == 262) {
                                    ast.tokencode = 40;
                                    ** break;
                                }
                                break block90;
                            }
                            case 5: {
                                ast.tokencode = 40;
                                ** break;
                            }
                            case 6: {
                                if (lcnextst2.tokencode != 263) {
                                    ast.tokencode = 40;
                                    ** break;
                                }
                                break block90;
                            }
                        }
lbl57:
                        // 7 sources

                        break block90;
                    }
                    lcstr = lcnextst.toString();
                    if (lcnextst.tokencode == 321 || lcnextst.tokencode == 285) {
                        lcnextst = this.sourcetokenlist.nextsolidtoken(i, 2, false);
                        lcstr = lcnextst != null ? lcstr + "_" + lcnextst.toString() : lcstr + "_";
                    }
                    if (TDatatypeAttribute.searchDataTypeAttributeByName(lcstr) != null) {
                        ast.tokencode = 558;
                    }
                    break block90;
                }
                if (ast.tokencode == 306) {
                    nextToken = ast.searchTokenAfterObjectName();
                    if (nextToken != null && nextToken.tokencode == 341) {
                        ast.tokencode = 563;
                    }
                } else if (ast.tokencode == 564) {
                    nextToken = ast.searchToken(40, 1);
                    if (nextToken != null) {
                        ast.tokencode = 565;
                    }
                } else if (ast.tokencode == 559) {
                    nextToken = ast.searchToken(40, 1);
                    if (nextToken == null) {
                        if (ast.prevSolidToken() == null) {
                            ast.tokencode = 264;
                        } else if (!ast.prevSolidToken().toString().equalsIgnoreCase("anchor")) {
                            ast.tokencode = 264;
                        }
                    }
                } else if (ast.tokencode == 566) {
                    lcprevst = this.getprevsolidtoken(ast);
                    if (lcprevst != null && lcprevst.tokencode == 313) {
                        lcprevst.tokencode = 567;
                    }
                } else if (ast.tokencode == 505) {
                    nextToken = ast.searchToken(40, 1);
                    if (nextToken != null) {
                        ast.tokencode = 264;
                    }
                } else if (ast.tokencode == 350 && (nextToken = ast.nextSolidToken()) != null && (nextToken.tokencode == 351 || nextToken.tokencode == 313)) {
                    nextToken.tokencode = 264;
                }
            }
            switch (1.$SwitchMap$gudusoft$gsqlparser$EFindSqlStateType[gst.ordinal()]) {
                case 1: {
                    if (ast.tokentype == ETokenType.ttsemicolon) {
                        this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block16;
                    }
                    this.gcurrentsqlstatement.sourcetokenlist.add(ast);
                    continue block16;
                }
                case 10: {
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode == 59 && ast.lastTokenOfLine()) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block16;
                    }
                    if (!ast.lastTokenOfLine()) continue block16;
                    cmdstr = this.gcurrentsqlstatement.sourcetokenlist.get(0).toString();
                    if (this.gcurrentsqlstatement.sourcetokenlist.size() > 1) {
                        cmdstr = cmdstr + this.gcurrentsqlstatement.sourcetokenlist.get(1).toString();
                    }
                    if (!cmdstr.toLowerCase().startsWith(".if")) continue block16;
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    gst = EFindSqlStateType.stnormal;
                    continue block16;
                }
                case 11: {
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode != 59 || !ast.lastTokenOfLine()) continue block16;
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    gst = EFindSqlStateType.stnormal;
                    continue block16;
                }
                case 12: {
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode == 59 && ast.lastTokenOfLine()) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block16;
                    }
                    if (ast.tokencode != 260 || (nextst = ast.nextSolidToken()) == null) continue block16;
                    if (nextst.tokencode == 282) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stFastLoadCmd;
                        continue block16;
                    }
                    if (nextst.tokencode == 46) {
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stFastLoadCmd;
                        continue block16;
                    }
                    if (this.sqlcmds.issql(nextst, this.dbVendor, gst, this.gcurrentsqlstatement) == null) continue block16;
                    this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                    gst = EFindSqlStateType.stnormal;
                    continue block16;
                }
                case 13: {
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    if (ast.tokencode == 260) {
                        if (isContinueBTEQCmd) {
                            isContinueBTEQCmd = false;
                            continue block16;
                        }
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        gst = EFindSqlStateType.stnormal;
                        continue block16;
                    }
                    if (ast.tokencode == 45 && ast.lastTokenOfLine()) {
                        if (inBTEQComment) continue block16;
                        isContinueBTEQCmd = true;
                        continue block16;
                    }
                    if (ast.tokencode == 259) continue block16;
                    if (ast.tokencode == 42) {
                        if (inBTEQComment) {
                            inBTEQComment = false;
                            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                            gst = EFindSqlStateType.stnormal;
                        }
                        isContinueBTEQCmd = false;
                        continue block16;
                    }
                    isContinueBTEQCmd = false;
                    continue block16;
                }
                case 2: {
                    if (ast.tokencode == 258 || ast.tokencode == 257 || ast.tokencode == 259 || ast.tokencode == 260 || ast.tokentype == ETokenType.ttsemicolon) {
                        if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        if (lcprevsolidtoken == null || ast.tokentype != ETokenType.ttsemicolon || lcprevsolidtoken.tokentype != ETokenType.ttsemicolon) continue block16;
                        ast.tokentype = ETokenType.ttsimplecomment;
                        ast.tokencode = 258;
                        continue block16;
                    }
                    if (ast.tokencode == 282) {
                        gst = ((TLexerTeradata)this.getFlexer()).cmdType(ast.astext.substring(1));
                        if (gst == EFindSqlStateType.stnormal) {
                            gst = EFindSqlStateType.stBTEQCmd;
                        }
                        this.gcurrentsqlstatement = new TTeradataBTEQCmd(this.dbVendor);
                        ((TTeradataBTEQCmd)this.gcurrentsqlstatement).setFindSqlStateType(gst);
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        continue block16;
                    }
                    if (ast.tokencode == 46 && ast.firstTokenOfLine()) {
                        nextst = ast.nextSolidToken();
                        if (nextst != null && (gst = ((TLexerTeradata)this.getFlexer()).cmdType(nextst.astext)) != EFindSqlStateType.stnormal) {
                            this.gcurrentsqlstatement = new TTeradataBTEQCmd(this.dbVendor);
                            ((TTeradataBTEQCmd)this.gcurrentsqlstatement).setFindSqlStateType(gst);
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            continue block16;
                        }
                    } else {
                        if (ast.tokencode == 42 && ast.firstTokenOfLine()) {
                            gst = EFindSqlStateType.stBTEQCmd;
                            inBTEQComment = true;
                            this.gcurrentsqlstatement = new TTeradataBTEQCmd(this.dbVendor);
                            ((TTeradataBTEQCmd)this.gcurrentsqlstatement).setFindSqlStateType(gst);
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            continue block16;
                        }
                        if (ast.tokencode == 61 && ast.firstTokenOfLine()) {
                            st1 = ast.prevSolidToken();
                            if (st1 != null && st1.tokencode == 59) {
                                gst = EFindSqlStateType.stBTEQCmd;
                                this.gcurrentsqlstatement = new TTeradataBTEQCmd(this.dbVendor);
                                ((TTeradataBTEQCmd)this.gcurrentsqlstatement).setFindSqlStateType(gst);
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                continue block16;
                            }
                        } else if (ast.firstTokenOfLine()) {
                            gst = ((TLexerTeradata)this.getFlexer()).cmdType(ast.astext);
                            if (gst == EFindSqlStateType.stMultiLoadCmd || gst == EFindSqlStateType.stFastLoadCmd || gst == EFindSqlStateType.stFastExportCmd) {
                                this.gcurrentsqlstatement = new TTeradataBTEQCmd(this.dbVendor);
                                ((TTeradataBTEQCmd)this.gcurrentsqlstatement).setFindSqlStateType(gst);
                                this.gcurrentsqlstatement.addtokentolist(ast);
                                continue block16;
                            }
                            gst = EFindSqlStateType.stnormal;
                        }
                    }
                    this.gcurrentsqlstatement = this.sqlcmds.issql(ast, this.dbVendor, gst, this.gcurrentsqlstatement);
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) {
                        ses = new ESqlStatementType[]{ESqlStatementType.sstteradatacreateprocedure, ESqlStatementType.sstteradatacreatefunction, ESqlStatementType.sstcreatetrigger};
                        if (this.includesqlstatementtype(this.gcurrentsqlstatement.sqlstatementtype, ses)) {
                            gst = EFindSqlStateType.ststoredprocedure;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                            if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstteradatacreateprocedure || this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstteradatacreatefunction || this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstcreatetrigger) {
                                this.curdelimiterchar = (char)59;
                            }
                        } else {
                            gst = EFindSqlStateType.stsql;
                            this.gcurrentsqlstatement.addtokentolist(ast);
                        }
                        lcNestedParens = 0;
                    }
                    if (TBaseType.assigned(this.gcurrentsqlstatement)) continue block16;
                    this.errormessage = "error when tokenlize:" + ast.astext + "(" + ast.lineNo + "," + ast.columnNo + ")";
                    errorcount = 1;
                    ast.tokentype = ETokenType.tttokenlizererrortoken;
                    gst = EFindSqlStateType.sterror;
                    this.gcurrentsqlstatement = new TUnknownSqlStatement(this.dbVendor);
                    this.gcurrentsqlstatement.sqlstatementtype = ESqlStatementType.sstinvalid;
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block16;
                }
                case 4: {
                    readyToEnd = true;
                    if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstteradatacreatemacro) {
                        if (ast.tokencode == 40 || ast.tokencode == 558) {
                            ++lcNestedParens;
                        }
                        if (ast.tokencode == 41 && --lcNestedParens < 0) {
                            lcNestedParens = 0;
                        }
                        v0 = readyToEnd = lcNestedParens == 0;
                    }
                    if (ast.tokentype == ETokenType.ttsemicolon && readyToEnd) {
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        this.gcurrentsqlstatement.semicolonended = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block16;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block16;
                }
                case 5: {
                    readyToEnd = true;
                    if (this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstcreatetrigger) {
                        if (ast.tokencode == 40 || ast.tokencode == 558) {
                            ++lcNestedParens;
                        }
                        if (ast.tokencode == 41 && --lcNestedParens < 0) {
                            lcNestedParens = 0;
                        }
                        v1 = readyToEnd = lcNestedParens == 0;
                    }
                    if (this.curdelimiterchar != this.delimiterchar) {
                        if (ast.tokencode == 351) {
                            this.curdelimiterchar = this.delimiterchar;
                        } else if (ast.tokencode == 276 && ast.container.nextsolidtoken((TSourceToken)ast, (int)1, (boolean)false).tokencode == 351) {
                            this.curdelimiterchar = this.delimiterchar;
                        }
                    }
                    if (this.curdelimiterchar == ';') {
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        if (!(ast.tokentype == ETokenType.ttsemicolon & this.gcurrentsqlstatement.sqlstatementtype == ESqlStatementType.sstcreatetrigger & readyToEnd)) continue block16;
                        gst = EFindSqlStateType.stnormal;
                        this.gcurrentsqlstatement._semicolon = ast;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block16;
                    }
                    ch = ast.astext.length() == 1 ? ast.astext.charAt(0) : (ast.astext.length() > 1 ? (char)ast.astext.charAt(ast.astext.length() - 1) : ' ');
                    if (ast.tokencode != 257 && ast.tokencode != 258 && ch == this.curdelimiterchar && ast.firstTokenOfLine()) {
                        if (ast.astext.length() > 1) {
                            lcstr = ast.astext.substring(0, ast.astext.length() - 1);
                            c = this.flexer.getkeywordvalue(lcstr);
                            if (c > 0) {
                                ast.tokencode = c;
                            }
                        } else {
                            this.gcurrentsqlstatement._semicolon = ast;
                        }
                        this.gcurrentsqlstatement.addtokentolist(ast);
                        gst = EFindSqlStateType.stnormal;
                        this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
                        continue block16;
                    }
                    this.gcurrentsqlstatement.addtokentolist(ast);
                    continue block16;
                }
            }
        }
        if (TBaseType.assigned(this.gcurrentsqlstatement) && (gst == EFindSqlStateType.stsql || gst == EFindSqlStateType.stBTEQCmd || gst == EFindSqlStateType.ststoredprocedure || gst == EFindSqlStateType.sterror)) {
            this.doongetrawsqlstatementevent(this.gcurrentsqlstatement);
        }
        return errorcount;
    }

    int dogetrawsqlstatements() {
        this.sqlstatements.clear();
        if (this.sourcetokenlist.size() == 0) {
            return -1;
        }
        switch (this.dbVendor) {
            case dbvmssql: {
                return this.domssqlgetrawsqlstatements();
            }
            case dbvsybase: {
                return this.dosybasegetrawsqlstatements();
            }
            case dbvinformix: {
                return this.doinformixgetrawsqlstatements();
            }
            case dbvoracle: {
                return this.dooraclegetrawsqlstatements();
            }
            case dbvdb2: {
                return this.dodb2getrawsqlstatements();
            }
            case dbvmysql: {
                return this.domysqlgetrawsqlstatements();
            }
            case dbvteradata: {
                return this.doteradatagetrawsqlstatements();
            }
            case dbvpostgresql: {
                return this.dopostgresqlgetrawsqlstatements();
            }
            case dbvredshift: {
                return this.doredshiftgetrawsqlstatements();
            }
            case dbvgreenplum: {
                return this.dogreenplumgetrawsqlstatements();
            }
            case dbvmdx: {
                return this.domdxgetrawsqlstatements();
            }
            case dbvnetezza: {
                return this.donetezzagetrawsqlstatements();
            }
            case dbvhive: {
                return this.dohivegetrawsqlstatements();
            }
            case dbvimpala: {
                return this.doimpalagetrawsqlstatements();
            }
            case dbvhana: {
                return this.dohanagetrawsqlstatements();
            }
            case dbvdax: {
                return this.dodaxgetrawsqlstatements();
            }
            case dbvodbc: {
                return this.doodbcgetrawsqlstatements();
            }
            case dbvvertica: {
                return this.doverticagetrawsqlstatements();
            }
            case dbvopenedge: {
                return this.domssqlgetrawsqlstatements();
            }
            case dbvcouchbase: {
                return this.docouchbasegetrawsqlstatements();
            }
            case dbvsnowflake: {
                return this.dosnowflakegetrawsqlstatements();
            }
            case dbvbigquery: {
                return this.dobigquerygetrawsqlstatements();
            }
        }
        return this.domssqlgetrawsqlstatements();
    }

    public int getrawsqlstatements() {
        int ret = this.readsql();
        if (ret != 0) {
            return ret;
        }
        this.dosqltexttotokenlist();
        return this.dogetrawsqlstatements();
    }

    public void tokenizeSqltext() {
        this.readsql();
        this.dosqltexttotokenlist();
    }

    void findAllSyntaxErrorsInPlsql(TCustomSqlStatement psql) {
        if (psql.getErrorCount() > 0) {
            this.copyerrormsg(psql);
        }
        for (int k = 0; k < psql.getStatements().size(); ++k) {
            this.findAllSyntaxErrorsInPlsql(psql.getStatements().get(k));
        }
    }

    public TSQLEnv getSqlEnv() {
        return this.sqlEnv;
    }

    public void setSqlEnv(TSQLEnv sqlEnv) {
        this.sqlEnv = sqlEnv;
    }

    int doparse() {
        int ret = this.getrawsqlstatements();
        boolean isPushGloablStack = false;
        if (ret != 0) {
            return ret;
        }
        TStackFrame firstFrame = null;
        if (this.getFrameStack().size() == 0) {
            TGlobalScope globalScope = new TGlobalScope();
            globalScope.setSqlEnv(this.sqlEnv);
            firstFrame = new TStackFrame(globalScope);
            firstFrame.pushStack(this.getFrameStack());
            isPushGloablStack = true;
        }
        for (int i = 0; i < this.sqlstatements.size(); ++i) {
            int k;
            boolean doRecover;
            this.sqlstatements.get(i).setFrameStack(this.frameStack);
            int j = this.sqlstatements.get(i).parsestatement(null, false);
            TCustomSqlStatement sql0 = null;
            if (this.sqlstatements.get(i).isoracleplsql()) {
                sql0 = this.sqlstatements.get(i);
                this.findAllSyntaxErrorsInPlsql(sql0);
            }
            if ((doRecover = true) && (j != 0 || this.sqlstatements.get(i).getErrorCount() > 0)) {
                if (this.sqlstatements.get((int)i).sqlstatementtype == ESqlStatementType.sstcreatetable || this.sqlstatements.get((int)i).sqlstatementtype == ESqlStatementType.sstcreateindex && this.dbVendor != EDbVendor.dbvcouchbase) {
                    TCustomSqlStatement errorSqlStatement = this.sqlstatements.get(i);
                    int nested = 0;
                    boolean isIgnore = false;
                    boolean isFoundIgnoreToken = false;
                    for (k = 0; k < errorSqlStatement.sourcetokenlist.size(); ++k) {
                        TSourceToken st = errorSqlStatement.sourcetokenlist.get(k);
                        if (isIgnore) {
                            if (st.issolidtoken() && st.tokencode != 59) {
                                isFoundIgnoreToken = true;
                            }
                            if (st.tokencode == 59) continue;
                            st.tokencode = 273;
                            continue;
                        }
                        if (st.tokencode == 41 && --nested == 0) {
                            TSourceToken st2;
                            boolean isSelect = false;
                            TSourceToken st1 = st.searchToken(341, 1);
                            if (st1 != null && (st2 = st.searchToken(40, 2)) != null) {
                                TSourceToken st3 = st.searchToken(301, 3);
                                boolean bl = isSelect = st3 != null;
                            }
                            if (!isSelect) {
                                isIgnore = true;
                            }
                        }
                        if (st.tokencode != 40 && st.tokencode != 558) continue;
                        ++nested;
                    }
                    if (isFoundIgnoreToken) {
                        errorSqlStatement.clearError();
                        j = this.sqlstatements.get(i).parsestatement(null, false);
                    }
                }
                if ((this.sqlstatements.get((int)i).sqlstatementtype == ESqlStatementType.sstcreatetrigger || this.sqlstatements.get((int)i).sqlstatementtype == ESqlStatementType.sstdb2createfunction || this.sqlstatements.get((int)i).sqlstatementtype == ESqlStatementType.sstdb2createprocedure) && this.dbVendor == EDbVendor.dbvdb2) {
                    TCustomSqlStatement stmt = this.sqlstatements.get(i);
                    StringBuffer stmtStr = new StringBuffer(1024);
                    for (int k2 = 0; k2 < stmt.sourcetokenlist.size(); ++k2) {
                        stmtStr.append(stmt.sourcetokenlist.get((int)k2).astext);
                    }
                    TGSqlParser lc_sqlparser = new TGSqlParser(EDbVendor.dbvoracle);
                    lc_sqlparser.sqltext = stmtStr.toString();
                    int iRet = lc_sqlparser.parse();
                    if (iRet == 0) {
                        this.sqlstatements.remove(i);
                        this.sqlstatements.add(i, lc_sqlparser.sqlstatements.get(0));
                        continue;
                    }
                }
            }
            if (j == 0 && this.sqlstatements.get(i).getErrorCount() <= 0) continue;
            this.copyerrormsg(this.sqlstatements.get(i));
            if (!this.isEnablePartialParsing() || this.dbVendor != EDbVendor.dbvsybase || this.sqlstatements.get((int)i).sqlstatementtype != ESqlStatementType.sstmssqlcreateprocedure) continue;
            TMssqlCreateProcedure createProcedure = (TMssqlCreateProcedure)this.sqlstatements.get(i);
            StringBuffer storedProcedure = new StringBuffer(1024);
            boolean ASKeyword = false;
            for (int k3 = 0; k3 < createProcedure.sourcetokenlist.size(); ++k3) {
                if (!ASKeyword && createProcedure.sourcetokenlist.get((int)k3).tokencode == 341) {
                    ASKeyword = true;
                    continue;
                }
                if (!ASKeyword) continue;
                storedProcedure.append(createProcedure.sourcetokenlist.get((int)k3).astext);
            }
            TGSqlParser lc_sqlparser = new TGSqlParser(this.dbVendor);
            lc_sqlparser.sqltext = storedProcedure.toString();
            lc_sqlparser.parse();
            for (k = 0; k < lc_sqlparser.sqlstatements.size(); ++k) {
                createProcedure.getBodyStatements().add(lc_sqlparser.sqlstatements.get(k));
            }
        }
        if (isPushGloablStack) {
            firstFrame.popStack(this.getFrameStack());
        }
        return this.getErrorCount();
    }

    void copyerrormsg(TCustomSqlStatement sql) {
        for (int i = 0; i < sql.fsyntaxerrors.size(); ++i) {
            this.syntaxErrors.add(new TSyntaxError((TSyntaxError)sql.fsyntaxerrors.get(i)));
        }
    }

    private static String calculateLicenseKey(boolean ignoreMachineId) {
        if (userName == null) {
            return null;
        }
        if (machineId == null) {
            return null;
        }
        byte[] bytesOfMessage = null;
        String licenseStr = "I love sql pretty printer, yeah!" + userName.toLowerCase();
        if (!ignoreMachineId) {
            licenseStr = licenseStr + machineId.toLowerCase();
        }
        try {
            bytesOfMessage = licenseStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] digest = md.digest(bytesOfMessage);
        return null;
    }

    private static boolean validateLicense() {
        boolean ret = false;
        return !ret;
    }

    private static boolean check_license_time() {
        Date toDt;
        boolean ret = false;
        String toDate = "2116-11-19";
        DateFormat df = DateFormat.getDateInstance(3);
        Calendar currDtCal = Calendar.getInstance();
        currDtCal.set(11, 0);
        currDtCal.set(12, 0);
        currDtCal.set(13, 0);
        currDtCal.set(14, 0);
        Date currDt = currDtCal.getTime();
        try {
            toDt = df.parse(toDate);
        }
        catch (ParseException e) {
            toDt = null;
        }
        if (toDt != null) {
            int results = toDt.compareTo(currDt);
            ret = results > 0;
        }
        return ret;
    }

    static {
        machineId = null;
        licenseOK = false;
        licenseOK = TGSqlParser.validateLicense();
    }

    static enum stored_procedure_type {
        function,
        procedure,
        package_spec,
        package_body,
        block_with_begin,
        block_with_declare,
        create_trigger,
        create_library,
        others;

    }

    static enum stored_procedure_status {
        start,
        is_as,
        body,
        bodyend,
        end;

    }
}

