/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser;

import gudusoft.gsqlparser.EActionOnParseError;
import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.EErrorType;
import gudusoft.gsqlparser.EJoinType;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TBaseType;
import gudusoft.gsqlparser.TCustomParser;
import gudusoft.gsqlparser.TGlobalScope;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.TStackFrame;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.TStmtScope;
import gudusoft.gsqlparser.TSymbolTableManager;
import gudusoft.gsqlparser.TSymbolVariable;
import gudusoft.gsqlparser.TSyntaxError;
import gudusoft.gsqlparser.nodes.TCTE;
import gudusoft.gsqlparser.nodes.TCTEList;
import gudusoft.gsqlparser.nodes.TColumnWithSortOrder;
import gudusoft.gsqlparser.nodes.TFromTable;
import gudusoft.gsqlparser.nodes.TJoin;
import gudusoft.gsqlparser.nodes.TJoinExpr;
import gudusoft.gsqlparser.nodes.TJoinItem;
import gudusoft.gsqlparser.nodes.TJoinList;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TOutputClause;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParameterDeclaration;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TResultColumn;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.nodes.TReturningClause;
import gudusoft.gsqlparser.nodes.TSymbolTableItem;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.TTableHint;
import gudusoft.gsqlparser.nodes.TTableList;
import gudusoft.gsqlparser.nodes.TTopClause;
import gudusoft.gsqlparser.nodes.TVarDeclStmt;
import gudusoft.gsqlparser.nodes.TWhereClause;
import gudusoft.gsqlparser.nodes.dax.TDaxFunction;
import gudusoft.gsqlparser.sqlenv.TSQLEnv;
import gudusoft.gsqlparser.sqlenv.TSQLFunction;
import gudusoft.gsqlparser.stmt.TCommonBlock;
import gudusoft.gsqlparser.stmt.TCommonStoredProcedureSqlStatement;
import gudusoft.gsqlparser.stmt.TCreateTriggerStmt;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;
import gudusoft.gsqlparser.stmt.TMergeSqlStatement;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.dax.TDaxStmt;
import gudusoft.gsqlparser.stmt.hive.THiveFromQuery;
import gudusoft.gsqlparser.stmt.oracle.TPlsqlCreateFunction;
import gudusoft.gsqlparser.stmt.oracle.TPlsqlCreateProcedure;
import gudusoft.gsqlparser.stmt.oracle.TPlsqlCreateTrigger;
import gudusoft.gsqlparser.util.functionChecker;
import gudusoft.gsqlparser.util.keywordChecker;
import java.util.ArrayList;
import java.util.Stack;

public class TCustomSqlStatement
extends TParseTreeNode {
    private Stack<TStackFrame> frameStack;
    private TPTNodeList<TColumnWithSortOrder> indexColumns = null;
    private Stack<TObjectName> variableStack = null;
    private Stack<TDaxFunction> daxFunctionStack = null;
    private TObjectName labelName;
    private TObjectName endlabelName;
    public ESqlStatementType sqlstatementtype;
    public TSourceTokenList sourcetokenlist;
    public EDbVendor dbvendor;
    public TCustomParser parser;
    public TCustomParser plsqlparser;
    public int dummytag;
    private TTable targetTable;
    public TJoinList joins;
    public TTableList tables;
    private TStatementList statements;
    private TCTEList cteList = null;
    private TResultColumnList resultColumnList = null;
    private TWhereClause whereClause = null;
    private TTopClause topClause = null;
    private TOutputClause outputClause = null;
    private TReturningClause returningClause = null;
    private boolean alreadyAddToParent = false;
    private TCustomSqlStatement ancestorStmt = null;
    private TCustomSqlStatement parentStmt = null;
    public TParseTreeNode rootNode;
    private Stack symbolTable = null;
    TSourceToken semicolonended;
    boolean isctequery;
    ArrayList fsyntaxerrors;
    protected boolean isparsed;
    TSourceToken _semicolon;
    protected TStmtScope stmtScope = null;
    private TObjectNameList orphanColumns = null;

    public TSQLFunction searchFunctionInSQLEnv(String functionName) {
        if (this.getSqlEnv() == null) {
            return null;
        }
        return this.getSqlEnv().searchFunction(functionName);
    }

    public TSQLEnv getSqlEnv() {
        if (this.getGlobalScope() == null) {
            return null;
        }
        return this.getGlobalScope().getSqlEnv();
    }

    public TGlobalScope getGlobalScope() {
        TGlobalScope lcResult = null;
        if (this.frameStack != null && this.frameStack.get(0) != null) {
            lcResult = (TGlobalScope)((TStackFrame)this.frameStack.get(0)).getScope();
        }
        return lcResult;
    }

    public void setFrameStack(Stack<TStackFrame> frameStack) {
        this.frameStack = frameStack;
    }

    public Stack<TStackFrame> getFrameStack() {
        return this.frameStack;
    }

    public TPTNodeList<TColumnWithSortOrder> getIndexColumns() {
        return this.indexColumns;
    }

    public void setVariableStack(Stack<TObjectName> variableStack) {
        this.variableStack = variableStack;
    }

    public Stack<TObjectName> getVariableStack() {
        if (this.variableStack == null) {
            this.variableStack = new Stack();
        }
        return this.variableStack;
    }

    public Stack<TDaxFunction> getDaxFunctionStack() {
        if (this.daxFunctionStack == null) {
            this.daxFunctionStack = new Stack();
        }
        return this.daxFunctionStack;
    }

    public void setLabelName(TObjectName lName) {
        this.labelName = lName;
        if (this.labelName != null) {
            this.labelName.setObjectType(14);
        }
    }

    public TObjectName getLabelName() {
        return this.labelName;
    }

    public void setEndlabelName(TObjectName endlabelName) {
        this.endlabelName = endlabelName;
    }

    public TObjectName getEndlabelName() {
        return this.endlabelName;
    }

    public TTable getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(TTable targetTable) {
        this.targetTable = targetTable;
    }

    public TJoinList getJoins() {
        return this.joins;
    }

    public TTableList getTables() {
        return this.tables;
    }

    public TStatementList getStatements() {
        if (this.statements == null) {
            this.statements = new TStatementList();
        }
        return this.statements;
    }

    public void setCteList(TCTEList cteList) {
        this.cteList = cteList;
    }

    public TCTEList getCteList() {
        return this.cteList;
    }

    public void setResultColumnList(TResultColumnList resultColumnList) {
        this.resultColumnList = resultColumnList;
    }

    public TResultColumnList getResultColumnList() {
        return this.resultColumnList;
    }

    public void setReturningClause(TReturningClause returningClause) {
        this.returningClause = returningClause;
    }

    public TReturningClause getReturningClause() {
        return this.returningClause;
    }

    public void setOutputClause(TOutputClause outputClause) {
        this.outputClause = outputClause;
    }

    public TOutputClause getOutputClause() {
        return this.outputClause;
    }

    public void setTopClause(TTopClause topClause) {
        this.topClause = topClause;
    }

    public TTopClause getTopClause() {
        return this.topClause;
    }

    public void setWhereClause(TWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    public TWhereClause addWhereClause(String condition) {
        return this.whereClause;
    }

    public TWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setAlreadyAddToParent(boolean alreadyAddToParent) {
        this.alreadyAddToParent = alreadyAddToParent;
    }

    private boolean ableToIncludeCTE(ESqlStatementType sst) {
        return sst == ESqlStatementType.sstselect || sst == ESqlStatementType.sstupdate || sst == ESqlStatementType.sstinsert || sst == ESqlStatementType.sstdelete;
    }

    protected TCTEList searchCTEList() {
        TCTEList ret = null;
        if (this.cteList != null) {
            return this.cteList;
        }
        TCustomSqlStatement lcParent = this.parentStmt;
        while (lcParent != null && this.ableToIncludeCTE(lcParent.sqlstatementtype) && (ret = lcParent.cteList) == null) {
            lcParent = lcParent.parentStmt;
        }
        return ret;
    }

    public TCustomSqlStatement getParentStmt() {
        return this.parentStmt;
    }

    public void setParentStmt(TCustomSqlStatement parentStmt) {
        if (!this.alreadyAddToParent) {
            this.parentStmt = parentStmt;
            parentStmt.getStatements().add(this);
            this.alreadyAddToParent = true;
        }
    }

    public TCustomSqlStatement getAncestorStmt() {
        TCustomSqlStatement lcRet = this;
        while (lcRet.getParentStmt() != null) {
            lcRet = lcRet.getParentStmt();
        }
        return lcRet;
    }

    public Stack getSymbolTable() {
        if (this.symbolTable == null) {
            this.symbolTable = new Stack();
        }
        return this.symbolTable;
    }

    public int getErrorCount() {
        return this.fsyntaxerrors.size();
    }

    public TCustomSqlStatement(EDbVendor dbvendor) {
        this.dbvendor = dbvendor;
        this.sqlstatementtype = ESqlStatementType.sstunknown;
        this.dummytag = 0;
        this.sourcetokenlist = new TSourceTokenList();
        this.fsyntaxerrors = new ArrayList();
        this.tables = new TTableList();
        this.joins = new TJoinList();
        this.indexColumns = new TPTNodeList();
    }

    public EActionOnParseError parseerrormessagehandle(TSyntaxError se) {
        this.fsyntaxerrors.add(se);
        return EActionOnParseError.aopcontinue;
    }

    public int parsestatement(TCustomSqlStatement pparentsql, boolean isparsetreeavailable) {
        int ret = 0;
        this.isparsed = false;
        if (!isparsetreeavailable) {
            ret = this.checksyntax(pparentsql);
        }
        if (ret == 0) {
            this.isparsed = true;
            ret = this.doParseStatement(pparentsql);
        } else if (this.dbvendor == EDbVendor.dbvsybase && this.rootNode != null && (this.sqlstatementtype == ESqlStatementType.sstmssqlcreateprocedure || this.sqlstatementtype == ESqlStatementType.sstmssqlcreatefunction || this.sqlstatementtype == ESqlStatementType.sstcreatetrigger)) {
            this.doParseStatement(pparentsql);
        }
        return ret;
    }

    public boolean OracleStatementCanBeSeparatedByBeginEndPair() {
        return this.sqlstatementtype == ESqlStatementType.sstplsql_createprocedure || this.sqlstatementtype == ESqlStatementType.sstplsql_createfunction || this.sqlstatementtype == ESqlStatementType.sstplsql_createpackage || this.sqlstatementtype == ESqlStatementType.sstplsql_createtype_placeholder || this.sqlstatementtype == ESqlStatementType.sstoraclecreatepackagebody || this.sqlstatementtype == ESqlStatementType.sstplsql_createtrigger || this.sqlstatementtype == ESqlStatementType.sstplsql_varraytypedef || this.sqlstatementtype == ESqlStatementType.sstplsql_createprocedure || this.sqlstatementtype == ESqlStatementType.sstplsql_execimmestmt || this.sqlstatementtype == ESqlStatementType.sstoraclecreatelibrary;
    }

    public boolean VerticaStatementCanBeSeparatedByBeginEndPair() {
        return this.sqlstatementtype == ESqlStatementType.sstcreatefunction;
    }

    public boolean isnzplsql() {
        return false;
    }

    public boolean ispgplsql() {
        return this instanceof TCommonBlock;
    }

    public boolean isverticaplsql() {
        return this.sqlstatementtype == ESqlStatementType.sstcreatefunction;
    }

    public boolean isoracleplsql() {
        return this.sqlstatementtype == ESqlStatementType.sst_block_with_label || this.sqlstatementtype == ESqlStatementType.sstplsql_createprocedure || this.sqlstatementtype == ESqlStatementType.sstplsql_createfunction || this.sqlstatementtype == ESqlStatementType.sstplsql_createpackage || this.sqlstatementtype == ESqlStatementType.sstplsql_createtype_placeholder || this.sqlstatementtype == ESqlStatementType.sstoraclecreatepackagebody || this.sqlstatementtype == ESqlStatementType.sstplsql_createtrigger || this.sqlstatementtype == ESqlStatementType.sstplsql_createtypebody || this.sqlstatementtype == ESqlStatementType.sstplsql_tabletypedef || this.sqlstatementtype == ESqlStatementType.sstplsql_varraytypedef || this.sqlstatementtype == ESqlStatementType.sstplsql_createprocedure || this.sqlstatementtype == ESqlStatementType.sstplsql_execimmestmt || this.sqlstatementtype == ESqlStatementType.sstoraclecreatelibrary;
    }

    int checksyntax(TCustomSqlStatement psql) {
        return this.dochecksyntax(psql);
    }

    protected int dochecksyntax(TCustomSqlStatement psql) {
        int ret = -1;
        this.clear();
        if (this.sourcetokenlist.size() == 0) {
            return ret;
        }
        if (this.isoracleplsql() && this.plsqlparser != null) {
            this.plsqlparser.sql = this;
            this.plsqlparser.sourcetokenlist = this.sourcetokenlist;
            if (this instanceof TCommonStoredProcedureSqlStatement && ((TCommonStoredProcedureSqlStatement)this).isWrapped()) {
                ret = 0;
                this.rootNode = this;
            } else {
                ret = this.plsqlparser.yyparse();
                this.rootNode = this.plsqlparser.rootNode;
            }
        } else {
            if (this.sqlstatementtype == ESqlStatementType.sstExplain && this.dbvendor != EDbVendor.dbvhana) {
                for (int k = 0; k < this.sourcetokenlist.size(); ++k) {
                    TSourceToken st = this.sourcetokenlist.get(k);
                    if (this.dbvendor == EDbVendor.dbvoracle) {
                        if (st.tokencode == 306) {
                            st.tokencode = 273;
                            break;
                        }
                    } else if (this.dbvendor == EDbVendor.dbvredshift) {
                        if (st.tokencode == 471) {
                            st.tokencode = 273;
                            TSourceToken nextst = st.nextSolidToken();
                            if (nextst.tokencode != 532) break;
                            nextst.tokencode = 273;
                            break;
                        }
                    } else if (this.dbvendor == EDbVendor.dbvvertica) {
                        if (st.tokencode == 301 || st.tokencode == 302 || st.tokencode == 304 || st.tokencode == 418) {
                            break;
                        }
                    } else if (this.dbvendor == EDbVendor.dbvmysql) {
                        if (st.tokencode == 301 || st.tokencode == 302 || st.tokencode == 304 || st.tokencode == 303 || st.tokencode == 505 || st.tokencode == 40) {
                            break;
                        }
                    } else if (this.dbvendor == EDbVendor.dbvcouchbase && st.tokencode == 471) {
                        st.tokencode = 273;
                        break;
                    }
                    st.tokencode = 273;
                }
            } else if (this.sqlstatementtype == ESqlStatementType.sstProfile) {
                for (int k = 0; k < this.sourcetokenlist.size(); ++k) {
                    TSourceToken st = this.sourcetokenlist.get(k);
                    if (this.dbvendor != EDbVendor.dbvvertica || st.tokencode != 301 && st.tokencode != 302 && st.tokencode != 304 && st.tokencode != 418) {
                        st.tokencode = 273;
                        continue;
                    }
                    break;
                }
            } else if (this.sqlstatementtype == ESqlStatementType.sstprepare && this.dbvendor == EDbVendor.dbvcouchbase) {
                int keywordCount = 0;
                for (int k = 0; k < this.sourcetokenlist.size(); ++k) {
                    TSourceToken st = this.sourcetokenlist.get(k);
                    if (st.tokencode == 491) {
                        ++keywordCount;
                    } else if (st.tokentype == ETokenType.ttkeyword && st.tokencode != 329 && st.tokencode != 341 && ++keywordCount > 1) break;
                    st.tokencode = 273;
                }
            }
            if (this.parser == null && psql != null) {
                this.parser = psql.getTopStatement().parser;
                this.setParentStmt(psql);
            }
            this.parser.sql = this;
            this.parser.sourcetokenlist = this.sourcetokenlist;
            ret = this.parser.yyparse();
            this.rootNode = this.parser.rootNode;
        }
        if (ret == 0) {
            ret = this.fsyntaxerrors.size();
        }
        if (this.rootNode == null) {
            ret = -1000;
            this.parseerrormessagehandle(new TSyntaxError("no root node", 0L, 0L, "no_root_node", EErrorType.sperror, -1000));
        }
        return ret;
    }

    public void clearError() {
        this.fsyntaxerrors.clear();
    }

    void clear() {
        this.fsyntaxerrors.clear();
    }

    void buildsql() {
    }

    public int doParseStatement(TCustomSqlStatement psql) {
        if (psql != null) {
            this.setParentStmt(psql);
            this.setFrameStack(psql.getFrameStack());
            this.stmtScope = new TStmtScope(psql.stmtScope, this);
        } else {
            this.stmtScope = new TStmtScope(this);
        }
        if (this.getStartToken() == null && this.rootNode != null) {
            this.setStartToken(this.rootNode.getStartToken());
        }
        if (this.getEndToken() == null && this.rootNode != null) {
            this.setEndToken(this.rootNode.getEndToken());
        }
        if (this.getGsqlparser() == null && this.rootNode != null) {
            this.setGsqlparser(this.rootNode.getGsqlparser());
        }
        return 0;
    }

    void addtokentolist(TSourceToken st) {
        st.stmt = this;
        this.sourcetokenlist.add(st);
    }

    public TTable analyzeTablename(TObjectName tableName) {
        TTable lcTable = new TTable();
        lcTable.setTableType(ETableSource.objectname);
        lcTable.setStartToken(tableName.getStartToken());
        lcTable.setEndToken(tableName.getEndToken());
        lcTable.setGsqlparser(this.getGsqlparser());
        lcTable.setTableName(tableName);
        this.tables.addTable(lcTable);
        return lcTable;
    }

    protected boolean isTableACTE(TTable pTable) {
        boolean lcResult = false;
        TCTEList cteList1 = this.getCteList();
        if (cteList1 == null) {
            for (TCustomSqlStatement lcStmt = this.getParentStmt(); lcStmt != null; lcStmt = lcStmt.getParentStmt()) {
                if (lcStmt.getCteList() == null) continue;
                cteList1 = lcStmt.getCteList();
                break;
            }
        }
        if (cteList1 == null) {
            return false;
        }
        TCTE lcCTE = cteList1.cteNames.get(TBaseType.getTextWithoutQuoted(pTable.toString()).toUpperCase());
        if (lcCTE != null) {
            pTable.setCTEName(true);
            pTable.setCTE(lcCTE);
            lcResult = true;
        }
        return lcResult;
    }

    public TTable findTable(ETableEffectType[] tableEffectTypes) {
        TTable lcResult = null;
        for (int i = 0; i < this.tables.size(); ++i) {
            for (int j = 0; j < tableEffectTypes.length; ++j) {
                if (this.tables.getTable(i).getEffectType() != tableEffectTypes[j]) continue;
                lcResult = this.tables.getTable(i);
                return lcResult;
            }
        }
        return lcResult;
    }

    public void addToTables(TTable pTable) {
        this.tables.addTable(pTable);
        if (this.isTableACTE(pTable)) {
            return;
        }
        if (pTable.getTableName() == null) {
            return;
        }
        if (pTable.getTableName().getTableToken() == null) {
            return;
        }
        if ((pTable.getTableName().getTableString().toString().equalsIgnoreCase("inserted") || pTable.getTableName().getTableString().toString().equalsIgnoreCase("deleted")) && (this.getAncestorStmt().sqlstatementtype == ESqlStatementType.sstcreatetrigger || this.getAncestorStmt().sqlstatementtype == ESqlStatementType.sstmssqlaltertrigger)) {
            ETableEffectType[] effectTypes = new ETableEffectType[]{ETableEffectType.tetTriggerOn, ETableEffectType.tetTriggerInsert, ETableEffectType.tetTriggerDelete, ETableEffectType.tetTriggerUpdate, ETableEffectType.tetTriggerInsteadOf};
            pTable.setLinkTable(this.getAncestorStmt().findTable(effectTypes));
        }
    }

    public TTable analyzeFromTable(TFromTable pfromTable, Boolean addToTableList) {
        TTable lcTable = new TTable();
        lcTable.setTableType(pfromTable.getFromtableType());
        lcTable.setAliasClause(pfromTable.getAliasClause());
        lcTable.setStartToken(pfromTable.getStartToken());
        lcTable.setEndToken(pfromTable.getEndToken());
        lcTable.setGsqlparser(pfromTable.getGsqlparser());
        lcTable.setTableHintList(pfromTable.getTableHintList());
        lcTable.setTableSample(pfromTable.getTableSample());
        lcTable.setLateralViewList(pfromTable.getLateralViewList());
        lcTable.setTableProperties(pfromTable.getTableProperties());
        lcTable.setPivotedTable(pfromTable.getPivotedTable());
        lcTable.setParenthesisCount(pfromTable.getParenthesisCount());
        lcTable.setParenthesisAfterAliasCount(pfromTable.getParenthesisAfterAliasCount());
        lcTable.setTableKeyword(pfromTable.isTableKeyword());
        lcTable.setOnlyKeyword(pfromTable.isOnlyKeyword());
        lcTable.setFlashback(pfromTable.getFlashback());
        lcTable.setPxGranule(pfromTable.getPxGranule());
        block0 : switch (lcTable.getTableType()) {
            case objectname: {
                boolean insertedInTrigger = false;
                if (this.getTopStatement().sqlstatementtype == ESqlStatementType.sstcreatetrigger) {
                    boolean bl = insertedInTrigger = pfromTable.getTableObjectName().toString().compareToIgnoreCase("inserted") == 0;
                }
                if (insertedInTrigger) {
                    lcTable.setTableName(((TCreateTriggerStmt)this.getTopStatement()).getOnTable().getTableName());
                    lcTable.setLinkTable(((TCreateTriggerStmt)this.getTopStatement()).getOnTable());
                } else {
                    lcTable.setTableName(pfromTable.getTableObjectName());
                }
                TCTEList lcCteList = this.searchCTEList();
                TCTE lcCte = null;
                if (lcCteList == null) break;
                for (int i = 0; i < lcCteList.size(); ++i) {
                    lcCte = lcCteList.getCTE(i);
                    if (lcCte.getTableName().toString().compareToIgnoreCase(lcTable.getTableName().toString()) != 0) continue;
                    lcTable.setCTEName(true);
                    lcTable.setCTE(lcCte);
                    lcTable.setCteColomnReferences(lcCte.getColumnList());
                    break block0;
                }
                break;
            }
            case tableExpr: {
                ESqlClause location = ESqlClause.tableExpr;
                if (this.sqlstatementtype == ESqlStatementType.sstinsert) {
                    // empty if block
                }
                lcTable.setTableExpr(pfromTable.getTableExpr());
                lcTable.getTableExpr().doParse(this, location);
                break;
            }
            case subquery: {
                lcTable.subquery = new TSelectSqlStatement(this.dbvendor);
                lcTable.subquery.rootNode = pfromTable.getSubquerynode();
                lcTable.subquery.setLocation(ESqlClause.elTable);
                lcTable.subquery.doParseStatement(this);
                break;
            }
            case function: {
                ESqlClause location = ESqlClause.tableFunction;
                if (this.sqlstatementtype == ESqlStatementType.sstinsert) {
                    // empty if block
                }
                lcTable.setFuncCall(pfromTable.getFuncCall());
                lcTable.getFuncCall().doParse(this, location);
                break;
            }
            case containsTable: {
                ESqlClause location = ESqlClause.containsTable;
                if (this.sqlstatementtype == ESqlStatementType.sstinsert) {
                    // empty if block
                }
                lcTable.setContainsTable(pfromTable.getContainsTable());
                lcTable.getContainsTable().doParse(this, location);
                break;
            }
            case openrowset: {
                ESqlClause location = ESqlClause.openrowset;
                if (this.sqlstatementtype == ESqlStatementType.sstinsert) {
                    // empty if block
                }
                lcTable.setOpenRowSet(pfromTable.getOpenRowSet());
                lcTable.getOpenRowSet().doParse(this, location);
                break;
            }
            case openxml: {
                ESqlClause location = ESqlClause.openxml;
                if (this.sqlstatementtype == ESqlStatementType.sstinsert) {
                    // empty if block
                }
                lcTable.setOpenXML(pfromTable.getOpenXML());
                lcTable.getOpenXML().doParse(this, location);
                break;
            }
            case opendatasource: {
                ESqlClause location = ESqlClause.opendatasource;
                if (this.sqlstatementtype == ESqlStatementType.sstinsert) {
                    // empty if block
                }
                lcTable.setOpenDatasource(pfromTable.getOpenDatasource());
                lcTable.getOpenDatasource().doParse(this, location);
                break;
            }
            case openquery: {
                ESqlClause location = ESqlClause.openquery;
                if (this.sqlstatementtype == ESqlStatementType.sstinsert) {
                    // empty if block
                }
                lcTable.setOpenquery(pfromTable.getOpenQuery());
                lcTable.getOpenquery().doParse(this, location);
                lcTable.setSubquery(lcTable.getOpenquery().getSubquery());
                break;
            }
            case datachangeTable: {
                ESqlClause location = ESqlClause.datachangeTable;
                if (this.sqlstatementtype == ESqlStatementType.sstinsert) {
                    // empty if block
                }
                lcTable.setDatachangeTable(pfromTable.getDatachangeTable());
                lcTable.getDatachangeTable().doParse(this, location);
                break;
            }
            case rowList: {
                ESqlClause location = ESqlClause.rowList;
                lcTable.setRowList(pfromTable.getRowList());
                lcTable.getRowList().doParse(this, location);
                break;
            }
            case pivoted_table: {
                ESqlClause location = ESqlClause.pivoted_table;
                lcTable.getPivotedTable().doParse(this, location);
                addToTableList = false;
                this.targetTable = lcTable;
                break;
            }
            case xmltable: {
                ESqlClause location = ESqlClause.xmltable;
                lcTable.setXmlTable(pfromTable.getXmlTable());
                lcTable.getXmlTable().doParse(this, location);
                break;
            }
            case informixOuter: {
                ESqlClause location = ESqlClause.outerTable;
                lcTable.setOuterClause(pfromTable.getOuterClause());
                lcTable.getOuterClause().doParse(this, location);
                break;
            }
            case table_ref_list: {
                lcTable.setFromTableList(pfromTable.getFromTableList());
                break;
            }
            case hiveFromQuery: {
                THiveFromQuery fromQuery = new THiveFromQuery(EDbVendor.dbvhive);
                fromQuery.rootNode = pfromTable.getFromQuerySqlNode();
                fromQuery.doParseStatement(this);
                lcTable.setHiveFromQuery(fromQuery);
                break;
            }
            case output_merge: {
                TMergeSqlStatement outputMerge = new TMergeSqlStatement(EDbVendor.dbvmssql);
                outputMerge.rootNode = pfromTable.getMergeSqlNode();
                outputMerge.doParseStatement(this);
                lcTable.setOutputMerge(outputMerge);
                break;
            }
            case td_unpivot: {
                pfromTable.getTdUnpivot().doParse(this, ESqlClause.tdUnPivot);
                lcTable.setTdUnpivot(pfromTable.getTdUnpivot());
                break;
            }
            case unnest: {
                pfromTable.getUnnestClause().doParse(this, ESqlClause.elTable);
                lcTable.setUnnestClause(pfromTable.getUnnestClause());
                break;
            }
            case jsonTable: {
                ESqlClause location = ESqlClause.jsonTable;
                lcTable.setJsonTable(pfromTable.getJsonTable());
                lcTable.getJsonTable().doParse(this, location);
                break;
            }
        }
        lcTable.setPartitionExtensionClause(pfromTable.getPartitionExtensionClause());
        if (addToTableList.booleanValue()) {
            this.addToTables(lcTable);
        }
        if (lcTable.getTableHintList() != null) {
            for (int i = 0; i < lcTable.getTableHintList().size(); ++i) {
                TTableHint hint = lcTable.getTableHintList().getElement(i);
                hint.setOwnerTable(lcTable);
                hint.doParse(this, ESqlClause.tableHint);
            }
        }
        if (lcTable.getAliasClause() != null && lcTable.getAliasClause().toString().equalsIgnoreCase("and")) {
            TSourceToken st1 = lcTable.getAliasClause().getStartToken();
            TSyntaxError err = new TSyntaxError(st1.toString(), st1.lineNo, st1.columnNo, String.format("AND keyword can't be table alias", new Object[0]), EErrorType.sperror, 10111);
            this.parseerrormessagehandle(err);
        }
        return lcTable;
    }

    public TJoin analyzeJoin(TJoinExpr pJoinExpr, TJoin pJoin, Boolean isSub) {
        TJoinExpr lcJoinItemJoinExpr;
        TTable lcTable;
        TJoin retval = pJoin;
        TJoinItem lcJoinItem = null;
        if (pJoinExpr == null) {
            return retval;
        }
        if (pJoinExpr.getJointype() == EJoinType.nested) {
            if (isSub.booleanValue()) {
                if (retval == null) {
                    retval = new TJoin();
                    retval.setStartToken(pJoinExpr.getStartToken());
                    retval.setEndToken(pJoinExpr.getEndToken());
                }
                pJoinExpr.setJointype(pJoinExpr.original_jontype);
                retval.setJoin(this.analyzeJoin(pJoinExpr, null, true));
                retval.setKind(3);
                retval.getJoin().setAliasClause(pJoinExpr.getAliasClause());
                retval.getJoin().setWithParen(true);
                retval.getJoin().setNestedParen(pJoinExpr.getNestedParen());
            } else {
                if (retval == null) {
                    retval = new TJoin();
                    retval.setStartToken(pJoinExpr.getStartToken());
                    retval.setEndToken(pJoinExpr.getEndToken());
                    retval.setGsqlparser(this.getGsqlparser());
                }
                pJoinExpr.setJointype(pJoinExpr.original_jontype);
                retval = this.analyzeJoin(pJoinExpr, retval, false);
                retval.setAliasClause(pJoinExpr.getAliasClause());
                retval.setWithParen(true);
                retval.setNestedParen(pJoinExpr.getNestedParen());
            }
            return retval;
        }
        if (pJoinExpr.getLeftOperand().getFromtableType() != ETableSource.join) {
            if (retval == null) {
                retval = new TJoin();
                retval.setStartToken(pJoinExpr.getStartToken());
                retval.setEndToken(pJoinExpr.getEndToken());
                retval.setGsqlparser(this.getGsqlparser());
            }
            lcTable = this.analyzeFromTable(pJoinExpr.getLeftOperand(), true);
            lcTable.setEffectType(ETableEffectType.tetSelect);
            retval.setTable(lcTable);
            retval.setKind(2);
        } else {
            lcJoinItemJoinExpr = pJoinExpr.getLeftOperand().getJoinExpr();
            retval = retval != null ? this.analyzeJoin(lcJoinItemJoinExpr, retval, true) : this.analyzeJoin(lcJoinItemJoinExpr, retval, isSub);
            retval.setStartToken(pJoinExpr.getStartToken());
            retval.setEndToken(pJoinExpr.getEndToken());
        }
        if (pJoinExpr.getRightOperand().getFromtableType() != ETableSource.join) {
            if (retval != null) {
                lcJoinItem = new TJoinItem();
                lcTable = this.analyzeFromTable(pJoinExpr.getRightOperand(), true);
                lcTable.setEffectType(ETableEffectType.tetSelect);
                lcJoinItem.setTable(lcTable);
                lcJoinItem.setStartToken(lcJoinItem.getTable().getStartToken());
                lcJoinItem.setKind(2);
                retval.getJoinItems().addJoinItem(lcJoinItem);
            }
        } else if (retval != null) {
            lcJoinItem = new TJoinItem();
            lcJoinItem.setKind(3);
            lcJoinItemJoinExpr = pJoinExpr.getRightOperand().getJoinExpr();
            lcJoinItem.setJoin(this.analyzeJoin(pJoinExpr.getRightOperand().getJoinExpr(), null, false));
            lcJoinItem.getJoin().setAliasClause(lcJoinItemJoinExpr.getAliasClause());
            lcJoinItem.setStartToken(lcJoinItem.getJoin().getStartToken());
            retval.getJoinItems().addJoinItem(lcJoinItem);
        }
        if (lcJoinItem == null) {
            return retval;
        }
        lcJoinItem.setJoinType(pJoinExpr.getJointype());
        lcJoinItem.setUsingColumns(pJoinExpr.usingColumns);
        if (lcJoinItem.getUsingColumns() != null && this.tables.size() > 1) {
            for (int i = 0; i < lcJoinItem.getUsingColumns().size(); ++i) {
                TObjectName crf = lcJoinItem.getUsingColumns().getObjectName(i);
                this.tables.getTable(this.tables.size() - 1).getObjectNameReferences().addObjectName(crf);
                this.tables.getTable(this.tables.size() - 2).getObjectNameReferences().addObjectName(crf);
                this.tables.getTable(this.tables.size() - 1).getLinkedColumns().addObjectName(crf);
                crf.setSourceTable(this.tables.getTable(this.tables.size() - 1));
                this.tables.getTable(this.tables.size() - 2).getLinkedColumns().addObjectName(crf);
                crf.setSourceTable(this.tables.getTable(this.tables.size() - 2));
            }
            lcJoinItem.setEndToken(lcJoinItem.getUsingColumns().getEndToken());
        }
        lcJoinItem.setOnCondition(pJoinExpr.onCondition);
        if (lcJoinItem.getOnCondition() != null) {
            lcJoinItem.getOnCondition().doParse(this, ESqlClause.joinCondition);
            lcJoinItem.setEndToken(lcJoinItem.getOnCondition().getEndToken());
        }
        return retval;
    }

    public boolean locateVariableOrParameter(TObjectName cr) {
        boolean ret = false;
        if (cr.getDbObjectType() == EDbObjectType.variable) {
            return true;
        }
        TSymbolVariable symbolVariable = TSymbolTableManager.searchSymbolVariable(this.getFrameStack(), cr.toString());
        if (symbolVariable != null) {
            cr.setDbObjectType(EDbObjectType.variable);
            symbolVariable.getVariableName().getReferencedObjects().addObjectName(cr);
            return true;
        }
        if (this.dbvendor != EDbVendor.dbvoracle && this.dbvendor != EDbVendor.dbvmysql) {
            return false;
        }
        if (cr.getObjectType() == 10) {
            return true;
        }
        Stack symbolTable = this.getTopStatement().getSymbolTable();
        TSymbolTableItem item = null;
        TObjectName objName = null;
        TObjectName qualifiedName = null;
        for (int i = symbolTable.size() - 1; i >= 0; --i) {
            item = (TSymbolTableItem)symbolTable.get(i);
            if (item.getData() instanceof TParameterDeclaration) {
                objName = ((TParameterDeclaration)item.getData()).getParameterName();
            } else if (item.getData() instanceof TVarDeclStmt) {
                objName = ((TVarDeclStmt)item.getData()).getElementName();
            } else if (item.getData() instanceof TObjectName) {
                objName = (TObjectName)item.getData();
            }
            if (objName == null) continue;
            if (cr.toString().compareToIgnoreCase(objName.toString()) == 0) {
                ret = true;
                int j = 0;
                while (i < this.tables.size()) {
                    TTable lcTable = this.tables.getTable(j);
                    if (lcTable.isBaseTable() && this.fireOnMetaDatabaseTableColumn(lcTable.getPrefixServer(), lcTable.getPrefixDatabase(), lcTable.getPrefixSchema(), lcTable.getName(), cr.getColumnNameOnly())) {
                        ret = false;
                        break;
                    }
                    ++i;
                }
                if (!ret) continue;
                break;
            }
            if (cr.toString().indexOf(".") <= 0) continue;
            if (item.getStmt() instanceof TPlsqlCreateFunction) {
                qualifiedName = ((TPlsqlCreateFunction)item.getStmt()).getFunctionName();
            } else if (item.getStmt() instanceof TPlsqlCreateProcedure) {
                qualifiedName = ((TPlsqlCreateProcedure)item.getStmt()).getProcedureName();
            } else if (item.getStmt() instanceof TCommonBlock) {
                qualifiedName = ((TCommonBlock)item.getStmt()).getLabelName();
            }
            if (qualifiedName != null && cr.toString().compareToIgnoreCase(qualifiedName.toString() + '.' + objName.toString()) == 0) {
                ret = true;
            }
            if (ret) break;
        }
        if (ret) {
            objName.getReferencedObjects().addObjectName(cr);
            cr.setObjectType(10);
        }
        return ret;
    }

    TCTE findCTEByName(String cteName) {
        TCTEList lcCteList = this.searchCTEList();
        TCTE lcCte = null;
        if (lcCteList != null) {
            for (int i = 0; i < lcCteList.size(); ++i) {
                if (lcCteList.getCTE(i).getTableName().toString().compareToIgnoreCase(cteName) != 0) continue;
                lcCte = lcCteList.getCTE(i);
                break;
            }
        }
        return lcCte;
    }

    public boolean fireOnMetaDatabaseTableColumn(String pServer, String pDatabase, String pSchema, String pTable, String pColumn) {
        TStackFrame stackFrame = (TStackFrame)this.getFrameStack().firstElement();
        TGlobalScope globalScope = (TGlobalScope)stackFrame.getScope();
        if (globalScope.getSqlEnv() != null) {
            return globalScope.getSqlEnv().columnInTable(pDatabase + "." + pSchema + "." + pTable, pColumn);
        }
        return false;
    }

    public TTable getFirstPhysicalTable() {
        TTable ret = null;
        if (this.tables.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.tables.size(); ++i) {
            if (!this.tables.getTable(i).isBaseTable()) continue;
            ret = this.tables.getTable(i);
            break;
        }
        return ret;
    }

    public TObjectNameList getOrphanColumns() {
        if (this.orphanColumns == null) {
            this.orphanColumns = new TObjectNameList();
        }
        return this.orphanColumns;
    }

    protected boolean linkToFirstTable(TObjectName pColumn, int pCandidateTableCnt) {
        boolean lcResult = false;
        if (this.dbvendor == EDbVendor.dbvteradata && pColumn.isPrefixed() && pColumn.getTableToken().getDbObjectType() != EDbObjectType.subquery_alias) {
            if (this.tables.searchTableByName(pColumn.getTableToken().toString()) == -1) {
                TTable newTable = null;
                if (pColumn.getSchemaToken() == null) {
                    newTable = new TTable(new TObjectName(pColumn.getTableToken(), EDbObjectType.table));
                    newTable.setStartToken(pColumn.getTableToken());
                    newTable.setEndToken(pColumn.getTableToken());
                } else {
                    newTable = new TTable(new TObjectName(pColumn.getSchemaToken(), pColumn.getTableToken(), EDbObjectType.table));
                    newTable.setStartToken(pColumn.getSchemaToken());
                    newTable.setEndToken(pColumn.getTableToken());
                }
                newTable.setTableType(ETableSource.objectname);
                newTable.setEffectType(ETableEffectType.tetTeradataReference);
                newTable.getLinkedColumns().addObjectName(pColumn);
                pColumn.setSourceTable(newTable);
                this.addToTables(newTable);
            }
            return true;
        }
        if (this.tables.size() == 1 || pCandidateTableCnt == 1) {
            this.tables.getTable(0).getLinkedColumns().addObjectName(pColumn);
            pColumn.setSourceTable(this.tables.getTable(0));
            lcResult = true;
        } else if (this.tables.size() > 1) {
            this.getOrphanColumns().addObjectName(pColumn);
        }
        return lcResult;
    }

    boolean isSQLServerInsertedDelete(TObjectName pColumn) {
        if ((pColumn.toString().toUpperCase().startsWith("INSERTED") || pColumn.toString().toUpperCase().startsWith("DELETED")) && this.targetTable != null) {
            this.targetTable.getObjectNameReferences().addObjectName(pColumn);
            pColumn.setSourceTable(this.targetTable);
            return true;
        }
        return false;
    }

    boolean isOracleNewOldTable(TObjectName pColumn) {
        boolean ret = false;
        if (this.dbvendor != EDbVendor.dbvoracle) {
            return false;
        }
        if (!pColumn.isPrefixed()) {
            return false;
        }
        if (pColumn.getTableString().equalsIgnoreCase(":new") || pColumn.getTableString().equalsIgnoreCase(":old")) {
            this.getAncestorStmt().tables.getTable(0).getLinkedColumns().addObjectName(pColumn);
            pColumn.setSourceTable(this.getAncestorStmt().tables.getTable(0));
            ret = true;
        }
        return ret;
    }

    public boolean searchDaxVariableInStack(TObjectName pName) {
        boolean ret = false;
        if (this.getVariableStack().size() == 0) {
            return false;
        }
        if (pName.getDbObjectType() == EDbObjectType.column) {
            return false;
        }
        for (int i = 0; i < this.variableStack.size(); ++i) {
            if (!pName.toString().equalsIgnoreCase(((TObjectName)this.variableStack.get(i)).toString())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    boolean linkColumnToTableDax(TObjectName pColumn, ESqlClause pLocation) {
        boolean lcResult = true;
        TDaxFunction daxFunction = null;
        if (this.searchDaxVariableInStack(pColumn)) {
            return false;
        }
        if (this.getDaxFunctionStack().size() > 0) {
            daxFunction = this.daxFunctionStack.peek();
        }
        if (pColumn.getTableToken() != null) {
            TTable sourceTable = new TTable(new TObjectName(pColumn.getTableToken(), EDbObjectType.table));
            sourceTable.getLinkedColumns().addObjectName(pColumn);
            this.addToTables(sourceTable);
            if (daxFunction != null && daxFunction.getDefaultTable() == null) {
                daxFunction.setDefaultTable(sourceTable);
            }
        } else if (daxFunction != null && daxFunction.getDefaultTable() != null) {
            daxFunction.getDefaultTable().getLinkedColumns().addObjectName(pColumn);
        } else {
            ((TDaxStmt)this).getDefaultTable().getLinkedColumns().addObjectName(pColumn);
        }
        return lcResult;
    }

    public boolean linkColumnToTable(TObjectName pColumn, ESqlClause pLocation) {
        boolean isSearchUpLevel;
        boolean lcResult = false;
        boolean isContinue = false;
        int candidateTableCnt = 0;
        if (this.dbvendor == EDbVendor.dbvdax) {
            return this.linkColumnToTableDax(pColumn, pLocation);
        }
        if (pColumn.getSourceTable() != null) {
            lcResult = true;
            return lcResult;
        }
        pColumn.setLocation(pLocation);
        if (!pColumn.isValidColumnName(this.dbvendor)) {
            if (pColumn.isReservedKeyword() && pColumn.getStartToken().tokencode != 545 && !pColumn.getStartToken().toString().equalsIgnoreCase("true") && pColumn.getStartToken().tokencode != 546 && !pColumn.getStartToken().toString().equalsIgnoreCase("false") && pColumn.getStartToken().tokencode != 547) {
                boolean mysqlBuiltFunction = false;
                if (this.dbvendor == EDbVendor.dbvmysql) {
                    mysqlBuiltFunction = functionChecker.isBuiltInFunction(pColumn.toString(), EDbVendor.dbvmysql, "6.0");
                }
                if (!mysqlBuiltFunction) {
                    TSourceToken st1 = pColumn.getStartToken();
                    TSyntaxError err = new TSyntaxError(st1.toString(), st1.lineNo, st1.columnNo, String.format("Reserved keyword can't be column name", new Object[0]), EErrorType.sperror, 10111);
                    this.parseerrormessagehandle(err);
                }
            }
            return false;
        }
        if (this.isOracleNewOldTable(pColumn)) {
            return true;
        }
        if (this.isSQLServerInsertedDelete(pColumn)) {
            return true;
        }
        if (pColumn.getLocation() == ESqlClause.insertValues) {
            TInsertSqlStatement insertSqlStatement;
            if (this instanceof TInsertSqlStatement && (insertSqlStatement = (TInsertSqlStatement)this).isInsertAll()) {
                lcResult = insertSqlStatement.getSubQuery().searchColumnInResultSet(pColumn, true);
            }
            if (lcResult) {
                return true;
            }
        }
        for (int i = 0; i < this.tables.size(); ++i) {
            TTable lcTable = this.tables.getTable(i);
            if (pColumn.isPrefixed()) {
                lcResult = pColumn.isPrefixedThisTable(lcTable);
                if (lcResult && lcTable.getTableType() == ETableSource.subquery) {
                    pColumn.getTableToken().setDbObjectType(EDbObjectType.subquery_alias);
                    lcTable.getSubquery().searchColumnInResultSet(pColumn, true);
                } else if (lcResult && lcTable.isCTEName()) {
                    lcTable.getCTE().searchColumnInResultSet(this, lcTable, pColumn, true);
                } else if (lcResult && lcTable.getTableType() == ETableSource.openquery && lcTable.getSubquery() != null) {
                    pColumn.getTableToken().setDbObjectType(EDbObjectType.subquery_alias);
                    lcTable.getSubquery().searchColumnInResultSet(pColumn, true);
                }
            } else if (pColumn.getColumnNameOnly().equalsIgnoreCase("*")) {
                lcResult = true;
                isContinue = true;
            } else if (lcTable.isBaseTable()) {
                lcResult = this.fireOnMetaDatabaseTableColumn(lcTable.getPrefixServer(), lcTable.getPrefixDatabase(), lcTable.getPrefixSchema(), lcTable.getName(), pColumn.getColumnNameOnly());
                if (!lcResult) {
                    ++candidateTableCnt;
                }
            } else if (lcTable.getTableType() == ETableSource.subquery || lcTable.getTableType() == ETableSource.openquery && lcTable.getSubquery() != null) {
                if (!lcTable.isIncludeColumnAlias() && !(lcResult = lcTable.getSubquery().searchColumnInResultSet(pColumn, this.tables.size() == 1))) {
                    ++candidateTableCnt;
                }
            } else if (lcTable.isCTEName() && !(lcResult = lcTable.getCTE().searchColumnInResultSet(this, lcTable, pColumn, this.tables.size() == 1))) {
                ++candidateTableCnt;
            }
            if (!lcResult) continue;
            lcTable.getLinkedColumns().addObjectName(pColumn);
            pColumn.setSourceTable(lcTable);
            if (!isContinue) break;
        }
        if (this.locateVariableOrParameter(pColumn)) {
            return false;
        }
        if (!lcResult && !pColumn.isPrefixed() && this instanceof TSelectSqlStatement && this.getResultColumnList() != null) {
            for (int j = 0; j < this.getResultColumnList().size(); ++j) {
                TResultColumn lcField = this.getResultColumnList().getResultColumn(j);
                lcResult = lcField.isMatchedUsingAlias(pColumn);
                if (!lcResult) continue;
                pColumn.setSourceColumn(lcField);
                lcField.getTargetColumns().addObjectName(pColumn);
                break;
            }
        }
        if (lcResult) {
            return true;
        }
        boolean bl = isSearchUpLevel = this.parentStmt != null;
        if (isSearchUpLevel && this.sqlstatementtype == ESqlStatementType.sstselect) {
            boolean bl2 = isSearchUpLevel = pColumn.isPrefixed() || ((TSelectSqlStatement)this).getLocation() != ESqlClause.elTable && !((TSelectSqlStatement)this).isQueryOfCTE();
        }
        if (isSearchUpLevel) {
            ++pColumn.searchLevel;
            lcResult = this.parentStmt.linkColumnToTable(pColumn, pLocation);
            --pColumn.searchLevel;
        }
        if (!lcResult && pColumn.searchLevel == 0) {
            this.linkToFirstTable(pColumn, candidateTableCnt);
        }
        return lcResult;
    }

    public void linkColumnReferenceToTable(TObjectName cr, ESqlClause plocation) {
        block33: {
            int ret;
            block37: {
                int i;
                block34: {
                    int i2;
                    TResultColumn lcColumn;
                    TSelectSqlStatement subquery;
                    TTable lcTable;
                    block36: {
                        block35: {
                            TSourceToken pt;
                            if (cr == null) {
                                return;
                            }
                            cr.setLocation(plocation);
                            if (cr.getObjectType() == 10) {
                                return;
                            }
                            if (cr.getObjectType() == 2) {
                                return;
                            }
                            if (this.dbvendor == EDbVendor.dbvsybase && (pt = cr.getPartToken()) != null && pt.tokentype == ETokenType.ttdqstring) {
                                if (pt.toString().charAt(1) >= '0' && pt.toString().charAt(1) <= '9') {
                                    return;
                                }
                                if (pt.toString().length() == 2) {
                                    return;
                                }
                                if (pt.toString().substring(1, pt.toString().length() - 1).trim().length() == 0) {
                                    return;
                                }
                            }
                            if (cr.getPartToken() != null && cr.getPartToken().tokentype == ETokenType.ttkeyword) {
                                boolean reservedKeyword = false;
                                switch (this.dbvendor) {
                                    case dbvmssql: {
                                        reservedKeyword = !this.getGsqlparser().getFlexer().canBeColumnName(cr.getPartToken().tokencode);
                                        break;
                                    }
                                    case dbvsybase: {
                                        reservedKeyword = keywordChecker.isKeyword(cr.getPartToken().toString(), EDbVendor.dbvsybase, "15.7", true);
                                        break;
                                    }
                                }
                                if (reservedKeyword) {
                                    return;
                                }
                            }
                            if (cr.toString().startsWith("@")) {
                                cr.setObjectType(-1);
                                return;
                            }
                            if (this.dbvendor == EDbVendor.dbvoracle && (cr.toString().compareToIgnoreCase("rowid") == 0 || cr.toString().compareToIgnoreCase("sysdate") == 0 || cr.toString().compareToIgnoreCase("nextval") == 0 || cr.toString().compareToIgnoreCase("rownum") == 0 || cr.toString().compareToIgnoreCase("level") == 0)) {
                                cr.setObjectType(-1);
                                return;
                            }
                            if ((cr.toString().toUpperCase().startsWith("INSERTED") || cr.toString().toUpperCase().startsWith("DELETED")) && plocation == ESqlClause.output && this.targetTable != null) {
                                this.targetTable.getObjectNameReferences().addObjectName(cr);
                                return;
                            }
                            if ((cr.toString().toUpperCase().startsWith(":NEW") || cr.toString().toUpperCase().startsWith(":OLD")) && this.getTopStatement() instanceof TPlsqlCreateTrigger && this.dbvendor == EDbVendor.dbvoracle) {
                                this.getTopStatement().tables.getTable(0).getObjectNameReferences().addObjectName(cr);
                                return;
                            }
                            ret = this.tables.checkColumnReferenceInTables(cr);
                            if (ret < 0) break block34;
                            lcTable = this.tables.getTable(ret);
                            if (!lcTable.isBaseTable()) break block35;
                            lcTable.getObjectNameReferences().addObjectName(cr);
                            break block33;
                        }
                        if (!lcTable.isCTEName()) break block36;
                        TCTE lccte = this.findCTEByName(lcTable.toString());
                        if (lccte == null) break block33;
                        TObjectName objectName = new TObjectName();
                        objectName.init(cr.getPartToken());
                        if (lccte.getSubquery() == null) break block33;
                        lccte.getSubquery().linkColumnReferenceToTable(objectName, plocation);
                        break block33;
                    }
                    if (lcTable.getTableType() != ETableSource.subquery || (subquery = lcTable.getSubquery()).getValueClause() != null || subquery.isCombinedQuery() || subquery.getResultColumnList().size() != 1 || !(lcColumn = subquery.getResultColumnList().getResultColumn(0)).toString().endsWith("*")) break block33;
                    boolean isfound = false;
                    for (i2 = 0; i2 < subquery.tables.size(); ++i2) {
                        if (subquery.tables.getTable(i2).getTableType() == ETableSource.subquery) continue;
                        String columnStr = null;
                        if (cr.getPartToken() != null) {
                            columnStr = cr.getPartToken().toString();
                        }
                        if (!this.fireOnMetaDatabaseTableColumn(subquery.tables.getTable(i2).getTableName().getServerString(), subquery.tables.getTable(i2).getTableName().getDatabaseString(), subquery.tables.getTable(i2).getTableName().getSchemaString(), subquery.tables.getTable(i2).getName(), columnStr)) continue;
                        subquery.tables.getTable(i2).getObjectNameReferences().addObjectName(cr);
                        isfound = true;
                        break;
                    }
                    if (isfound) break block33;
                    if (subquery.tables.size() > 1) {
                        cr.setTableDetermined(false);
                    }
                    for (i2 = 0; i2 < subquery.tables.size(); ++i2) {
                        subquery.tables.getTable(i2).getObjectNameReferences().addObjectName(cr);
                    }
                    break block33;
                }
                if (ret != -2) break block37;
                boolean isfound = false;
                for (int i3 = 0; i3 < this.tables.size(); ++i3) {
                    if (!this.tables.getTable(i3).isCTEName() || this.tables.getTable(i3).getCteColomnReferences() == null || this.tables.getTable(i3).getCteColomnReferences().searchColumnReference(cr) < 0) continue;
                    this.tables.getTable(i3).getObjectNameReferences().addObjectName(cr);
                    isfound = true;
                    break;
                }
                if (!isfound && cr.getLocation() != ESqlClause.resultColumn && cr.getLocation() != ESqlClause.insertColumn && cr.getLocation() != ESqlClause.mergeInsert && cr.getLocation() != ESqlClause.selectList) {
                    TCustomSqlStatement lcParent = null;
                    for (lcParent = this.getParentStmt(); lcParent != null && lcParent.sqlstatementtype == ESqlStatementType.sstselect; lcParent = lcParent.getParentStmt()) {
                        for (i = 0; i < lcParent.tables.size(); ++i) {
                            TTable lcTable = lcParent.tables.getTable(i);
                            if (lcTable.getTableType() != ETableSource.objectname) continue;
                            for (int k = 0; k < lcTable.getObjectNameReferences().size(); ++k) {
                                if (!lcTable.getObjectNameReferences().getObjectName(k).isTableDetermined() || !cr.toString().equalsIgnoreCase(lcTable.getObjectNameReferences().getObjectName(k).toString())) continue;
                                isfound = true;
                                break;
                            }
                            if (isfound) break;
                        }
                        if (isfound) break;
                    }
                }
                if (!isfound) {
                    isfound = this.checkNonQualifiedColumnReferenceInSubQueryOfUplevelStmt(cr, plocation == ESqlClause.resultColumn || plocation == ESqlClause.insertColumn || plocation == ESqlClause.mergeInsert || plocation == ESqlClause.selectList);
                }
                if (isfound || this.tables.size() <= 0) break block33;
                int candidate = 0;
                int firstCandidate = -1;
                for (i = 0; i < this.tables.size(); ++i) {
                    if (this.tables.getTable(i).isCTEName() && (!this.tables.getTable(i).isCTEName() || this.tables.getTable(i).getCteColomnReferences() != null) || this.tables.getTable(i).getTableType() == ETableSource.subquery) continue;
                    ++candidate;
                    if (firstCandidate == -1) {
                        firstCandidate = i;
                    }
                    if (this.fireOnMetaDatabaseTableColumn(this.tables.getTable(i).getTableName().getServerString(), this.tables.getTable(i).getTableName().getDatabaseString(), this.tables.getTable(i).getTableName().getSchemaString(), this.tables.getTable(i).getName(), cr.toString())) {
                        this.tables.getTable(i).getObjectNameReferences().addObjectName(cr);
                        isfound = true;
                        break;
                    }
                    this.tables.getTable(i).getObjectNameReferences().addObjectName(cr);
                    if (this.tables.size() > 1) {
                        cr.setTableDetermined(false);
                    }
                    isfound = true;
                    break;
                }
                if (isfound || candidate != true) break block33;
                this.tables.getTable(firstCandidate).getObjectNameReferences().addObjectName(cr);
                break block33;
            }
            if (ret == -1) {
                TCustomSqlStatement lcParent = null;
                for (lcParent = this.getParentStmt(); lcParent != null; lcParent = lcParent.getParentStmt()) {
                    ret = lcParent.tables.checkColumnReferenceInTables(cr);
                    if (ret < 0) continue;
                    lcParent.tables.getTable(ret).getObjectNameReferences().addObjectName(cr);
                    break;
                }
            }
        }
    }

    public boolean checkNonQualifiedColumnReferenceInSubQueryOfUplevelStmt(TObjectName crf, boolean sameLevelOnly) {
        boolean ret = false;
        TCustomSqlStatement lcParent = null;
        lcParent = this;
        while (lcParent != null) {
            TTable lcTable;
            for (int i = 0; !(i >= lcParent.tables.size() || (lcTable = lcParent.tables.getTable(i)).getTableType() == ETableSource.subquery && (ret = this.isColumnNameInSelectList(crf.toString(), lcTable.subquery))); ++i) {
            }
            if (ret) break;
            if (sameLevelOnly) {
                lcParent = null;
                continue;
            }
            lcParent = lcParent.getParentStmt();
        }
        return ret;
    }

    private boolean isColumnNameInSelectList(String pColumn, TSelectSqlStatement pSelect) {
        boolean ret = false;
        if (pSelect.isCombinedQuery()) {
            ret = this.isColumnNameInSelectList(pColumn, pSelect.getLeftStmt());
            if (!ret) {
                ret = this.isColumnNameInSelectList(pColumn, pSelect.getRightStmt());
            }
        } else if (pSelect.getResultColumnList() != null) {
            for (int j = 0; j < pSelect.getResultColumnList().size(); ++j) {
                TResultColumn lcColumn = pSelect.getResultColumnList().getResultColumn(j);
                if (lcColumn.getAliasClause() != null) {
                    ret = pColumn.equalsIgnoreCase(lcColumn.getAliasClause().toString());
                }
                if (ret || (ret = pColumn.equalsIgnoreCase(lcColumn.getExpr().toString()))) break;
            }
        }
        return ret;
    }

    public TCustomSqlStatement getTopStatement() {
        TCustomSqlStatement ret = this;
        while (ret.getParentStmt() != null) {
            ret = ret.getParentStmt();
        }
        return ret;
    }
}

