/*
 * Decompiled with CFR 0.152.
 */
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

class getObject {
    public static final int compareMode = 1;
    public static final int showMode = 2;
    String sqlfile;
    String[] desiredTables = new String[100];
    String[] desiredColumns = new String[100];
    int desiredTableCount = 0;
    int desiredColumnCount = 0;
    String oracle_sqldir = "D:/prg/gsqlparser/Test/TestCases/java/oracle/dbobject/";
    String[] oracle_sqlfiles = new String[]{"berger_example_01", "berger_sqltest_01", "berger_sqltest_02", "berger_sqltest_03", "berger_sqltest_04", "berger_sqltest_05", "createtrigger", "plsql_block_correlated_subquery", "createfunction", "createpackagebody"};
    String sqlserver_sqldir = "D:/prg/gsqlparser/Test/TestCases/fetchdbobject/mssql/java/";
    String[] sqlserver_sqlfiles = new String[]{"bigjoin1", "shurleyjoin", "delete1", "delete2", "delete3", "delete4", "update1", "update2", "update3", "insert1", "createfunction1", "createprocedure1", "createtrigger1", "createview1", "while1"};
    String sqldir;
    String[] sqlfiles;
    int files_count = 0;
    public String showModeFile;
    String[] foundTables = new String[1000];
    String[] foundColumns = new String[1000];
    int foundTableCount = 0;
    int foundColumnsCount = 0;
    EDbVendor dbvendor;

    getObject(EDbVendor db) {
        this.dbvendor = db;
        if (db == EDbVendor.dbvoracle) {
            this.sqldir = this.oracle_sqldir;
            this.sqlfiles = this.oracle_sqlfiles;
            this.files_count = this.sqlfiles.length;
        } else {
            this.sqldir = this.sqlserver_sqldir;
            this.sqlfiles = this.sqlserver_sqlfiles;
            this.files_count = this.sqlfiles.length;
        }
    }

    void getDesiredTablesColumns(String sqlfile, String[] pTables, String[] pColumns) {
        this.desiredTableCount = 0;
        this.desiredColumnCount = 0;
        boolean isTable = false;
        boolean isColumn = false;
        try {
            BufferedReader br = new BufferedReader(new FileReader(sqlfile));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.toLowerCase().indexOf("tables:") >= 0) {
                        isTable = true;
                        isColumn = false;
                        continue;
                    }
                    if (line.toLowerCase().indexOf("fields:") >= 0) {
                        isTable = false;
                        isColumn = true;
                        continue;
                    }
                    if (line.toLowerCase().indexOf("functions:") >= 0) {
                        isTable = false;
                        isColumn = false;
                        continue;
                    }
                    if (line.toLowerCase().indexOf("schema:") >= 0) {
                        isTable = false;
                        isColumn = false;
                        continue;
                    }
                    if (isTable) {
                        pTables[this.desiredTableCount] = line.trim();
                        ++this.desiredTableCount;
                    }
                    if (!isColumn) continue;
                    pColumns[this.desiredColumnCount] = line.trim();
                    ++this.desiredColumnCount;
                }
                br.close();
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
    }

    void run(int pmode) {
        TGSqlParser sqlparser = new TGSqlParser(this.dbvendor);
        if (pmode == 2) {
            this.files_count = 1;
        }
        for (int k = 0; k < this.files_count; ++k) {
            this.foundColumnsCount = 0;
            this.foundTableCount = 0;
            sqlparser.sqlfilename = pmode == 2 ? this.showModeFile : this.sqldir + this.sqlfiles[k] + ".sql";
            int ret = sqlparser.parse();
            if (ret == 0) {
                int j;
                int i;
                if (pmode == 1) {
                    this.getDesiredTablesColumns(this.sqldir + this.sqlfiles[k] + ".out", this.desiredTables, this.desiredColumns);
                }
                Object stmt = null;
                for (int i2 = 0; i2 < sqlparser.sqlstatements.size(); ++i2) {
                    this.analyzeStmt(sqlparser.sqlstatements.get(i2));
                }
                String[] foundTables2 = new String[this.foundTableCount];
                for (int k1 = 0; k1 < this.foundTableCount; ++k1) {
                    this.foundTables[k1] = this.foundTables[k1].toLowerCase();
                }
                System.arraycopy(this.foundTables, 0, foundTables2, 0, this.foundTableCount);
                HashSet<String> set = new HashSet<String>(Arrays.asList(foundTables2));
                Object[] foundTables3 = set.toArray();
                Arrays.sort(foundTables3);
                String[] foundColumns2 = new String[this.foundColumnsCount];
                for (int k1 = 0; k1 < this.foundColumnsCount; ++k1) {
                    this.foundColumns[k1] = this.foundColumns[k1].toLowerCase();
                }
                System.arraycopy(this.foundColumns, 0, foundColumns2, 0, this.foundColumnsCount);
                HashSet<String> set2 = new HashSet<String>(Arrays.asList(foundColumns2));
                Object[] foundColumns3 = set2.toArray();
                Arrays.sort(foundColumns3);
                if (pmode == 1) {
                    System.out.println("process: " + this.sqlfiles[k] + ", tables desired: " + this.desiredTableCount + ", found: " + foundTables3.length + ", columns desired: " + this.desiredColumnCount + ", found columns: " + foundColumns3.length);
                }
                if (pmode == 2) {
                    int j2;
                    System.out.println("Tables:");
                    for (j2 = 0; j2 < foundTables3.length; ++j2) {
                        System.out.println(foundTables3[j2]);
                    }
                    System.out.println("Fields:");
                    for (j2 = 0; j2 < foundColumns3.length; ++j2) {
                        System.out.println(foundColumns3[j2]);
                    }
                    return;
                }
                boolean isfound = false;
                for (i = 0; i < this.desiredColumnCount; ++i) {
                    isfound = false;
                    for (j = 0; j < foundColumns3.length; ++j) {
                        if (!this.desiredColumns[i].toString().equalsIgnoreCase(foundColumns3[j].toString())) continue;
                        isfound = true;
                        break;
                    }
                    if (isfound) continue;
                    System.out.println("desired column not found:" + this.desiredColumns[i]);
                }
                for (i = 0; i < foundColumns3.length; ++i) {
                    isfound = false;
                    for (j = 0; j < this.desiredColumnCount; ++j) {
                        if (!foundColumns3[i].toString().equalsIgnoreCase(this.desiredColumns[j].toString())) continue;
                        isfound = true;
                        break;
                    }
                    if (isfound) continue;
                    System.out.println("not in desired column:" + foundColumns3[i]);
                }
                continue;
            }
            System.out.println(sqlparser.getErrormessage());
        }
    }

    protected void analyzeStmt(TCustomSqlStatement stmt) {
        int i;
        for (i = 0; i < stmt.tables.size(); ++i) {
            if (!stmt.tables.getTable(i).isBaseTable() || stmt.dbvendor == EDbVendor.dbvmssql && (stmt.tables.getTable(i).getFullName().equalsIgnoreCase("deleted") || stmt.tables.getTable(i).getFullName().equalsIgnoreCase("inserted"))) continue;
            this.foundTables[this.foundTableCount] = stmt.tables.getTable(i).getFullName();
            ++this.foundTableCount;
            for (int j = 0; j < stmt.tables.getTable(i).getObjectNameReferences().size(); ++j) {
                this.foundColumns[this.foundColumnsCount] = stmt.tables.getTable(i).getFullName() + "." + stmt.tables.getTable(i).getObjectNameReferences().getObjectName(j).getColumnNameOnly();
                ++this.foundColumnsCount;
            }
        }
        for (i = 0; i < stmt.getStatements().size(); ++i) {
            this.analyzeStmt(stmt.getStatements().get(i));
        }
    }
}

