/*
 * Decompiled with CFR 0.152.
 */
import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.EFindSqlStateType;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSqlCmds;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.nodes.TColumnWithSortOrder;
import gudusoft.gsqlparser.nodes.TConstraint;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParameterDeclaration;
import gudusoft.gsqlparser.nodes.TResultColumn;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.TVarDeclStmt;
import gudusoft.gsqlparser.stmt.TAssignStmt;
import gudusoft.gsqlparser.stmt.TCreateTableSqlStatement;
import gudusoft.gsqlparser.stmt.TCursorDeclStmt;
import gudusoft.gsqlparser.stmt.TDropStmt;
import gudusoft.gsqlparser.stmt.TIfStmt;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.TUnknownSqlStatement;
import gudusoft.gsqlparser.stmt.mssql.TMssqlBlock;
import gudusoft.gsqlparser.stmt.mssql.TMssqlCreateProcedure;
import gudusoft.gsqlparser.stmt.oracle.TSqlplusCmdStatement;
import gudusoft.gsqlparser.stmt.teradata.TTeradataNotImplement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;

public class demo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getQueryFromFile(String filename) {
        File file = new File(filename);
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String text = null;
            while ((text = reader.readLine()) != null) {
                contents.append(text).append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return contents.toString();
    }

    public static void readbigfile(String filename) {
        try {
            FileInputStream fstream = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            int lineNo = 0;
            try {
                String strLine;
                while ((strLine = br.readLine()) != null) {
                    System.out.println(strLine);
                    if (lineNo++ <= 1000) continue;
                }
                br.close();
            }
            catch (IOException o) {
                o.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        String sqlfile = "c:/prg/tmp/demo.sql";
        long t = System.currentTimeMillis();
        demo.parse(EDbVendor.dbvteradata, sqlfile);
        String[] a = "a.*".split("[.]");
        System.out.println("Time Escaped: " + (System.currentTimeMillis() - t));
    }

    public static void parseJsonFile(EDbVendor db, String jsonfile) {
    }

    public static String qualifySchemaObjectName(String schemaObjectName) {
        String lcResult = schemaObjectName;
        String[] names = schemaObjectName.split("[.]");
        if (names.length == 1) {
            lcResult = ".." + names[0];
        } else if (names.length == 2) {
            lcResult = "." + names[0] + "." + names[1];
        } else if (names.length == 3) {
            lcResult = names[0] + "." + names[1] + "." + names[2];
        }
        return lcResult;
    }

    static boolean compareIdentifier(EDbVendor dbVendor, String source, String target) {
        return demo.compareIdentifier(dbVendor, EDbObjectType.table, source, target);
    }

    static boolean compareIdentifier(EDbVendor dbVendor, EDbObjectType objectType, String source, String target) {
        boolean ret = false;
        switch (dbVendor) {
            case dbvbigquery: {
                String normalTarget = target.indexOf(96) >= 0 ? target.replaceAll("[`]", "") : (objectType == EDbObjectType.table ? target : target.toUpperCase());
                String normalSource = source.indexOf(96) >= 0 ? source.replaceAll("[`]", "") : (objectType == EDbObjectType.table ? source : source.toUpperCase());
                ret = normalTarget.compareTo(normalSource) == 0;
                break;
            }
            case dbvcouchbase: 
            case dbvhive: 
            case dbvimpala: {
                String normalTarget = target.indexOf(96) >= 0 ? target.replaceAll("[`]", "") : target;
                String normalSource = source.indexOf(96) >= 0 ? source.replaceAll("[`]", "") : source;
                ret = normalTarget.equalsIgnoreCase(normalSource);
                break;
            }
            case dbvmysql: {
                String normalTarget = target.indexOf(96) >= 0 ? target.replaceAll("[`]", "") : target;
                String normalSource = source.indexOf(96) >= 0 ? source.replaceAll("[`]", "") : source;
                ret = normalTarget.equalsIgnoreCase(normalSource);
                break;
            }
            case dbvdax: {
                String normalTarget = target.indexOf(39) >= 0 ? target.replaceAll("[']", "") : target;
                String normalSource = source.indexOf(39) >= 0 ? source.replaceAll("[']", "") : source;
                ret = normalTarget.equalsIgnoreCase(normalSource);
                break;
            }
            case dbvdb2: 
            case dbvhana: 
            case dbvinformix: 
            case dbvnetezza: 
            case dbvoracle: 
            case dbvredshift: 
            case dbvsnowflake: 
            case dbvsybase: 
            case dbvteradata: 
            case dbvvertica: {
                String normalTarget = target.indexOf(34) >= 0 ? target.replaceAll("\"", "") : target.toUpperCase();
                String normalSource = source.indexOf(34) >= 0 ? source.replaceAll("\"", "") : source.toUpperCase();
                ret = normalTarget.compareTo(normalSource) == 0;
                break;
            }
            case dbvpostgresql: {
                String normalTarget = target.indexOf(34) >= 0 ? target.replaceAll("\"", "") : target.toLowerCase();
                String normalSource = source.indexOf(34) >= 0 ? source.replaceAll("\"", "") : source.toLowerCase();
                ret = normalTarget.compareTo(normalSource) == 0;
                break;
            }
            case dbvmssql: {
                String normalTarget = target.indexOf(34) >= 0 ? target.replaceAll("\"", "") : (target.indexOf("[") >= 0 ? target.replaceAll("\\[", "").replaceAll("]", "") : target);
                String normalSource = source.indexOf(34) >= 0 ? source.replaceAll("\"", "") : (source.indexOf("[") >= 0 ? source.replaceAll("\\[", "").replaceAll("]", "") : source);
                ret = normalTarget.equalsIgnoreCase(normalSource);
                break;
            }
            default: {
                String normalTarget = target.indexOf(34) >= 0 ? target.replaceAll("\"", "") : target.toUpperCase();
                String normalSource = source.indexOf(34) >= 0 ? source.replaceAll("\"", "") : source.toUpperCase();
                ret = normalTarget.compareTo(normalSource) == 0;
            }
        }
        return ret;
    }

    static void testUseFile(String sqlfilename) {
        ProcessFile processFile = new ProcessFile(sqlfilename);
        processFile.openIt();
        processFile.closeIt();
    }

    static void testReplace() {
        String s = "DECLARE inString alias for $1; begin return ''bob''; end;";
        System.out.print(s.replaceAll("''", "'"));
    }

    static void testSQLPlus() {
        System.out.println((Object)TSqlplusCmdStatement.searchCmd("rem"));
        System.out.println((Object)TSqlplusCmdStatement.searchCmd("rem", null));
    }

    static void printMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        sb.append("free memory: " + format.format(freeMemory / 0x100000L) + "\n");
        sb.append("allocated memory: " + format.format(allocatedMemory / 0x100000L) + "\n");
        sb.append("used memory: " + format.format((allocatedMemory - freeMemory) / 0x100000L) + "\n");
        sb.append("max memory: " + format.format(maxMemory / 0x100000L) + "\n");
        sb.append("total free memory: " + format.format((freeMemory + (maxMemory - allocatedMemory)) / 0x100000L) + "\n");
        System.out.println(sb.toString());
    }

    static void example1() {
        String query = "CREATE TABLE \"QATEST\".\"BANK_TRANSACTION4\"\n   (    \"BANK_TRANSACTION_ID\" NUMBER(11,0) NOT NULL ENABLE NOVALIDATE,\n        \"TRANSACTION_ID\" VARCHAR2(800),\n        \"TRANSACTION_AMOUNT\" NUMBER(15,4),CONSTRAINT \"BANK_TRANS_PK3\" PRIMARY KEY (\"BANK_TRANSACTION_ID\"))";
        TGSqlParser sqlparser = new TGSqlParser(EDbVendor.dbvoracle);
        sqlparser.sqltext = query;
        System.out.println(query);
        if (sqlparser.parse() == 0) {
            System.out.println("parsing successfull");
            TCustomSqlStatement stmt = sqlparser.sqlstatements.get(0);
            TCreateTableSqlStatement createTable = (TCreateTableSqlStatement)stmt;
            System.out.println(createTable.getTableConstraints().getConstraint(0));
            TConstraint constraint = createTable.getTableConstraints().getConstraint(0);
            System.out.println((Object)constraint.getConstraint_type());
            TPTNodeList<TColumnWithSortOrder> constrColList = constraint.getColumnList();
            for (int constrColIndex = 0; constrColIndex < constrColList.size(); ++constrColIndex) {
                String colName = constrColList.getElement(constrColIndex).getColumnName().toString();
                System.out.println(colName);
            }
        }
    }

    static void listSupportedSQLs(EDbVendor dbVendor, boolean html) {
        TSqlCmds sqlCmds = new TSqlCmds();
        TSqlCmds.TSqlCmdList cmdList = sqlCmds.getSqlCmdList(dbVendor);
        TGSqlParser sqlParser = new TGSqlParser(dbVendor);
        boolean isSupported = false;
        int supportSqlNum = 0;
        int skippedNum = 0;
        int processedNum = 0;
        int errorNum = 0;
        ArrayList<ESqlStatementType> sqltypes = new ArrayList<ESqlStatementType>();
        String summaryStr = "<p>Level 1 statements: %d, Level 2 statements: %d, generated by %s</p>\n";
        String rowStr = " <tr height=21 style='height:15.75pt'>\n  <td height=21 class=xl2427189 style='height:15.75pt;border-top:none'>%s</td>\n  <td class=xl2427189 style='border-top:none;border-left:none'>%s</td>\n  <td class=xl2527189 style='border-top:none;border-left:none'>%s</td>\n </tr>";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cmdList.size(); ++i) {
            isSupported = false;
            TSqlCmds.TSqlCmd sqlCmd = (TSqlCmds.TSqlCmd)cmdList.get(i);
            if (sqltypes.contains((Object)sqlCmd.sqlstatementtype)) {
                ++skippedNum;
                continue;
            }
            ++processedNum;
            sqltypes.add(sqlCmd.sqlstatementtype);
            if (sqlCmd.toString().length() > 0) {
                sqlParser.sqltext = sqlCmd.toString();
                sqlParser.tokenizeSqltext();
                TCustomSqlStatement stmt = sqlCmds.issql(sqlParser.getSourcetokenlist().get(0), dbVendor, EFindSqlStateType.stnormal, null);
                if (stmt != null) {
                    boolean bl = isSupported = !(stmt instanceof TUnknownSqlStatement) && !(stmt instanceof TTeradataNotImplement);
                }
                if (isSupported) {
                    ++supportSqlNum;
                }
            }
            if (!html) {
                System.out.println(processedNum + "\t" + isSupported + "\t" + sqlCmd.toString());
            }
            if (sqlCmd.toString().contains("*")) {
                ++errorNum;
            }
            sb.append(String.format(rowStr, sqlCmd.toString(), "Y", isSupported ? "Y" : " "));
        }
        sb.insert(0, String.format(summaryStr, processedNum, supportSqlNum, "General SQL Parser Java Version 2.0.5.1," + new SimpleDateFormat("yyyy/MM/dd").format(Calendar.getInstance().getTime())));
        if (html) {
            System.out.println(sb.toString());
        }
        System.out.println("total:" + cmdList.size() + ",processed:" + processedNum + ",skipped:" + skippedNum + ",error:" + errorNum + ",supported:" + supportSqlNum);
    }

    static void perfTest(TGSqlParser sqlparser, String filename, int iterateNum) {
        sqlparser.sqlfilename = filename;
        for (int i = 0; i < iterateNum; ++i) {
            sqlparser.parse();
        }
    }

    static void mssqlTest() {
        TGSqlParser sqlparser = new TGSqlParser(EDbVendor.dbvmssql);
        sqlparser.sqltext = "CREATE PROCEDURE [HumanResources].[uspUpdateEmployeeHireInfo]\n@BusinessEntityID [int],@JobTitle [nvarchar](50),@HireDate [datetime],@RateChangeDate [datetime],@Rate [money], @PayFrequency [tinyint],@CurrentFlag [dbo].[Flag]WITH EXECUTE AS CALLER\nAS\n\nBEGIN\n\nSET NOCOUNT ON;\nBEGIN TRY\nBEGIN TRANSACTION;\nUPDATE [HumanResources].[Employee] \nSET [JobTitle] = @JobTitle\n,[HireDate] = @HireDate\n,[CurrentFlag] = @CurrentFlag\nWHERE [BusinessEntityID] = @BusinessEntityID;\nINSERT INTO [HumanResources].[EmployeePayHistory] \n([BusinessEntityID],[RateChangeDate],[Rate],[PayFrequency])\nVALUES (@BusinessEntityID, @RateChangeDate, @Rate, @PayFrequency);\nCOMMIT TRANSACTION;\nEND TRY\nBEGIN CATCH\n-- Rollback any active or uncommittable transactions before\n-- inserting information in the ErrorLog\nIF @@TRANCOUNT > 0\nBEGIN\nROLLBACK TRANSACTION;\nEND\nEXECUTE [dbo].[uspLogError];\nEND CATCH;\nEND;";
        int ret = sqlparser.parse();
        if (ret != 0) {
            System.out.println(sqlparser.getErrormessage());
            return;
        }
        TCustomSqlStatement sql = sqlparser.sqlstatements.get(0);
        System.out.println("SQL Statement: " + (Object)((Object)sql.sqlstatementtype));
        TMssqlCreateProcedure procedure = (TMssqlCreateProcedure)sql;
        System.out.println("Procedure name: " + procedure.getProcedureName().toString());
        if (procedure.getParameterDeclarations() != null) {
            System.out.println("Parameters:" + procedure.getParameterDeclarations());
            TParameterDeclaration param = null;
            for (int i = 0; i < procedure.getParameterDeclarations().size(); ++i) {
                param = procedure.getParameterDeclarations().getParameterDeclarationItem(i);
                System.out.println("\tName:" + param.getParameterName().toString());
                System.out.println("\tDatatype:" + param.getDataType().toString());
                System.out.println("\tIN/OUT:" + param.getMode());
            }
        }
        if (procedure.getDeclareStatements().size() != 0) {
            TStatementList list = procedure.getDeclareStatements();
            System.out.println("List : " + list);
            System.out.println("List: " + list.size());
            for (int k = 0; k < list.size(); ++k) {
                if (!list.get(k).toString().toUpperCase().contains("CURSOR")) continue;
                TCursorDeclStmt cur = (TCursorDeclStmt)list.get(k);
                System.out.println("Cursor Type : " + (Object)((Object)cur.sqlstatementtype));
                System.out.println("Cursor name is : " + cur.getCursorName());
                System.out.println("Cursor Subquery : " + cur.getSubquery());
            }
            TStatementList declareStatements = procedure.getDeclareStatements();
            System.out.println("declare statements: " + declareStatements.size());
            TCustomSqlStatement declareStatement = null;
            TVarDeclStmt variableDelcare = null;
            block17: for (int i = 0; i < declareStatements.size(); ++i) {
                declareStatement = declareStatements.get(i);
                System.out.println("SQL Statement: " + (Object)((Object)declareStatement.sqlstatementtype));
                if (declareStatement.toString().toLowerCase().contains("cursor")) {
                    TCursorDeclStmt cur = (TCursorDeclStmt)declareStatement;
                    System.out.println("Cursor Name:" + cur.getCursorName());
                    continue;
                }
                variableDelcare = (TVarDeclStmt)declareStatement;
                switch (variableDelcare.getWhatDeclared()) {
                    case 1: {
                        System.out.println("\tVariable Name:" + variableDelcare.getElementName().toString());
                        System.out.println("\tVariable Datatype:" + variableDelcare.getDataType().toString());
                        continue block17;
                    }
                    case 2: {
                        continue block17;
                    }
                    case 3: {
                        System.out.println("\tException:" + variableDelcare.getElementName().toString());
                        continue block17;
                    }
                    case 4: {
                        continue block17;
                    }
                    case 6: {
                        continue block17;
                    }
                    case 5: {
                        continue block17;
                    }
                    case 7: {
                        continue block17;
                    }
                    case 9: {
                        continue block17;
                    }
                }
            }
        }
        TStatementList bodyStatements1 = procedure.getBodyStatements();
        for (int j = 0; j <= bodyStatements1.size(); ++j) {
            System.out.println("SQL Body Statement" + bodyStatements1.getNodeType());
        }
        System.out.println("body statements: " + bodyStatements1.size());
        System.out.println("body statements: " + bodyStatements1);
        if (procedure.getBodyStatements().size() != 0) {
            TStatementList bodyStatements = procedure.getBodyStatements();
            System.out.println("body statements: " + bodyStatements.size());
            TCustomSqlStatement bodyStatement = null;
            block19: for (int i = 0; i < bodyStatements.size(); ++i) {
                bodyStatement = bodyStatements.get(i);
                System.out.println("SQL Statement: " + (Object)((Object)bodyStatement.sqlstatementtype));
                System.out.println("Body Statement : " + bodyStatement);
                switch (bodyStatement.sqlstatementtype) {
                    case sstmssqlblock: {
                        TMssqlBlock block = (TMssqlBlock)bodyStatement;
                        demo.processBlock(block, 0);
                        continue block19;
                    }
                    case sst_assignstmt: {
                        TAssignStmt assign = (TAssignStmt)bodyStatement;
                        System.out.println("left: " + assign.getLeft().toString());
                        System.out.println("right: " + assign.getExpression().toString());
                        continue block19;
                    }
                    case sst_ifstmt: {
                        int j;
                        TIfStmt ifstmt = (TIfStmt)bodyStatement;
                        System.out.println("condition: " + ifstmt.getCondition().toString());
                        if (ifstmt.getThenStatements().size() > 0) {
                            System.out.println("then statement:");
                            for (j = 0; j < ifstmt.getThenStatements().size(); ++j) {
                                System.out.println("\tStatement type: " + (Object)((Object)ifstmt.getThenStatements().get((int)j).sqlstatementtype));
                                System.out.println("\tStatement text: " + ifstmt.getThenStatements().get(j).toString());
                            }
                        }
                        if (ifstmt.getElseifStatements().size() > 0) {
                            System.out.println("else if statement:");
                            for (j = 0; j < ifstmt.getElseifStatements().size(); ++j) {
                                System.out.println("\tStatement type: " + (Object)((Object)ifstmt.getElseifStatements().get((int)j).sqlstatementtype));
                                System.out.println("\tStatement text: " + ifstmt.getElseifStatements().get(j).toString());
                            }
                        }
                        if (ifstmt.getElseStatements().size() <= 0) continue block19;
                        System.out.println("else statement:");
                        for (j = 0; j < ifstmt.getElseStatements().size(); ++j) {
                            System.out.println("\tStatement type: " + (Object)((Object)ifstmt.getElseStatements().get((int)j).sqlstatementtype));
                            System.out.println("\tStatement text: " + ifstmt.getElseStatements().get(j).toString());
                        }
                        continue block19;
                    }
                }
            }
        }
    }

    static void processBlock(TMssqlBlock block, int level) {
        for (int k = 0; k < block.getBodyStatements().size(); ++k) {
            for (int i = 0; i < level; ++i) {
                System.out.print("\t");
            }
            System.out.println("Inside block: " + (Object)((Object)block.getBodyStatements().get((int)k).sqlstatementtype));
            if (block.getBodyStatements().get((int)k).sqlstatementtype != ESqlStatementType.sstmssqlblock) continue;
            demo.processBlock((TMssqlBlock)block.getBodyStatements().get(k), ++level);
        }
    }

    static void iterateStatements(EDbVendor db, String file) {
        TGSqlParser parser = new TGSqlParser(db);
        parser.sqlfilename = file;
        int iret = parser.parse();
        if (iret != 0) {
            System.out.println(parser.getErrormessage());
            return;
        }
        TStatementList stmtList = parser.sqlstatements;
        System.out.println(stmtList.size());
        System.out.println(stmtList.hasNext());
        TCustomSqlStatement topLevelStmt = stmtList.next();
        System.out.println(topLevelStmt.toString());
        for (int i = 0; i < parser.sqlstatements.size(); ++i) {
            TCustomSqlStatement tCustomSqlStatement = parser.sqlstatements.get(i);
        }
    }

    static void parseSQLInputStream(EDbVendor db, String file) {
        TGSqlParser sqlparser = new TGSqlParser(db);
        String fullSql = "select * from foo";
        try {
            FileInputStream inputStream = new FileInputStream(file);
            sqlparser.setSqlInputStream(inputStream);
            int ret = sqlparser.parse();
            if (ret == 0) {
                System.out.println("parse ok, statements:" + sqlparser.sqlstatements.size());
            } else {
                System.out.println("error:" + sqlparser.getErrormessage());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    static void mysqlPerformanceText() {
        int num = 1000;
        long t = System.currentTimeMillis();
        for (int i = 0; i < num; ++i) {
            TGSqlParser sqlParser = new TGSqlParser(EDbVendor.dbvmysql);
            sqlParser.sqltext = "select * from foo" + i;
            int n = sqlParser.parse();
        }
        System.out.println("Time Escaped: " + (System.currentTimeMillis() - t) + " for " + num);
    }

    static void teradataTest() {
        String sql;
        TGSqlParser sqlParser = new TGSqlParser(EDbVendor.dbvteradata);
        sqlParser.sqltext = sql = "select TIMESTAMP '1999-07-01 15:00:00-08:00'\nfrom dual;";
        int ret = sqlParser.parse();
        if (ret != 0) {
            System.out.println(sqlParser.getErrormessage());
            return;
        }
        TSelectSqlStatement select = (TSelectSqlStatement)sqlParser.sqlstatements.get(0);
        TResultColumnList columnList = select.getResultColumnList();
        TResultColumn column = null;
        for (int i = 0; i < columnList.size(); ++i) {
            column = columnList.getResultColumn(i);
            System.out.println(column.toString());
        }
    }

    static void selecttoString() {
        String sql;
        TGSqlParser sqlParser = new TGSqlParser(EDbVendor.dbvoracle);
        sqlParser.sqltext = sql = "SELECT R.* FROM REGIONS R";
        sqlParser.parse();
        TSelectSqlStatement select = (TSelectSqlStatement)sqlParser.sqlstatements.get(0);
        System.out.println(select.toString());
    }

    static void tokenizeSqltext(EDbVendor db, String filename) {
        TGSqlParser sqlparser = new TGSqlParser(db);
        sqlparser.sqlfilename = filename;
        sqlparser.tokenizeSqltext();
        for (int i = 0; i < sqlparser.sourcetokenlist.size(); ++i) {
            TSourceToken st = sqlparser.sourcetokenlist.get(i);
            System.out.printf("line:%d,Column:%d,%s,type:%s,code:%d\n", new Object[]{st.lineNo, st.columnNo, st.tokentype == ETokenType.ttreturn ? "linebreak" : st.toString(), st.tokentype, st.tokencode});
        }
    }

    static void textVisitor(EDbVendor db, String filename) {
        TGSqlParser sqlparser = new TGSqlParser(db);
        sqlparser.sqlfilename = filename;
        int ret = sqlparser.parse();
        if (ret == 0) {
            TtextVisitor tv = new TtextVisitor();
            for (int i = 0; i < sqlparser.sqlstatements.size(); ++i) {
                sqlparser.sqlstatements.get(i).accept(tv);
            }
        } else {
            System.out.println(sqlparser.getErrormessage());
        }
    }

    static void modifySql(String sqlfile) {
        TGSqlParser sqlparser = new TGSqlParser(EDbVendor.dbvoracle);
        sqlparser.sqlfilename = sqlfile;
        int ret = sqlparser.parse();
        if (ret == 0) {
            TCustomSqlStatement s = sqlparser.sqlstatements.get(0);
            for (int i = 0; i < s.tables.size(); ++i) {
                TTable t = s.tables.getTable(i);
                if (t.toString().compareToIgnoreCase("table2") != 0) continue;
                for (int j = 0; j < t.getObjectNameReferences().size(); ++j) {
                    System.out.println(t.getObjectNameReferences().getObjectName(j).toString());
                }
                t.setString("(tableX join tableY using (id)) as table2");
            }
            System.out.println(s.toString());
        } else {
            System.out.println(sqlparser.getErrormessage());
        }
    }

    static void parsetext(EDbVendor db, String sql) {
        TGSqlParser sqlparser = new TGSqlParser(db);
        sqlparser.sqltext = sql;
        int ret = sqlparser.parse();
        if (ret == 0) {
            System.out.println("Successfully check syntax!");
        } else {
            System.out.println(sqlparser.getErrormessage());
        }
    }

    static void parseallfiles() {
    }

    static void toScript(EDbVendor db, String file) {
        int ret = 0;
        TGSqlParser sqlparser = new TGSqlParser(db);
        System.out.println("Parsing with " + (Object)((Object)db) + " ...");
        sqlparser.sqlfilename = file;
        ret = sqlparser.parse();
        for (int j = 0; j < sqlparser.sqlstatements.size(); ++j) {
            System.out.println("sql type: " + (Object)((Object)sqlparser.sqlstatements.get((int)j).sqlstatementtype) + "(" + sqlparser.sqlstatements.get(j).getClass().toString() + "), " + sqlparser.sqlstatements.get(j).getStartToken().toString() + "(" + sqlparser.sqlstatements.get((int)j).getStartToken().lineNo + "," + sqlparser.sqlstatements.get((int)j).getStartToken().columnNo + ")");
            System.out.println(sqlparser.sqlstatements.get(j).toScript());
        }
        if (ret == 0) {
            System.out.println("sqls: " + sqlparser.sqlstatements.size());
        } else {
            System.out.println("error: " + sqlparser.getErrormessage());
        }
    }

    static void parse(EDbVendor db, String file) {
        int ret = 0;
        TGSqlParser sqlparser = new TGSqlParser(db);
        System.out.println("Parsing with " + (Object)((Object)db) + " ...");
        sqlparser.sqlfilename = file;
        ret = sqlparser.parse();
        for (int j = 0; j < sqlparser.sqlstatements.size(); ++j) {
            System.out.print("sql type: " + (Object)((Object)sqlparser.sqlstatements.get((int)j).sqlstatementtype) + "(" + sqlparser.sqlstatements.get(j).getClass().toString() + "), " + sqlparser.sqlstatements.get(j).getStartToken().toString() + "(" + sqlparser.sqlstatements.get((int)j).getStartToken().lineNo + "," + sqlparser.sqlstatements.get((int)j).getStartToken().columnNo + ")");
            if (sqlparser.sqlstatements.get((int)j).sqlstatementtype == ESqlStatementType.sstDrop) {
                TDropStmt stmt = (TDropStmt)sqlparser.sqlstatements.get(j);
                System.out.printf("\tDBType:%s, Name:%s\n", new Object[]{stmt.getDbObjectType(), stmt.getDbObjectName()});
                continue;
            }
            System.out.print("\n");
        }
        if (ret == 0) {
            System.out.println("sqls: " + sqlparser.sqlstatements.size());
        } else {
            System.out.println("error: " + sqlparser.getErrormessage());
        }
    }

    static void parseAndFetch(EDbVendor db, String file) {
        TGSqlParser sqlparser = new TGSqlParser(db);
        sqlparser.sqlfilename = file;
        int ret = sqlparser.parse();
        for (int j = 0; j < sqlparser.sqlstatements.size(); ++j) {
            System.out.println("sql type: " + (Object)((Object)sqlparser.sqlstatements.get((int)j).sqlstatementtype));
            TCustomSqlStatement st = sqlparser.sqlstatements.get(j);
            demo.analyzeStmt(st, 1);
        }
        if (ret == 0) {
            System.out.println("sqls: " + sqlparser.sqlstatements.size());
        } else {
            System.out.println("error: " + sqlparser.getErrormessage());
        }
    }

    private static void analyzeStmt(TCustomSqlStatement st, int level) {
        int i;
        System.out.println("/----------------- " + level + " ----------------- ");
        System.out.println(st.getClass());
        System.out.println(st.toString());
        System.out.println("result columns:" + st.getResultColumnList().size());
        for (i = 0; i < st.getResultColumnList().size(); ++i) {
            System.out.println("Column:" + st.getResultColumnList().getResultColumn(i).toString());
        }
        System.out.println("join tables:" + st.joins.size());
        for (i = 0; i < st.joins.size(); ++i) {
            System.out.println("Table:" + st.joins.getJoin(i).toString());
        }
        for (i = 0; i < st.getStatements().size(); ++i) {
            TCustomSqlStatement st1 = st.getStatements().get(i);
            demo.analyzeStmt(st1, level + 1);
        }
        System.out.println("----------------- " + level + " ----------------- /");
    }

    static void getrawsqlstatements(EDbVendor db, String file) {
        TGSqlParser sqlparser = new TGSqlParser(db);
        sqlparser.sqlfilename = file;
        int ret = -1;
        ret = sqlparser.getrawsqlstatements();
        if (ret == 0) {
            for (int j = 0; j < sqlparser.sqlstatements.size(); ++j) {
                TCustomSqlStatement stmt = sqlparser.sqlstatements.get(j);
                System.out.printf("sql type: %s, %s(%d,%d) to %s(%d,%d)\n", new Object[]{stmt.sqlstatementtype, stmt.getStartToken().toString(), stmt.getStartToken().lineNo, stmt.getStartToken().columnNo, stmt.getEndToken().tokentype == ETokenType.ttreturn ? "linebreak" : stmt.getEndToken().toString(), stmt.getEndToken().lineNo, stmt.getEndToken().columnNo});
            }
        } else {
            System.out.println("error: " + sqlparser.getErrormessage());
        }
    }

    public static boolean moveFile(String sourcePath, String targetPath) {
        File fileToMove = new File(sourcePath);
        return fileToMove.renameTo(new File(targetPath));
    }

    static void parsefiles(EDbVendor db, String dir) {
        int e = 0;
        boolean m = false;
        TGSqlParser sqlparser = new TGSqlParser(db);
        SqlFileList sqlfiles = new SqlFileList(dir, true);
        for (int k = 0; k < sqlfiles.sqlfiles.size(); ++k) {
            sqlparser.sqlfilename = sqlfiles.sqlfiles.get(k).toString();
            int i = sqlparser.parse();
            if (i == 0) continue;
            ++e;
            System.out.println("syntax error: " + sqlfiles.sqlfiles.get(k));
        }
        System.out.println(db.toString() + " total sql files: " + sqlfiles.sqlfiles.size() + ", error files: " + e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateKeywordList(String keywordFile, String outFile) throws IOException {
        BufferedReader reader = null;
        BufferedReader reader2 = null;
        PrintWriter outputStream = null;
        ArrayList rows = new ArrayList();
        ArrayList<String> oldkeys = new ArrayList<String>();
        try {
            String[] strArr;
            String file;
            reader = new BufferedReader(new FileReader("c:\\prg\\tmp\\demo.sql"));
            reader2 = new BufferedReader(new FileReader(keywordFile));
            outputStream = new PrintWriter(new FileWriter(outFile));
            while ((file = reader2.readLine()) != null) {
                oldkeys.add(file);
            }
            Collections.sort(oldkeys);
            for (String cur : strArr = oldkeys.toArray(new String[0])) {
                outputStream.printf("addkeyword('%s',\tRW_%s,\tttkeyword);\n", cur.trim(), cur.trim());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (reader2 != null) {
                reader2.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

