/*
 * Decompiled with CFR 0.152.
 */
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.nodes.TObjectName;

class crud {
    public static final int max_tables = 100;
    tableEffected[] tables;
    int total_tables;
    EDbVendor dbvendor;
    String sqlfile;

    public crud(EDbVendor db, String sqlfile) {
        this.dbvendor = db;
        this.sqlfile = sqlfile;
        this.tables = new tableEffected[100];
        this.total_tables = 0;
    }

    public int run() {
        TGSqlParser sqlparser = new TGSqlParser(this.dbvendor);
        sqlparser.sqlfilename = this.sqlfile;
        int ret = sqlparser.parse();
        if (ret != 0) {
            System.out.println(sqlparser.getErrormessage());
            return ret;
        }
        for (int i = 0; i < sqlparser.sqlstatements.size(); ++i) {
            this.analyzeStmt(sqlparser.sqlstatements.get(i));
        }
        this.showResult();
        return ret;
    }

    void showResult() {
        String str = "";
        for (int i = 0; i < this.total_tables; ++i) {
            for (int j = 0; j < 5; ++j) {
                str = str + "\t\t\t\t" + this.tables[i].statetments[j] + "(" + tableEffected.stmtstr[j] + ")";
            }
            System.out.println(this.tables[i].tablename.toString() + str);
            str = "";
        }
    }

    protected void analyzeStmt(TCustomSqlStatement stmt) {
        int i;
        block7: for (i = 0; i < stmt.tables.size(); ++i) {
            if (!stmt.tables.getTable(i).isBaseTable() || stmt.dbvendor == EDbVendor.dbvmssql && (stmt.tables.getTable(i).getFullName().equalsIgnoreCase("deleted") || stmt.tables.getTable(i).getFullName().equalsIgnoreCase("inserted"))) continue;
            switch (stmt.sqlstatementtype) {
                case sstselect: {
                    this.addTable(stmt.tables.getTable(i).getTableName(), 0);
                    continue block7;
                }
                case sstcreatetable: {
                    this.addTable(stmt.tables.getTable(i).getTableName(), 1);
                    continue block7;
                }
                case sstdelete: {
                    if (i == 0) {
                        this.addTable(stmt.tables.getTable(i).getTableName(), 2);
                        continue block7;
                    }
                    this.addTable(stmt.tables.getTable(i).getTableName(), 0);
                    continue block7;
                }
                case sstinsert: {
                    this.addTable(stmt.tables.getTable(i).getTableName(), 3);
                    continue block7;
                }
                case sstupdate: {
                    if (i == 0) {
                        this.addTable(stmt.tables.getTable(i).getTableName(), 4);
                        continue block7;
                    }
                    this.addTable(stmt.tables.getTable(i).getTableName(), 0);
                    continue block7;
                }
                default: {
                    System.out.println(stmt.sqlstatementtype.toString() + " was not supported in current version, this version able to get table information from select/create table/delete/insert/update");
                }
            }
        }
        for (i = 0; i < stmt.getStatements().size(); ++i) {
            this.analyzeStmt(stmt.getStatements().get(i));
        }
    }

    void addTable(TObjectName tablename, int kind) {
        boolean isFound = false;
        for (int i = 0; i < this.total_tables; ++i) {
            if (this.tables[i].tablename.toString().compareToIgnoreCase(tablename.toString()) != 0) continue;
            int n = kind;
            this.tables[i].statetments[n] = this.tables[i].statetments[n] + 1;
            isFound = true;
            break;
        }
        if (!isFound) {
            this.tables[this.total_tables] = new tableEffected();
            this.tables[this.total_tables].tablename = tablename;
            int n = kind;
            this.tables[this.total_tables].statetments[n] = this.tables[this.total_tables].statetments[n] + 1;
            ++this.total_tables;
        }
    }
}

