/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

class SqlFileList {
    public final List<String> sqlfiles = new ArrayList<String>();
    private String suffix = ".sql";

    public SqlFileList(String dir, boolean includeSubDir) {
        File parent = new File(dir);
        if (parent.exists() && parent.isDirectory()) {
            this.traverseSqlFiles(parent, includeSubDir);
        }
    }

    public SqlFileList(String dir, boolean includeSubDir, String suffix) {
        this.suffix = suffix;
        File parent = new File(dir);
        if (parent.exists() && parent.isDirectory()) {
            this.traverseSqlFiles(parent, includeSubDir);
        }
    }

    public SqlFileList(String dir) {
        this(dir, false);
    }

    private void traverseSqlFiles(File parent, boolean includeSubDir) {
        File[] files = parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.getName().toLowerCase().endsWith(SqlFileList.this.suffix)) {
                    SqlFileList.this.sqlfiles.add(file.getAbsolutePath());
                }
                return file.isDirectory();
            }
        });
        if (includeSubDir && files != null && files.length > 0) {
            for (File file : files) {
                this.traverseSqlFiles(file, includeSubDir);
            }
        }
    }
}

