/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

class SQLUtil {
    SQLUtil() {
    }

    public static String getFileContent(File file) {
        String charset = null;
        String sqlfilename = file.getAbsolutePath();
        int read = 0;
        try {
            FileInputStream fr = new FileInputStream(sqlfilename);
            byte[] bom = new byte[4];
            fr.read(bom, 0, bom.length);
            if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                charset = "UTF-32BE";
                read = 4;
            } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                charset = "UTF-32LE";
                read = 4;
            } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                charset = "UTF-8";
                read = 3;
            } else if (bom[0] == -2 && bom[1] == -1) {
                charset = "UTF-16BE";
                read = 2;
            } else if (bom[0] == -1 && bom[1] == -2) {
                charset = "UTF-16LE";
                read = 2;
            } else {
                charset = Charset.defaultCharset().name();
                read = 0;
            }
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(sqlfilename));
            ((InputStream)in).read(filecontent);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] content = new byte[filelength.intValue() - read];
        System.arraycopy(filecontent, read, content, 0, content.length);
        try {
            String fileContent = new String(content, charset == null ? Charset.defaultCharset().name() : charset).trim();
            return fileContent;
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("The OS does not support " + charset == null ? Charset.defaultCharset().name() : charset);
            return null;
        }
    }

    public static String getInputStreamContent(InputStream is, boolean close) {
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            byte[] tmp = new byte[4096];
            while ((r = is.read(tmp)) != -1) {
                out.write(tmp, 0, r);
            }
            byte[] bytes = out.toByteArray();
            if (close) {
                is.close();
            }
            out.close();
            String content = new String(bytes);
            return content.trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFileContent(String filePath) {
        if (filePath == null) {
            return "";
        }
        File file = new File(filePath);
        if (!file.exists() || file.isDirectory()) {
            return "";
        }
        return SQLUtil.getFileContent(file);
    }

    public static InputStream getInputStreamWithoutBom(String file) throws IOException {
        UnicodeInputStream stream = null;
        FileInputStream fis = new FileInputStream(file);
        stream = new UnicodeInputStream(fis, null);
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileContent(File file, String sql) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            pw.write(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static class UnicodeInputStream
    extends InputStream {
        PushbackInputStream internalIn;
        boolean isInited = false;
        String defaultEnc;
        String encoding;
        private static final int BOM_SIZE = 4;

        public UnicodeInputStream(InputStream in, String defaultEnc) {
            this.internalIn = new PushbackInputStream(in, 4);
            this.defaultEnc = defaultEnc;
        }

        public String getDefaultEncoding() {
            return this.defaultEnc;
        }

        public String getEncoding() {
            if (!this.isInited) {
                try {
                    this.init();
                }
                catch (IOException ex) {
                    IllegalStateException ise = new IllegalStateException("Init method failed.");
                    ise.initCause(ise);
                    throw ise;
                }
            }
            return this.encoding;
        }

        protected void init() throws IOException {
            int unread;
            if (this.isInited) {
                return;
            }
            byte[] bom = new byte[4];
            int n = this.internalIn.read(bom, 0, bom.length);
            if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                this.encoding = "UTF-32BE";
                unread = n - 4;
            } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                this.encoding = "UTF-32LE";
                unread = n - 4;
            } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                this.encoding = "UTF-8";
                unread = n - 3;
            } else if (bom[0] == -2 && bom[1] == -1) {
                this.encoding = "UTF-16BE";
                unread = n - 2;
            } else if (bom[0] == -1 && bom[1] == -2) {
                this.encoding = "UTF-16LE";
                unread = n - 2;
            } else {
                this.encoding = this.defaultEnc;
                unread = n;
            }
            if (unread > 0) {
                this.internalIn.unread(bom, n - unread, unread);
            }
            this.isInited = true;
        }

        @Override
        public void close() throws IOException {
            this.internalIn.close();
        }

        @Override
        public int read() throws IOException {
            return this.internalIn.read();
        }
    }
}

