/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast.visitors;

import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.buffer.LongArrayBuffer;
import com.oracle.truffle.regex.tregex.nfa.ASTNodeSet;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.Set;
import org.graalvm.collections.EconomicMap;

public abstract class NFATraversalRegexASTVisitor {
    private static final int SUCCESSOR_DEDUPLICATION_BAILOUT_THRESHOLD = 100000;
    protected final RegexAST ast;
    private final LongArrayBuffer curPath = new LongArrayBuffer(8);
    private final ASTNodeSet<Group> insideEmptyGuardGroup;
    private final ASTNodeSet<Group> insideLoops;
    private RegexASTNode cur;
    private Set<LookBehindAssertion> traversableLookBehindAssertions;
    private boolean canTraverseCaret = false;
    private boolean reverse = false;
    private boolean done = false;
    private final EconomicMap<ASTNodeSet<RegexASTNode>, ASTNodeSet<RegexASTNode>> targetDeduplicationMap = EconomicMap.create();
    private final ASTNodeSet<RegexASTNode> dollarsOrLookAheadsOnPath;
    private final ASTNodeSet<RegexASTNode> targetsVisited;
    private final int[] nodeVisitCount;
    private int dollarsOnPath = 0;
    private int deduplicatedTargets = 0;
    private final CompilationFinalBitSet captureGroupUpdates;
    private final CompilationFinalBitSet captureGroupClears;
    private static final int PATH_GROUP_ALT_INDEX_OFFSET = 0;
    private static final int PATH_NODE_OFFSET = 16;
    private static final int PATH_GROUP_ACTION_OFFSET = 32;
    private static final long PATH_GROUP_ACTION_ENTER = 0x100000000L;
    private static final long PATH_GROUP_ACTION_EXIT = 0x200000000L;
    private static final long PATH_GROUP_ACTION_PASS_THROUGH = 0x400000000L;
    private static final long PATH_GROUP_ACTION_ENTER_OR_PASS_THROUGH = 0x500000000L;
    private static final long PATH_GROUP_ACTION_TO_ENTER_MASK = -281466386776065L;
    private static final long PATH_GROUP_ACTION_ANY = 0x700000000L;

    protected NFATraversalRegexASTVisitor(RegexAST ast) {
        this.ast = ast;
        this.insideEmptyGuardGroup = new ASTNodeSet(ast);
        this.insideLoops = new ASTNodeSet(ast);
        this.targetsVisited = new ASTNodeSet(ast);
        this.dollarsOrLookAheadsOnPath = new ASTNodeSet(ast);
        this.nodeVisitCount = new int[ast.getNumberOfStates()];
        this.captureGroupUpdates = new CompilationFinalBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.captureGroupClears = new CompilationFinalBitSet(ast.getNumberOfCaptureGroups() * 2);
    }

    public Set<LookBehindAssertion> getTraversableLookBehindAssertions() {
        return this.traversableLookBehindAssertions;
    }

    public void setTraversableLookBehindAssertions(Set<LookBehindAssertion> traversableLookBehindAssertions) {
        this.traversableLookBehindAssertions = traversableLookBehindAssertions;
    }

    public boolean canTraverseCaret() {
        return this.canTraverseCaret;
    }

    public void setCanTraverseCaret(boolean canTraverseCaret) {
        this.canTraverseCaret = canTraverseCaret;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    protected void run(Term runRoot) {
        assert (this.insideEmptyGuardGroup.isEmpty());
        assert (this.insideLoops.isEmpty());
        assert (this.curPath.isEmpty());
        assert (this.dollarsOrLookAheadsOnPath.isEmpty());
        this.targetsVisited.clear();
        this.targetDeduplicationMap.clear();
        this.deduplicatedTargets = 0;
        if (runRoot instanceof Group) {
            this.cur = runRoot;
        } else {
            this.advanceTerm(runRoot);
        }
        while (!this.done) {
            while (this.doAdvance()) {
            }
            if (this.done) break;
            this.visit(this.pathGetNode(this.curPath.peek()));
            this.retreat();
        }
        this.done = false;
    }

    protected abstract void visit(RegexASTNode var1);

    protected abstract void enterLookAhead(LookAheadAssertion var1);

    protected abstract void leaveLookAhead(LookAheadAssertion var1);

    private boolean dollarsOrLookAheadsOnPath() {
        return !this.dollarsOrLookAheadsOnPath.isEmpty();
    }

    protected boolean dollarsOnPath() {
        return this.dollarsOnPath > 0;
    }

    protected PositionAssertion getLastDollarOnPath() {
        assert (this.dollarsOnPath());
        for (int i = this.curPath.length() - 1; i >= 0; --i) {
            long element = this.curPath.get(i);
            if (!(this.pathGetNode(element) instanceof PositionAssertion) || ((PositionAssertion)this.pathGetNode((long)element)).type != PositionAssertion.Type.DOLLAR) continue;
            return (PositionAssertion)this.pathGetNode(element);
        }
        throw new IllegalStateException();
    }

    protected GroupBoundaries getGroupBoundaries() {
        this.captureGroupUpdates.clear();
        this.captureGroupClears.clear();
        for (int i = 0; i < this.curPath.length(); ++i) {
            long element = this.curPath.get(i);
            if (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(element) || !NFATraversalRegexASTVisitor.pathIsGroup(element)) continue;
            Group group = (Group)this.pathGetNode(element);
            if (group.isCapturing()) {
                this.captureGroupUpdates.set(NFATraversalRegexASTVisitor.pathIsGroupEnter(element) ? group.getBoundaryIndexStart() : group.getBoundaryIndexEnd());
            }
            assert (!group.isLoop() || group.isExpandedQuantifier());
            if (!group.isExpandedQuantifier() || !group.hasEnclosedCaptureGroups() || !NFATraversalRegexASTVisitor.pathIsGroupEnter(element)) continue;
            this.captureGroupClears.setRange(Group.groupNumberToBoundaryIndexStart(group.getEnclosedCaptureGroupsLow()), Group.groupNumberToBoundaryIndexEnd(group.getEnclosedCaptureGroupsHigh() - 1));
        }
        this.captureGroupClears.subtract(this.captureGroupUpdates);
        return this.ast.createGroupBoundaries(this.captureGroupUpdates, this.captureGroupClears);
    }

    private boolean doAdvance() {
        if (this.cur.isDead() || this.insideLoops.contains(this.cur)) {
            return this.retreat();
        }
        if (this.cur instanceof Sequence) {
            Sequence sequence = (Sequence)this.cur;
            if (sequence.isEmpty()) {
                Group parent = sequence.getParent();
                if (parent.isLoop()) {
                    this.insideLoops.remove(parent);
                }
                if (parent.isExpandedQuantifier()) {
                    long lastElement = this.curPath.pop();
                    assert (this.pathGetNode(lastElement) == parent && NFATraversalRegexASTVisitor.pathIsGroupEnter(lastElement));
                    this.curPath.add(NFATraversalRegexASTVisitor.pathSwitchEnterAndPassThrough(lastElement));
                } else {
                    this.pushGroupExit(parent);
                }
                return this.advanceTerm(parent);
            }
            this.cur = this.reverse ? sequence.getLastTerm() : sequence.getFirstTerm();
            return true;
        }
        if (this.cur instanceof Group) {
            Group group = (Group)this.cur;
            this.curPath.add(NFATraversalRegexASTVisitor.createGroupEnterPathElement(group));
            if (group.hasEmptyGuard()) {
                this.insideEmptyGuardGroup.add(group);
            }
            if (group.isLoop()) {
                this.insideLoops.add(group);
            }
            this.cur = group.getAlternatives().get(0);
            return true;
        }
        this.curPath.add(NFATraversalRegexASTVisitor.createPathElement(this.cur));
        if (this.cur instanceof PositionAssertion) {
            PositionAssertion assertion = (PositionAssertion)this.cur;
            switch (assertion.type) {
                case CARET: {
                    if (this.canTraverseCaret) {
                        return this.advanceTerm(assertion);
                    }
                    return this.retreat();
                }
                case DOLLAR: {
                    ++this.dollarsOnPath;
                    return this.advanceDedupRelevantTerm();
                }
            }
            throw new IllegalStateException();
        }
        if (this.cur instanceof LookAheadAssertion) {
            this.enterLookAhead((LookAheadAssertion)this.cur);
            return this.advanceDedupRelevantTerm();
        }
        if (this.cur instanceof LookBehindAssertion) {
            if (this.traversableLookBehindAssertions == null || this.traversableLookBehindAssertions.contains(this.cur)) {
                return this.advanceTerm((LookBehindAssertion)this.cur);
            }
            return this.retreat();
        }
        if (this.cur instanceof CharacterClass) {
            if (!this.reverse && this.dollarsOnPath()) {
                return this.retreat();
            }
            return this.deduplicateTarget();
        }
        if (this.cur instanceof BackReference) {
            throw new UnsupportedRegexException("back-references are not suitable for this visitor!");
        }
        if (this.cur instanceof MatchFound) {
            return this.deduplicateTarget();
        }
        throw new IllegalStateException();
    }

    private boolean advanceDedupRelevantTerm() {
        short s = this.cur.getId();
        this.nodeVisitCount[s] = this.nodeVisitCount[s] + 1;
        this.dollarsOrLookAheadsOnPath.add(this.cur);
        return this.advanceTerm((Term)this.cur);
    }

    private boolean advanceTerm(Term term) {
        if (this.ast.isNFAInitialState(term)) {
            assert (term instanceof PositionAssertion || term instanceof MatchFound);
            this.cur = term instanceof PositionAssertion ? ((PositionAssertion)term).getNext() : ((MatchFound)term).getNext();
            return true;
        }
        Term curTerm = term;
        while (!(curTerm.getParent() instanceof RegexASTSubtreeRootNode)) {
            if (curTerm.hasEmptyGuard() && this.insideEmptyGuardGroup.contains(curTerm)) {
                return this.retreat();
            }
            Sequence parentSeq = (Sequence)curTerm.getParent();
            if (curTerm == (this.reverse ? parentSeq.getFirstTerm() : parentSeq.getLastTerm())) {
                Group parentGroup = parentSeq.getParent();
                this.pushGroupExit(parentGroup);
                if (parentGroup.isLoop()) {
                    this.cur = parentGroup;
                    return true;
                }
                curTerm = parentGroup;
                continue;
            }
            this.cur = parentSeq.getTerms().get(curTerm.getSeqIndex() + (this.reverse ? -1 : 1));
            return true;
        }
        assert (curTerm instanceof Group);
        assert (curTerm.getParent() instanceof RegexASTSubtreeRootNode);
        if (curTerm.hasEmptyGuard() && this.insideEmptyGuardGroup.contains(curTerm)) {
            return this.retreat();
        }
        this.cur = curTerm.getSubTreeParent().getMatchFound();
        return true;
    }

    private void pushGroupExit(Group group) {
        this.curPath.add(NFATraversalRegexASTVisitor.createPathElement(group) | 0x200000000L);
    }

    private boolean retreat() {
        while (!this.curPath.isEmpty()) {
            long lastVisited = this.curPath.pop();
            if (NFATraversalRegexASTVisitor.pathIsGroup(lastVisited)) {
                Group group = (Group)this.pathGetNode(lastVisited);
                if (NFATraversalRegexASTVisitor.pathIsGroupExit(lastVisited)) continue;
                if (this.pathGroupHasNext(lastVisited)) {
                    this.cur = this.pathGroupGetNext(lastVisited);
                    this.curPath.add(NFATraversalRegexASTVisitor.pathToGroupEnter(NFATraversalRegexASTVisitor.pathIncGroupAltIndex(lastVisited)));
                    return true;
                }
                assert (this.noEmptyGuardEnterOnPath(group));
                assert (!group.hasEmptyGuard() || this.insideEmptyGuardGroup.contains(group));
                this.insideEmptyGuardGroup.remove(group);
                if (!group.isLoop()) continue;
                this.insideLoops.remove(group);
                continue;
            }
            if (this.pathGetNode(lastVisited) instanceof LookAheadAssertion) {
                LookAheadAssertion assertion = (LookAheadAssertion)this.pathGetNode(lastVisited);
                this.leaveLookAhead(assertion);
                this.retreatDedupRelevantTerm(lastVisited);
                continue;
            }
            if (!(this.pathGetNode(lastVisited) instanceof PositionAssertion) || ((PositionAssertion)this.pathGetNode((long)lastVisited)).type != PositionAssertion.Type.DOLLAR) continue;
            --this.dollarsOnPath;
            this.retreatDedupRelevantTerm(lastVisited);
        }
        this.done = true;
        return false;
    }

    private void retreatDedupRelevantTerm(long lastVisited) {
        int n = NFATraversalRegexASTVisitor.pathGetNodeId(lastVisited);
        this.nodeVisitCount[n] = this.nodeVisitCount[n] - 1;
        if (this.nodeVisitCount[n] == 0) {
            this.dollarsOrLookAheadsOnPath.remove(this.pathGetNode(lastVisited));
        }
    }

    private boolean deduplicateTarget() {
        boolean isDuplicate = false;
        if (!this.dollarsOrLookAheadsOnPath()) {
            isDuplicate = !this.targetsVisited.add(this.cur);
        } else {
            StateSet key = this.dollarsOrLookAheadsOnPath.copy();
            key.add(this.cur);
            boolean bl = isDuplicate = this.targetDeduplicationMap.put((Object)key, (Object)key) != null;
        }
        if (isDuplicate) {
            if (++this.deduplicatedTargets > 100000) {
                throw new UnsupportedRegexException("NFATraversal explosion");
            }
            return this.retreat();
        }
        return false;
    }

    private static long createPathElement(RegexASTNode node) {
        return (long)node.getId() << 16;
    }

    private static long createGroupEnterPathElement(Group node) {
        return (long)node.getId() << 16 | 1L | 0x100000000L;
    }

    private static int pathGetNodeId(long pathElement) {
        return (short)(pathElement >>> 16);
    }

    private RegexASTNode pathGetNode(long pathElement) {
        return this.ast.getState(NFATraversalRegexASTVisitor.pathGetNodeId(pathElement));
    }

    private static int pathGetGroupAltIndex(long pathElement) {
        return (short)(pathElement >>> 0);
    }

    private static long pathToGroupEnter(long pathElement) {
        return pathElement & 0xFFFF0001FFFFFFFFL;
    }

    private static boolean pathIsGroup(long pathElement) {
        return (pathElement & 0x700000000L) != 0L;
    }

    private static boolean pathIsGroupEnter(long pathElement) {
        return (pathElement & 0x100000000L) != 0L;
    }

    private static boolean pathIsGroupExit(long pathElement) {
        return (pathElement & 0x200000000L) != 0L;
    }

    private static boolean pathIsGroupPassThrough(long pathElement) {
        return (pathElement & 0x400000000L) != 0L;
    }

    private static long pathSwitchEnterAndPassThrough(long pathElement) {
        assert (NFATraversalRegexASTVisitor.pathIsGroupEnter(pathElement) != NFATraversalRegexASTVisitor.pathIsGroupPassThrough(pathElement));
        return pathElement ^ 0x500000000L;
    }

    private boolean pathGroupHasNext(long pathElement) {
        return NFATraversalRegexASTVisitor.pathGetGroupAltIndex(pathElement) < ((Group)this.pathGetNode(pathElement)).size();
    }

    private Sequence pathGroupGetNext(long pathElement) {
        return ((Group)this.pathGetNode(pathElement)).getAlternatives().get(NFATraversalRegexASTVisitor.pathGetGroupAltIndex(pathElement));
    }

    private static long pathIncGroupAltIndex(long pathElement) {
        return pathElement + 1L;
    }

    private boolean noEmptyGuardEnterOnPath(Group group) {
        if (!group.hasEmptyGuard()) {
            return true;
        }
        for (int i = 0; i < this.curPath.length(); ++i) {
            if (this.pathGetNode(this.curPath.get(i)) != group || !NFATraversalRegexASTVisitor.pathIsGroupEnter(this.curPath.get(i))) continue;
            return false;
        }
        return true;
    }

    private void dumpPath() {
        for (int i = 0; i < this.curPath.length(); ++i) {
            long element = this.curPath.get(i);
            if (NFATraversalRegexASTVisitor.pathIsGroup(element)) {
                Group group = (Group)this.pathGetNode(element);
                if (NFATraversalRegexASTVisitor.pathIsGroupEnter(element)) {
                    System.out.println(String.format("ENTER (%d)   %s", NFATraversalRegexASTVisitor.pathGetGroupAltIndex(element), group));
                    continue;
                }
                if (NFATraversalRegexASTVisitor.pathIsGroupExit(element)) {
                    System.out.println(String.format("EXIT        %s", group));
                    continue;
                }
                System.out.println(String.format("PASSTHROUGH %s", group));
                continue;
            }
            System.out.println(String.format("NODE        %s", this.pathGetNode(element)));
        }
    }
}

