/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexExecRootNode;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.result.NoMatchResult;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.result.RegexResult;
import com.oracle.truffle.regex.tregex.nodes.input.InputEndsWithNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputEqualsNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputStartsWithNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.PreCalcResultVisitor;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public abstract class LiteralRegexExecRootNode
extends RegexExecRootNode
implements JsonConvertible {
    protected final PreCalculatedResultFactory resultFactory;

    public LiteralRegexExecRootNode(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
        super(language, ast.getSource(), ast.getFlags().isUnicode());
        this.resultFactory = preCalcResultVisitor.getResultFactory();
    }

    protected String getLiteral() {
        return "";
    }

    @Override
    protected final String getEngineLabel() {
        return "literal:" + this.getImplName() + "(" + this.getLiteral() + ")";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("method", this.getImplName()), Json.prop("literal", DebugUtil.escapeString(this.getLiteral())), Json.prop("factory", this.resultFactory));
    }

    protected abstract String getImplName();

    public static final class RegionMatches
    extends NonEmptyLiteralRegexExecRootNode {
        @Node.Child
        InputRegionMatchesNode regionMatchesNode = InputRegionMatchesNode.create();

        public RegionMatches(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "regionMatches";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            if (this.regionMatchesNode.execute(input, fromIndex, this.literal, 0, this.literal.length(), this.mask)) {
                return this.resultFactory.createFromStart(fromIndex);
            }
            return NoMatchResult.getInstance();
        }
    }

    public static final class Equals
    extends NonEmptyLiteralRegexExecRootNode {
        @Node.Child
        InputEqualsNode equalsNode = InputEqualsNode.create();

        public Equals(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "equals";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            if (fromIndex == 0 && this.equalsNode.execute(input, this.literal, this.mask)) {
                return this.resultFactory.createFromStart(0);
            }
            return NoMatchResult.getInstance();
        }
    }

    public static final class EndsWith
    extends NonEmptyLiteralRegexExecRootNode {
        @Node.Child
        InputEndsWithNode endsWithNode = InputEndsWithNode.create();

        public EndsWith(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "endsWith";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            if (fromIndex <= this.inputLength(input) - this.literal.length() && this.endsWithNode.execute(input, this.literal, this.mask)) {
                return this.resultFactory.createFromEnd(this.inputLength(input));
            }
            return NoMatchResult.getInstance();
        }
    }

    public static final class StartsWith
    extends NonEmptyLiteralRegexExecRootNode {
        @Node.Child
        InputStartsWithNode startsWithNode = InputStartsWithNode.create();

        public StartsWith(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "startsWith";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            if (fromIndex == 0 && this.startsWithNode.execute(input, this.literal, this.mask)) {
                return this.resultFactory.createFromStart(0);
            }
            return NoMatchResult.getInstance();
        }
    }

    public static final class IndexOfString
    extends NonEmptyLiteralRegexExecRootNode {
        @Node.Child
        InputIndexOfStringNode indexOfStringNode = InputIndexOfStringNode.create();

        public IndexOfString(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "indexOfString";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            int start = this.indexOfStringNode.execute(input, fromIndex, this.inputLength(input), this.literal, this.mask);
            if (start == -1) {
                return NoMatchResult.getInstance();
            }
            return this.resultFactory.createFromStart(start);
        }
    }

    static abstract class NonEmptyLiteralRegexExecRootNode
    extends LiteralRegexExecRootNode {
        protected final String literal;
        protected final String mask;

        NonEmptyLiteralRegexExecRootNode(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
            this.literal = preCalcResultVisitor.getLiteral();
            this.mask = preCalcResultVisitor.getMask();
        }

        @Override
        protected String getLiteral() {
            return this.literal;
        }
    }

    public static final class EmptyEquals
    extends LiteralRegexExecRootNode {
        public EmptyEquals(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "emptyEquals";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            assert (fromIndex <= this.inputLength(input));
            return this.inputLength(input) == 0 ? this.resultFactory.createFromStart(0) : NoMatchResult.getInstance();
        }
    }

    public static final class EmptyEndsWith
    extends LiteralRegexExecRootNode {
        public EmptyEndsWith(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "emptyEndsWith";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            assert (fromIndex <= this.inputLength(input));
            return this.resultFactory.createFromEnd(this.inputLength(input));
        }
    }

    public static final class EmptyStartsWith
    extends LiteralRegexExecRootNode {
        public EmptyStartsWith(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "emptyStartsWith";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            return fromIndex == 0 ? this.resultFactory.createFromStart(0) : NoMatchResult.getInstance();
        }
    }

    public static final class EmptyIndexOf
    extends LiteralRegexExecRootNode {
        public EmptyIndexOf(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "emptyIndexOf";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            return this.resultFactory.createFromStart(fromIndex);
        }
    }
}

