/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.bind.MiniGson;
import com.google.gson.internal.bind.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringToValueMapTypeAdapterFactory
implements TypeAdapter.Factory {
    private final ConstructorConstructor constructorConstructor;

    public StringToValueMapTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(MiniGson context, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Class<T> rawType = typeToken.getRawType();
        if (!Map.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type[] keyAndValueTypes = $Gson$Types.getMapKeyAndValueTypes(type, rawType);
        if (keyAndValueTypes[0] != String.class) {
            return null;
        }
        TypeAdapter<?> valueAdapter = context.getAdapter(TypeToken.get(keyAndValueTypes[1]));
        ObjectConstructor<T> constructor = this.constructorConstructor.getConstructor(typeToken);
        Adapter result = new Adapter(valueAdapter, constructor);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Adapter<V>
    extends TypeAdapter<Map<String, V>> {
        private final TypeAdapter<V> valueTypeAdapter;
        private final ObjectConstructor<? extends Map<String, V>> constructor;

        public Adapter(TypeAdapter<V> valueTypeAdapter, ObjectConstructor<? extends Map<String, V>> constructor) {
            this.valueTypeAdapter = valueTypeAdapter;
            this.constructor = constructor;
        }

        @Override
        public Map<String, V> read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            Map<String, V> map = this.constructor.construct();
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                V value = this.valueTypeAdapter.read(reader);
                map.put(key, value);
            }
            reader.endObject();
            return map;
        }

        @Override
        public void write(JsonWriter writer, Map<String, V> map) throws IOException {
            if (map == null) {
                writer.nullValue();
                return;
            }
            writer.beginObject();
            for (Map.Entry<String, V> entry : map.entrySet()) {
                writer.name(entry.getKey());
                this.valueTypeAdapter.write(writer, entry.getValue());
            }
            writer.endObject();
        }
    }
}

