/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.internal.bind.MiniGson;
import com.google.gson.internal.bind.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapter.Factory FACTORY = new TypeAdapter.Factory(){

        @Override
        public <T> TypeAdapter<T> create(MiniGson context, TypeToken<T> type) {
            if (type.getRawType() == Object.class) {
                return new ObjectTypeAdapter(context);
            }
            return null;
        }
    };
    private final MiniGson miniGson;

    private ObjectTypeAdapter(MiniGson miniGson) {
        this.miniGson = miniGson;
    }

    @Override
    public Object read(JsonReader reader) throws IOException {
        JsonToken token = reader.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                reader.beginArray();
                while (reader.hasNext()) {
                    list.add(this.read(reader));
                }
                reader.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                reader.beginObject();
                while (reader.hasNext()) {
                    map.put(reader.nextName(), this.read(reader));
                }
                reader.endObject();
                return map;
            }
            case STRING: {
                return reader.nextString();
            }
            case NUMBER: {
                return reader.nextDouble();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void write(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        TypeAdapter<?> typeAdapter = this.miniGson.getAdapter(value.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            writer.beginObject();
            writer.endObject();
            return;
        }
        typeAdapter.write(writer, value);
    }
}

