/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type;

import com.orientechnologies.common.io.OIOUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
public class OBuffer
implements Externalizable {
    public byte[] buffer;

    public OBuffer() {
    }

    public OBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    @Override
    public void readExternal(ObjectInput iInput) throws IOException, ClassNotFoundException {
        int bufferLength = iInput.readInt();
        if (bufferLength > 0) {
            this.buffer = new byte[bufferLength];
            int bytesReaded = 0;
            for (int pos = 0; pos < bufferLength; pos += bytesReaded) {
                bytesReaded = iInput.read(this.buffer, pos, this.buffer.length - pos);
            }
        } else {
            this.buffer = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput iOutput) throws IOException {
        int bufferLength = this.buffer != null ? this.buffer.length : 0;
        iOutput.writeInt(bufferLength);
        if (bufferLength > 0) {
            iOutput.write(this.buffer);
        }
    }

    public String toString() {
        return "size:" + (this.buffer != null ? Integer.valueOf(this.buffer.length) : "empty");
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OBuffer)) {
            return false;
        }
        return OIOUtils.equals(this.buffer, ((OBuffer)o).buffer);
    }

    public int hashCode() {
        return this.buffer != null ? Arrays.hashCode(this.buffer) : 0;
    }
}

