/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.ridbag.sbtree;

import com.orientechnologies.common.serialization.types.OBooleanSerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OCompactedLinkSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtree.OSBTreeMapEntryIterator;
import com.orientechnologies.orient.core.storage.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsaiLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class OIndexRIDContainerSBTree
implements Set<OIdentifiable> {
    private static final String INDEX_FILE_EXTENSION = ".irs";
    private final OSBTreeBonsaiLocal<OIdentifiable, Boolean> tree;

    public static String generateLockName(String indexName) {
        return indexName + INDEX_FILE_EXTENSION;
    }

    public OIndexRIDContainerSBTree(long fileId, OAbstractPaginatedStorage storage) {
        OAtomicOperation atomicOperation = storage.getAtomicOperationsManager().getCurrentOperation();
        String fileName = atomicOperation == null ? storage.getWriteCache().fileNameById(fileId) : atomicOperation.fileNameById(fileId);
        this.tree = new OSBTreeBonsaiLocal(fileName.substring(0, fileName.length() - INDEX_FILE_EXTENSION.length()), INDEX_FILE_EXTENSION, storage);
        this.tree.create(OCompactedLinkSerializer.INSTANCE, OBooleanSerializer.INSTANCE);
    }

    public OIndexRIDContainerSBTree(long fileId, OBonsaiBucketPointer rootPointer, boolean durableMode, OAbstractPaginatedStorage storage) {
        OAtomicOperation atomicOperation = storage.getAtomicOperationsManager().getCurrentOperation();
        String fileName = atomicOperation == null ? storage.getWriteCache().fileNameById(fileId) : atomicOperation.fileNameById(fileId);
        this.tree = new OSBTreeBonsaiLocal(fileName.substring(0, fileName.length() - INDEX_FILE_EXTENSION.length()), INDEX_FILE_EXTENSION, storage);
        this.tree.load(rootPointer);
    }

    public OIndexRIDContainerSBTree(String file, OBonsaiBucketPointer rootPointer, boolean durableMode, OAbstractPaginatedStorage storage) {
        this.tree = new OSBTreeBonsaiLocal(file, INDEX_FILE_EXTENSION, storage);
        this.tree.load(rootPointer);
    }

    public OBonsaiBucketPointer getRootPointer() {
        return this.tree.getRootBucketPointer();
    }

    @Override
    public int size() {
        return (int)this.tree.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.size() == 0L;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof OIdentifiable && this.contains((OIdentifiable)o);
    }

    public boolean contains(OIdentifiable o) {
        return this.tree.get(o) != null;
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new TreeKeyIterator(this.tree, false);
    }

    @Override
    public Object[] toArray() {
        ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>(this.size());
        list.addAll(this);
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>(this.size());
        list.addAll(this);
        return list.toArray(a);
    }

    @Override
    public boolean add(OIdentifiable oIdentifiable) {
        return this.tree.put(oIdentifiable, Boolean.TRUE);
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof OIdentifiable && this.remove((OIdentifiable)o);
    }

    public boolean remove(OIdentifiable o) {
        return this.tree.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        boolean modified = false;
        for (OIdentifiable oIdentifiable : c) {
            if (!this.add(oIdentifiable)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<OIdentifiable> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    public void delete() {
        this.tree.delete();
    }

    public String getName() {
        return this.tree.getName();
    }

    private static class TreeKeyIterator
    implements Iterator<OIdentifiable> {
        private final boolean autoConvertToRecord;
        private final OSBTreeMapEntryIterator<OIdentifiable, Boolean> entryIterator;

        public TreeKeyIterator(OTreeInternal<OIdentifiable, Boolean> tree, boolean autoConvertToRecord) {
            this.entryIterator = new OSBTreeMapEntryIterator<OIdentifiable, Boolean>(tree);
            this.autoConvertToRecord = autoConvertToRecord;
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public OIdentifiable next() {
            OIdentifiable identifiable = (OIdentifiable)this.entryIterator.next().getKey();
            if (this.autoConvertToRecord) {
                return identifiable.getRecord();
            }
            return identifiable;
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }
}

