/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.index.hashindex.local.MessageDigestHolder;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashFunction;

public class OSHA256HashFunction<V>
implements OHashFunction<V> {
    private final OBinarySerializer<V> valueSerializer;

    public OSHA256HashFunction(OBinarySerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Override
    public long hashCode(V value) {
        byte[] serializedValue = new byte[this.valueSerializer.getObjectSize(value, new Object[0])];
        this.valueSerializer.serializeNativeObject(value, serializedValue, 0, new Object[0]);
        byte[] digest = MessageDigestHolder.instance().get().digest(serializedValue);
        return OLongSerializer.INSTANCE.deserializeNative(digest, 0);
    }
}

