/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OHashTableDirectoryException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.hashindex.local.ODirectoryFirstPage;
import com.orientechnologies.orient.core.storage.index.hashindex.local.ODirectoryPage;
import java.io.IOException;

public class OHashTableDirectory
extends ODurableComponent {
    static final int ITEM_SIZE = 8;
    private static final int LEVEL_SIZE = 256;
    static final int BINARY_LEVEL_SIZE = 2051;
    private long fileId;
    private final long firstEntryIndex;

    OHashTableDirectory(String defaultExtension, String name, String lockName, OAbstractPaginatedStorage storage) {
        super(storage, name, defaultExtension, lockName);
        this.firstEntryIndex = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(false);
            this.acquireExclusiveLock();
            try {
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.init();
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during creation of hash table", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            OCacheEntry firstEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true);
            if (firstEntry == null) {
                firstEntry = this.addPage(atomicOperation, this.fileId);
                assert (firstEntry.getPageIndex() == 0L);
            }
            this.pinPage(atomicOperation, firstEntry);
            try {
                ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, firstEntry);
                firstPage.setTreeSize(0);
                firstPage.setTombstone(-1);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, firstEntry);
            }
            this.endAtomicOperation(false, null);
        }
        catch (IOException e) {
            this.endAtomicOperation(true, e);
            throw e;
        }
        catch (Exception e) {
            this.endAtomicOperation(true, e);
            throw OException.wrapException(new OHashTableDirectoryException("Error during hash table initialization", this), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                this.fileId = this.openFile(atomicOperation, this.getFullName());
                int filledUpTo = (int)this.getFilledUpTo(atomicOperation, this.fileId);
                for (int i = 0; i < filledUpTo; ++i) {
                    OCacheEntry entry = this.loadPageForRead(atomicOperation, this.fileId, i, true);
                    assert (entry != null);
                    this.pinPage(atomicOperation, entry);
                    this.releasePageFromRead(atomicOperation, entry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    public void close() throws IOException {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                this.readCache.closeFile(this.fileId, true, this.writeCache);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(false);
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during hash table deletion", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteWithoutOpen() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(false);
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    this.fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, this.fileId);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during deletion of hash table", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addNewNode(byte maxLeftChildDepth, byte maxRightChildDepth, byte nodeLocalDepth, long[] newNode) throws IOException {
        this.startOperation();
        try {
            int nodeIndex;
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                block23: {
                    OCacheEntry firstEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true);
                    try {
                        ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, firstEntry);
                        int tombstone = firstPage.getTombstone();
                        if (tombstone >= 0) {
                            nodeIndex = tombstone;
                        } else {
                            nodeIndex = firstPage.getTreeSize();
                            firstPage.setTreeSize(nodeIndex + 1);
                        }
                        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                            int localNodeIndex = nodeIndex;
                            firstPage.setMaxLeftChildDepth(localNodeIndex, maxLeftChildDepth);
                            firstPage.setMaxRightChildDepth(localNodeIndex, maxRightChildDepth);
                            firstPage.setNodeLocalDepth(localNodeIndex, nodeLocalDepth);
                            if (tombstone >= 0) {
                                firstPage.setTombstone((int)firstPage.getPointer(nodeIndex, 0));
                            }
                            for (int i = 0; i < newNode.length; ++i) {
                                firstPage.setPointer(localNodeIndex, i, newNode[i]);
                            }
                            break block23;
                        }
                        int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
                        int localLevel = nodeIndex % ODirectoryPage.NODES_PER_PAGE;
                        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, true);
                        while (cacheEntry == null || cacheEntry.getPageIndex() < (long)pageIndex) {
                            if (cacheEntry != null) {
                                this.releasePageFromWrite(atomicOperation, cacheEntry);
                            }
                            cacheEntry = this.addPage(atomicOperation, this.fileId);
                        }
                        try {
                            ODirectoryPage page = new ODirectoryPage(cacheEntry, cacheEntry);
                            page.setMaxLeftChildDepth(localLevel, maxLeftChildDepth);
                            page.setMaxRightChildDepth(localLevel, maxRightChildDepth);
                            page.setNodeLocalDepth(localLevel, nodeLocalDepth);
                            if (tombstone >= 0) {
                                firstPage.setTombstone((int)page.getPointer(localLevel, 0));
                            }
                            for (int i = 0; i < newNode.length; ++i) {
                                page.setPointer(localLevel, i, newNode[i]);
                            }
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, cacheEntry);
                        }
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, firstEntry);
                    }
                }
                this.endAtomicOperation(false, null);
            }
            catch (RuntimeException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            finally {
                this.releaseExclusiveLock();
            }
            int n = nodeIndex;
            return n;
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteNode(int nodeIndex) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                block16: {
                    OCacheEntry firstEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true);
                    try {
                        ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, firstEntry);
                        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                            firstPage.setPointer(nodeIndex, 0, firstPage.getTombstone());
                            firstPage.setTombstone(nodeIndex);
                            break block16;
                        }
                        int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
                        int localNodeIndex = nodeIndex % ODirectoryPage.NODES_PER_PAGE;
                        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, true);
                        try {
                            ODirectoryPage page = new ODirectoryPage(cacheEntry, cacheEntry);
                            page.setPointer(localNodeIndex, 0, firstPage.getTombstone());
                            firstPage.setTombstone(nodeIndex);
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, cacheEntry);
                        }
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, firstEntry);
                    }
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during node deletion", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    byte getMaxLeftChildDepth(int nodeIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxLeftChildDepth(int nodeIndex, byte maxLeftChildDepth) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    page.setMaxLeftChildDepth(this.getLocalNodeIndex(nodeIndex), maxLeftChildDepth);
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of max left child depth", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    byte getMaxRightChildDepth(int nodeIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxRightChildDepth(int nodeIndex, byte maxRightChildDepth) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    page.setMaxRightChildDepth(this.getLocalNodeIndex(nodeIndex), maxRightChildDepth);
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of right max child depth", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    byte getNodeLocalDepth(int nodeIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodeLocalDepth(int nodeIndex, byte localNodeDepth) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    page.setNodeLocalDepth(this.getLocalNodeIndex(nodeIndex), localNodeDepth);
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of local node depth", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getNode(int nodeIndex) throws IOException {
        this.startOperation();
        try {
            long[] node = new long[256];
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    ODirectoryPage page = this.loadPage(nodeIndex, false, atomicOperation);
                    try {
                        int localNodeIndex = this.getLocalNodeIndex(nodeIndex);
                        for (int i = 0; i < 256; ++i) {
                            node[i] = page.getPointer(localNodeIndex, i);
                        }
                    }
                    finally {
                        this.releasePage(page, false, atomicOperation);
                    }
                }
                finally {
                    this.releaseSharedLock();
                }
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
            long[] lArray = node;
            return lArray;
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNode(int nodeIndex, long[] node) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    int localNodeIndex = this.getLocalNodeIndex(nodeIndex);
                    for (int i = 0; i < 256; ++i) {
                        page.setPointer(localNodeIndex, i, node[i]);
                    }
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of node", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    long getNodePointer(int nodeIndex, int index) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodePointer(int nodeIndex, int index, long pointer) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    page.setPointer(this.getLocalNodeIndex(nodeIndex), index, pointer);
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of node pointer", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                this.truncateFile(atomicOperation, this.fileId);
                this.init();
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during removing of hash table directory content", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    public void flush() throws IOException {
        this.startOperation();
        try {
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                this.acquireSharedLock();
                try {
                    this.writeCache.flush(this.fileId);
                }
                finally {
                    this.releaseSharedLock();
                }
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
        }
        finally {
            this.completeOperation();
        }
    }

    private ODirectoryPage loadPage(int nodeIndex, boolean exclusiveLock, OAtomicOperation atomicOperation) throws IOException {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            OCacheEntry cacheEntry = exclusiveLock ? this.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true) : this.loadPageForRead(atomicOperation, this.fileId, this.firstEntryIndex, true);
            return new ODirectoryFirstPage(cacheEntry, cacheEntry);
        }
        int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
        OCacheEntry cacheEntry = exclusiveLock ? this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, true) : this.loadPageForRead(atomicOperation, this.fileId, pageIndex, true);
        return new ODirectoryPage(cacheEntry, cacheEntry);
    }

    private void releasePage(ODirectoryPage page, boolean exclusiveLock, OAtomicOperation atomicOperation) {
        OCacheEntry cacheEntry = page.getEntry();
        if (exclusiveLock) {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        } else {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private int getLocalNodeIndex(int nodeIndex) {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            return nodeIndex;
        }
        return (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) % ODirectoryPage.NODES_PER_PAGE;
    }
}

