/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSegment;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageV2;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALSegmentCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

final class OLogSegmentV2
implements OLogSegment {
    private final ODiskWriteAheadLog writeAheadLog;
    private volatile long writtenUpTo;
    private volatile OLogSequenceNumber storedUpTo;
    private volatile OLogSequenceNumber syncedUpTo;
    private final Path path;
    private final long order;
    private final int maxPagesCacheSize;
    private final OWALSegmentCache segmentCache;
    private final Lock cacheLock = new ReentrantLock();
    private volatile List<OLogRecord> writeCache = new ArrayList<OLogRecord>();
    private final ScheduledExecutorService commitExecutor;
    private volatile long filledUpTo;
    private boolean closed;
    private OLogSequenceNumber last = null;
    private volatile boolean flushNewData = true;
    private WeakReference<OPair<OLogSequenceNumber, byte[]>> lastReadRecord = new WeakReference<Object>(null);

    OLogSegmentV2(ODiskWriteAheadLog writeAheadLog, Path path, int maxPagesCacheSize, int fileTTL, int segmentBufferSize, ScheduledExecutorService closer, ScheduledExecutorService commitExecutor) throws IOException {
        this.writeAheadLog = writeAheadLog;
        this.path = path;
        this.maxPagesCacheSize = maxPagesCacheSize;
        this.commitExecutor = commitExecutor;
        this.order = this.extractOrder(path.getFileName().toString());
        this.segmentCache = new OWALSegmentCache(path, fileTTL, segmentBufferSize, closer);
        this.segmentCache.open();
        this.closed = false;
    }

    @Override
    public void startBackgroundWrite() {
        if (this.writeAheadLog.getCommitDelay() > 0) {
            this.commitExecutor.scheduleAtFixedRate(new WriteTask(), 5L, 5L, TimeUnit.MILLISECONDS);
            this.commitExecutor.scheduleAtFixedRate(new SyncTask(), this.writeAheadLog.getCommitDelay(), this.writeAheadLog.getCommitDelay(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stopBackgroundWrite(boolean flush) {
        if (flush) {
            this.flush();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                    throw new OStorageException("WAL flush task for '" + this.getPath() + "' segment cannot be stopped");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error(this, "Cannot shutdown background WAL commit thread", e, new Object[0]);
            }
        }
    }

    private void preparePageForFlush(ByteBuffer content) {
        content.putLong(4, 4012948655L);
        byte[] data = new byte[OWALPage.PAGE_SIZE - 4];
        content.position(4);
        content.get(data);
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        content.putInt(0, (int)crc32.getValue());
    }

    @Override
    public long getOrder() {
        return this.order;
    }

    @Override
    public void init() throws IOException {
        int freeSpaceOffset;
        int lastRecordEnd;
        long lastPosition;
        ByteBuffer buffer;
        long pages = this.segmentCache.filledUpTo();
        if (pages == 0L) {
            this.last = null;
            this.filledUpTo = 0L;
            return;
        }
        long currentPage = pages;
        while (true) {
            if (--currentPage < 0L) {
                this.last = null;
                this.filledUpTo = 0L;
                OLogManager.instance().error(this, "%d pages in WAL segment %s are broken and will be truncated, some data will be lost after restore.", null, pages, this.path.getFileName());
                this.segmentCache.truncate(0L);
                this.segmentCache.sync();
                return;
            }
            byte[] content = this.segmentCache.readPage(currentPage);
            buffer = ByteBuffer.wrap(content).order(ByteOrder.nativeOrder());
            if (this.isPageBroken(content)) {
                OLogManager.instance().warn((Object)this, "Page %d is broken in WAL segment %d and will be truncated", currentPage, currentPage, this.order);
                continue;
            }
            lastPosition = buffer.getLong(16);
            if (lastPosition >= 0L) break;
        }
        if (currentPage + 1L < pages) {
            OLogManager.instance().error(this, "Last %d pages in WAL segment %s are broken and will be truncate, some data will be lost after restore.", null, pages - currentPage - 1L, this.path.getFileName());
            this.segmentCache.truncate(currentPage + 1L);
            this.segmentCache.sync();
        }
        if (OWALPage.PAGE_SIZE - (lastRecordEnd = buffer.getInt(24)) != (freeSpaceOffset = buffer.getInt(12))) {
            OLogManager.instance().error(this, "For the page '%d' of WAL segment '%s' amount of free space '%d' does not match the end of last record in page '%d' it will be fixed automatically but may lead to data loss during recovery after crash", null, currentPage, this.path.getFileName(), freeSpaceOffset, lastRecordEnd);
            buffer.putInt(12, OWALPage.PAGE_SIZE - lastRecordEnd);
            this.preparePageForFlush(buffer);
            buffer.position(0);
            this.segmentCache.writePage(buffer, currentPage);
            this.segmentCache.sync();
        }
        this.last = new OLogSequenceNumber(this.order, lastPosition);
        int freeSpace = buffer.getInt(12);
        this.filledUpTo = currentPage * (long)OWALPage.PAGE_SIZE + (long)(OWALPage.PAGE_SIZE - freeSpace);
    }

    @Override
    public int compareTo(OLogSegment other) {
        long otherOrder = other.getOrder();
        if (this.order > otherOrder) {
            return 1;
        }
        if (this.order < otherOrder) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLogSegmentV2 that = (OLogSegmentV2)o;
        return this.order == that.order;
    }

    public int hashCode() {
        return (int)(this.order ^ this.order >>> 32);
    }

    @Override
    public long filledUpTo() {
        return this.filledUpTo;
    }

    @Override
    public OLogSequenceNumber begin() throws IOException {
        if (!this.writeCache.isEmpty()) {
            return new OLogSequenceNumber(this.order, 28L);
        }
        if (this.segmentCache.filledUpTo() > 0L) {
            return new OLogSequenceNumber(this.order, 28L);
        }
        return null;
    }

    @Override
    public OLogSequenceNumber end() {
        return this.last;
    }

    @Override
    public void delete(boolean flush) throws IOException {
        this.close(flush);
        this.segmentCache.delete();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    static OLogRecord generateLogRecord(long starting, byte[] record) {
        long resultSize;
        long from = starting;
        long length = record.length;
        int freePageSpace = OWALPage.PAGE_SIZE - (int)Math.max(starting % (long)OWALPage.PAGE_SIZE, 28L);
        int inPage = OWALPageV2.calculateRecordSize(freePageSpace);
        if ((long)inPage >= length) {
            long resultSize2 = OWALPageV2.calculateSerializedSize((int)length);
            if (from % (long)OWALPage.PAGE_SIZE == 0L) {
                from += 28L;
            }
            return new OLogRecord(record, from, from + resultSize2);
        }
        if (inPage > 0) {
            length -= (long)inPage;
            resultSize = freePageSpace;
            if (from % (long)OWALPage.PAGE_SIZE == 0L) {
                from += 28L;
            }
        } else {
            from = starting + (long)freePageSpace + 28L;
            resultSize = -28L;
        }
        resultSize += length / (long)OWALPageV2.calculateRecordSize(OWALPageV2.MAX_ENTRY_SIZE) * (long)OWALPage.PAGE_SIZE;
        int leftSize = (int)length % OWALPageV2.calculateRecordSize(OWALPageV2.MAX_ENTRY_SIZE);
        if (leftSize > 0) {
            resultSize += (long)(28 + OWALPageV2.calculateSerializedSize(leftSize));
        }
        return new OLogRecord(record, from, from + resultSize);
    }

    @Override
    public OLogSequenceNumber logRecord(byte[] record) {
        this.flushNewData = true;
        OLogRecord rec = OLogSegmentV2.generateLogRecord(this.filledUpTo, record);
        this.filledUpTo = rec.writeTo;
        this.last = new OLogSequenceNumber(this.order, rec.writeFrom);
        try {
            this.cacheLock.lock();
            this.writeCache.add(rec);
        }
        finally {
            this.cacheLock.unlock();
        }
        long pagesInCache = (this.filledUpTo - this.writtenUpTo) / (long)OWALPage.PAGE_SIZE;
        if (pagesInCache > (long)this.maxPagesCacheSize) {
            OLogManager.instance().debug((Object)this, "Max cache limit is reached (%d vs. %d), sync write is performed", this.maxPagesCacheSize, pagesInCache);
            this.writeAheadLog.incrementCacheOverflowCount();
            try {
                this.commitExecutor.submit(new WriteTask()).get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw OException.wrapException(new OStorageException("Thread was interrupted during WAL write"), e);
            }
            catch (ExecutionException e) {
                throw OException.wrapException(new OStorageException("Error during WAL segment '" + this.getPath() + "' write"), e);
            }
        }
        return this.last;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public byte[] readRecord(OLogSequenceNumber lsn) throws IOException {
        OPair lastRecord = (OPair)this.lastReadRecord.get();
        if (lastRecord != null && ((OLogSequenceNumber)lastRecord.getKey()).equals(lsn)) {
            return (byte[])lastRecord.getValue();
        }
        assert (lsn.getSegment() == this.order);
        if (lsn.getPosition() >= this.filledUpTo) {
            return null;
        }
        if (!this.writeCache.isEmpty()) {
            this.flush();
        }
        long pageIndex = lsn.getPosition() / (long)OWALPage.PAGE_SIZE;
        byte[] record = null;
        int pageOffset = (int)(lsn.getPosition() % (long)OWALPage.PAGE_SIZE);
        long pageCount = (this.filledUpTo + (long)OWALPage.PAGE_SIZE - 1L) / (long)OWALPage.PAGE_SIZE;
        while (pageIndex < pageCount) {
            byte[] pageContent = this.segmentCache.readPage(pageIndex);
            if (this.isPageBroken(pageContent)) {
                throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
            }
            ByteBuffer buffer = ByteBuffer.wrap(pageContent).order(ByteOrder.nativeOrder());
            OWALPageV2 page = new OWALPageV2(buffer, false);
            byte[] content = page.getRecord(pageOffset);
            if (record == null) {
                record = content;
            } else {
                byte[] oldRecord = record;
                record = new byte[record.length + content.length];
                System.arraycopy(oldRecord, 0, record, 0, oldRecord.length);
                System.arraycopy(content, 0, record, oldRecord.length, record.length - oldRecord.length);
            }
            if (page.mergeWithNextPage(pageOffset)) {
                pageOffset = 28;
                if (++pageIndex < pageCount) continue;
                throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
            }
            if (page.getFreeSpace() < 7 || pageIndex >= pageCount - 1L) break;
            throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
        }
        this.lastReadRecord = new WeakReference<OPair<OLogSequenceNumber, Object>>(new OPair<OLogSequenceNumber, Object>(lsn, record));
        return record;
    }

    @Override
    public OLogSequenceNumber getNextLSN(OLogSequenceNumber lsn) throws IOException {
        byte[] record = this.readRecord(lsn);
        if (record == null) {
            return null;
        }
        long pos = lsn.getPosition();
        long pageIndex = pos / (long)OWALPage.PAGE_SIZE;
        int pageOffset = (int)(pos - pageIndex * (long)OWALPage.PAGE_SIZE);
        int restOfRecord = record.length;
        while (restOfRecord > 0) {
            int entrySize = OWALPageV2.calculateSerializedSize(restOfRecord);
            if (entrySize + pageOffset < OWALPage.PAGE_SIZE) {
                if (entrySize + pageOffset <= OWALPage.PAGE_SIZE - 7) {
                    pos += (long)entrySize;
                    break;
                }
                pos += (long)(OWALPage.PAGE_SIZE - pageOffset + 28);
                break;
            }
            if (entrySize + pageOffset == OWALPage.PAGE_SIZE) {
                pos += (long)(entrySize + 28);
                break;
            }
            long chunkSize = OWALPageV2.calculateRecordSize(OWALPage.PAGE_SIZE - pageOffset);
            restOfRecord = (int)((long)restOfRecord - chunkSize);
            pos += (long)(OWALPage.PAGE_SIZE - pageOffset + 28);
            pageOffset = 28;
        }
        if (pos >= this.filledUpTo) {
            return null;
        }
        return new OLogSequenceNumber(this.order, pos);
    }

    @Override
    public void close(boolean flush) throws IOException {
        if (!this.closed) {
            this.lastReadRecord.clear();
            this.stopBackgroundWrite(flush);
            this.segmentCache.close(flush);
            this.closed = true;
        }
    }

    @Override
    public void flush() {
        this.writeData();
        this.syncData();
    }

    private void writeData() {
        if (this.commitExecutor.isShutdown()) {
            if (this.flushNewData) {
                throw new OStorageException("Unable to write data, WAL thread is shutdown");
            }
            return;
        }
        try {
            this.commitExecutor.submit(new WriteTask()).get();
        }
        catch (RejectedExecutionException e) {
            if (this.flushNewData || !this.commitExecutor.isShutdown()) {
                throw OException.wrapException(new OStorageException("Unable to write data"), e);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw OException.wrapException(new OStorageException("Thread was interrupted during data write"), e);
        }
        catch (ExecutionException e) {
            throw OException.wrapException(new OStorageException("Error during WAL segment '" + this.getPath() + "' data write"), e);
        }
    }

    private void syncData() {
        if (this.commitExecutor.isShutdown()) {
            if (this.flushNewData || !Objects.equals(this.storedUpTo, this.syncedUpTo)) {
                throw new OStorageException("Unable to sync data, WAL thread is shutdown");
            }
            return;
        }
        try {
            this.commitExecutor.submit(new SyncTask()).get();
        }
        catch (RejectedExecutionException e) {
            if (this.flushNewData || !Objects.equals(this.storedUpTo, this.syncedUpTo) || !this.commitExecutor.isShutdown()) {
                throw OException.wrapException(new OStorageException("Unable to sync data"), e);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw OException.wrapException(new OStorageException("Thread was interrupted during data sync"), e);
        }
        catch (ExecutionException e) {
            throw OException.wrapException(new OStorageException("Error during WAL segment '" + this.getPath() + "' data sync"), e);
        }
    }

    private long extractOrder(String name) {
        Matcher matcher = Pattern.compile("^.*\\.(\\d+)\\.wal$").matcher(name);
        boolean matches = matcher.find();
        assert (matches);
        String order = matcher.group(1);
        try {
            return Long.parseLong(order);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isPageBroken(byte[] content) {
        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(content, 4);
        if (magicNumber != 4012948655L) {
            return true;
        }
        CRC32 crc32 = new CRC32();
        crc32.update(content, 4, OWALPage.PAGE_SIZE - 4);
        return (int)crc32.getValue() != OIntegerSerializer.INSTANCE.deserializeNative(content, 0);
    }

    static class OLogRecord {
        final byte[] record;
        final long writeFrom;
        final long writeTo;

        OLogRecord(byte[] record, long writeFrom, long writeTo) {
            this.record = record;
            this.writeFrom = writeFrom;
            this.writeTo = writeTo;
        }
    }

    private final class SyncTask
    implements Runnable {
        private SyncTask() {
        }

        @Override
        public void run() {
            try {
                OLogSequenceNumber stored = OLogSegmentV2.this.storedUpTo;
                OLogSequenceNumber synced = OLogSegmentV2.this.syncedUpTo;
                if (stored == null) {
                    return;
                }
                if (synced == null || synced.compareTo(stored) < 0) {
                    OLogSegmentV2.this.segmentCache.sync();
                    OLogSegmentV2.this.syncedUpTo = stored;
                    OLogSegmentV2.this.writeAheadLog.setFlushedLsn(stored);
                }
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Can not force sync content of file " + OLogSegmentV2.this.path, ioe, new Object[0]);
            }
        }
    }

    private final class WriteTask
    implements Runnable {
        private WriteTask() {
        }

        @Override
        public void run() {
            try {
                ByteBuffer buffer;
                List toFlush;
                if (!OLogSegmentV2.this.flushNewData) {
                    return;
                }
                OLogSegmentV2.this.flushNewData = false;
                try {
                    OLogSegmentV2.this.cacheLock.lock();
                    if (OLogSegmentV2.this.writeCache.isEmpty()) {
                        return;
                    }
                    toFlush = OLogSegmentV2.this.writeCache;
                    OLogSegmentV2.this.writeCache = new ArrayList();
                }
                finally {
                    OLogSegmentV2.this.cacheLock.unlock();
                }
                OLogRecord first = (OLogRecord)toFlush.get(0);
                long curPageIndex = first.writeFrom / (long)OWALPage.PAGE_SIZE;
                long lastRecordPosition = -1L;
                int endOfLastRecord = -1;
                long filledUpTo = OLogSegmentV2.this.segmentCache.filledUpTo();
                if (filledUpTo > curPageIndex) {
                    assert (filledUpTo - 1L == curPageIndex);
                    buffer = OLogSegmentV2.this.segmentCache.readPageBuffer(curPageIndex);
                    lastRecordPosition = buffer.getLong(16);
                    endOfLastRecord = buffer.getInt(24);
                } else {
                    buffer = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
                    buffer.putLong(16, lastRecordPosition);
                    buffer.putInt(24, endOfLastRecord);
                }
                boolean lastToFlush = false;
                for (OLogRecord log : toFlush) {
                    OLogSequenceNumber lsn = new OLogSequenceNumber(OLogSegmentV2.this.order, log.writeFrom);
                    int pos = (int)(log.writeFrom % (long)OWALPage.PAGE_SIZE);
                    int written = 0;
                    while (written < log.record.length) {
                        lastToFlush = true;
                        int pageFreeSpace = OWALPageV2.calculateRecordSize(OWALPage.PAGE_SIZE - pos);
                        int contentLength = Math.min(pageFreeSpace, log.record.length - written);
                        int fromRecord = written;
                        if ((written += contentLength) == log.record.length) {
                            lastRecordPosition = lsn.getPosition();
                            endOfLastRecord = pos + OWALPageV2.calculateSerializedSize(contentLength);
                        }
                        if (OWALPage.PAGE_SIZE - (pos = this.writeContentInPage(buffer, pos, log.record, written == log.record.length, fromRecord, contentLength, lastRecordPosition, endOfLastRecord)) >= 7) continue;
                        OLogSegmentV2.this.preparePageForFlush(buffer);
                        OLogSegmentV2.this.segmentCache.writePage(buffer, curPageIndex);
                        buffer = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
                        ++curPageIndex;
                        lastRecordPosition = -1L;
                        endOfLastRecord = -1;
                        lastToFlush = false;
                        pos = 28;
                    }
                    OLogSegmentV2.this.writtenUpTo = log.writeTo;
                    OLogSegmentV2.this.storedUpTo = lsn;
                }
                if (lastToFlush) {
                    OLogSegmentV2.this.preparePageForFlush(buffer);
                    OLogSegmentV2.this.segmentCache.writePage(buffer, curPageIndex);
                }
                OLogSegmentV2.this.writeAheadLog.checkFreeSpace();
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during WAL background flush", e, new Object[0]);
            }
        }

        private int writeContentInPage(ByteBuffer pageContent, int posInPage, byte[] log, boolean isLast, int fromRecord, int contentLength, long lsnPosition, int endOfLastRecord) {
            pageContent.put(posInPage, !isLast ? (byte)1 : 0);
            pageContent.put(posInPage + 1, isLast ? (byte)1 : 0);
            pageContent.putInt(posInPage + 2, contentLength);
            pageContent.position(posInPage + 4 + 2);
            pageContent.put(log, fromRecord, contentLength);
            pageContent.putInt(12, OWALPage.PAGE_SIZE - (posInPage += OWALPageV2.calculateSerializedSize(contentLength)));
            pageContent.putLong(16, lsnPosition);
            pageContent.putInt(24, endOfLastRecord);
            return posInPage;
        }
    }
}

