/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSegment;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageV1;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALSegmentCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class OLogSegmentV1
implements OLogSegment {
    private final ODiskWriteAheadLog writeAheadLog;
    private volatile long writtenUpTo;
    private volatile OLogSequenceNumber storedUpTo;
    private volatile OLogSequenceNumber syncedUpTo;
    private final Path path;
    private final long order;
    private final int maxPagesCacheSize;
    private final OWALSegmentCache segmentCache;
    private final Lock cacheLock = new ReentrantLock();
    private volatile List<OLogRecord> writeCache = new ArrayList<OLogRecord>();
    private final ScheduledExecutorService commitExecutor;
    private volatile long filledUpTo;
    private boolean closed;
    private OLogSequenceNumber last = null;
    private volatile boolean flushNewData = true;
    private WeakReference<OPair<OLogSequenceNumber, byte[]>> lastReadRecord = new WeakReference<Object>(null);

    OLogSegmentV1(ODiskWriteAheadLog writeAheadLog, Path path, int maxPagesCacheSize, int fileTTL, int segmentBufferSize, ScheduledExecutorService closer, ScheduledExecutorService commitExecutor) throws IOException {
        this.writeAheadLog = writeAheadLog;
        this.path = path;
        this.maxPagesCacheSize = maxPagesCacheSize;
        this.commitExecutor = commitExecutor;
        this.order = this.extractOrder(path.getFileName().toString());
        this.segmentCache = new OWALSegmentCache(path, fileTTL, segmentBufferSize, closer);
        this.segmentCache.open();
        this.closed = false;
    }

    @Override
    public void startBackgroundWrite() {
        if (this.writeAheadLog.getCommitDelay() > 0) {
            this.commitExecutor.scheduleAtFixedRate(new WriteTask(), 100L, 100L, TimeUnit.MICROSECONDS);
            this.commitExecutor.scheduleAtFixedRate(new SyncTask(), this.writeAheadLog.getCommitDelay(), this.writeAheadLog.getCommitDelay(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stopBackgroundWrite(boolean flush) {
        if (flush) {
            this.flush();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                    throw new OStorageException("WAL flush task for '" + this.getPath() + "' segment cannot be stopped");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error(this, "Cannot shutdown background WAL commit thread", e, new Object[0]);
            }
        }
    }

    @Override
    public long getOrder() {
        return this.order;
    }

    @Override
    public void init() throws IOException {
        this.initPageCache();
        this.last = new OLogSequenceNumber(this.order, this.filledUpTo - 1L);
    }

    @Override
    public int compareTo(OLogSegment other) {
        long otherOrder = other.getOrder();
        if (this.order > otherOrder) {
            return 1;
        }
        if (this.order < otherOrder) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLogSegmentV1 that = (OLogSegmentV1)o;
        return this.order == that.order;
    }

    public int hashCode() {
        return (int)(this.order ^ this.order >>> 32);
    }

    @Override
    public long filledUpTo() {
        return this.filledUpTo;
    }

    @Override
    public OLogSequenceNumber begin() throws IOException {
        if (!this.writeCache.isEmpty()) {
            return new OLogSequenceNumber(this.order, 16L);
        }
        if (this.segmentCache.filledUpTo() > 0L) {
            return new OLogSequenceNumber(this.order, 16L);
        }
        return null;
    }

    @Override
    public OLogSequenceNumber end() {
        return this.last;
    }

    @Override
    public void delete(boolean flush) throws IOException {
        this.close(flush);
        this.segmentCache.delete();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    private static OLogRecord generateLogRecord(long starting, byte[] record) {
        long resultSize;
        long from = starting;
        long length = record.length;
        int freePageSpace = OWALPage.PAGE_SIZE - (int)Math.max(starting % (long)OWALPage.PAGE_SIZE, 16L);
        int inPage = OWALPageV1.calculateRecordSize(freePageSpace);
        if ((long)inPage >= length) {
            long resultSize2 = OWALPageV1.calculateSerializedSize((int)length);
            if (from % (long)OWALPage.PAGE_SIZE == 0L) {
                from += 16L;
            }
            return new OLogRecord(record, from, from + resultSize2);
        }
        if (inPage > 0) {
            length -= (long)inPage;
            resultSize = freePageSpace;
            if (from % (long)OWALPage.PAGE_SIZE == 0L) {
                from += 16L;
            }
        } else {
            from = starting + (long)freePageSpace + 16L;
            resultSize = -16L;
        }
        resultSize += length / (long)OWALPageV1.calculateRecordSize(OWALPageV1.MAX_ENTRY_SIZE) * (long)OWALPage.PAGE_SIZE;
        int leftSize = (int)length % OWALPageV1.calculateRecordSize(OWALPageV1.MAX_ENTRY_SIZE);
        if (leftSize > 0) {
            resultSize += (long)(16 + OWALPageV1.calculateSerializedSize(leftSize));
        }
        return new OLogRecord(record, from, from + resultSize);
    }

    @Override
    public OLogSequenceNumber logRecord(byte[] record) {
        this.flushNewData = true;
        OLogRecord rec = OLogSegmentV1.generateLogRecord(this.filledUpTo, record);
        this.filledUpTo = rec.writeTo;
        this.last = new OLogSequenceNumber(this.order, rec.writeFrom);
        try {
            this.cacheLock.lock();
            this.writeCache.add(rec);
        }
        finally {
            this.cacheLock.unlock();
        }
        long pagesInCache = (this.filledUpTo - this.writtenUpTo) / (long)OWALPage.PAGE_SIZE;
        if (pagesInCache > (long)this.maxPagesCacheSize) {
            OLogManager.instance().info((Object)this, "Max cache limit is reached (%d vs. %d), sync write is performed", this.maxPagesCacheSize, pagesInCache);
            this.writeAheadLog.incrementCacheOverflowCount();
            try {
                this.commitExecutor.submit(new WriteTask()).get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw OException.wrapException(new OStorageException("Thread was interrupted during WAL write"), e);
            }
            catch (ExecutionException e) {
                throw OException.wrapException(new OStorageException("Error during WAL segment '" + this.getPath() + "' write"), e);
            }
        }
        return this.last;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public byte[] readRecord(OLogSequenceNumber lsn) throws IOException {
        OPair lastRecord = (OPair)this.lastReadRecord.get();
        if (lastRecord != null && ((OLogSequenceNumber)lastRecord.getKey()).equals(lsn)) {
            return (byte[])lastRecord.getValue();
        }
        assert (lsn.getSegment() == this.order);
        if (lsn.getPosition() >= this.filledUpTo) {
            return null;
        }
        if (!this.writeCache.isEmpty()) {
            this.flush();
        }
        long pageIndex = lsn.getPosition() / (long)OWALPage.PAGE_SIZE;
        byte[] record = null;
        int pageOffset = (int)(lsn.getPosition() % (long)OWALPage.PAGE_SIZE);
        long pageCount = (this.filledUpTo + (long)OWALPage.PAGE_SIZE - 1L) / (long)OWALPage.PAGE_SIZE;
        while (pageIndex < pageCount) {
            byte[] pageContent = this.segmentCache.readPage(pageIndex);
            if (!this.checkPageIntegrity(pageContent)) {
                throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
            }
            ByteBuffer buffer = ByteBuffer.wrap(pageContent).order(ByteOrder.nativeOrder());
            OWALPageV1 page = new OWALPageV1(buffer, false);
            byte[] content = page.getRecord(pageOffset);
            if (record == null) {
                record = content;
            } else {
                byte[] oldRecord = record;
                record = new byte[record.length + content.length];
                System.arraycopy(oldRecord, 0, record, 0, oldRecord.length);
                System.arraycopy(content, 0, record, oldRecord.length, record.length - oldRecord.length);
            }
            if (page.mergeWithNextPage(pageOffset)) {
                pageOffset = 16;
                if (++pageIndex < pageCount) continue;
                throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
            }
            if (page.getFreeSpace() < 7 || pageIndex >= pageCount - 1L) break;
            throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
        }
        this.lastReadRecord = new WeakReference<OPair<OLogSequenceNumber, Object>>(new OPair<OLogSequenceNumber, Object>(lsn, record));
        return record;
    }

    @Override
    public OLogSequenceNumber getNextLSN(OLogSequenceNumber lsn) throws IOException {
        byte[] record = this.readRecord(lsn);
        if (record == null) {
            return null;
        }
        long pos = lsn.getPosition();
        long pageIndex = pos / (long)OWALPage.PAGE_SIZE;
        int pageOffset = (int)(pos - pageIndex * (long)OWALPage.PAGE_SIZE);
        int restOfRecord = record.length;
        while (restOfRecord > 0) {
            int entrySize = OWALPageV1.calculateSerializedSize(restOfRecord);
            if (entrySize + pageOffset < OWALPage.PAGE_SIZE) {
                if (entrySize + pageOffset <= OWALPage.PAGE_SIZE - 7) {
                    pos += (long)entrySize;
                    break;
                }
                pos += (long)(OWALPage.PAGE_SIZE - pageOffset + 16);
                break;
            }
            if (entrySize + pageOffset == OWALPage.PAGE_SIZE) {
                pos += (long)(entrySize + 16);
                break;
            }
            long chunkSize = OWALPageV1.calculateRecordSize(OWALPage.PAGE_SIZE - pageOffset);
            restOfRecord = (int)((long)restOfRecord - chunkSize);
            pos += (long)(OWALPage.PAGE_SIZE - pageOffset + 16);
            pageOffset = 16;
        }
        if (pos >= this.filledUpTo) {
            return null;
        }
        return new OLogSequenceNumber(this.order, pos);
    }

    @Override
    public void close(boolean flush) throws IOException {
        if (!this.closed) {
            this.lastReadRecord.clear();
            this.stopBackgroundWrite(flush);
            this.segmentCache.close(flush);
            this.closed = true;
        }
    }

    @Override
    public void flush() {
        this.writeData();
        this.syncData();
    }

    private void writeData() {
        if (this.commitExecutor.isShutdown()) {
            if (this.flushNewData) {
                throw new OStorageException("Unable to write data, WAL thread is shutdown");
            }
            return;
        }
        try {
            this.commitExecutor.submit(new WriteTask()).get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw OException.wrapException(new OStorageException("Thread was interrupted during data write"), e);
        }
        catch (ExecutionException e) {
            throw OException.wrapException(new OStorageException("Error during WAL segment '" + this.getPath() + "' data write"), e);
        }
    }

    private void syncData() {
        if (this.commitExecutor.isShutdown()) {
            if (this.flushNewData || !Objects.equals(this.storedUpTo, this.syncedUpTo)) {
                throw new OStorageException("Unable to sync data, WAL thread is shutdown");
            }
            return;
        }
        try {
            this.commitExecutor.submit(new SyncTask()).get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw OException.wrapException(new OStorageException("Thread was interrupted during data sync"), e);
        }
        catch (ExecutionException e) {
            throw OException.wrapException(new OStorageException("Error during WAL segment '" + this.getPath() + "' data sync"), e);
        }
    }

    private void initPageCache() throws IOException {
        long pagesCount = this.segmentCache.filledUpTo();
        if (pagesCount == 0L) {
            return;
        }
        byte[] content = this.segmentCache.readPage(pagesCount - 1L);
        if (this.checkPageIntegrity(content)) {
            int freeSpace = OIntegerSerializer.INSTANCE.deserializeNative(content, 12);
            this.filledUpTo = (pagesCount - 1L) * (long)OWALPage.PAGE_SIZE + (long)(OWALPage.PAGE_SIZE - freeSpace);
        } else {
            this.filledUpTo = pagesCount * (long)OWALPage.PAGE_SIZE + 16L;
        }
    }

    private long extractOrder(String name) {
        Matcher matcher = Pattern.compile("^.*\\.(\\d+)\\.wal$").matcher(name);
        boolean matches = matcher.find();
        assert (matches);
        String order = matcher.group(1);
        try {
            return Long.parseLong(order);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean checkPageIntegrity(byte[] content) {
        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(content, 4);
        if (magicNumber != 4207608830L) {
            return false;
        }
        CRC32 crc32 = new CRC32();
        crc32.update(content, 4, OWALPage.PAGE_SIZE - 4);
        return (int)crc32.getValue() == OIntegerSerializer.INSTANCE.deserializeNative(content, 0);
    }

    static class OLogRecord {
        final byte[] record;
        final long writeFrom;
        final long writeTo;

        OLogRecord(byte[] record, long writeFrom, long writeTo) {
            this.record = record;
            this.writeFrom = writeFrom;
            this.writeTo = writeTo;
        }
    }

    private final class SyncTask
    implements Runnable {
        private SyncTask() {
        }

        @Override
        public void run() {
            try {
                OLogSequenceNumber stored = OLogSegmentV1.this.storedUpTo;
                OLogSequenceNumber synced = OLogSegmentV1.this.syncedUpTo;
                if (stored == null) {
                    return;
                }
                if (synced == null || synced.compareTo(stored) < 0) {
                    OLogSegmentV1.this.syncedUpTo = stored;
                    OLogSegmentV1.this.segmentCache.sync();
                    OLogSegmentV1.this.writeAheadLog.setFlushedLsn(stored);
                }
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Can not force sync content of file " + OLogSegmentV1.this.path, ioe, new Object[0]);
            }
        }
    }

    private final class WriteTask
    implements Runnable {
        private WriteTask() {
        }

        @Override
        public void run() {
            try {
                ByteBuffer buffer;
                List toFlush;
                if (!OLogSegmentV1.this.flushNewData) {
                    return;
                }
                OLogSegmentV1.this.flushNewData = false;
                try {
                    OLogSegmentV1.this.cacheLock.lock();
                    if (OLogSegmentV1.this.writeCache.isEmpty()) {
                        return;
                    }
                    toFlush = OLogSegmentV1.this.writeCache;
                    OLogSegmentV1.this.writeCache = new ArrayList();
                }
                finally {
                    OLogSegmentV1.this.cacheLock.unlock();
                }
                OLogRecord first = (OLogRecord)toFlush.get(0);
                long curPageIndex = first.writeFrom / (long)OWALPage.PAGE_SIZE;
                long filledUpTo = OLogSegmentV1.this.segmentCache.filledUpTo();
                if (filledUpTo > curPageIndex) {
                    assert (filledUpTo - 1L == curPageIndex);
                    buffer = OLogSegmentV1.this.segmentCache.readPageBuffer(curPageIndex);
                } else {
                    buffer = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
                }
                boolean lastToFlush = false;
                for (OLogRecord log : toFlush) {
                    OLogSequenceNumber lsn = new OLogSequenceNumber(OLogSegmentV1.this.order, log.writeFrom);
                    int pos = (int)(log.writeFrom % (long)OWALPage.PAGE_SIZE);
                    int written = 0;
                    while (written < log.record.length) {
                        int fromRecord;
                        int contentLength;
                        lastToFlush = true;
                        int pageFreeSpace = OWALPageV1.calculateRecordSize(OWALPage.PAGE_SIZE - pos);
                        if (OWALPage.PAGE_SIZE - (pos = this.writeContentInPage(buffer, pos, log.record, (written += (contentLength = Math.min(pageFreeSpace, log.record.length - written))) == log.record.length, fromRecord = written, contentLength)) >= 7) continue;
                        this.preparePageForFlush(buffer);
                        OLogSegmentV1.this.segmentCache.writePage(buffer, curPageIndex);
                        buffer = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
                        ++curPageIndex;
                        lastToFlush = false;
                        pos = 16;
                    }
                    OLogSegmentV1.this.writtenUpTo = log.writeTo;
                    OLogSegmentV1.this.storedUpTo = lsn;
                }
                if (lastToFlush) {
                    this.preparePageForFlush(buffer);
                    OLogSegmentV1.this.segmentCache.writePage(buffer, curPageIndex);
                }
                OLogSegmentV1.this.writeAheadLog.checkFreeSpace();
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during WAL background flush", e, new Object[0]);
            }
        }

        private int writeContentInPage(ByteBuffer pageContent, int posInPage, byte[] log, boolean isLast, int fromRecord, int contentLength) {
            pageContent.put(posInPage, !isLast ? (byte)1 : 0);
            pageContent.put(posInPage + 1, isLast ? (byte)1 : 0);
            pageContent.putInt(posInPage + 2, contentLength);
            pageContent.position(posInPage + 4 + 2);
            pageContent.put(log, fromRecord, contentLength);
            pageContent.putInt(12, OWALPage.PAGE_SIZE - (posInPage += OWALPageV1.calculateSerializedSize(contentLength)));
            return posInPage;
        }

        private void preparePageForFlush(ByteBuffer content) {
            content.putLong(4, 4207608830L);
            byte[] data = new byte[OWALPage.PAGE_SIZE - 4];
            content.position(4);
            content.get(data);
            CRC32 crc32 = new CRC32();
            crc32.update(data);
            content.putInt(0, (int)crc32.getValue());
        }
    }
}

