/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCacheEntryImpl;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OCacheEntryChanges;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileDeletedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class OAtomicOperation {
    private final int storageId;
    private final OLogSequenceNumber startLSN;
    private final OOperationUnitId operationUnitId;
    private int startCounter;
    private boolean rollback;
    private Exception rollbackException;
    private final Set<String> lockedObjects = new HashSet<String>();
    private final Map<Long, FileChanges> fileChanges = new HashMap<Long, FileChanges>();
    private final Map<String, Long> newFileNamesId = new HashMap<String, Long>();
    private final Set<Long> deletedFiles = new HashSet<Long>();
    private final Map<String, Long> deletedFileNameIdMap = new HashMap<String, Long>();
    private final OReadCache readCache;
    private final OWriteCache writeCache;
    private final OPerformanceStatisticManager performanceStatisticManager;
    private final Map<String, OAtomicOperationMetadata<?>> metadata = new LinkedHashMap();

    public OAtomicOperation(OLogSequenceNumber startLSN, OOperationUnitId operationUnitId, OReadCache readCache, OWriteCache writeCache, int storageId, OPerformanceStatisticManager performanceStatisticManager) {
        this.storageId = storageId;
        this.startLSN = startLSN;
        this.operationUnitId = operationUnitId;
        this.performanceStatisticManager = performanceStatisticManager;
        this.startCounter = 1;
        this.readCache = readCache;
        this.writeCache = writeCache;
    }

    public OLogSequenceNumber getStartLSN() {
        return this.startLSN;
    }

    public OOperationUnitId getOperationUnitId() {
        return this.operationUnitId;
    }

    public OCacheEntry loadPageForWrite(long fileId, long pageIndex, boolean checkPinnedPages, int pageCount) throws IOException {
        assert (pageCount > 0);
        if (this.deletedFiles.contains(fileId = this.checkFileIdCompatibility(fileId, this.storageId))) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.computeIfAbsent(fileId, k -> new FileChanges());
        if (changesContainer.isNew) {
            if (pageIndex <= changesContainer.maxNewPageIndex) {
                OCacheEntryChanges pageChange = (OCacheEntryChanges)changesContainer.pageChangesMap.get(pageIndex);
                return pageChange;
            }
            return null;
        }
        OCacheEntryChanges pageChangesContainer = (OCacheEntryChanges)changesContainer.pageChangesMap.get(pageIndex);
        if (this.checkChangesFilledUpTo(changesContainer, pageIndex)) {
            if (pageChangesContainer == null) {
                OCacheEntry delegate = this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, pageCount, true);
                if (delegate != null) {
                    pageChangesContainer = new OCacheEntryChanges();
                    changesContainer.pageChangesMap.put(pageIndex, pageChangesContainer);
                    pageChangesContainer.delegate = delegate;
                    return pageChangesContainer;
                }
            } else {
                OCacheEntry delegate;
                if (pageChangesContainer.isNew) {
                    return pageChangesContainer;
                }
                pageChangesContainer.delegate = delegate = this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, pageCount, true);
                return pageChangesContainer;
            }
        }
        return null;
    }

    public OCacheEntry loadPageForRead(long fileId, long pageIndex, boolean checkPinnedPages, int pageCount) throws IOException {
        assert (pageCount > 0);
        if (this.deletedFiles.contains(fileId = this.checkFileIdCompatibility(fileId, this.storageId))) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        if (changesContainer == null) {
            return this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, pageCount, true);
        }
        if (changesContainer.isNew) {
            if (pageIndex <= changesContainer.maxNewPageIndex) {
                OCacheEntryChanges pageChange = (OCacheEntryChanges)changesContainer.pageChangesMap.get(pageIndex);
                return pageChange;
            }
            return null;
        }
        OCacheEntryChanges pageChangesContainer = (OCacheEntryChanges)changesContainer.pageChangesMap.get(pageIndex);
        if (this.checkChangesFilledUpTo(changesContainer, pageIndex)) {
            OCacheEntry delegate;
            if (pageChangesContainer == null) {
                return this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, pageCount, true);
            }
            if (pageChangesContainer.isNew) {
                return pageChangesContainer;
            }
            pageChangesContainer.delegate = delegate = this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, pageCount, true);
            return pageChangesContainer;
        }
        return null;
    }

    public void addMetadata(OAtomicOperationMetadata<?> metadata) {
        this.metadata.put(metadata.getKey(), metadata);
    }

    public OAtomicOperationMetadata<?> getMetadata(String key) {
        return this.metadata.get(key);
    }

    public Map<String, OAtomicOperationMetadata<?>> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public void pinPage(OCacheEntry cacheEntry) {
        if (this.deletedFiles.contains(cacheEntry.getFileId())) {
            throw new OStorageException("File with id " + cacheEntry.getFileId() + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(cacheEntry.getFileId());
        assert (changesContainer != null);
        OCacheEntryChanges pageChangesContainer = (OCacheEntryChanges)changesContainer.pageChangesMap.get(cacheEntry.getPageIndex());
        assert (pageChangesContainer != null);
        pageChangesContainer.pinPage = true;
    }

    public OCacheEntry addPage(long fileId) {
        if (this.deletedFiles.contains(fileId = this.checkFileIdCompatibility(fileId, this.storageId))) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        assert (changesContainer != null);
        long filledUpTo = this.internalFilledUpTo(fileId, changesContainer);
        OCacheEntryChanges pageChangesContainer = (OCacheEntryChanges)changesContainer.pageChangesMap.get(filledUpTo);
        assert (pageChangesContainer == null);
        pageChangesContainer = new OCacheEntryChanges();
        pageChangesContainer.isNew = true;
        changesContainer.pageChangesMap.put(filledUpTo, pageChangesContainer);
        changesContainer.maxNewPageIndex = filledUpTo;
        OCacheEntryImpl delegate = new OCacheEntryImpl(fileId, filledUpTo, new OCachePointer(null, null, fileId, filledUpTo), false);
        pageChangesContainer.delegate = delegate;
        return pageChangesContainer;
    }

    public void releasePageFromRead(OCacheEntry cacheEntry) {
        if (cacheEntry instanceof OCacheEntryChanges) {
            this.releasePageFromWrite(cacheEntry);
        } else {
            this.readCache.releaseFromRead(cacheEntry, this.writeCache);
        }
    }

    public void releasePageFromWrite(OCacheEntry cacheEntry) {
        OCacheEntryChanges real = (OCacheEntryChanges)cacheEntry;
        if (this.deletedFiles.contains(cacheEntry.getFileId())) {
            throw new OStorageException("File with id " + cacheEntry.getFileId() + " is deleted.");
        }
        if (cacheEntry.getCachePointer().getBuffer() != null) {
            this.readCache.releaseFromRead(real.getDelegate(), this.writeCache);
        } else assert (real.isNew || !cacheEntry.isLockAcquiredByCurrentThread());
    }

    public long filledUpTo(long fileId) {
        if (this.deletedFiles.contains(fileId = this.checkFileIdCompatibility(fileId, this.storageId))) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        return this.internalFilledUpTo(fileId, changesContainer);
    }

    private long internalFilledUpTo(long fileId, FileChanges changesContainer) {
        if (changesContainer == null) {
            changesContainer = new FileChanges();
            this.fileChanges.put(fileId, changesContainer);
        } else {
            if (changesContainer.isNew || changesContainer.maxNewPageIndex > -2L) {
                return changesContainer.maxNewPageIndex + 1L;
            }
            if (changesContainer.truncate) {
                return 0L;
            }
        }
        return this.writeCache.getFilledUpTo(fileId);
    }

    private boolean checkChangesFilledUpTo(FileChanges changesContainer, long pageIndex) {
        if (changesContainer == null) {
            return true;
        }
        if (changesContainer.isNew || changesContainer.maxNewPageIndex > -2L) {
            return pageIndex < changesContainer.maxNewPageIndex + 1L;
        }
        return !changesContainer.truncate;
    }

    public long addFile(String fileName) {
        boolean isNew;
        long fileId;
        if (this.newFileNamesId.containsKey(fileName)) {
            throw new OStorageException("File with name " + fileName + " already exists.");
        }
        if (this.deletedFileNameIdMap.containsKey(fileName)) {
            fileId = this.deletedFileNameIdMap.remove(fileName);
            this.deletedFiles.remove(fileId);
            isNew = false;
        } else {
            fileId = this.writeCache.bookFileId(fileName);
            isNew = true;
        }
        this.newFileNamesId.put(fileName, fileId);
        FileChanges fileChanges = new FileChanges();
        fileChanges.isNew = isNew;
        fileChanges.fileName = fileName;
        fileChanges.maxNewPageIndex = -1L;
        this.fileChanges.put(fileId, fileChanges);
        return fileId;
    }

    public long loadFile(String fileName) throws IOException {
        Long fileId = this.newFileNamesId.get(fileName);
        if (fileId == null) {
            fileId = this.writeCache.loadFile(fileName);
        }
        this.fileChanges.computeIfAbsent(fileId, k -> new FileChanges());
        return fileId;
    }

    public void deleteFile(long fileId) {
        FileChanges fileChanges = this.fileChanges.remove(fileId = this.checkFileIdCompatibility(fileId, this.storageId));
        if (fileChanges != null && fileChanges.fileName != null) {
            this.newFileNamesId.remove(fileChanges.fileName);
        } else {
            this.deletedFiles.add(fileId);
            String f = this.writeCache.fileNameById(fileId);
            if (f != null) {
                this.deletedFileNameIdMap.put(f, fileId);
            }
        }
    }

    public boolean isFileExists(String fileName) {
        if (this.newFileNamesId.containsKey(fileName)) {
            return true;
        }
        if (this.deletedFileNameIdMap.containsKey(fileName)) {
            return false;
        }
        return this.writeCache.exists(fileName);
    }

    public boolean isFileExists(long fileId) {
        if (this.fileChanges.containsKey(fileId = this.checkFileIdCompatibility(fileId, this.storageId))) {
            return true;
        }
        if (this.deletedFiles.contains(fileId)) {
            return false;
        }
        return this.writeCache.exists(fileId);
    }

    public String fileNameById(long fileId) {
        FileChanges fileChanges = this.fileChanges.get(fileId = this.checkFileIdCompatibility(fileId, this.storageId));
        if (fileChanges != null && fileChanges.fileName != null) {
            return fileChanges.fileName;
        }
        if (this.deletedFiles.contains(fileId)) {
            throw new OStorageException("File with id " + fileId + " was deleted.");
        }
        return this.writeCache.fileNameById(fileId);
    }

    public void truncateFile(long fileId) {
        fileId = this.checkFileIdCompatibility(fileId, this.storageId);
        FileChanges fileChanges = this.fileChanges.computeIfAbsent(fileId, k -> new FileChanges());
        fileChanges.pageChangesMap.clear();
        fileChanges.maxNewPageIndex = -1L;
        if (fileChanges.isNew) {
            return;
        }
        fileChanges.truncate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges(OWriteAheadLog writeAheadLog) throws IOException {
        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (sessionStoragePerformanceStatistic != null) {
            sessionStoragePerformanceStatistic.startCommitTimer();
            sessionStoragePerformanceStatistic.startComponentOperation("atomic operation", OSessionStoragePerformanceStatistic.ComponentType.GENERAL);
        }
        try {
            if (writeAheadLog != null) {
                Iterator<Object> iterator = this.deletedFiles.iterator();
                while (iterator.hasNext()) {
                    long l = iterator.next();
                    writeAheadLog.log(new OFileDeletedWALRecord(this.operationUnitId, l));
                    this.readCache.deleteFile(l, this.writeCache);
                }
                for (Map.Entry entry : this.fileChanges.entrySet()) {
                    FileChanges fileChanges = (FileChanges)entry.getValue();
                    long fileId = (Long)entry.getKey();
                    if (fileChanges.isNew) {
                        writeAheadLog.log(new OFileCreatedWALRecord(this.operationUnitId, fileChanges.fileName, fileId));
                        this.readCache.addFile(fileChanges.fileName, this.newFileNamesId.get(fileChanges.fileName), this.writeCache);
                    } else if (fileChanges.truncate) {
                        OLogManager.instance().warn((Object)this, "You performing truncate operation which is considered unsafe because can not be rolled back, as result data can be incorrectly restored after crash, this operation is not recommended to be used", new Object[0]);
                        this.readCache.truncateFile(fileId, this.writeCache);
                    }
                    Iterator filePageChangesIterator = fileChanges.pageChangesMap.entrySet().iterator();
                    while (filePageChangesIterator.hasNext()) {
                        Map.Entry filePageChangesEntry = filePageChangesIterator.next();
                        if (((OCacheEntryChanges)filePageChangesEntry.getValue()).changes.hasChanges()) {
                            long pageIndex = (Long)filePageChangesEntry.getKey();
                            OCacheEntryChanges filePageChanges = (OCacheEntryChanges)filePageChangesEntry.getValue();
                            OCacheEntry cacheEntry = this.readCache.loadForWrite(fileId, pageIndex, true, this.writeCache, 1, true);
                            if (cacheEntry == null) {
                                assert (filePageChanges.isNew);
                                do {
                                    if (cacheEntry == null) continue;
                                    this.readCache.releaseFromWrite(cacheEntry, this.writeCache);
                                } while ((cacheEntry = this.readCache.allocateNewPage(fileId, this.writeCache, true)).getPageIndex() != pageIndex);
                            }
                            OLogSequenceNumber originalPageLSN = ODurablePage.getLogSequenceNumberFromPage(cacheEntry.getCachePointer().getBuffer());
                            OLogSequenceNumber changesLSN = writeAheadLog.log(new OUpdatePageRecord(pageIndex, fileId, this.operationUnitId, filePageChanges.changes, originalPageLSN));
                            try {
                                ODurablePage durablePage = new ODurablePage(cacheEntry);
                                durablePage.restoreChanges(filePageChanges.changes);
                                durablePage.setLsn(changesLSN);
                                if (!filePageChanges.pinPage) continue;
                                this.readCache.pinPage(cacheEntry);
                                continue;
                            }
                            finally {
                                this.readCache.releaseFromWrite(cacheEntry, this.writeCache);
                                continue;
                            }
                        }
                        filePageChangesIterator.remove();
                    }
                }
            } else {
                Iterator<Object> iterator = this.deletedFiles.iterator();
                while (iterator.hasNext()) {
                    long l = iterator.next();
                    this.readCache.deleteFile(l, this.writeCache);
                }
                for (Map.Entry entry : this.fileChanges.entrySet()) {
                    FileChanges fileChanges = (FileChanges)entry.getValue();
                    long fileId = (Long)entry.getKey();
                    if (fileChanges.isNew) {
                        this.readCache.addFile(fileChanges.fileName, this.newFileNamesId.get(fileChanges.fileName), this.writeCache);
                    } else if (fileChanges.truncate) {
                        this.readCache.truncateFile(fileId, this.writeCache);
                    }
                    for (Map.Entry filePageChangesEntry : fileChanges.pageChangesMap.entrySet()) {
                        OCacheEntryChanges filePageChanges = (OCacheEntryChanges)filePageChangesEntry.getValue();
                        if (!filePageChanges.changes.hasChanges()) continue;
                        long pageIndex = (Long)filePageChangesEntry.getKey();
                        OCacheEntry cacheEntry = this.readCache.loadForWrite(fileId, pageIndex, true, this.writeCache, 1, true);
                        if (cacheEntry == null) {
                            assert (filePageChanges.isNew);
                            do {
                                if (cacheEntry == null) continue;
                                this.readCache.releaseFromWrite(cacheEntry, this.writeCache);
                            } while ((cacheEntry = this.readCache.allocateNewPage(fileId, this.writeCache, true)).getPageIndex() != pageIndex);
                        }
                        try {
                            ODurablePage durablePage = new ODurablePage(cacheEntry);
                            durablePage.restoreChanges(filePageChanges.changes);
                            if (!filePageChanges.pinPage) continue;
                            this.readCache.pinPage(cacheEntry);
                        }
                        finally {
                            this.readCache.releaseFromWrite(cacheEntry, this.writeCache);
                        }
                    }
                }
            }
        }
        finally {
            if (sessionStoragePerformanceStatistic != null) {
                sessionStoragePerformanceStatistic.stopCommitTimer();
                sessionStoragePerformanceStatistic.completeComponentOperation();
            }
        }
    }

    void incrementCounter() {
        ++this.startCounter;
    }

    void decrementCounter() {
        --this.startCounter;
    }

    int getCounter() {
        return this.startCounter;
    }

    void rollback(Exception e) {
        this.rollback = true;
        this.rollbackException = e;
    }

    Exception getRollbackException() {
        return this.rollbackException;
    }

    boolean isRollback() {
        return this.rollback;
    }

    void addLockedObject(String lockedObject) {
        this.lockedObjects.add(lockedObject);
    }

    boolean containsInLockedObjects(String objectToLock) {
        return this.lockedObjects.contains(objectToLock);
    }

    Iterable<String> lockedObjects() {
        return this.lockedObjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAtomicOperation operation = (OAtomicOperation)o;
        return this.operationUnitId.equals(operation.operationUnitId);
    }

    public int hashCode() {
        return this.operationUnitId.hashCode();
    }

    private int storageId(long fileId) {
        return (int)(fileId >>> 32);
    }

    private long composeFileId(long fileId, int storageId) {
        return (long)storageId << 32 | fileId;
    }

    private long checkFileIdCompatibility(long fileId, int storageId) {
        if (storageId == -1) {
            return fileId;
        }
        if (this.storageId(fileId) == 0) {
            return this.composeFileId(fileId, storageId);
        }
        return fileId;
    }

    private static class FileChanges {
        private final Map<Long, OCacheEntryChanges> pageChangesMap = new HashMap<Long, OCacheEntryChanges>();
        private long maxNewPageIndex = -2L;
        private boolean isNew = false;
        private boolean truncate = false;
        private String fileName = null;

        private FileChanges() {
        }
    }
}

