/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.lock.OComparableLockManager;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OHighLevelException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.AtomicLongOProfilerHookValue;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OUTF8Serializer;
import com.orientechnologies.common.thread.OScheduledThreadPoolExecutorWithLogging;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationImpl;
import com.orientechnologies.orient.core.config.OStorageConfigurationUpdateListener;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDeleter;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.encryption.OEncryptionFactory;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.exception.OJVMErrorException;
import com.orientechnologies.orient.core.exception.OLowDiskSpaceException;
import com.orientechnologies.orient.core.exception.OPageIsBrokenException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.ORetryQueryException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OStorageExistsException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.query.OQueryAbstract;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OIdentifiableStorage;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.impl.local.OCheckpointRequestListener;
import com.orientechnologies.orient.core.storage.impl.local.OClusterBrowsePage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorageComponent;
import com.orientechnologies.orient.core.storage.impl.local.OIndexEngineCallback;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.OMicroTransaction;
import com.orientechnologies.orient.core.storage.impl.local.OPageIsBrokenListener;
import com.orientechnologies.orient.core.storage.impl.local.OStorageRecoverListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineCluster;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractCheckPointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileDeletedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPaginatedClusterFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import com.orientechnologies.orient.core.storage.index.engine.OHashTableIndexEngine;
import com.orientechnologies.orient.core.storage.index.engine.OSBTreeIndexEngine;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainerSBTree;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManagerAbstract;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManagerShared;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class OAbstractPaginatedStorage
extends OStorageAbstract
implements OLowDiskSpaceListener,
OCheckpointRequestListener,
OIdentifiableStorage,
OBackgroundExceptionListener,
OFreezableStorageComponent,
OPageIsBrokenListener {
    private static final int RECORD_LOCK_TIMEOUT = OGlobalConfiguration.STORAGE_RECORD_LOCK_TIMEOUT.getValueAsInteger();
    private static final int WAL_RESTORE_REPORT_INTERVAL = 30000;
    private static final Comparator<ORecordOperation> COMMIT_RECORD_OPERATION_COMPARATOR = Comparator.comparing(o -> o.getRecord().getIdentity());
    private static volatile DataOutputStream journaledStream = null;
    protected static final OScheduledThreadPoolExecutorWithLogging fuzzyCheckpointExecutor;
    private final OComparableLockManager<ORID> lockManager;
    private final OLockManager<ORID> recordVersionManager;
    private final Map<String, OCluster> clusterMap = new HashMap<String, OCluster>();
    private final List<OCluster> clusters = new ArrayList<OCluster>();
    private volatile ThreadLocal<OStorageTransaction> transaction;
    private final AtomicBoolean checkpointInProgress = new AtomicBoolean();
    private final AtomicBoolean walVacuumInProgress = new AtomicBoolean();
    private final AtomicReference<Error> jvmError = new AtomicReference();
    protected final OSBTreeCollectionManagerShared sbTreeCollectionManager;
    private final OPerformanceStatisticManager performanceStatisticManager = new OPerformanceStatisticManager(this, (long)OGlobalConfiguration.STORAGE_PROFILER_SNAPSHOT_INTERVAL.getValueAsInteger() * 1000000L, (long)OGlobalConfiguration.STORAGE_PROFILER_CLEANUP_INTERVAL.getValueAsInteger() * 1000000L);
    protected volatile OWriteAheadLog writeAheadLog;
    private OStorageRecoverListener recoverListener;
    protected volatile OReadCache readCache;
    protected volatile OWriteCache writeCache;
    private volatile ORecordConflictStrategy recordConflictStrategy = (ORecordConflictStrategy)Orient.instance().getRecordConflictStrategy().getDefaultImplementation();
    private volatile int defaultClusterId = -1;
    protected volatile OAtomicOperationsManager atomicOperationsManager;
    private volatile boolean wereNonTxOperationsPerformedInPreviousOpen = false;
    private volatile OLowDiskSpaceInformation lowDiskSpace = null;
    private volatile boolean pessimisticLock = false;
    private final Set<OPair<String, Long>> brokenPages = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile Throwable dataFlushException = null;
    private final int id;
    private final Map<String, OIndexEngine> indexEngineNameMap = new HashMap<String, OIndexEngine>();
    private final List<OIndexEngine> indexEngines = new ArrayList<OIndexEngine>();
    private boolean wereDataRestoredAfterOpen = false;
    private final LongAdder fullCheckpointCount = new LongAdder();
    private final AtomicLong recordCreated = new AtomicLong(0L);
    private final AtomicLong recordUpdated = new AtomicLong(0L);
    private final AtomicLong recordRead = new AtomicLong(0L);
    private final AtomicLong recordDeleted = new AtomicLong(0L);
    private final AtomicLong recordScanned = new AtomicLong(0L);
    private final AtomicLong recordRecycled = new AtomicLong(0L);
    private final AtomicLong recordConflict = new AtomicLong(0L);
    private final AtomicLong txBegun = new AtomicLong(0L);
    private final AtomicLong txCommit = new AtomicLong(0L);
    private final AtomicLong txRollback = new AtomicLong(0L);

    public OAbstractPaginatedStorage(String name, String filePath, String mode, int id) {
        super(name, filePath, mode);
        this.id = id;
        this.lockManager = new ORIDOLockManager();
        this.recordVersionManager = new OPartitionedLockManager<ORID>();
        this.registerProfilerHooks();
        this.sbTreeCollectionManager = new OSBTreeCollectionManagerShared(this);
    }

    @Override
    public void open(String iUserName, String iUserPassword, OContextConfiguration contextConfiguration) {
        this.open(contextConfiguration);
    }

    public void open(OContextConfiguration contextConfiguration) {
        try {
            this.stateLock.acquireReadLock();
            try {
                if (this.status == OStorage.STATUS.OPEN) {
                    return;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
            this.stateLock.acquireWriteLock();
            try {
                if (this.status == OStorage.STATUS.OPEN) {
                    return;
                }
                if (!this.exists()) {
                    throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
                }
                this.pessimisticLock = contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_PESSIMISTIC_LOCKING);
                this.transaction = new ThreadLocal();
                ((OStorageConfigurationImpl)this.configuration).load(contextConfiguration);
                this.checkPageSizeAndRelatedParameters();
                this.componentsFactory = new OCurrentStorageComponentsFactory(this.getConfiguration());
                this.preOpenSteps();
                try {
                    this.performanceStatisticManager.registerMBean(this.name, this.id);
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for profiler cannot be registered.", e, new Object[0]);
                }
                this.initWalAndDiskCache(contextConfiguration);
                this.atomicOperationsManager = new OAtomicOperationsManager(this);
                try {
                    this.atomicOperationsManager.registerMBean();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for atomic operations manager cannot be registered", e, new Object[0]);
                }
                this.recoverIfNeeded();
                this.openClusters();
                this.openIndexes();
                this.status = OStorage.STATUS.OPEN;
                String cs = this.configuration.getConflictStrategy();
                if (cs != null) {
                    this.setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(cs));
                }
                this.readCache.loadCacheState(this.writeCache);
            }
            catch (OStorageException e) {
                throw e;
            }
            catch (Exception e) {
                for (OCluster c : this.clusters) {
                    try {
                        if (c == null) continue;
                        c.close(false);
                    }
                    catch (IOException e1) {
                        OLogManager.instance().error(this, "Cannot close cluster after exception on open", e1, new Object[0]);
                    }
                }
                try {
                    this.status = OStorage.STATUS.OPEN;
                    this.close(true, false);
                }
                catch (RuntimeException re) {
                    OLogManager.instance().error(this, "Error during storage close", re, new Object[0]);
                }
                this.status = OStorage.STATUS.CLOSED;
                throw OException.wrapException(new OStorageException("Cannot open local storage '" + this.url + "' with mode=" + this.mode), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        OLogManager.instance().infoNoDb(this, "Storage '%s' is opened under OrientDB distribution : %s", this.getURL(), OConstants.getVersion());
    }

    public void handleJVMError(Error e) {
        this.jvmError.compareAndSet(null, e);
    }

    public void underDistributedStorage() {
        this.sbTreeCollectionManager.prohibitAccess();
    }

    @Override
    public String getCreatedAtVersion() {
        return this.getConfiguration().getCreatedAtVersion();
    }

    protected void openIndexes() {
        OCurrentStorageComponentsFactory cf = this.componentsFactory;
        if (cf == null) {
            throw new OStorageException("Storage '" + this.name + "' is not properly initialized");
        }
        Set<String> indexNames = this.getConfiguration().indexEngines();
        for (String indexName : indexNames) {
            OStorageConfigurationImpl.IndexEngineData engineData = this.getConfiguration().getIndexEngine(indexName);
            OIndexEngine engine = OIndexes.createIndexEngine(engineData.getName(), engineData.getAlgorithm(), engineData.getIndexType(), engineData.getDurableInNonTxMode(), this, engineData.getVersion(), engineData.getEngineProperties(), null);
            try {
                OEncryption encryption = engineData.getEncryption() == null || engineData.getEncryption().toLowerCase(this.configuration.getLocaleInstance()).equals("nothing") ? null : OEncryptionFactory.INSTANCE.getEncryption(engineData.getEncryption(), engineData.getEncryptionOptions());
                engine.load(engineData.getName(), cf.binarySerializerFactory.getObjectSerializer(engineData.getValueSerializerId()), engineData.isAutomatic(), cf.binarySerializerFactory.getObjectSerializer(engineData.getKeySerializedId()), engineData.getKeyTypes(), engineData.isNullValuesSupport(), engineData.getKeySize(), engineData.getEngineProperties(), encryption);
                this.indexEngineNameMap.put(engineData.getName(), engine);
                this.indexEngines.add(engine);
            }
            catch (RuntimeException e) {
                OLogManager.instance().error(this, "Index '" + engineData.getName() + "' cannot be created and will be removed from configuration", e, new Object[0]);
                engine.deleteWithoutLoad(engineData.getName());
            }
        }
    }

    protected void openClusters() throws IOException {
        this.addDefaultClusters();
        List<OStorageClusterConfiguration> configurationClusters = this.configuration.getClusters();
        for (int i = 0; i < configurationClusters.size(); ++i) {
            OStorageClusterConfiguration clusterConfig = configurationClusters.get(i);
            if (clusterConfig != null) {
                int pos = this.createClusterFromConfig(clusterConfig);
                try {
                    if (pos == -1) {
                        this.clusters.get(i).open();
                        continue;
                    }
                    if (clusterConfig.getName().equals("default")) {
                        this.defaultClusterId = pos;
                    }
                    this.clusters.get(pos).open();
                }
                catch (FileNotFoundException e) {
                    OLogManager.instance().warn((Object)this, "Error on loading cluster '" + configurationClusters.get(i).getName() + "' (" + i + "): file not found. It will be excluded from current database '" + this.getName() + "'.", e, new Object[0]);
                    this.clusterMap.remove(configurationClusters.get(i).getName().toLowerCase(this.configuration.getLocaleInstance()));
                    this.setCluster(i, null);
                }
                continue;
            }
            this.setCluster(i, null);
        }
    }

    public void open(OToken iToken, OContextConfiguration configuration) {
        this.open(iToken.getUserName(), "", configuration);
    }

    @Override
    public void create(OContextConfiguration contextConfiguration) throws IOException {
        OAbstractPaginatedStorage.checkPageSizeAndRelatedParametersInGlobalConfiguration();
        try {
            this.stateLock.acquireWriteLock();
            try {
                if (this.status != OStorage.STATUS.CLOSED) {
                    throw new OStorageExistsException("Cannot create new storage '" + this.getURL() + "' because it is not closed");
                }
                if (this.exists()) {
                    throw new OStorageExistsException("Cannot create new storage '" + this.getURL() + "' because it already exists");
                }
                this.pessimisticLock = contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_PESSIMISTIC_LOCKING);
                ((OStorageConfigurationImpl)this.configuration).initConfiguration(contextConfiguration);
                this.componentsFactory = new OCurrentStorageComponentsFactory(this.getConfiguration());
                try {
                    this.performanceStatisticManager.registerMBean(this.name, this.id);
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for profiler cannot be registered.", e, new Object[0]);
                }
                this.transaction = new ThreadLocal();
                this.initWalAndDiskCache(contextConfiguration);
                this.atomicOperationsManager = new OAtomicOperationsManager(this);
                try {
                    this.atomicOperationsManager.registerMBean();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for atomic operations manager cannot be registered", e, new Object[0]);
                }
                this.preCreateSteps();
                this.status = OStorage.STATUS.OPEN;
                this.doAddCluster("internal", null);
                ((OStorageConfigurationImpl)this.configuration).create();
                ((OStorageConfigurationImpl)this.configuration).setCreationVersion(OConstants.getVersion());
                ((OStorageConfigurationImpl)this.configuration).setPageSize(OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024);
                ((OStorageConfigurationImpl)this.configuration).setFreeListBoundary(OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger() * 1024);
                ((OStorageConfigurationImpl)this.configuration).setMaxKeySize(OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger());
                this.doAddCluster("index", null);
                this.doAddCluster("manindex", null);
                this.defaultClusterId = this.doAddCluster("default", null);
                if (this.jvmError.get() == null) {
                    this.clearStorageDirty();
                }
                if (contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CREATE)) {
                    this.makeFullCheckpoint();
                }
                this.postCreateSteps();
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OStorageException("Storage creation was interrupted"), e);
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw OException.wrapException(new OStorageException("Error on creation of storage '" + this.name + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        OLogManager.instance().infoNoDb(this, "Storage '%s' is created under OrientDB distribution : %s", this.getURL(), OConstants.getVersion());
    }

    private static void checkPageSizeAndRelatedParametersInGlobalConfiguration() {
        int pageSize = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
        int freeListBoundary = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger() * 1024;
        int maxKeySize = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
        if (freeListBoundary > pageSize / 2) {
            throw new OStorageException("Value of parameter " + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " should be at least 2 times bigger than value of parameter " + OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getKey() + " but real values are :" + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " = " + pageSize + " , " + OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getKey() + " = " + freeListBoundary);
        }
        if (maxKeySize > pageSize / 4) {
            throw new OStorageException("Value of parameter " + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " should be at least 4 times bigger than value of parameter " + OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getKey() + " but real values are :" + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " = " + pageSize + " , " + OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getKey() + " = " + maxKeySize);
        }
    }

    private void checkPageSizeAndRelatedParameters() {
        int pageSize = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
        int freeListBoundary = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger() * 1024;
        int maxKeySize = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
        if (this.configuration.getPageSize() != -1 && this.configuration.getPageSize() != pageSize) {
            throw new OStorageException("Storage is created with value of " + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " parameter equal to " + this.configuration.getPageSize() + " but current value is " + pageSize);
        }
        if (this.configuration.getFreeListBoundary() != -1 && this.configuration.getFreeListBoundary() != freeListBoundary) {
            throw new OStorageException("Storage is created with value of " + OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getKey() + " parameter equal to " + this.configuration.getFreeListBoundary() + " but current value is " + freeListBoundary);
        }
        if (this.configuration.getMaxKeySize() != -1 && this.configuration.getMaxKeySize() != maxKeySize) {
            throw new OStorageException("Storage is created with value of " + OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getKey() + " parameter equal to " + this.configuration.getMaxKeySize() + " but current value is " + maxKeySize);
        }
    }

    @Override
    public boolean isClosed() {
        this.stateLock.acquireReadLock();
        try {
            boolean bl = super.isClosed();
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    @Override
    public void close(boolean force, boolean onDelete) {
        try {
            this.doClose(force, onDelete);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        try {
            long timer = Orient.instance().getProfiler().startChrono();
            this.stateLock.acquireWriteLock();
            try {
                try {
                    this.close(true, true);
                    if (this.writeAheadLog != null) {
                        this.writeAheadLog.delete();
                    }
                    if (this.writeCache != null) {
                        if (this.readCache != null) {
                            this.readCache.deleteStorage(this.writeCache);
                        } else {
                            this.writeCache.delete();
                        }
                    }
                    this.postDeleteSteps();
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Cannot delete database '" + this.name + "'"), e);
                }
            }
            finally {
                this.stateLock.releaseWriteLock();
                Orient.instance().getProfiler().stopChrono("db." + this.name + ".drop", "Drop a database", timer, "db.*.drop");
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean check(boolean verbose, OCommandOutputListener listener) {
        try {
            listener.onMessage("Check of storage is started...");
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                long lockId = this.atomicOperationsManager.freezeAtomicOperations(null, null);
                try {
                    this.checkOpenness();
                    long start = System.currentTimeMillis();
                    OPageDataVerificationError[] pageErrors = this.writeCache.checkStoredPages(verbose ? listener : null);
                    listener.onMessage("Check of storage completed in " + (System.currentTimeMillis() - start) + "ms. " + (pageErrors.length > 0 ? pageErrors.length + " with errors." : " without errors."));
                    boolean bl = pageErrors.length == 0;
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                    throw throwable;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int addCluster(String clusterName, Object ... parameters) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.makeStorageDirty();
                int n = this.doAddCluster(clusterName, parameters);
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error in creation of new cluster '" + clusterName), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int addCluster(String clusterName, int requestedId, Object ... parameters) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                if (requestedId < 0) {
                    throw new OConfigurationException("Cluster id must be positive!");
                }
                if (requestedId < this.clusters.size() && this.clusters.get(requestedId) != null) {
                    throw new OConfigurationException("Requested cluster ID [" + requestedId + "] is occupied by cluster with name [" + this.clusters.get(requestedId).getName() + "]");
                }
                this.makeStorageDirty();
                int n = this.addClusterInternal(clusterName, requestedId, parameters);
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error in creation of new cluster '" + clusterName + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean dropCluster(int clusterId, boolean iTruncate) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                if (clusterId < 0) throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                if (clusterId >= this.clusters.size()) {
                    throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                }
                OCluster cluster = this.clusters.get(clusterId);
                if (cluster == null) {
                    boolean bl = false;
                    return bl;
                }
                if (iTruncate) {
                    cluster.truncate();
                }
                cluster.delete();
                this.makeStorageDirty();
                this.clusterMap.remove(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()));
                this.clusters.set(clusterId, null);
                this.getConfiguration().dropCluster(clusterId);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw OException.wrapException(new OStorageException("Error while removing cluster '" + clusterId + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setClusterStatus(int clusterId, OStorageClusterConfiguration.STATUS iStatus) {
        try {
            this.checkOpenness();
            this.stateLock.acquireWriteLock();
            try {
                OCluster newCluster;
                this.checkOpenness();
                if (clusterId < 0) throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                if (clusterId >= this.clusters.size()) {
                    throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                }
                OCluster cluster = this.clusters.get(clusterId);
                if (cluster == null) {
                    boolean bl = false;
                    return bl;
                }
                if (iStatus == OStorageClusterConfiguration.STATUS.OFFLINE && cluster instanceof OOfflineCluster || iStatus == OStorageClusterConfiguration.STATUS.ONLINE && !(cluster instanceof OOfflineCluster)) {
                    boolean bl = false;
                    return bl;
                }
                if (iStatus == OStorageClusterConfiguration.STATUS.OFFLINE) {
                    cluster.close(true);
                    newCluster = new OOfflineCluster(this, clusterId, cluster.getName());
                } else {
                    newCluster = OPaginatedClusterFactory.INSTANCE.createCluster(cluster.getName(), this.configuration.getVersion(), this);
                    newCluster.configure(this, clusterId, cluster.getName(), new Object[0]);
                    newCluster.open();
                }
                this.clusterMap.put(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()), newCluster);
                this.clusters.set(clusterId, newCluster);
                this.makeStorageDirty();
                ((OStorageConfigurationImpl)this.configuration).setClusterStatus(clusterId, iStatus);
                this.makeFullCheckpoint();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw OException.wrapException(new OStorageException("Error while removing cluster '" + clusterId + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public OSBTreeCollectionManager getSBtreeCollectionManager() {
        return this.sbTreeCollectionManager;
    }

    public OReadCache getReadCache() {
        return this.readCache;
    }

    public OWriteCache getWriteCache() {
        return this.writeCache;
    }

    @Override
    public long count(int iClusterId) {
        return this.count(iClusterId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long count(int clusterId, boolean countTombstones) {
        try {
            if (clusterId == -1) {
                throw new OStorageException("Cluster Id " + clusterId + " is invalid in database '" + this.name + "'");
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                OCluster cluster = this.clusters.get(clusterId);
                if (cluster == null) {
                    long l = 0L;
                    return l;
                }
                if (countTombstones) {
                    long l = cluster.getEntries();
                    return l;
                }
                long l = cluster.getEntries() - cluster.getTombstonesCount();
                return l;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long[] getClusterDataRange(int iClusterId) {
        try {
            if (iClusterId == -1) {
                return new long[]{-1L, -1L};
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                long[] lArray;
                this.checkOpenness();
                if (this.clusters.get(iClusterId) != null) {
                    long[] lArray2 = new long[2];
                    lArray2[0] = this.clusters.get(iClusterId).getFirstPosition();
                    lArray = lArray2;
                    lArray2[1] = this.clusters.get(iClusterId).getLastPosition();
                } else {
                    lArray = OCommonConst.EMPTY_LONG_ARRAY;
                }
                long[] lArray3 = lArray;
                return lArray3;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cannot retrieve information about data range"), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public OLogSequenceNumber getLSN() {
        try {
            if (this.writeAheadLog == null) {
                return null;
            }
            return this.writeAheadLog.end();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    @Override
    public void onException(Throwable e) {
        this.dataFlushException = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OLogSequenceNumber recordsChangedAfterLSN(OLogSequenceNumber lsn, OutputStream stream, OCommandOutputListener outputListener) {
        try {
            if (!this.getConfiguration().getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL)) {
                throw new IllegalStateException("Cannot find records which were changed starting from provided LSN because tracking of rids of changed records in WAL is switched off, to switch it on please set property " + OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getKey() + " to the true value, please note that only records which are stored after this property was set will be retrieved");
            }
            this.stateLock.acquireReadLock();
            try {
                if (this.writeAheadLog == null) {
                    OLogSequenceNumber oLogSequenceNumber = null;
                    return oLogSequenceNumber;
                }
                OLogSequenceNumber endLsn = this.writeAheadLog.end();
                if (endLsn == null || lsn.compareTo(endLsn) > 0) {
                    OLogManager.instance().warn((Object)this, "Cannot find requested LSN=%s for database sync operation. Last available LSN is %s", lsn, endLsn);
                    OLogSequenceNumber oLogSequenceNumber = null;
                    return oLogSequenceNumber;
                }
                if (lsn.equals(endLsn)) {
                    OLogSequenceNumber oLogSequenceNumber = endLsn;
                    return oLogSequenceNumber;
                }
                TreeSet sortedRids = new TreeSet();
                OLogSequenceNumber startLsn = this.writeAheadLog.next(lsn);
                if (startLsn == null) {
                    OLogManager.instance().info((Object)this, "Cannot find requested LSN=%s for database sync operation (last available LSN is %s)", lsn, endLsn);
                    OLogSequenceNumber oLogSequenceNumber = null;
                    return oLogSequenceNumber;
                }
                OLogSequenceNumber freezeLsn = startLsn;
                this.writeAheadLog.addCutTillLimit(freezeLsn);
                try {
                    startLsn = this.writeAheadLog.next(lsn);
                    if (startLsn == null) {
                        OLogManager.instance().info((Object)this, "Cannot find requested LSN=%s for database sync operation (last available LSN is %s)", lsn, endLsn);
                        OLogSequenceNumber oLogSequenceNumber = null;
                        return oLogSequenceNumber;
                    }
                    OWALRecord walRecord = this.writeAheadLog.read(startLsn);
                    if (walRecord == null) {
                        OLogManager.instance().info((Object)this, "Cannot find requested LSN=%s for database sync operation (record in WAL is absent)", lsn);
                        OLogSequenceNumber oLogSequenceNumber = null;
                        return oLogSequenceNumber;
                    }
                    OLogSequenceNumber currentLsn = startLsn;
                    long read = 0L;
                    while (currentLsn != null && endLsn.compareTo(currentLsn) >= 0) {
                        OAtomicUnitEndRecord atomicUnitEndRecord;
                        walRecord = this.writeAheadLog.read(currentLsn);
                        if (walRecord instanceof OFileCreatedWALRecord) {
                            throw new ODatabaseException("Cannot execute delta-sync because a new file has been added. Filename: '" + ((OFileCreatedWALRecord)walRecord).getFileName() + "' (id=" + ((OFileCreatedWALRecord)walRecord).getFileId() + ")");
                        }
                        if (walRecord instanceof OFileDeletedWALRecord) {
                            throw new ODatabaseException("Cannot execute delta-sync because a file has been deleted. File id: " + ((OFileDeletedWALRecord)walRecord).getFileId());
                        }
                        if (walRecord instanceof OAtomicUnitEndRecord && (atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord).getAtomicOperationMetadata().containsKey("cluster.record.rid")) {
                            ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)atomicUnitEndRecord.getAtomicOperationMetadata().get("cluster.record.rid");
                            Object rids = recordOperationMetadata.getValue();
                            sortedRids.addAll(rids);
                        }
                        currentLsn = this.writeAheadLog.next(currentLsn);
                        ++read;
                        if (outputListener == null) continue;
                        outputListener.onMessage("read " + read + " records from WAL and collected " + sortedRids.size() + " records");
                    }
                }
                finally {
                    this.writeAheadLog.removeCutTillLimit(freezeLsn);
                }
                int totalRecords = sortedRids.size();
                OLogManager.instance().info((Object)this, "Exporting records after LSN=%s. Found %d records", lsn, totalRecords);
                long lockId = this.atomicOperationsManager.freezeAtomicOperations(null, null);
                try (DataOutputStream dataOutputStream = new DataOutputStream(stream);){
                    OCluster cluster;
                    dataOutputStream.writeLong(sortedRids.size());
                    long exportedRecord = 1L;
                    Iterator ridIterator = sortedRids.iterator();
                    while (ridIterator.hasNext()) {
                        ORID rid = (ORID)ridIterator.next();
                        cluster = this.clusters.get(rid.getClusterId());
                        if (cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition())) != null) continue;
                        dataOutputStream.writeInt(rid.getClusterId());
                        dataOutputStream.writeLong(rid.getClusterPosition());
                        dataOutputStream.write(1);
                        OLogManager.instance().debug((Object)this, "Exporting deleted record %s", rid);
                        if (outputListener != null) {
                            outputListener.onMessage("exporting record " + exportedRecord + "/" + totalRecords);
                        }
                        ridIterator.remove();
                        ++exportedRecord;
                    }
                    for (ORID rid : sortedRids) {
                        cluster = this.clusters.get(rid.getClusterId());
                        dataOutputStream.writeInt(rid.getClusterId());
                        dataOutputStream.writeLong(rid.getClusterPosition());
                        if (cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition())) == null) {
                            dataOutputStream.writeBoolean(true);
                            OLogManager.instance().debug((Object)this, "Exporting deleted record %s", rid);
                        } else {
                            ORawBuffer rawBuffer = cluster.readRecord(rid.getClusterPosition(), false);
                            assert (rawBuffer != null);
                            dataOutputStream.writeBoolean(false);
                            dataOutputStream.writeInt(rawBuffer.version);
                            dataOutputStream.write(rawBuffer.recordType);
                            dataOutputStream.writeInt(rawBuffer.buffer.length);
                            dataOutputStream.write(rawBuffer.buffer);
                            OLogManager.instance().debug((Object)this, "Exporting modified record rid=%s type=%d size=%d v=%d - buffer size=%d", rid, rawBuffer.recordType, rawBuffer.buffer.length, rawBuffer.version, dataOutputStream.size());
                        }
                        if (outputListener != null) {
                            outputListener.onMessage("exporting record " + exportedRecord + "/" + totalRecords);
                        }
                        ++exportedRecord;
                    }
                }
                finally {
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                }
                OLogSequenceNumber oLogSequenceNumber = endLsn;
                return oLogSequenceNumber;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error of reading of records changed after LSN " + lsn), e);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Set<ORecordId> recordsChangedRecently(int maxEntries) {
        TreeSet<ORecordId> result = new TreeSet<ORecordId>();
        try {
            if (!OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getValueAsBoolean()) {
                throw new IllegalStateException("Cannot find records which were changed starting from provided LSN because tracking of rids of changed records in WAL is switched off, to switch it on please set property " + OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getKey() + " to the true value, please note that only records which are stored after this property was set will be retrieved");
            }
            this.stateLock.acquireReadLock();
            try {
                OWALRecord walRecord;
                OLogSequenceNumber endLsn;
                OLogSequenceNumber freezeLSN;
                OLogSequenceNumber startLsn;
                block30: {
                    block29: {
                        block28: {
                            if (this.writeAheadLog == null) {
                                OLogManager.instance().warn((Object)this, "No WAL found for database '%s'", this.name);
                                Set<ORecordId> set = null;
                                return set;
                            }
                            startLsn = this.writeAheadLog.begin();
                            if (startLsn == null) {
                                OLogManager.instance().warn((Object)this, "The WAL is empty for database '%s'", this.name);
                                TreeSet<ORecordId> treeSet = result;
                                return treeSet;
                            }
                            freezeLSN = startLsn;
                            this.writeAheadLog.addCutTillLimit(freezeLSN);
                            startLsn = this.writeAheadLog.begin();
                            if (startLsn != null) break block28;
                            OLogManager.instance().warn((Object)this, "The WAL is empty for database '%s'", this.name);
                            TreeSet<ORecordId> treeSet = result;
                            this.writeAheadLog.removeCutTillLimit(freezeLSN);
                            return treeSet;
                        }
                        endLsn = this.writeAheadLog.end();
                        if (endLsn != null) break block29;
                        OLogManager.instance().warn((Object)this, "The WAL is empty for database '%s'", this.name);
                        TreeSet<ORecordId> treeSet = result;
                        this.writeAheadLog.removeCutTillLimit(freezeLSN);
                        return treeSet;
                    }
                    walRecord = this.writeAheadLog.read(startLsn);
                    if (walRecord != null) break block30;
                    OLogManager.instance().info((Object)this, "Cannot find requested LSN=%s for database sync operation (record in WAL is absent)", startLsn);
                    Set<ORecordId> set = null;
                    this.writeAheadLog.removeCutTillLimit(freezeLSN);
                    return set;
                }
                try {
                    OLogSequenceNumber currentLsn = startLsn;
                    LinkedList<OLogSequenceNumber> lastTx = new LinkedList<OLogSequenceNumber>();
                    while (currentLsn != null && endLsn.compareTo(currentLsn) >= 0) {
                        walRecord = this.writeAheadLog.read(currentLsn);
                        if (walRecord instanceof OAtomicUnitEndRecord) {
                            if (lastTx.size() >= maxEntries) {
                                lastTx.remove(0);
                            }
                            lastTx.add(currentLsn);
                        }
                        currentLsn = this.writeAheadLog.next(currentLsn);
                    }
                    for (OLogSequenceNumber lsn : lastTx) {
                        walRecord = this.writeAheadLog.read(lsn);
                        OAtomicUnitEndRecord atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord;
                        if (!atomicUnitEndRecord.getAtomicOperationMetadata().containsKey("cluster.record.rid")) continue;
                        ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)atomicUnitEndRecord.getAtomicOperationMetadata().get("cluster.record.rid");
                        Object rids = recordOperationMetadata.getValue();
                        Iterator iterator = rids.iterator();
                        while (iterator.hasNext()) {
                            ORID rid = (ORID)iterator.next();
                            result.add((ORecordId)rid);
                        }
                    }
                    OLogManager.instance().info((Object)this, "Found %d records changed in last %d operations", result.size(), lastTx.size());
                    TreeSet<ORecordId> treeSet = result;
                    this.writeAheadLog.removeCutTillLimit(freezeLSN);
                    return treeSet;
                }
                catch (Throwable throwable) {
                    try {
                        this.writeAheadLog.removeCutTillLimit(freezeLSN);
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw OException.wrapException(new OStorageException("Error on reading last changed records"), e);
                    }
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.checkOpenness();
        long tot = 0L;
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            for (int iClusterId : iClusterIds) {
                OCluster c;
                if (iClusterId >= this.clusters.size()) {
                    throw new OConfigurationException("Cluster id " + iClusterId + " was not found in database '" + this.name + "'");
                }
                if (iClusterId <= -1 || (c = this.clusters.get(iClusterId)) == null) continue;
                tot += c.getEntries() - (countTombstones ? 0L : c.getTombstonesCount());
            }
            long l = tot;
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorageOperationResult<OPhysicalPosition> createRecord(ORecordId rid, byte[] content, int recordVersion, byte recordType, int mode, ORecordCallback<Long> callback) {
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        OPhysicalPosition ppos = new OPhysicalPosition(recordType);
        OCluster cluster = this.getClusterById(rid.getClusterId());
        if (this.transaction.get() != null) {
            return this.doCreateRecord(rid, content, recordVersion, recordType, callback, cluster, ppos, null);
        }
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OStorageOperationResult<OPhysicalPosition> oStorageOperationResult = this.doCreateRecord(rid, content, recordVersion, recordType, callback, cluster, ppos, null);
            this.stateLock.releaseReadLock();
            return oStorageOperationResult;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        try {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and cannot be stored.");
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                OCluster cluster = this.getClusterById(rid.getClusterId());
                this.checkOpenness();
                OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
                if (ppos == null) {
                    ORecordMetadata oRecordMetadata = null;
                    return oRecordMetadata;
                }
                ORecordMetadata oRecordMetadata = new ORecordMetadata(rid, ppos.recordVersion);
                return oRecordMetadata;
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Retrieval of record  '" + rid + "' cause: " + ioe.getMessage(), ioe, new Object[0]);
                return null;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDeleted(ORID rid) {
        try {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and cannot be stored.");
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                OCluster cluster = this.getClusterById(rid.getClusterId());
                this.checkOpenness();
                boolean bl = cluster.isDeleted(new OPhysicalPosition(rid.getClusterPosition()));
                return bl;
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Retrieval of record  '" + rid + "' cause: " + ioe.getMessage(), ioe, new Object[0]);
                return false;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<OClusterBrowsePage> browseCluster(int clusterId) {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            final int finalClusterId = clusterId == -1 ? this.defaultClusterId : clusterId;
            Iterator<OClusterBrowsePage> iterator = new Iterator<OClusterBrowsePage>(){
                private OClusterBrowsePage page = null;
                private long lastPos = -1L;

                @Override
                public boolean hasNext() {
                    if (this.page == null) {
                        this.page = OAbstractPaginatedStorage.this.nextPage(finalClusterId, this.lastPos);
                        if (this.page != null) {
                            this.lastPos = this.page.getLastPosition();
                        }
                    }
                    return this.page != null;
                }

                @Override
                public OClusterBrowsePage next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    OClusterBrowsePage curPage = this.page;
                    this.page = null;
                    return curPage;
                }
            };
            this.stateLock.releaseReadLock();
            return iterator;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClusterBrowsePage nextPage(int clusterId, long lastPosition) {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OCluster cluster = this.doGetAndCheckCluster(clusterId);
            OClusterBrowsePage oClusterBrowsePage = cluster.nextPage(lastPosition);
            this.stateLock.releaseReadLock();
            return oClusterBrowsePage;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private OCluster doGetAndCheckCluster(int clusterId) {
        this.checkClusterSegmentIndexRange(clusterId);
        OCluster cluster = this.clusters.get(clusterId);
        if (cluster == null) {
            throw new IllegalArgumentException("Cluster " + clusterId + " is null");
        }
        return cluster;
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, boolean prefetchRecords, ORecordCallback<ORawBuffer> iCallback) {
        try {
            OCluster cluster;
            this.checkOpenness();
            try {
                cluster = this.getClusterById(iRid.getClusterId());
            }
            catch (IllegalArgumentException e) {
                throw OException.wrapException(new ORecordNotFoundException(iRid), e);
            }
            return new OStorageOperationResult<ORawBuffer>(this.readRecord(cluster, iRid, prefetchRecords));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(ORecordId rid, String fetchPlan, boolean ignoreCache, int recordVersion) throws ORecordNotFoundException {
        try {
            this.checkOpenness();
            return new OStorageOperationResult<ORawBuffer>(this.readRecordIfNotLatest(this.getClusterById(rid.getClusterId()), rid, recordVersion));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<Integer> updateRecord(ORecordId rid, boolean updateContent, byte[] content, int version, byte recordType, int mode, ORecordCallback<Integer> callback) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            OCluster cluster = this.getClusterById(rid.getClusterId());
            if (this.transaction.get() != null) {
                return this.doUpdateRecord(rid, updateContent, content, version, recordType, callback, cluster);
            }
            this.stateLock.acquireReadLock();
            try {
                Lock lock = this.recordVersionManager.acquireExclusiveLock(rid);
                try {
                    this.checkOpenness();
                    OStorageOperationResult<Integer> oStorageOperationResult = this.doUpdateRecord(rid, updateContent, content, version, recordType, callback, cluster);
                    lock.unlock();
                    return oStorageOperationResult;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public OStorageOperationResult<Integer> recyclePosition(ORecordId rid, byte[] content, int version, byte recordType) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            OCluster cluster = this.getClusterById(rid.getClusterId());
            if (this.transaction.get() != null) {
                return this.doRecycleRecord(rid, content, version, cluster, recordType);
            }
            this.stateLock.acquireReadLock();
            try {
                Lock lock = this.recordVersionManager.acquireExclusiveLock(rid);
                try {
                    this.checkOpenness();
                    OStorageOperationResult<Integer> oStorageOperationResult = this.doRecycleRecord(rid, content, version, cluster, recordType);
                    lock.unlock();
                    return oStorageOperationResult;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public OStorageTransaction getStorageTransaction() {
        return this.transaction.get();
    }

    public OAtomicOperationsManager getAtomicOperationsManager() {
        return this.atomicOperationsManager;
    }

    public OWriteAheadLog getWALInstance() {
        return this.writeAheadLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId rid, int version, int mode, ORecordCallback<Boolean> callback) {
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        OCluster cluster = this.getClusterById(rid.getClusterId());
        if (this.transaction.get() != null) {
            return this.doDeleteRecord(rid, version, cluster);
        }
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OStorageOperationResult<Boolean> oStorageOperationResult = this.doDeleteRecord(rid, version, cluster);
            this.stateLock.releaseReadLock();
            return oStorageOperationResult;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public OStorageOperationResult<Boolean> hideRecord(ORecordId rid, int mode, ORecordCallback<Boolean> callback) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            OCluster cluster = this.getClusterById(rid.getClusterId());
            if (this.transaction.get() != null) {
                return this.doHideMethod(rid, cluster);
            }
            this.stateLock.acquireReadLock();
            try {
                Lock lock = this.recordVersionManager.acquireExclusiveLock(rid);
                try {
                    this.checkOpenness();
                    OStorageOperationResult<Boolean> oStorageOperationResult = this.doHideMethod(rid, cluster);
                    lock.unlock();
                    return oStorageOperationResult;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public OPerformanceStatisticManager getPerformanceStatisticManager() {
        return this.performanceStatisticManager;
    }

    public void startGatheringPerformanceStatisticForCurrentThread() {
        try {
            this.performanceStatisticManager.startThreadMonitoring();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public OSessionStoragePerformanceStatistic completeGatheringPerformanceStatisticForCurrentThread() {
        try {
            return this.performanceStatisticManager.stopThreadMonitoring();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        try {
            this.stateLock.acquireReadLock();
            try {
                if (iExclusiveLock) {
                    V v = super.callInLock(iCallable, true);
                    return v;
                }
                V v = super.callInLock(iCallable, false);
                return v;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public Set<String> getClusterNames() {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            this.stateLock.releaseReadLock();
            return hashSet;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getClusterIdByName(String clusterName) {
        try {
            this.checkOpenness();
            if (clusterName == null) {
                throw new IllegalArgumentException("Cluster name is null");
            }
            if (clusterName.length() == 0) {
                throw new IllegalArgumentException("Cluster name is empty");
            }
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                OCluster segment = this.clusterMap.get(clusterName.toLowerCase(this.configuration.getLocaleInstance()));
                if (segment != null) {
                    int n = segment.getId();
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public void preallocateRids(OTransactionInternal clientTx) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            Collection<ORecordOperation> entries = clientTx.getRecordOperations();
            TreeMap<Integer, OCluster> clustersToLock = new TreeMap<Integer, OCluster>();
            TreeSet<ORecordOperation> newRecords = new TreeSet<ORecordOperation>(COMMIT_RECORD_OPERATION_COMPARATOR);
            for (ORecordOperation txEntry : entries) {
                if (txEntry.type != 3) continue;
                newRecords.add(txEntry);
                int clusterId = txEntry.getRID().getClusterId();
                clustersToLock.put(clusterId, this.getClusterById(clusterId));
            }
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.makeStorageDirty();
                this.atomicOperationsManager.startAtomicOperation((String)null, true);
                try {
                    OAbstractPaginatedStorage.lockClusters(clustersToLock);
                    for (ORecordOperation txEntry : newRecords) {
                        ORecordId rid;
                        ORecord rec = txEntry.getRecord();
                        if (!rec.getIdentity().isPersistent()) {
                            if (!rec.isDirty()) continue;
                            rid = (ORecordId)rec.getIdentity().copy();
                            ORecordId oldRID = rid.copy();
                            OCluster cluster = this.getClusterById(rid.getClusterId());
                            OPhysicalPosition ppos = cluster.allocatePosition(ORecordInternal.getRecordType(rec));
                            rid.setClusterPosition(ppos.clusterPosition);
                            clientTx.updateIdentityAfterCommit(oldRID, rid);
                            continue;
                        }
                        rid = (ORecordId)rec.getIdentity();
                        OCluster cluster = this.getClusterById(rid.getClusterId());
                        OPhysicalPosition ppos = cluster.allocatePosition(ORecordInternal.getRecordType(rec));
                        if (ppos.clusterPosition == rid.getClusterPosition()) continue;
                        throw new OConcurrentCreateException(rid, new ORecordId(rid.getClusterId(), ppos.clusterPosition));
                    }
                    this.atomicOperationsManager.endAtomicOperation(false, null);
                }
                catch (RuntimeException e) {
                    this.atomicOperationsManager.endAtomicOperation(true, e);
                    throw e;
                }
            }
            catch (IOException | RuntimeException ioe) {
                throw OException.wrapException(new OStorageException("Could not preallocate RIDs"), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public List<ORecordOperation> commit(OTransactionInternal clientTx) {
        return this.commit(clientTx, false);
    }

    public List<ORecordOperation> commitPreAllocated(OTransactionInternal clientTx) {
        return this.commit(clientTx, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ORecordOperation> commit(OTransactionInternal transaction, boolean allocated) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.txBegun.incrementAndGet();
            ODatabaseDocumentInternal database = transaction.getDatabase();
            OIndexManager indexManager = database.getMetadata().getIndexManager();
            TreeMap<String, OTransactionIndexChanges> indexOperations = OAbstractPaginatedStorage.getSortedIndexOperations(transaction);
            database.getMetadata().makeThreadLocalSchemaSnapshot();
            Collection<ORecordOperation> recordOperations = transaction.getRecordOperations();
            TreeMap<Integer, OCluster> clustersToLock = new TreeMap<Integer, OCluster>();
            IdentityHashMap<ORecordOperation, Integer> clusterOverrides = new IdentityHashMap<ORecordOperation, Integer>();
            TreeSet<ORecordOperation> newRecords = new TreeSet<ORecordOperation>(COMMIT_RECORD_OPERATION_COMPARATOR);
            for (ORecordOperation recordOperation : recordOperations) {
                OImmutableClass class_;
                ORecord record;
                if ((recordOperation.type == 3 || recordOperation.type == 1) && (record = recordOperation.getRecord()) instanceof ODocument) {
                    ((ODocument)record).validate();
                }
                if (recordOperation.type == 1 || recordOperation.type == 2) {
                    int clusterId = recordOperation.getRecord().getIdentity().getClusterId();
                    clustersToLock.put(clusterId, this.getClusterById(clusterId));
                    continue;
                }
                if (recordOperation.type != 3) continue;
                newRecords.add(recordOperation);
                record = recordOperation.getRecord();
                ORID rid = record.getIdentity();
                int clusterId = rid.getClusterId();
                if (record.isDirty() && clusterId == -1 && record instanceof ODocument && (class_ = ODocumentInternal.getImmutableSchemaClass((ODocument)record)) != null) {
                    clusterId = class_.getClusterForNewInstance((ODocument)record);
                    clusterOverrides.put(recordOperation, clusterId);
                }
                clustersToLock.put(clusterId, this.getClusterById(clusterId));
            }
            ArrayList<ORecordOperation> result = new ArrayList<ORecordOperation>();
            this.stateLock.acquireReadLock();
            try {
                if (this.pessimisticLock) {
                    ArrayList<ORID> recordLocks = new ArrayList<ORID>();
                    for (ORecordOperation recordOperation : recordOperations) {
                        if (recordOperation.type != 1 && recordOperation.type != 2) continue;
                        recordLocks.add(recordOperation.getRID());
                    }
                    Collections.sort(recordLocks);
                    for (ORID rid : recordLocks) {
                        this.acquireWriteLock(rid);
                    }
                }
                try {
                    try {
                        this.checkOpenness();
                        this.makeStorageDirty();
                        this.startStorageTx(transaction);
                        OAbstractPaginatedStorage.lockClusters(clustersToLock);
                        this.checkReadOnlyConditions();
                        IdentityHashMap<ORecordOperation, OPhysicalPosition> positions = new IdentityHashMap<ORecordOperation, OPhysicalPosition>();
                        for (ORecordOperation recordOperation : newRecords) {
                            ORecord rec = recordOperation.getRecord();
                            if (allocated) {
                                if (rec.getIdentity().isPersistent()) {
                                    positions.put(recordOperation, new OPhysicalPosition(rec.getIdentity().getClusterPosition()));
                                    continue;
                                }
                                throw new OStorageException("Impossible to commit a transaction with not valid rid in pre-allocated commit");
                            }
                            if (!rec.isDirty() || rec.getIdentity().isPersistent()) continue;
                            ORecordId rid = (ORecordId)rec.getIdentity().copy();
                            ORecordId oldRID = rid.copy();
                            Integer clusterOverride = (Integer)clusterOverrides.get(recordOperation);
                            int clusterId = clusterOverride == null ? rid.getClusterId() : clusterOverride.intValue();
                            OCluster cluster = this.getClusterById(clusterId);
                            OPhysicalPosition physicalPosition = cluster.allocatePosition(ORecordInternal.getRecordType(rec));
                            rid.setClusterId(cluster.getId());
                            if (rid.getClusterPosition() > -1L) {
                                while (rid.getClusterPosition() > physicalPosition.clusterPosition) {
                                    physicalPosition = cluster.allocatePosition(ORecordInternal.getRecordType(rec));
                                }
                                if (rid.getClusterPosition() != physicalPosition.clusterPosition) {
                                    throw new OConcurrentCreateException(rid, new ORecordId(rid.getClusterId(), physicalPosition.clusterPosition));
                                }
                            }
                            positions.put(recordOperation, physicalPosition);
                            rid.setClusterPosition(physicalPosition.clusterPosition);
                            transaction.updateIdentityAfterCommit(oldRID, rid);
                        }
                        this.lockRidBags(clustersToLock, indexOperations, indexManager);
                        this.checkReadOnlyConditions();
                        for (ORecordOperation recordOperation : recordOperations) {
                            this.commitEntry(recordOperation, (OPhysicalPosition)positions.get(recordOperation), database.getSerializer());
                            result.add(recordOperation);
                        }
                        OAbstractPaginatedStorage.lockIndexes(indexOperations);
                        this.checkReadOnlyConditions();
                        OAbstractPaginatedStorage.commitIndexes(indexOperations);
                        OLogSequenceNumber lsn = this.endStorageTx();
                        DataOutputStream journaledStream = OAbstractPaginatedStorage.journaledStream;
                        if (journaledStream != null) {
                            int txId = transaction.getClientTransactionId();
                            if (lsn == null || this.writeAheadLog == null) {
                                try {
                                    journaledStream.writeInt(txId);
                                }
                                catch (IOException e) {
                                    OLogManager.instance().error(this, "unable to write tx id into journaled stream", e, new Object[0]);
                                }
                            } else {
                                this.writeAheadLog.addEventAt(lsn, () -> {
                                    try {
                                        journaledStream.writeInt(txId);
                                    }
                                    catch (IOException e) {
                                        OLogManager.instance().error(this, "unable to write tx id into journaled stream", e, new Object[0]);
                                    }
                                });
                            }
                        }
                        OTransactionAbstract.updateCacheFromEntries(transaction.getDatabase(), recordOperations, true);
                        this.txCommit.incrementAndGet();
                    }
                    catch (IOException | RuntimeException e) {
                        this.makeRollback(transaction, e);
                    }
                    finally {
                        this.transaction.set(null);
                    }
                }
                finally {
                    this.atomicOperationsManager.ensureThatComponentsUnlocked();
                    database.getMetadata().clearThreadLocalSchemaSnapshot();
                }
            }
            finally {
                try {
                    if (this.pessimisticLock) {
                        for (ORecordOperation recordOperation : recordOperations) {
                            if (recordOperation.type != 1 && recordOperation.type != 2) continue;
                            this.releaseWriteLock(recordOperation.getRID());
                        }
                    }
                }
                finally {
                    this.stateLock.releaseReadLock();
                }
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "%d Committed transaction %d on database '%s' (result=%s)", Thread.currentThread().getId(), transaction.getId(), database.getName(), result);
            }
            return result;
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            this.handleJVMError(ee);
            OAtomicOperationsManager.alarmClearOfAtomicOperation();
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commitIndexes(Map<String, OTransactionIndexChanges> indexesToCommit) {
        OIndexAbstract.IndexTxSnapshot snapshot;
        OIndexInternal<?> index;
        IdentityHashMap snapshots = new IdentityHashMap();
        for (OTransactionIndexChanges changes : indexesToCommit.values()) {
            index = changes.getAssociatedIndex();
            snapshot = new OIndexAbstract.IndexTxSnapshot();
            snapshots.put(index, snapshot);
            index.preCommit(snapshot);
        }
        for (OTransactionIndexChanges changes : indexesToCommit.values()) {
            index = changes.getAssociatedIndex();
            snapshot = (OIndexAbstract.IndexTxSnapshot)snapshots.get(index);
            index.addTxOperation(snapshot, changes);
        }
        try {
            for (OTransactionIndexChanges changes : indexesToCommit.values()) {
                index = changes.getAssociatedIndex();
                snapshot = (OIndexAbstract.IndexTxSnapshot)snapshots.get(index);
                index.commit(snapshot);
            }
        }
        finally {
            for (OTransactionIndexChanges changes : indexesToCommit.values()) {
                index = changes.getAssociatedIndex();
                snapshot = (OIndexAbstract.IndexTxSnapshot)snapshots.get(index);
                index.postCommit(snapshot);
            }
        }
    }

    private static TreeMap<String, OTransactionIndexChanges> getSortedIndexOperations(OTransactionInternal clientTx) {
        return new TreeMap<String, OTransactionIndexChanges>(clientTx.getIndexOperations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadIndexEngine(String name) {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                OIndexEngine engine = this.indexEngineNameMap.get(name);
                if (engine == null) {
                    int n = -1;
                    return n;
                }
                int indexId = this.indexEngines.indexOf(engine);
                assert (indexId >= 0);
                int n = indexId;
                return n;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadExternalIndexEngine(String engineName, String algorithm, String indexType, OIndexDefinition indexDefinition, OBinarySerializer valueSerializer, boolean isAutomatic, Boolean durableInNonTxMode, int version, Map<String, String> engineProperties) {
        try {
            this.checkOpenness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                if (this.configuration.getBinaryFormatVersion() > 15) {
                    int n = -1;
                    return n;
                }
                if (this.indexEngineNameMap.containsKey(engineName)) {
                    throw new OIndexException("Index with name " + engineName + " already exists");
                }
                this.makeStorageDirty();
                OBinarySerializer keySerializer = this.determineKeySerializer(indexDefinition);
                int keySize = OAbstractPaginatedStorage.determineKeySize(indexDefinition);
                OType[] keyTypes = indexDefinition != null ? indexDefinition.getTypes() : null;
                boolean nullValuesSupport = indexDefinition != null && !indexDefinition.isNullValuesIgnored();
                OStorageConfigurationImpl.IndexEngineData engineData = new OStorageConfigurationImpl.IndexEngineData(engineName, algorithm, indexType, durableInNonTxMode, version, valueSerializer.getId(), keySerializer.getId(), isAutomatic, keyTypes, nullValuesSupport, keySize, null, null, engineProperties);
                OIndexEngine engine = OIndexes.createIndexEngine(engineName, algorithm, indexType, durableInNonTxMode, this, version, engineProperties, null);
                engine.load(engineName, valueSerializer, isAutomatic, keySerializer, keyTypes, nullValuesSupport, keySize, engineData.getEngineProperties(), null);
                this.indexEngineNameMap.put(engineName, engine);
                this.indexEngines.add(engine);
                ((OStorageConfigurationImpl)this.configuration).addIndexEngine(engineName, engineData);
                int n = this.indexEngines.size() - 1;
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Cannot add index engine " + engineName + " in storage."), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addIndexEngine(String engineName, String algorithm, String indexType, OIndexDefinition indexDefinition, OBinarySerializer valueSerializer, boolean isAutomatic, Boolean durableInNonTxMode, int version, Map<String, String> engineProperties, Set<String> clustersToIndex, ODocument metadata) {
        try {
            this.checkOpenness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                if (this.indexEngineNameMap.containsKey(engineName)) {
                    OLogManager.instance().warn((Object)this, "Index with name '%s' already exists, removing it and re-create the index", engineName);
                    OIndexEngine engine = this.indexEngineNameMap.remove(engineName);
                    if (engine != null) {
                        this.indexEngines.remove(engine);
                        ((OStorageConfigurationImpl)this.configuration).deleteIndexEngine(engineName);
                        engine.delete();
                    }
                }
                this.makeStorageDirty();
                OBinarySerializer keySerializer = this.determineKeySerializer(indexDefinition);
                int keySize = OAbstractPaginatedStorage.determineKeySize(indexDefinition);
                OType[] keyTypes = indexDefinition != null ? indexDefinition.getTypes() : null;
                boolean nullValuesSupport = indexDefinition != null && !indexDefinition.isNullValuesIgnored();
                byte serializerId = valueSerializer != null ? (byte)valueSerializer.getId() : (byte)-1;
                OIndexEngine engine = OIndexes.createIndexEngine(engineName, algorithm, indexType, durableInNonTxMode, this, version, engineProperties, metadata);
                OContextConfiguration ctxCfg = this.getConfiguration().getContextConfiguration();
                String cfgEncryption = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD);
                String cfgEncryptionKey = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
                OEncryption encryption = cfgEncryption == null || cfgEncryption.equals("nothing") ? null : OEncryptionFactory.INSTANCE.getEncryption(cfgEncryption, cfgEncryptionKey);
                engine.create(valueSerializer, isAutomatic, keyTypes, nullValuesSupport, keySerializer, keySize, clustersToIndex, engineProperties, metadata, encryption);
                if (this.writeAheadLog != null) {
                    this.writeAheadLog.flush();
                }
                this.indexEngineNameMap.put(engineName, engine);
                this.indexEngines.add(engine);
                OStorageConfigurationImpl.IndexEngineData engineData = new OStorageConfigurationImpl.IndexEngineData(engineName, algorithm, indexType, durableInNonTxMode, version, serializerId, keySerializer.getId(), isAutomatic, keyTypes, nullValuesSupport, keySize, cfgEncryption, cfgEncryptionKey, engineProperties);
                ((OStorageConfigurationImpl)this.configuration).addIndexEngine(engineName, engineData);
                int n = this.indexEngines.size() - 1;
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Cannot add index engine " + engineName + " in storage."), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private static int determineKeySize(OIndexDefinition indexDefinition) {
        if (indexDefinition == null || indexDefinition instanceof ORuntimeKeyIndexDefinition) {
            return 1;
        }
        return indexDefinition.getTypes().length;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OBinarySerializer determineKeySerializer(OIndexDefinition indexDefinition) {
        void var2_6;
        if (indexDefinition != null) {
            if (indexDefinition instanceof ORuntimeKeyIndexDefinition) {
                OBinarySerializer oBinarySerializer = ((ORuntimeKeyIndexDefinition)indexDefinition).getSerializer();
                return var2_6;
            } else if (indexDefinition.getTypes().length > 1) {
                OCompositeKeySerializer oCompositeKeySerializer = OCompositeKeySerializer.INSTANCE;
                return var2_6;
            } else {
                OType keyType = indexDefinition.getTypes()[0];
                if (keyType == OType.STRING) {
                    return OUTF8Serializer.INSTANCE;
                }
                OCurrentStorageComponentsFactory currentStorageComponentsFactory = this.componentsFactory;
                if (currentStorageComponentsFactory == null) throw new IllegalStateException("Cannot load binary serializer, storage is not properly initialized");
                OBinarySerializer oBinarySerializer = currentStorageComponentsFactory.binarySerializerFactory.getObjectSerializer(keyType);
            }
            return var2_6;
        } else {
            OSimpleKeySerializer oSimpleKeySerializer = new OSimpleKeySerializer();
        }
        return var2_6;
    }

    public void deleteIndexEngine(int indexId) throws OInvalidIndexEngineIdException {
        try {
            this.checkOpenness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.checkIndexId(indexId);
                this.makeStorageDirty();
                OIndexEngine engine = this.indexEngines.get(indexId);
                this.indexEngines.set(indexId, null);
                engine.delete();
                String engineName = engine.getName();
                this.indexEngineNameMap.remove(engineName);
                ((OStorageConfigurationImpl)this.configuration).deleteIndexEngine(engineName);
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error on index deletion"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private void checkIndexId(int indexId) throws OInvalidIndexEngineIdException {
        if (indexId < 0 || indexId >= this.indexEngines.size() || this.indexEngines.get(indexId) == null) {
            throw new OInvalidIndexEngineIdException("Engine with id " + indexId + " is not registered inside of storage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexContainsKey(int indexId, Object key) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doIndexContainsKey(indexId, key);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            boolean bl = this.doIndexContainsKey(indexId, key);
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private boolean doIndexContainsKey(int indexId, Object key) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKeyFromIndex(int indexId, Object key) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doRemoveKeyFromIndex(indexId, key);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            boolean bl = this.doRemoveKeyFromIndex(indexId, key);
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private boolean doRemoveKeyFromIndex(int indexId, Object key) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            this.makeStorageDirty();
            OIndexEngine engine = this.indexEngines.get(indexId);
            return engine.remove(key);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during removal of entry with key " + key + " from index "), e);
        }
    }

    public void clearIndex(int indexId) throws OInvalidIndexEngineIdException {
        try {
            if (this.transaction.get() != null) {
                this.doClearIndex(indexId);
                return;
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.doClearIndex(indexId);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private void doClearIndex(int indexId) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OIndexEngine engine = this.indexEngines.get(indexId);
            this.makeStorageDirty();
            engine.clear();
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during clearing of index"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getIndexValue(int indexId, Object key) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexValue(indexId, key);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            Object object = this.doGetIndexValue(indexId, key);
            this.stateLock.releaseReadLock();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Object doGetIndexValue(int indexId, Object key) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.get(key);
    }

    public OIndexEngine getIndexEngine(int indexId) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            return this.indexEngines.get(indexId);
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexEntry(int indexId, Object key, OIndexKeyUpdater<Object> valueCreator) throws OInvalidIndexEngineIdException {
        try {
            if (this.transaction.get() != null) {
                this.doUpdateIndexEntry(indexId, key, valueCreator);
                return;
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.doUpdateIndexEntry(indexId, key, valueCreator);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T callIndexEngine(boolean atomicOperation, boolean readOperation, int indexId, OIndexEngineCallback<T> callback) throws OInvalidIndexEngineIdException {
        try {
            if (this.transaction.get() != null) {
                return this.doCallIndexEngine(atomicOperation, readOperation, indexId, callback);
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                T t = this.doCallIndexEngine(atomicOperation, readOperation, indexId, callback);
                return t;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    private <T> T doCallIndexEngine(boolean atomicOperation, boolean readOperation, int indexId, OIndexEngineCallback<T> callback) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        try {
            if (atomicOperation) {
                this.atomicOperationsManager.startAtomicOperation((String)null, true);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key value entry in index"), e);
        }
        try {
            if (!readOperation) {
                this.makeStorageDirty();
            }
            OIndexEngine engine = this.indexEngines.get(indexId);
            T result = callback.callEngine(engine);
            if (atomicOperation) {
                this.atomicOperationsManager.endAtomicOperation(false, null);
            }
            return result;
        }
        catch (Exception e) {
            try {
                if (atomicOperation) {
                    this.atomicOperationsManager.endAtomicOperation(true, e);
                }
                throw OException.wrapException(new OStorageException("Cannot put key value entry in index"), e);
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Error during operation rollback"), ioe);
            }
        }
    }

    private void doUpdateIndexEntry(int indexId, Object key, OIndexKeyUpdater<Object> valueCreator) throws OInvalidIndexEngineIdException {
        try {
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key value entry in index"), e);
        }
        try {
            this.checkIndexId(indexId);
            OIndexEngine engine = this.indexEngines.get(indexId);
            this.makeStorageDirty();
            engine.update(key, valueCreator);
            this.atomicOperationsManager.endAtomicOperation(false, null);
        }
        catch (OInvalidIndexEngineIdException e) {
            try {
                this.atomicOperationsManager.endAtomicOperation(true, e);
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Error during operation rollback"), ioe);
            }
            throw e;
        }
        catch (Exception e) {
            try {
                this.atomicOperationsManager.endAtomicOperation(true, e);
                throw OException.wrapException(new OStorageException("Cannot put key value entry in index"), e);
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Error during operation rollback"), ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIndexValue(int indexId, Object key, Object value) throws OInvalidIndexEngineIdException {
        try {
            if (this.transaction.get() != null) {
                this.doPutIndexValue(indexId, key, value);
                return;
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.doPutIndexValue(indexId, key, value);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private void doPutIndexValue(int indexId, Object key, Object value) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OIndexEngine engine = this.indexEngines.get(indexId);
            this.makeStorageDirty();
            engine.put(key, value);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key " + key + " value " + value + " entry to the index"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validatedPutIndexValue(int indexId, Object key, OIdentifiable value, OIndexEngine.Validator<Object, OIdentifiable> validator) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doValidatedPutIndexValue(indexId, key, value, validator);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            boolean bl = this.doValidatedPutIndexValue(indexId, key, value, validator);
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private boolean doValidatedPutIndexValue(int indexId, Object key, OIdentifiable value, OIndexEngine.Validator<Object, OIdentifiable> validator) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OIndexEngine engine = this.indexEngines.get(indexId);
            this.makeStorageDirty();
            return engine.validatedPut(key, value, validator);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key " + key + " value " + value + " entry to the index"), e);
        }
    }

    public Object getIndexFirstKey(int indexId) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexFirstKey(indexId);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            Object object = this.doGetIndexFirstKey(indexId);
            this.stateLock.releaseReadLock();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Object doGetIndexFirstKey(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.getFirstKey();
    }

    public Object getIndexLastKey(int indexId) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexFirstKey(indexId);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            Object object = this.doGetIndexLastKey(indexId);
            this.stateLock.releaseReadLock();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Object doGetIndexLastKey(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.getLastKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor iterateIndexEntriesBetween(int indexId, Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doIterateIndexEntriesBetween(indexId, rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OIndexCursor oIndexCursor = this.doIterateIndexEntriesBetween(indexId, rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private OIndexCursor doIterateIndexEntriesBetween(int indexId, Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor iterateIndexEntriesMajor(int indexId, Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doIterateIndexEntriesMajor(indexId, fromKey, isInclusive, ascSortOrder, transformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OIndexCursor oIndexCursor = this.doIterateIndexEntriesMajor(indexId, fromKey, isInclusive, ascSortOrder, transformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private OIndexCursor doIterateIndexEntriesMajor(int indexId, Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor iterateIndexEntriesMinor(int indexId, Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doIterateIndexEntriesMinor(indexId, toKey, isInclusive, ascSortOrder, transformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OIndexCursor oIndexCursor = this.doIterateIndexEntriesMinor(indexId, toKey, isInclusive, ascSortOrder, transformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private OIndexCursor doIterateIndexEntriesMinor(int indexId, Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.iterateEntriesMinor(toKey, isInclusive, ascSortOrder, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor getIndexCursor(int indexId, OIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexCursor(indexId, valuesTransformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OIndexCursor oIndexCursor = this.doGetIndexCursor(indexId, valuesTransformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private OIndexCursor doGetIndexCursor(int indexId, OIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.cursor(valuesTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor getIndexDescCursor(int indexId, OIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexDescCursor(indexId, valuesTransformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OIndexCursor oIndexCursor = this.doGetIndexDescCursor(indexId, valuesTransformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private OIndexCursor doGetIndexDescCursor(int indexId, OIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.descCursor(valuesTransformer);
    }

    public OIndexKeyCursor getIndexKeyCursor(int indexId) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexKeyCursor(indexId);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OIndexKeyCursor oIndexKeyCursor = this.doGetIndexKeyCursor(indexId);
            this.stateLock.releaseReadLock();
            return oIndexKeyCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private OIndexKeyCursor doGetIndexKeyCursor(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.keyCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIndexSize(int indexId, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexSize(indexId, transformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            long l = this.doGetIndexSize(indexId, transformer);
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private long doGetIndexSize(int indexId, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.size(transformer);
    }

    public boolean hasIndexRangeQuerySupport(int indexId) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doHasRangeQuerySupport(indexId);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            boolean bl = this.doHasRangeQuerySupport(indexId);
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private boolean doHasRangeQuerySupport(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.hasRangeQuerySupport();
    }

    private void makeRollback(OTransactionInternal clientTx, Exception e) {
        OLogManager.instance().debug((Object)this, "Error during transaction commit, transaction will be rolled back (tx-id=%d)", e, clientTx.getId());
        this.rollback(clientTx);
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw OException.wrapException(new OStorageException("Error during transaction commit"), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(OTransactionInternal clientTx) {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                try {
                    this.checkOpenness();
                    if (this.transaction.get() == null) {
                        return;
                    }
                    if (this.transaction.get().getClientTx().getId() != clientTx.getId()) {
                        throw new OStorageException("Passed in and active transaction are different transactions. Passed in transaction cannot be rolled back.");
                    }
                    this.makeStorageDirty();
                    this.rollbackStorageTx();
                    OTransactionAbstract.updateCacheFromEntries(clientTx.getDatabase(), clientTx.getRecordOperations(), false);
                    this.txRollback.incrementAndGet();
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Error during transaction rollback"), e);
                }
                finally {
                    this.transaction.set(null);
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(OMicroTransaction microTransaction) {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                try {
                    this.checkOpenness();
                    if (this.transaction.get() == null) {
                        return;
                    }
                    if (this.transaction.get().getMicroTransaction().getId() != microTransaction.getId()) {
                        throw new OStorageException("Passed in and active micro-transaction are different micro-transactions. Passed in micro-transaction cannot be rolled back.");
                    }
                    this.makeStorageDirty();
                    this.rollbackStorageTx();
                    microTransaction.updateRecordCacheAfterRollback();
                    this.txRollback.incrementAndGet();
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Error during micro-transaction rollback"), e);
                }
                finally {
                    this.transaction.set(null);
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        try {
            return ppos != null && !ORecordVersionHelper.isTombstone(ppos.recordVersion);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synch() {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                long timer = Orient.instance().getProfiler().startChrono();
                long lockId = this.atomicOperationsManager.freezeAtomicOperations(null, null);
                try {
                    this.checkOpenness();
                    if (this.jvmError.get() == null) {
                        for (OIndexEngine indexEngine : this.indexEngines) {
                            try {
                                if (indexEngine == null) continue;
                                indexEngine.flush();
                            }
                            catch (Throwable t) {
                                OLogManager.instance().error(this, "Error while flushing index via index engine of class %s.", t, indexEngine.getClass().getSimpleName());
                            }
                        }
                        if (this.writeAheadLog != null) {
                            this.makeFullCheckpoint();
                            return;
                        }
                        this.writeCache.flush();
                        this.clearStorageDirty();
                    } else {
                        OLogManager.instance().errorNoDb(this, "Sync can not be performed because of JVM error on storage", null, new Object[0]);
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Error on synch storage '" + this.name + "'"), e);
                }
                finally {
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                    Orient.instance().getProfiler().stopChrono("db." + this.name + ".synch", "Synch a database", timer, "db.*.synch");
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                if (iClusterId < 0 || iClusterId >= this.clusters.size()) {
                    String string = null;
                    return string;
                }
                String string = this.clusters.get(iClusterId) != null ? this.clusters.get(iClusterId).getName() : null;
                return string;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterById(int iClusterId) {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            OCluster cluster;
            this.checkOpenness();
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            OCluster oCluster = cluster = this.doGetAndCheckCluster(iClusterId);
            this.stateLock.releaseReadLock();
            return oCluster;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterByName(String clusterName) {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OCluster cluster = this.clusterMap.get(clusterName.toLowerCase(this.configuration.getLocaleInstance()));
            if (cluster == null) {
                throw new OStorageException("Cluster " + clusterName + " does not exist in database '" + this.name + "'");
            }
            OCluster oCluster = cluster;
            this.stateLock.releaseReadLock();
            return oCluster;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        try {
            try {
                long size = 0L;
                this.stateLock.acquireReadLock();
                try {
                    for (OCluster c : this.clusters) {
                        if (c == null) continue;
                        size += c.getRecordsSize();
                    }
                }
                finally {
                    this.stateLock.releaseReadLock();
                }
                return size;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cannot calculate records size"), ioe);
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public int getClusters() {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            int n = this.clusterMap.size();
            this.stateLock.releaseReadLock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OCluster> getClusterInstances() {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            HashSet<OCluster> result = new HashSet<OCluster>();
            for (OCluster c : this.clusters) {
                if (c == null) continue;
                result.add(c);
            }
            HashSet<OCluster> hashSet = result;
            this.stateLock.releaseReadLock();
            return hashSet;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    public void renameCluster(String oldName, String newName) {
        try {
            this.clusterMap.put(newName.toLowerCase(this.configuration.getLocaleInstance()), this.clusterMap.remove(oldName.toLowerCase(this.configuration.getLocaleInstance())));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public boolean cleanOutRecord(ORecordId recordId, int recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.deleteRecord(recordId, recordVersion, iMode, callback).getResult();
    }

    @Override
    public boolean isFrozen() {
        try {
            return this.atomicOperationsManager.isFrozen();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeze(boolean throwException) {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                if (throwException) {
                    this.atomicOperationsManager.freezeAtomicOperations(OModificationOperationProhibitedException.class, "Modification requests are prohibited");
                } else {
                    this.atomicOperationsManager.freezeAtomicOperations(null, null);
                }
                ArrayList<OFreezableStorageComponent> frozenIndexes = new ArrayList<OFreezableStorageComponent>(this.indexEngines.size());
                try {
                    for (OIndexEngine indexEngine : this.indexEngines) {
                        if (!(indexEngine instanceof OFreezableStorageComponent)) continue;
                        ((OFreezableStorageComponent)((Object)indexEngine)).freeze(false);
                        frozenIndexes.add((OFreezableStorageComponent)((Object)indexEngine));
                    }
                }
                catch (Exception e) {
                    for (OFreezableStorageComponent indexEngine : frozenIndexes) {
                        indexEngine.release();
                    }
                    throw OException.wrapException(new OStorageException("Error on freeze of storage '" + this.name + "'"), e);
                }
                this.synch();
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public void release() {
        try {
            for (OIndexEngine indexEngine : this.indexEngines) {
                if (!(indexEngine instanceof OFreezableStorageComponent)) continue;
                ((OFreezableStorageComponent)((Object)indexEngine)).release();
            }
            this.atomicOperationsManager.releaseAtomicOperations(-1L);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public boolean wereDataRestoredAfterOpen() {
        return this.wereDataRestoredAfterOpen;
    }

    public boolean wereNonTxOperationsPerformedInPreviousOpen() {
        return this.wereNonTxOperationsPerformedInPreviousOpen;
    }

    @Override
    public void reload() {
        try {
            this.close();
            this.open(null, null, null);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public String getMode() {
        return this.mode;
    }

    @Override
    public void lowDiskSpace(OLowDiskSpaceInformation information) {
        this.lowDiskSpace = information;
    }

    @Override
    public void pageIsBroken(String fileName, long pageIndex) {
        this.brokenPages.add(new OPair<String, Long>(fileName, pageIndex));
    }

    @Override
    public void requestCheckpoint() {
        try {
            if (!this.walVacuumInProgress.get() && this.walVacuumInProgress.compareAndSet(false, true)) {
                fuzzyCheckpointExecutor.submit(new WALVacuum());
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public Object command(OCommandRequestText iCommand) {
        try {
            while (true) {
                try {
                    OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
                    executor.setContext(iCommand.getContext());
                    executor.setProgressListener(iCommand.getProgressListener());
                    executor.parse(iCommand);
                    return this.executeCommand(iCommand, executor);
                }
                catch (ORetryQueryException ignore) {
                    if (!(iCommand instanceof OQueryAbstract)) continue;
                    OQueryAbstract query = (OQueryAbstract)((Object)iCommand);
                    query.reset();
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee, false);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeCommand(OCommandRequestText iCommand, OCommandExecutor executor) {
        try {
            ODatabaseDocumentInternal db;
            Iterator iterator;
            if (iCommand.isIdempotent() && !executor.isIdempotent()) {
                throw new OCommandExecutionException("Cannot execute non idempotent command");
            }
            long beginTime = Orient.instance().getProfiler().startChrono();
            try {
                Map<Object, Object> params;
                ODatabaseDocumentInternal db2 = ODatabaseRecordThreadLocal.instance().get();
                Iterable<ODatabaseListener> listeners = db2.getListeners();
                for (ODatabaseListener oDatabaseListener : listeners) {
                    oDatabaseListener.onBeforeCommand(iCommand, executor);
                }
                boolean foundInCache = false;
                Object result = null;
                if (iCommand.isCacheableResult() && executor.isCacheable() && iCommand.getParameters() == null && (result = db2.getMetadata().getCommandCache().get(db2.getUser(), iCommand.getText(), iCommand.getLimit())) != null) {
                    foundInCache = true;
                    if (iCommand.getResultListener() != null) {
                        if (result instanceof Collection) {
                            for (Object o : (Collection)result) {
                                iCommand.getResultListener().result(o);
                            }
                        } else {
                            iCommand.getResultListener().result(result);
                        }
                        result = null;
                    }
                }
                if (!foundInCache && (result = executor.execute(params = iCommand.getParameters())) != null && iCommand.isCacheableResult() && executor.isCacheable() && (iCommand.getParameters() == null || iCommand.getParameters().isEmpty())) {
                    db2.getMetadata().getCommandCache().put(db2.getUser(), iCommand.getText(), result, iCommand.getLimit(), executor.getInvolvedClusters(), System.currentTimeMillis() - beginTime);
                }
                for (ODatabaseListener oDatabaseListener : listeners) {
                    oDatabaseListener.onAfterCommand(iCommand, executor, result);
                }
                iterator = result;
            }
            catch (OException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw OException.wrapException(new OCommandExecutionException("Error on execution of command: " + iCommand), e2);
                    }
                }
                catch (Throwable throwable) {
                    ODatabaseDocumentInternal db3;
                    if (Orient.instance().getProfiler().isRecording() && (db3 = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
                        OSecurityUser user = db3.getUser();
                        String userString = user != null ? user.toString() : null;
                        Orient.instance().getProfiler().stopChrono("db." + ODatabaseRecordThreadLocal.instance().get().getName() + ".command." + iCommand.toString(), "Command executed against the database", beginTime, "db.*.command.*", null, userString);
                    }
                    throw throwable;
                }
            }
            if (Orient.instance().getProfiler().isRecording() && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
                OSecurityUser user = db.getUser();
                String userString = user != null ? user.toString() : null;
                Orient.instance().getProfiler().stopChrono("db." + ODatabaseRecordThreadLocal.instance().get().getName() + ".command." + iCommand.toString(), "Command executed against the database", beginTime, "db.*.command.*", null, userString);
            }
            return iterator;
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee, false);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        try {
            if (currentClusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                OCluster cluster = this.getClusterById(currentClusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.higherPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        try {
            if (clusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                OCluster cluster = this.getClusterById(clusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.ceilingPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        try {
            if (currentClusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                OCluster cluster = this.getClusterById(currentClusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.lowerPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        try {
            if (clusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                OCluster cluster = this.getClusterById(clusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.floorPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public void acquireWriteLock(ORID rid) {
        try {
            this.lockManager.acquireLock(rid, OComparableLockManager.LOCK.EXCLUSIVE, RECORD_LOCK_TIMEOUT);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public void releaseWriteLock(ORID rid) {
        try {
            this.lockManager.releaseLock(this, rid, OComparableLockManager.LOCK.EXCLUSIVE);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public void acquireReadLock(ORID rid) {
        try {
            this.lockManager.acquireLock(rid, OComparableLockManager.LOCK.SHARED, RECORD_LOCK_TIMEOUT);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public void releaseReadLock(ORID rid) {
        try {
            this.lockManager.releaseLock(this, rid, OComparableLockManager.LOCK.SHARED);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        return this.recordConflictStrategy;
    }

    @Override
    public void setConflictStrategy(ORecordConflictStrategy conflictResolver) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.recordConflictStrategy = conflictResolver;
            ((OStorageConfigurationImpl)this.configuration).setConflictStrategy(conflictResolver.getName());
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public AtomicLong getRecordScanned() {
        return this.recordScanned;
    }

    protected abstract OLogSequenceNumber copyWALToIncrementalBackup(ZipOutputStream var1, long var2) throws IOException;

    protected abstract boolean isWriteAllowedDuringIncrementalBackup();

    public OStorageRecoverListener getRecoverListener() {
        return this.recoverListener;
    }

    public void registerRecoverListener(OStorageRecoverListener recoverListener) {
        this.recoverListener = recoverListener;
    }

    public void unregisterRecoverListener(OStorageRecoverListener recoverListener) {
        if (this.recoverListener == recoverListener) {
            this.recoverListener = null;
        }
    }

    protected abstract File createWalTempDirectory();

    protected abstract void addFileToDirectory(String var1, InputStream var2, File var3) throws IOException;

    protected abstract OWriteAheadLog createWalFromIBUFiles(File var1) throws IOException;

    protected void checkOpenness() {
        if (this.status != OStorage.STATUS.OPEN) {
            throw new OStorageException("Storage " + this.name + " is not opened.");
        }
    }

    protected void makeFuzzyCheckpoint() {
        if (this.writeAheadLog == null) {
            return;
        }
        while (!this.stateLock.tryAcquireReadLock(1000000L)) {
            if (this.status == OStorage.STATUS.OPEN) continue;
            return;
        }
        try {
            long fuzzySegment;
            if (this.status != OStorage.STATUS.OPEN || this.writeAheadLog == null) {
                return;
            }
            OLogSequenceNumber endLSN = this.writeAheadLog.end();
            OLogSequenceNumber minLSN = this.writeCache.getMinimalNotFlushedLSN();
            if (minLSN != null) {
                fuzzySegment = minLSN.getSegment();
            } else {
                if (endLSN == null) {
                    return;
                }
                fuzzySegment = endLSN.getSegment();
            }
            this.writeCache.makeFuzzyCheckpoint(fuzzySegment);
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OIOException("Error during fuzzy checkpoint"), ioe);
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    protected void makeFullCheckpoint() {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startFullCheckpointTimer();
        }
        try {
            if (this.writeAheadLog == null) {
                return;
            }
            try {
                this.writeAheadLog.flush();
                this.writeAheadLog.appendNewSegment();
                OLogSequenceNumber lastLSN = this.writeAheadLog.logFullCheckpointStart();
                this.writeCache.flush();
                this.writeAheadLog.logFullCheckpointEnd();
                this.writeAheadLog.flush();
                this.writeAheadLog.cutTill(lastLSN);
                if (this.jvmError.get() == null) {
                    this.clearStorageDirty();
                }
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Error during checkpoint creation for storage " + this.name), ioe);
            }
            this.fullCheckpointCount.increment();
        }
        finally {
            if (statistic != null) {
                statistic.stopFullCheckpointTimer();
            }
        }
    }

    public long getFullCheckpointCount() {
        return this.fullCheckpointCount.sum();
    }

    protected void preOpenSteps() throws IOException {
    }

    protected void postCreateSteps() {
    }

    protected void preCreateSteps() throws IOException {
    }

    protected abstract void initWalAndDiskCache(OContextConfiguration var1) throws IOException, InterruptedException;

    protected abstract void postCloseSteps(boolean var1, boolean var2) throws IOException;

    protected void preCloseSteps() {
    }

    protected void postDeleteSteps() {
    }

    protected void makeStorageDirty() throws IOException {
    }

    protected void clearStorageDirty() throws IOException {
    }

    protected boolean isDirty() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer readRecordIfNotLatest(OCluster cluster, ORecordId rid, int recordVersion) throws ORecordNotFoundException {
        this.checkOpenness();
        if (!rid.isPersistent()) {
            throw new ORecordNotFoundException(rid, "Cannot read record " + rid + " since the position is invalid in database '" + this.name + '\'');
        }
        if (this.transaction.get() != null) {
            return OAbstractPaginatedStorage.doReadRecordIfNotLatest(cluster, rid, recordVersion);
        }
        this.stateLock.acquireReadLock();
        try {
            ORawBuffer buff;
            if (this.pessimisticLock) {
                this.acquireReadLock(rid);
            }
            this.checkOpenness();
            ORawBuffer oRawBuffer = buff = OAbstractPaginatedStorage.doReadRecordIfNotLatest(cluster, rid, recordVersion);
            return oRawBuffer;
        }
        finally {
            try {
                if (this.pessimisticLock) {
                    this.releaseReadLock(rid);
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer readRecord(OCluster clusterSegment, ORecordId rid, boolean prefetchRecords) {
        this.checkOpenness();
        if (!rid.isPersistent()) {
            throw new ORecordNotFoundException(rid, "Cannot read record " + rid + " since the position is invalid in database '" + this.name + '\'');
        }
        if (this.transaction.get() != null) {
            return this.doReadRecord(clusterSegment, rid, prefetchRecords);
        }
        this.stateLock.acquireReadLock();
        try {
            if (this.pessimisticLock) {
                this.acquireReadLock(rid);
            }
            this.checkOpenness();
            ORawBuffer oRawBuffer = this.doReadRecord(clusterSegment, rid, prefetchRecords);
            return oRawBuffer;
        }
        finally {
            try {
                if (this.pessimisticLock) {
                    this.releaseReadLock(rid);
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
    }

    private OLogSequenceNumber endStorageTx() throws IOException {
        OLogSequenceNumber lsn = this.atomicOperationsManager.endAtomicOperation(false, null);
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
        return lsn;
    }

    private void startStorageTx(OTransactionInternal clientTx) throws IOException {
        OStorageTransaction storageTx = this.transaction.get();
        if (storageTx != null && storageTx.getClientTx().getId() != clientTx.getId()) {
            this.rollback(clientTx);
        }
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
        this.transaction.set(new OStorageTransaction(clientTx));
        try {
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
        }
        catch (RuntimeException e) {
            this.transaction.set(null);
            throw e;
        }
    }

    private void rollbackStorageTx() throws IOException {
        if (this.writeAheadLog == null || this.transaction.get() == null) {
            return;
        }
        this.atomicOperationsManager.endAtomicOperation(true, null);
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
    }

    private void recoverIfNeeded() throws Exception {
        if (this.isDirty()) {
            OLogManager.instance().warn((Object)this, "Storage '" + this.name + "' was not closed properly. Will try to recover from write ahead log", new Object[0]);
            try {
                boolean bl = this.wereDataRestoredAfterOpen = this.restoreFromWAL() != null;
                if (this.recoverListener != null) {
                    this.recoverListener.onStorageRecover();
                }
                this.makeFullCheckpoint();
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Exception during storage data restore", e, new Object[0]);
                throw e;
            }
            OLogManager.instance().info((Object)this, "Storage data recover was completed", new Object[0]);
        }
    }

    private OStorageOperationResult<OPhysicalPosition> doCreateRecord(ORecordId rid, byte[] content, int recordVersion, byte recordType, ORecordCallback<Long> callback, OCluster cluster, OPhysicalPosition ppos, OPhysicalPosition allocated) {
        if (content == null) {
            throw new IllegalArgumentException("Record is null");
        }
        try {
            recordVersion = recordVersion > -1 ? ++recordVersion : 0;
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                ppos = cluster.createRecord(content, recordVersion, recordType, allocated);
                rid.setClusterPosition(ppos.clusterPosition);
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e);
                if (e instanceof OOfflineClusterException) {
                    throw (OOfflineClusterException)e;
                }
                OLogManager.instance().error(this, "Error on creating record in cluster: " + cluster, e, new Object[0]);
                try {
                    if (ppos.clusterPosition != -1L) {
                        cluster.deleteRecord(ppos.clusterPosition);
                    }
                }
                catch (IOException ioe) {
                    OLogManager.instance().error(this, "Error on removing record in cluster: " + cluster, ioe, new Object[0]);
                }
                throw ODatabaseException.wrapException(new OStorageException("Error during creation of record"), e);
            }
            if (callback != null) {
                callback.call(rid, ppos.clusterPosition);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Created record %s v.%s size=%d bytes", rid, recordVersion, content.length);
            }
            this.recordCreated.incrementAndGet();
            return new OStorageOperationResult<OPhysicalPosition>(ppos);
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error during record deletion in cluster " + (cluster != null ? cluster.getName() : "")), ioe);
        }
    }

    private OStorageOperationResult<Integer> doUpdateRecord(ORecordId rid, boolean updateContent, byte[] content, int version, byte recordType, ORecordCallback<Integer> callback, OCluster cluster) {
        Orient.instance().getProfiler().startChrono();
        try {
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
            if (!this.checkForRecordValidity(ppos)) {
                int recordVersion = -1;
                if (callback != null) {
                    callback.call(rid, -1);
                }
                return new OStorageOperationResult<Integer>(-1);
            }
            boolean contentModified = false;
            if (updateContent) {
                AtomicInteger recVersion = new AtomicInteger(version);
                AtomicInteger dbVersion = new AtomicInteger(ppos.recordVersion);
                byte[] newContent = this.checkAndIncrementVersion(cluster, rid, recVersion, dbVersion, content, recordType);
                ppos.recordVersion = dbVersion.get();
                if (newContent != null) {
                    contentModified = true;
                    content = newContent;
                }
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                ORecordSerializationContext context;
                if (updateContent) {
                    cluster.updateRecord(rid.getClusterPosition(), content, ppos.recordVersion, recordType);
                }
                if ((context = ORecordSerializationContext.getContext()) != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e);
                OLogManager.instance().error(this, "Error on updating record " + rid + " (cluster: " + cluster + ")", e, new Object[0]);
                int recordVersion = -1;
                if (callback != null) {
                    callback.call(rid, -1);
                }
                return new OStorageOperationResult<Integer>(-1);
            }
            int newRecordVersion = updateContent ? ppos.recordVersion : version;
            if (callback != null) {
                callback.call(rid, newRecordVersion);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Updated record %s v.%s size=%d", rid, newRecordVersion, content.length);
            }
            this.recordUpdated.incrementAndGet();
            if (contentModified) {
                return new OStorageOperationResult<Integer>(newRecordVersion, content, false);
            }
            return new OStorageOperationResult<Integer>(newRecordVersion);
        }
        catch (OConcurrentModificationException e) {
            this.recordConflict.incrementAndGet();
            throw e;
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error on updating record " + rid + " (cluster: " + cluster.getName() + ")"), ioe);
        }
    }

    private OStorageOperationResult<Integer> doRecycleRecord(ORecordId rid, byte[] content, int version, OCluster cluster, byte recordType) {
        try {
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                cluster.recycleRecord(rid.getClusterPosition(), content, version, recordType);
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null);
            }
            catch (RuntimeException e) {
                this.atomicOperationsManager.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e);
                OLogManager.instance().error(this, "Error on recycling record " + rid + " (cluster: " + cluster + ")", e, new Object[0]);
                throw OException.wrapException(new OStorageException("Error on recycling record " + rid + " (cluster: " + cluster + ")"), e);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Recycled record %s v.%s size=%d", rid, version, content.length);
            }
            return new OStorageOperationResult<Integer>(version, content, false);
        }
        catch (IOException ioe) {
            OLogManager.instance().error(this, "Error on recycling record " + rid + " (cluster: " + cluster + ")", ioe, new Object[0]);
            throw OException.wrapException(new OStorageException("Error on recycling record " + rid + " (cluster: " + cluster + ")"), ioe);
        }
    }

    private OStorageOperationResult<Boolean> doDeleteRecord(ORecordId rid, int version, OCluster cluster) {
        Orient.instance().getProfiler().startChrono();
        try {
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
            if (ppos == null) {
                return new OStorageOperationResult<Boolean>(false);
            }
            if (version > -1 && ppos.recordVersion != version) {
                this.recordConflict.incrementAndGet();
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(rid, ppos.recordVersion, version, 2);
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                cluster.deleteRecord(ppos.clusterPosition);
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e);
                OLogManager.instance().error(this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", e, new Object[0]);
                return new OStorageOperationResult<Boolean>(false);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Deleted record %s v.%s", rid, version);
            }
            this.recordDeleted.incrementAndGet();
            return new OStorageOperationResult<Boolean>(true);
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error on deleting record " + rid + "( cluster: " + cluster.getName() + ")"), ioe);
        }
    }

    private OStorageOperationResult<Boolean> doHideMethod(ORecordId rid, OCluster cluster) {
        try {
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
            if (ppos == null) {
                return new OStorageOperationResult<Boolean>(false);
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                cluster.hideRecord(ppos.clusterPosition);
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e);
                OLogManager.instance().error(this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", e, new Object[0]);
                return new OStorageOperationResult<Boolean>(false);
            }
            return new OStorageOperationResult<Boolean>(true);
        }
        catch (IOException ioe) {
            OLogManager.instance().error(this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", ioe, new Object[0]);
            throw OException.wrapException(new OStorageException("Error on deleting record " + rid + "( cluster: " + cluster + ")"), ioe);
        }
    }

    private ORawBuffer doReadRecord(OCluster clusterSegment, ORecordId rid, boolean prefetchRecords) {
        try {
            ORawBuffer buff = clusterSegment.readRecord(rid.getClusterPosition(), prefetchRecords);
            if (buff != null && OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Read record %s v.%s size=%d bytes", rid, buff.version, buff.buffer != null ? buff.buffer.length : 0);
            }
            this.recordRead.incrementAndGet();
            return buff;
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during read of record with rid = " + rid), e);
        }
    }

    private static ORawBuffer doReadRecordIfNotLatest(OCluster cluster, ORecordId rid, int recordVersion) throws ORecordNotFoundException {
        try {
            return cluster.readRecordIfVersionIsNotLatest(rid.getClusterPosition(), recordVersion);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during read of record with rid = " + rid), e);
        }
    }

    private void addDefaultClusters() throws IOException {
        String storageCompression = this.getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD);
        String storageEncryption = this.getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD);
        String encryptionKey = this.getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
        String stgConflictStrategy = this.getConflictStrategy().getName();
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.getConfiguration(), this.clusters.size(), "internal", null, true, 20.0f, 4.0f, storageCompression, storageEncryption, encryptionKey, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.getConfiguration(), this.clusters.size(), "index", null, false, 1.2f, 1.2f, storageCompression, storageEncryption, encryptionKey, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.getConfiguration(), this.clusters.size(), "manindex", null, false, 1.0f, 1.0f, storageCompression, storageEncryption, encryptionKey, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
        this.defaultClusterId = this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.getConfiguration(), this.clusters.size(), "default", null, true, 1.2f, 1.2f, storageCompression, storageEncryption, encryptionKey, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
    }

    private int createClusterFromConfig(OStorageClusterConfiguration config) throws IOException {
        OCluster cluster = this.clusterMap.get(config.getName().toLowerCase(this.configuration.getLocaleInstance()));
        if (cluster != null) {
            cluster.configure(this, config);
            return -1;
        }
        cluster = config.getStatus() == OStorageClusterConfiguration.STATUS.ONLINE ? OPaginatedClusterFactory.INSTANCE.createCluster(config.getName(), this.configuration.getVersion(), this) : new OOfflineCluster(this, config.getId(), config.getName());
        cluster.configure(this, config);
        return this.registerCluster(cluster);
    }

    private void setCluster(int id, OCluster cluster) {
        if (this.clusters.size() <= id) {
            while (this.clusters.size() < id) {
                this.clusters.add(null);
            }
            this.clusters.add(cluster);
        } else {
            this.clusters.set(id, cluster);
        }
    }

    private int registerCluster(OCluster cluster) {
        int id;
        if (cluster != null) {
            if (this.clusterMap.containsKey(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()))) {
                throw new OConfigurationException("Cannot add cluster '" + cluster.getName() + "' because it is already registered in database '" + this.name + "'");
            }
            this.clusterMap.put(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()), cluster);
            id = cluster.getId();
        } else {
            id = this.clusters.size();
        }
        this.setCluster(id, cluster);
        return id;
    }

    private int doAddCluster(String clusterName, Object[] parameters) throws IOException {
        int clusterPos = this.clusters.size();
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i) != null) continue;
            clusterPos = i;
            break;
        }
        return this.addClusterInternal(clusterName, clusterPos, parameters);
    }

    private int addClusterInternal(String clusterName, int clusterPos, Object ... parameters) throws IOException {
        OCluster cluster;
        if (clusterName != null) {
            clusterName = clusterName.toLowerCase(this.configuration.getLocaleInstance());
            cluster = OPaginatedClusterFactory.INSTANCE.createCluster(clusterName, this.configuration.getVersion(), this);
            cluster.configure(this, clusterPos, clusterName, parameters);
        } else {
            cluster = null;
        }
        int createdClusterId = -1;
        if (cluster != null) {
            cluster.create(-1);
            if (this.writeAheadLog != null) {
                this.writeAheadLog.flush();
            }
            createdClusterId = this.registerCluster(cluster);
            ((OPaginatedCluster)cluster).registerInStorageConfig((OStorageConfigurationImpl)this.configuration);
            ((OStorageConfigurationImpl)this.configuration).update();
        }
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Created cluster '%s' in database '%s' with id %d. Clusters: %s", clusterName, this.url, createdClusterId, this.clusters);
        }
        return createdClusterId;
    }

    private void doClose(boolean force, boolean onDelete) {
        if (!force && !onDelete) {
            return;
        }
        if (this.status == OStorage.STATUS.CLOSED) {
            return;
        }
        long timer = Orient.instance().getProfiler().startChrono();
        this.stateLock.acquireWriteLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                return;
            }
            this.status = OStorage.STATUS.CLOSING;
            if (this.jvmError.get() == null) {
                this.readCache.storeCacheState(this.writeCache);
                if (!onDelete && this.jvmError.get() == null) {
                    this.makeFullCheckpoint();
                }
                this.preCloseSteps();
                this.sbTreeCollectionManager.close();
                this.clusters.clear();
                this.clusterMap.clear();
                for (OIndexEngine engine : this.indexEngines) {
                    if (engine == null || engine instanceof OSBTreeIndexEngine || engine instanceof OHashTableIndexEngine) continue;
                    if (onDelete) {
                        engine.delete();
                        continue;
                    }
                    engine.close();
                }
                this.indexEngines.clear();
                this.indexEngineNameMap.clear();
                if (this.getConfiguration() != null) {
                    if (onDelete) {
                        ((OStorageConfigurationImpl)this.configuration).delete();
                    } else {
                        ((OStorageConfigurationImpl)this.configuration).close();
                    }
                }
                super.close(force, onDelete);
                if (this.writeCache != null) {
                    this.writeCache.removeLowDiskSpaceListener(this);
                    this.writeCache.removeBackgroundExceptionListener(this);
                    this.writeCache.removePageIsBrokenListener(this);
                }
                if (this.writeAheadLog != null) {
                    this.writeAheadLog.removeFullCheckpointListener(this);
                    this.writeAheadLog.removeLowDiskSpaceListener(this);
                }
                if (this.readCache != null) {
                    if (!onDelete) {
                        this.readCache.closeStorage(this.writeCache);
                    } else {
                        this.readCache.deleteStorage(this.writeCache);
                    }
                }
                if (this.writeAheadLog != null) {
                    this.writeAheadLog.close();
                    if (onDelete) {
                        this.writeAheadLog.delete();
                    }
                }
                try {
                    this.performanceStatisticManager.unregisterMBean(this.name, this.id);
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for write cache cannot be unregistered", e, new Object[0]);
                }
                this.postCloseSteps(onDelete, this.jvmError.get() != null);
                if (this.atomicOperationsManager != null) {
                    try {
                        this.atomicOperationsManager.unregisterMBean();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "MBean for atomic operations manager cannot be unregistered", e, new Object[0]);
                    }
                }
                this.transaction = null;
            } else {
                OLogManager.instance().errorNoDb(this, "Because of JVM error happened inside of storage it can not be properly closed", null, new Object[0]);
            }
            this.status = OStorage.STATUS.CLOSED;
        }
        catch (IOException e) {
            String message = "Error on closing of storage '" + this.name;
            OLogManager.instance().error(this, message, e, new Object[0]);
            throw OException.wrapException(new OStorageException(message), e);
        }
        finally {
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".close", "Close a database", timer, "db.*.close");
            this.stateLock.releaseWriteLock();
        }
    }

    protected void closeClusters(boolean onDelete) throws IOException {
        for (OCluster cluster : this.clusters) {
            if (cluster == null) continue;
            cluster.close(!onDelete);
        }
        this.clusters.clear();
        this.clusterMap.clear();
    }

    protected void closeIndexes(boolean onDelete) {
        for (OIndexEngine engine : this.indexEngines) {
            if (engine == null) continue;
            if (onDelete) {
                engine.delete();
                continue;
            }
            engine.close();
        }
        this.indexEngines.clear();
        this.indexEngineNameMap.clear();
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private byte[] checkAndIncrementVersion(OCluster iCluster, ORecordId rid, AtomicInteger version, AtomicInteger iDatabaseVersion, byte[] iRecordContent, byte iRecordType) {
        int v = version.get();
        switch (v) {
            case -1: {
                iDatabaseVersion.incrementAndGet();
                break;
            }
            case -2: {
                break;
            }
            default: {
                if (v < -2) {
                    version.set(ORecordVersionHelper.clearRollbackMode(v));
                    iDatabaseVersion.set(version.get());
                    break;
                }
                if (v != iDatabaseVersion.get()) {
                    ORecordConflictStrategy strategy = iCluster.getRecordConflictStrategy() != null ? iCluster.getRecordConflictStrategy() : this.recordConflictStrategy;
                    return strategy.onUpdate(this, iRecordType, rid, v, iRecordContent, iDatabaseVersion);
                }
                iDatabaseVersion.incrementAndGet();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void commitEntry(ORecordOperation txEntry, OPhysicalPosition allocated, ORecordSerializer serializer) {
        rec = txEntry.getRecord();
        if (txEntry.type != 2 && !rec.isDirty()) {
            return;
        }
        rid = (ORecordId)rec.getIdentity();
        if (txEntry.type == 1 && rid.isNew()) {
            txEntry.type = (byte)3;
        }
        ORecordSerializationContext.pushContext();
        try {
            cluster = this.getClusterById(rid.getClusterId());
            if (cluster.getName().equals("index") || cluster.getName().equals("manindex")) {
                return;
            }
            switch (txEntry.type) {
                case 0: {
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 3: {
                    stream = serializer.toStream(rec, false);
                    if (allocated != null) {
                        recordType = ORecordInternal.getRecordType(rec);
                        ppos = this.doCreateRecord(rid, stream, rec.getVersion(), recordType, null, cluster, new OPhysicalPosition(recordType), allocated).getResult();
                        ORecordInternal.setVersion(rec, ppos.recordVersion);
                        ** break;
lbl24:
                        // 1 sources

                    } else {
                        updateRes = this.updateRecord(rid, ORecordInternal.isContentChanged(rec), stream, -2, ORecordInternal.getRecordType(rec), -1, null);
                        ORecordInternal.setVersion(rec, updateRes.getResult());
                        if (updateRes.getModifiedRecordContent() != null) {
                            ORecordInternal.fill(rec, rid, updateRes.getResult(), updateRes.getModifiedRecordContent(), false);
                            ** break;
                        }
                    }
lbl31:
                    // 3 sources

                    break;
                }
                case 1: {
                    stream = serializer.toStream(rec, false);
                    updateRes = this.doUpdateRecord(rid, ORecordInternal.isContentChanged(rec), stream, rec.getVersion(), ORecordInternal.getRecordType(rec), null, cluster);
                    ORecordInternal.setVersion(rec, updateRes.getResult());
                    if (updateRes.getModifiedRecordContent() != null) {
                        ORecordInternal.fill(rec, rid, updateRes.getResult(), updateRes.getModifiedRecordContent(), false);
                        ** break;
                    }
lbl40:
                    // 3 sources

                    break;
                }
                case 2: {
                    if (rec instanceof ODocument) {
                        ORidBagDeleter.deleteAllRidBags((ODocument)rec);
                    }
                    this.deleteRecord(rid, rec.getVersion(), -1, null);
                    ** break;
lbl47:
                    // 1 sources

                    break;
                }
                default: {
                    throw new OStorageException("Unknown record operation " + txEntry.type);
                }
            }
        }
        finally {
            ORecordSerializationContext.pullContext();
        }
        if (rec instanceof ODocument && ((ODocument)rec).isTrackingChanges()) {
            ODocumentInternal.clearTrackData((ODocument)rec);
        }
        ORecordInternal.unsetDirty(rec);
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId < 0 || iClusterId > this.clusters.size() - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in database '" + this.name + "'");
        }
    }

    private OLogSequenceNumber restoreFromWAL() throws IOException {
        if (this.writeAheadLog == null) {
            OLogManager.instance().error(this, "Restore is not possible because write ahead logging is switched off.", null, new Object[0]);
            return null;
        }
        if (this.writeAheadLog.begin() == null) {
            OLogManager.instance().error(this, "Restore is not possible because write ahead log is empty.", null, new Object[0]);
            return null;
        }
        OLogManager.instance().info((Object)this, "Looking for last checkpoint...", new Object[0]);
        OLogSequenceNumber end = this.writeAheadLog.end();
        if (end == null) {
            OLogManager.instance().errorNoDb(this, "WAL is empty, there is nothing not restore", null, new Object[0]);
            return null;
        }
        this.writeAheadLog.addCutTillLimit(end);
        try {
            OWALRecord checkPointRecord;
            OLogSequenceNumber lastCheckPoint;
            try {
                lastCheckPoint = this.writeAheadLog.getLastCheckpoint();
            }
            catch (OWALPageBrokenException ignore) {
                lastCheckPoint = null;
            }
            if (lastCheckPoint == null) {
                OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
                OLogSequenceNumber ignore = this.restoreFromBeginning();
                return ignore;
            }
            try {
                checkPointRecord = this.writeAheadLog.read(lastCheckPoint);
            }
            catch (OWALPageBrokenException ignore) {
                checkPointRecord = null;
            }
            if (checkPointRecord == null) {
                OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
                OLogSequenceNumber ignore = this.restoreFromBeginning();
                return ignore;
            }
            if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
                OLogManager.instance().info((Object)this, "Found FUZZY checkpoint.", new Object[0]);
                boolean fuzzyCheckPointIsComplete = this.checkFuzzyCheckPointIsComplete(lastCheckPoint);
                if (!fuzzyCheckPointIsComplete) {
                    OLogManager.instance().warn((Object)this, "FUZZY checkpoint is not complete.", new Object[0]);
                    OLogSequenceNumber previousCheckpoint = ((OFuzzyCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                    checkPointRecord = null;
                    if (previousCheckpoint != null) {
                        checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                    }
                    if (checkPointRecord != null) {
                        OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                        OLogSequenceNumber oLogSequenceNumber = this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                        return oLogSequenceNumber;
                    }
                    OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                    OLogSequenceNumber oLogSequenceNumber = this.restoreFromBeginning();
                    return oLogSequenceNumber;
                }
                OLogSequenceNumber previousCheckpoint = this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                return previousCheckpoint;
            }
            if (checkPointRecord instanceof OFullCheckpointStartRecord) {
                OLogManager.instance().info((Object)this, "FULL checkpoint found.", new Object[0]);
                boolean fullCheckPointIsComplete = this.checkFullCheckPointIsComplete(lastCheckPoint);
                if (!fullCheckPointIsComplete) {
                    OLogManager.instance().warn((Object)this, "FULL checkpoint has not completed.", new Object[0]);
                    OLogSequenceNumber previousCheckpoint = ((OFullCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                    checkPointRecord = null;
                    if (previousCheckpoint != null) {
                        checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                    }
                    if (checkPointRecord != null) {
                        OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                        OLogSequenceNumber oLogSequenceNumber = this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                        return oLogSequenceNumber;
                    }
                    OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                    OLogSequenceNumber oLogSequenceNumber = this.restoreFromBeginning();
                    return oLogSequenceNumber;
                }
                OLogSequenceNumber oLogSequenceNumber = this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                return oLogSequenceNumber;
            }
            throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
        }
        finally {
            this.writeAheadLog.removeCutTillLimit(end);
        }
    }

    private boolean checkFullCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                if (walRecord instanceof OCheckpointEndRecord) {
                    return true;
                }
                lsn = this.writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException ignore) {
            return false;
        }
        return false;
    }

    @Override
    public String incrementalBackup(String backupDirectory) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Incremental backup is supported only in enterprise version");
    }

    @Override
    public void restoreFromIncrementalBackup(String filePath) {
        throw new UnsupportedOperationException("Incremental backup is supported only in enterprise version");
    }

    private boolean checkFuzzyCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                if (walRecord instanceof OFuzzyCheckpointEndRecord) {
                    return true;
                }
                lsn = this.writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException ignore) {
            return false;
        }
        return false;
    }

    private OLogSequenceNumber restoreFromCheckPoint(OAbstractCheckPointStartRecord checkPointRecord) throws IOException {
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            return this.restoreFromFuzzyCheckPoint((OFuzzyCheckpointStartRecord)checkPointRecord);
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            return this.restoreFromFullCheckPoint((OFullCheckpointStartRecord)checkPointRecord);
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private OLogSequenceNumber restoreFromFullCheckPoint(OFullCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure from full checkpoint is started. Restore is performed from LSN %s", checkPointRecord.getLsn());
        OLogSequenceNumber lsn = this.writeAheadLog.next(checkPointRecord.getLsn());
        return this.restoreFrom(lsn, this.writeAheadLog);
    }

    private OLogSequenceNumber restoreFromFuzzyCheckPoint(OFuzzyCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().infoNoDb(this, "Data restore procedure from FUZZY checkpoint is started.", new Object[0]);
        OLogSequenceNumber flushedLsn = checkPointRecord.getFlushedLsn();
        if (flushedLsn.compareTo(this.writeAheadLog.begin()) < 0) {
            OLogManager.instance().errorNoDb(this, "Fuzzy checkpoint points to removed part of the log, will try to restore data from the rest of the WAL", null, new Object[0]);
            flushedLsn = this.writeAheadLog.begin();
        }
        return this.restoreFrom(flushedLsn, this.writeAheadLog);
    }

    private OLogSequenceNumber restoreFromBeginning() throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure is started.", new Object[0]);
        OLogSequenceNumber lsn = this.writeAheadLog.begin();
        return this.restoreFrom(lsn, this.writeAheadLog);
    }

    protected OLogSequenceNumber restoreFrom(OLogSequenceNumber lsn, OWriteAheadLog writeAheadLog) throws IOException {
        OLogSequenceNumber logSequenceNumber = null;
        OModifiableBoolean atLeastOnePageUpdate = new OModifiableBoolean();
        long recordsProcessed = 0L;
        int reportBatchSize = OGlobalConfiguration.WAL_REPORT_AFTER_OPERATIONS_DURING_RESTORE.getValueAsInteger();
        HashMap operationUnits = new HashMap();
        long lastReportTime = 0L;
        try {
            while (lsn != null) {
                logSequenceNumber = lsn;
                OWALRecord walRecord = writeAheadLog.read(lsn);
                if (walRecord instanceof OAtomicUnitEndRecord) {
                    OAtomicUnitEndRecord atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord;
                    List atomicUnit = (List)operationUnits.remove(atomicUnitEndRecord.getOperationUnitId());
                    if (atomicUnit != null) {
                        atomicUnit.add(walRecord);
                        this.restoreAtomicUnit(atomicUnit, atLeastOnePageUpdate);
                    }
                } else if (walRecord instanceof OAtomicUnitStartRecord) {
                    ArrayList<Object> operationList = new ArrayList<Object>();
                    assert (!operationUnits.containsKey(((OAtomicUnitStartRecord)walRecord).getOperationUnitId()));
                    operationUnits.put(((OAtomicUnitStartRecord)walRecord).getOperationUnitId(), operationList);
                    operationList.add(walRecord);
                } else if (walRecord instanceof OOperationUnitRecord) {
                    OOperationUnitRecord operationUnitRecord = (OOperationUnitRecord)walRecord;
                    ArrayList<OOperationUnitRecord> operationList = (ArrayList<OOperationUnitRecord>)operationUnits.get(operationUnitRecord.getOperationUnitId());
                    if (operationList == null || operationList.isEmpty()) {
                        OLogManager.instance().errorNoDb(this, "'Start transaction' record is absent for atomic operation", null, new Object[0]);
                        if (operationList == null) {
                            operationList = new ArrayList<OOperationUnitRecord>();
                            operationUnits.put(operationUnitRecord.getOperationUnitId(), operationList);
                        }
                    }
                    operationList.add(operationUnitRecord);
                } else if (walRecord instanceof ONonTxOperationPerformedWALRecord) {
                    if (!this.wereNonTxOperationsPerformedInPreviousOpen) {
                        OLogManager.instance().warnNoDb(this, "Non tx operation was used during data modification we will need index rebuild.", new Object[0]);
                        this.wereNonTxOperationsPerformedInPreviousOpen = true;
                    }
                } else {
                    OLogManager.instance().warnNoDb(this, "Record %s will be skipped during data restore", walRecord);
                }
                long currentTime = System.currentTimeMillis();
                if (reportBatchSize > 0 && ++recordsProcessed % (long)reportBatchSize == 0L || currentTime - lastReportTime > 30000L) {
                    OLogManager.instance().infoNoDb(this, "%d operations were processed, current LSN is %s last LSN is %s", recordsProcessed, lsn, writeAheadLog.end());
                    lastReportTime = currentTime;
                }
                lsn = writeAheadLog.next(lsn);
            }
            OLogManager.instance().infoNoDb(this, "There are %d unfinished atomic operations left, they will be rolled back", operationUnits.size());
            if (!operationUnits.isEmpty()) {
                for (List atomicOperation : operationUnits.values()) {
                    this.revertAtomicUnit(atomicOperation, atLeastOnePageUpdate);
                }
            }
        }
        catch (OWALPageBrokenException e) {
            OLogManager.instance().errorNoDb(this, "Data restore was paused because broken WAL page was found. The rest of changes will be rolled back.", e, new Object[0]);
        }
        catch (RuntimeException e) {
            OLogManager.instance().errorNoDb(this, "Data restore was paused because of exception. The rest of changes will be rolled back and WAL files will be backed up. Please report issue about this exception to bug tracker and provide WAL files which are backed up in 'wal_backup' directory.", e, new Object[0]);
            this.backUpWAL(e);
        }
        if (atLeastOnePageUpdate.getValue()) {
            return logSequenceNumber;
        }
        return null;
    }

    private void backUpWAL(Exception e) {
        try {
            boolean created;
            File rootDir = new File(this.getConfiguration().getDirectory());
            File backUpDir = new File(rootDir, "wal_backup");
            if (!backUpDir.exists() && !(created = backUpDir.mkdir())) {
                OLogManager.instance().error(this, "Cannot create directory for backup files " + backUpDir.getAbsolutePath(), null, new Object[0]);
                return;
            }
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd_MM_yy_HH_mm_ss");
            String strDate = dateFormat.format(date);
            String archiveName = "wal_backup_" + strDate + ".zip";
            String metadataName = "wal_metadata_" + strDate + ".txt";
            File archiveFile = new File(backUpDir, archiveName);
            if (!archiveFile.createNewFile()) {
                OLogManager.instance().error(this, "Cannot create backup file " + archiveFile.getAbsolutePath(), null, new Object[0]);
                return;
            }
            try (FileOutputStream archiveOutputStream = new FileOutputStream(archiveFile);
                 ZipOutputStream archiveZipOutputStream = new ZipOutputStream(new BufferedOutputStream(archiveOutputStream));){
                ZipEntry metadataEntry = new ZipEntry(metadataName);
                archiveZipOutputStream.putNextEntry(metadataEntry);
                PrintWriter metadataFileWriter = new PrintWriter(new OutputStreamWriter((OutputStream)archiveZipOutputStream, "UTF-8"));
                metadataFileWriter.append("Storage name : ").append(this.getName()).append("\r\n");
                metadataFileWriter.append("Date : ").append(strDate).append("\r\n");
                metadataFileWriter.append("Stacktrace : \r\n");
                e.printStackTrace(metadataFileWriter);
                metadataFileWriter.flush();
                archiveZipOutputStream.closeEntry();
                List<String> walPaths = ((ODiskWriteAheadLog)this.writeAheadLog).getWalFiles();
                for (String walSegment : walPaths) {
                    OAbstractPaginatedStorage.archiveEntry(archiveZipOutputStream, walSegment);
                }
                OAbstractPaginatedStorage.archiveEntry(archiveZipOutputStream, ((ODiskWriteAheadLog)this.writeAheadLog).getWMRFile().toString());
            }
        }
        catch (IOException ioe) {
            OLogManager.instance().error(this, "Error during WAL backup", ioe, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void archiveEntry(ZipOutputStream archiveZipOutputStream, String walSegment) throws IOException {
        File walFile = new File(walSegment);
        ZipEntry walZipEntry = new ZipEntry(walFile.getName());
        archiveZipOutputStream.putNextEntry(walZipEntry);
        try (FileInputStream walInputStream = new FileInputStream(walFile);
             BufferedInputStream walBufferedInputStream = new BufferedInputStream(walInputStream);){
            int readBytes;
            byte[] buffer = new byte[1024];
            while ((readBytes = walBufferedInputStream.read(buffer)) > -1) {
                archiveZipOutputStream.write(buffer, 0, readBytes);
            }
        }
        finally {
            archiveZipOutputStream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertAtomicUnit(List<OWALRecord> atomicUnit, OModifiableBoolean atLeastOnePageUpdate) throws IOException {
        ListIterator<OWALRecord> recordsIterator = atomicUnit.listIterator(atomicUnit.size());
        while (recordsIterator.hasPrevious()) {
            OWALRecord record = recordsIterator.previous();
            if (record instanceof OFileDeletedWALRecord) {
                OLogManager.instance().infoNoDb(this, "Deletion of file can not be rolled back", new Object[0]);
                continue;
            }
            if (record instanceof OFileCreatedWALRecord) {
                OFileCreatedWALRecord fileCreatedWALRecord = (OFileCreatedWALRecord)record;
                OLogManager.instance().infoNoDb(this, "File %s is going to be deleted", fileCreatedWALRecord.getFileName());
                if (this.writeCache.exists(fileCreatedWALRecord.getFileId())) {
                    this.readCache.deleteFile(fileCreatedWALRecord.getFileId(), this.writeCache);
                    OLogManager.instance().infoNoDb(this, "File %s was deleted", fileCreatedWALRecord.getFileName());
                    continue;
                }
                OLogManager.instance().infoNoDb(this, "File %d is absent and can not be deleted", fileCreatedWALRecord.getFileName());
                continue;
            }
            if (record instanceof OUpdatePageRecord) {
                OUpdatePageRecord updatePageRecord = (OUpdatePageRecord)record;
                long fileId = updatePageRecord.getFileId();
                if (!this.writeCache.exists(fileId)) {
                    String fileName = this.writeCache.restoreFileById(fileId);
                    throw new OStorageException("File with id " + fileId + " and name " + fileName + " was deleted from storage, the rest of operations can not be restored");
                }
                long pageIndex = updatePageRecord.getPageIndex();
                OCacheEntry cacheEntry = this.readCache.loadForWrite(fileId = this.writeCache.externalFileId(this.writeCache.internalFileId(fileId)), pageIndex, true, this.writeCache, 1, false);
                if (cacheEntry == null) continue;
                try {
                    ODurablePage durablePage = new ODurablePage(cacheEntry);
                    durablePage.rollbackChanges(updatePageRecord.getChanges());
                    durablePage.setLsn(updatePageRecord.getPrevLsn());
                }
                finally {
                    this.readCache.releaseFromWrite(cacheEntry, this.writeCache);
                }
                atLeastOnePageUpdate.setValue(true);
                continue;
            }
            if (record instanceof OAtomicUnitStartRecord || record instanceof OAtomicUnitEndRecord) continue;
            OLogManager.instance().errorNoDb(this, "Invalid WAL record type was passed %s. Given record will be skipped.", null, record.getClass());
            assert (false) : "Invalid WAL record type was passed " + record.getClass().getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreAtomicUnit(List<OWALRecord> atomicUnit, OModifiableBoolean atLeastOnePageUpdate) throws IOException {
        assert (atomicUnit.get(atomicUnit.size() - 1) instanceof OAtomicUnitEndRecord);
        for (OWALRecord walRecord : atomicUnit) {
            if (walRecord instanceof OFileDeletedWALRecord) {
                OFileDeletedWALRecord fileDeletedWALRecord = (OFileDeletedWALRecord)walRecord;
                if (!this.writeCache.exists(fileDeletedWALRecord.getFileId())) continue;
                this.readCache.deleteFile(fileDeletedWALRecord.getFileId(), this.writeCache);
                continue;
            }
            if (walRecord instanceof OFileCreatedWALRecord) {
                OFileCreatedWALRecord fileCreatedCreatedWALRecord = (OFileCreatedWALRecord)walRecord;
                if (this.writeCache.exists(fileCreatedCreatedWALRecord.getFileName())) continue;
                this.readCache.addFile(fileCreatedCreatedWALRecord.getFileName(), fileCreatedCreatedWALRecord.getFileId(), this.writeCache);
                continue;
            }
            if (walRecord instanceof OUpdatePageRecord) {
                OUpdatePageRecord updatePageRecord = (OUpdatePageRecord)walRecord;
                long fileId = updatePageRecord.getFileId();
                if (!this.writeCache.exists(fileId)) {
                    String fileName = this.writeCache.restoreFileById(fileId);
                    if (fileName == null) {
                        throw new OStorageException("File with id " + fileId + " was deleted from storage, the rest of operations can not be restored");
                    }
                    OLogManager.instance().warn((Object)this, "Previously deleted file with name " + fileName + " was deleted but new empty file was added to continue restore process", new Object[0]);
                }
                long pageIndex = updatePageRecord.getPageIndex();
                OCacheEntry cacheEntry = this.readCache.loadForWrite(fileId = this.writeCache.externalFileId(this.writeCache.internalFileId(fileId)), pageIndex, true, this.writeCache, 1, false);
                if (cacheEntry == null) {
                    do {
                        if (cacheEntry == null) continue;
                        this.readCache.releaseFromWrite(cacheEntry, this.writeCache);
                    } while ((cacheEntry = this.readCache.allocateNewPage(fileId, this.writeCache, false)).getPageIndex() != pageIndex);
                }
                try {
                    ODurablePage durablePage = new ODurablePage(cacheEntry);
                    durablePage.restoreChanges(updatePageRecord.getChanges());
                    durablePage.setLsn(updatePageRecord.getLsn());
                }
                finally {
                    this.readCache.releaseFromWrite(cacheEntry, this.writeCache);
                }
                atLeastOnePageUpdate.setValue(true);
                continue;
            }
            if (walRecord instanceof OAtomicUnitStartRecord || walRecord instanceof OAtomicUnitEndRecord) continue;
            OLogManager.instance().error(this, "Invalid WAL record type was passed %s. Given record will be skipped.", null, walRecord.getClass());
            assert (false) : "Invalid WAL record type was passed " + walRecord.getClass().getName();
        }
    }

    private void checkLowDiskSpaceRequestsAndReadOnlyConditions() {
        if (this.transaction.get() != null) {
            return;
        }
        if (this.lowDiskSpace != null && this.checkpointInProgress.compareAndSet(false, true)) {
            try {
                if (this.writeCache.checkLowDiskSpace()) {
                    OLogManager.instance().error(this, "Not enough disk space, force sync will be called", null, new Object[0]);
                    this.synch();
                    if (this.writeCache.checkLowDiskSpace()) {
                        throw new OLowDiskSpaceException("Error occurred while executing a write operation to database '" + this.name + "' due to limited free space on the disk (" + this.lowDiskSpace.freeSpace / 0x100000L + " MB). The database is now working in read-only mode. Please close the database (or stop OrientDB), make room on your hard drive and then reopen the database. The minimal required space is " + this.lowDiskSpace.requiredSpace / 0x100000L + " MB. Required space is now set to " + this.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT) + "MB (you can change it by setting parameter " + OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getKey() + ") .");
                    }
                    this.lowDiskSpace = null;
                } else {
                    this.lowDiskSpace = null;
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error during low disk space handling"), e);
            }
            finally {
                this.checkpointInProgress.set(false);
            }
        }
        this.checkReadOnlyConditions();
    }

    public void checkReadOnlyConditions() {
        if (this.dataFlushException != null) {
            throw OException.wrapException(new OStorageException("Error in data flush background thread, please restart database and send full stack trace inside of bug report"), this.dataFlushException);
        }
        if (!this.brokenPages.isEmpty()) {
            HashMap<String, SortedSet> pagesByFile = new HashMap<String, SortedSet>();
            for (OPair<String, Long> brokenPage : this.brokenPages) {
                SortedSet sortedPages = pagesByFile.computeIfAbsent((String)brokenPage.key, fileName -> new TreeSet());
                sortedPages.add(brokenPage.value);
            }
            StringBuilder brokenPagesList = new StringBuilder();
            brokenPagesList.append("[");
            for (String fileName2 : pagesByFile.keySet()) {
                brokenPagesList.append('\'').append(fileName2).append("' :");
                SortedSet pageIndexes = (SortedSet)pagesByFile.get(fileName2);
                long lastPage = (Long)pageIndexes.last();
                for (Long pageIndex : (SortedSet)pagesByFile.get(fileName2)) {
                    brokenPagesList.append(pageIndex);
                    if (pageIndex == lastPage) continue;
                    brokenPagesList.append(", ");
                }
                brokenPagesList.append(";");
            }
            brokenPagesList.append("]");
            throw new OPageIsBrokenException("Following files and pages are detected to be broken " + brokenPagesList + ", storage is switched to 'read only' mode. Any modification operations are prohibited. To restore database and make it fully operational you may export and import database to and from JSON.");
        }
        if (this.jvmError.get() != null) {
            throw new OJVMErrorException("JVM error '" + this.jvmError.get().getClass().getSimpleName() + " : " + this.jvmError.get().getMessage() + "' occurred during data processing, storage is switched to 'read-only' mode. To prevent this exception please restart the JVM and check data consistency by calling of 'check database' command from database console.");
        }
    }

    public void setStorageConfigurationUpdateListener(OStorageConfigurationUpdateListener storageConfigurationUpdateListener) {
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            ((OStorageConfigurationImpl)this.configuration).setConfigurationUpdateListener(storageConfigurationUpdateListener);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    protected static Map<Integer, List<ORecordId>> getRidsGroupedByCluster(Collection<ORecordId> iRids) {
        HashMap<Integer, List<ORecordId>> ridsPerCluster = new HashMap<Integer, List<ORecordId>>();
        for (ORecordId rid : iRids) {
            List rids = ridsPerCluster.computeIfAbsent(rid.getClusterId(), k -> new ArrayList(iRids.size()));
            rids.add(rid);
        }
        return ridsPerCluster;
    }

    private static void lockIndexes(TreeMap<String, OTransactionIndexChanges> indexes) {
        for (OTransactionIndexChanges changes : indexes.values()) {
            assert (changes.changesPerKey instanceof TreeMap);
            OIndexInternal<?> index = changes.getAssociatedIndex();
            ArrayList orderedIndexNames = new ArrayList(changes.changesPerKey.keySet());
            if (orderedIndexNames.size() > 1) {
                orderedIndexNames.sort((o1, o2) -> {
                    String i1 = index.getIndexNameByKey(o1);
                    String i2 = index.getIndexNameByKey(o2);
                    return i1.compareTo(i2);
                });
            }
            boolean fullyLocked = false;
            for (Object key : orderedIndexNames) {
                if (!index.acquireAtomicExclusiveLock(key)) continue;
                fullyLocked = true;
                break;
            }
            if (fullyLocked || changes.nullKeyChanges.entries.isEmpty()) continue;
            index.acquireAtomicExclusiveLock(null);
        }
    }

    private static void lockClusters(TreeMap<Integer, OCluster> clustersToLock) {
        for (OCluster cluster : clustersToLock.values()) {
            cluster.acquireAtomicExclusiveLock();
        }
    }

    private void lockRidBags(TreeMap<Integer, OCluster> clusters, TreeMap<String, OTransactionIndexChanges> indexes, OIndexManager manager) {
        OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
        for (Integer n : clusters.keySet()) {
            this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(atomicOperation, OSBTreeCollectionManagerAbstract.generateLockName(n));
        }
        for (Map.Entry entry : indexes.entrySet()) {
            String indexName = (String)entry.getKey();
            OIndexInternal<?> index = ((OTransactionIndexChanges)entry.getValue()).resolveAssociatedIndex(indexName, manager);
            if (index.isUnique()) continue;
            this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(atomicOperation, OIndexRIDContainerSBTree.generateLockName(indexName));
        }
    }

    private void registerProfilerHooks() {
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".createRecord", "Number of created records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordCreated), "db.*.createRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".readRecord", "Number of read records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordRead), "db.*.readRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".updateRecord", "Number of updated records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordUpdated), "db.*.updateRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".deleteRecord", "Number of deleted records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordDeleted), "db.*.deleteRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".scanRecord", "Number of read scanned", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordScanned), "db.*.scanRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".recyclePosition", "Number of recycled records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordRecycled), "db.*.recyclePosition");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".conflictRecord", "Number of conflicts during updating and deleting records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordConflict), "db.*.conflictRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".txBegun", "Number of transactions begun", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.txBegun), "db.*.txBegun");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".txCommit", "Number of committed transactions", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.txCommit), "db.*.txCommit");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".txRollback", "Number of rolled back transactions", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.txRollback), "db.*.txRollback");
    }

    protected RuntimeException logAndPrepareForRethrow(RuntimeException runtimeException) {
        if (!(runtimeException instanceof OHighLevelException) && !(runtimeException instanceof ONeedRetryException)) {
            OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s`: %s", runtimeException, System.identityHashCode(runtimeException), this.getURL(), OConstants.getVersion());
        }
        return runtimeException;
    }

    protected Error logAndPrepareForRethrow(Error error) {
        return this.logAndPrepareForRethrow(error, true);
    }

    private Error logAndPrepareForRethrow(Error error, boolean putInReadOnlyMode) {
        if (!(error instanceof OHighLevelException)) {
            OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s`: %s", error, System.identityHashCode(error), this.getURL(), OConstants.getVersion());
        }
        if (putInReadOnlyMode) {
            this.handleJVMError(error);
        }
        return error;
    }

    protected RuntimeException logAndPrepareForRethrow(Throwable throwable) {
        if (!(throwable instanceof OHighLevelException) && !(throwable instanceof ONeedRetryException)) {
            OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s`: %s", throwable, System.identityHashCode(throwable), this.getURL(), OConstants.getVersion());
        }
        return new RuntimeException(throwable);
    }

    private OInvalidIndexEngineIdException logAndPrepareForRethrow(OInvalidIndexEngineIdException exception) {
        OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s` : %s", exception, System.identityHashCode(exception), this.getURL(), OConstants.getVersion());
        return exception;
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setSchemaRecordId(String schemaRecordId) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setSchemaRecordId(schemaRecordId);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setDateFormat(String dateFormat) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setDateFormat(dateFormat);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setTimeZone(TimeZone timeZoneValue) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setTimeZone(timeZoneValue);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setLocaleLanguage(String locale) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setLocaleLanguage(locale);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setCharset(String charset) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setCharset(charset);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setIndexMgrRecordId(String indexMgrRecordId) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setIndexMgrRecordId(indexMgrRecordId);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setDateTimeFormat(String dateTimeFormat) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setDateTimeFormat(dateTimeFormat);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setLocaleCountry(String localeCountry) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setLocaleCountry(localeCountry);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setClusterSelection(String clusterSelection) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setClusterSelection(clusterSelection);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setMinimumClusters(int minimumClusters) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setMinimumClusters(minimumClusters);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setValidation(boolean validation) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setValidation(validation);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void removeProperty(String property) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.removeProperty(property);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setProperty(String property, String value) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setProperty(property, value);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setRecordSerializer(String recordSerializer, int version) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setRecordSerializer(recordSerializer);
            storageConfiguration.setRecordSerializerVersion(version);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void clearProperties() {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.clearProperties();
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    static {
        Integer journaledPort = (Integer)OGlobalConfiguration.STORAGE_INTERNAL_JOURNALED_TX_STREAMING_PORT.getValue();
        if (journaledPort != null) {
            ServerSocket serverSocket;
            try {
                serverSocket = new ServerSocket(journaledPort, 0, InetAddress.getLocalHost());
                serverSocket.setReuseAddress(true);
            }
            catch (IOException e) {
                serverSocket = null;
                OLogManager.instance().error(OAbstractPaginatedStorage.class, "unable to create journaled tx server socket", e, new Object[0]);
            }
            if (serverSocket != null) {
                ServerSocket finalServerSocket = serverSocket;
                Thread serverThread = new Thread(() -> {
                    OLogManager.instance().info(OAbstractPaginatedStorage.class, "journaled tx streaming server is listening on localhost:" + journaledPort, new Object[0]);
                    try {
                        Socket clientSocket = finalServerSocket.accept();
                        clientSocket.setSendBufferSize(0x400000);
                        journaledStream = new DataOutputStream(clientSocket.getOutputStream());
                    }
                    catch (IOException e) {
                        journaledStream = null;
                        OLogManager.instance().error(OAbstractPaginatedStorage.class, "unable to accept journaled tx client connection", e, new Object[0]);
                    }
                });
                serverThread.setDaemon(true);
                serverThread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
                serverThread.start();
            }
        }
        fuzzyCheckpointExecutor = new OScheduledThreadPoolExecutorWithLogging(1, new FuzzyCheckpointThreadFactory());
        fuzzyCheckpointExecutor.setMaximumPoolSize(1);
    }

    private final class WALVacuum
    implements Runnable {
        WALVacuum() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OAbstractPaginatedStorage.this.stateLock.acquireReadLock();
            try {
                OLogSequenceNumber endLSN;
                OLogSequenceNumber minDirtyLSN;
                long minDirtySegment;
                if (OAbstractPaginatedStorage.this.status == OStorage.STATUS.CLOSED) {
                    return;
                }
                long[] nonActiveSegments = OAbstractPaginatedStorage.this.writeAheadLog.nonActiveSegments();
                if (nonActiveSegments.length == 0) {
                    return;
                }
                long flushTillSegmentId = nonActiveSegments.length == 1 ? OAbstractPaginatedStorage.this.writeAheadLog.activeSegment() : (nonActiveSegments[0] + nonActiveSegments[nonActiveSegments.length - 1]) / 2L;
                do {
                    OAbstractPaginatedStorage.this.writeCache.flushTillSegment(flushTillSegmentId);
                    endLSN = OAbstractPaginatedStorage.this.writeAheadLog.end();
                } while ((minDirtySegment = (minDirtyLSN = OAbstractPaginatedStorage.this.writeCache.getMinimalNotFlushedLSN()) == null ? endLSN.getSegment() : minDirtyLSN.getSegment()) < flushTillSegmentId);
                OAbstractPaginatedStorage.this.writeCache.makeFuzzyCheckpoint(minDirtySegment);
            }
            catch (Exception e) {
                OAbstractPaginatedStorage.this.dataFlushException = e;
                OLogManager.instance().error(this, "Error during flushing of data for fuzzy checkpoint", e, new Object[0]);
            }
            finally {
                OAbstractPaginatedStorage.this.stateLock.releaseReadLock();
                OAbstractPaginatedStorage.this.walVacuumInProgress.set(false);
            }
        }
    }

    private static class FuzzyCheckpointThreadFactory
    implements ThreadFactory {
        private FuzzyCheckpointThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        }
    }

    private static class ORIDOLockManager
    extends OComparableLockManager<ORID> {
        ORIDOLockManager() {
            super(true, -1);
        }

        @Override
        protected ORID getImmutableResourceId(ORID iResourceId) {
            return new ORecordId(iResourceId);
        }
    }
}

