/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.util.concurrent.atomic.AtomicInteger;

public class OCacheEntryImpl
implements OCacheEntry {
    private OCachePointer dataPointer;
    private final long fileId;
    private final long pageIndex;
    private boolean dirty;
    private final AtomicInteger usagesCount = new AtomicInteger();

    public OCacheEntryImpl(long fileId, long pageIndex, OCachePointer dataPointer, boolean dirty) {
        this.fileId = fileId;
        this.pageIndex = pageIndex;
        this.dataPointer = dataPointer;
        this.dirty = dirty;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void clearDirty() {
        this.dirty = false;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public OCachePointer getCachePointer() {
        return this.dataPointer;
    }

    @Override
    public void clearCachePointer() {
        this.dataPointer = null;
    }

    @Override
    public void setCachePointer(OCachePointer cachePointer) {
        this.dataPointer = cachePointer;
    }

    @Override
    public long getFileId() {
        return this.fileId;
    }

    @Override
    public long getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void acquireExclusiveLock() {
        this.dataPointer.acquireExclusiveLock();
    }

    @Override
    public void releaseExclusiveLock() {
        this.dataPointer.releaseExclusiveLock();
    }

    @Override
    public void acquireSharedLock() {
        this.dataPointer.acquireSharedLock();
    }

    @Override
    public void releaseSharedLock() {
        this.dataPointer.releaseSharedLock();
    }

    @Override
    public int getUsagesCount() {
        return this.usagesCount.get();
    }

    @Override
    public void incrementUsages() {
        this.usagesCount.incrementAndGet();
    }

    @Override
    public boolean isLockAcquiredByCurrentThread() {
        return this.dataPointer.isLockAcquiredByCurrentThread();
    }

    @Override
    public void decrementUsages() {
        this.usagesCount.decrementAndGet();
    }

    @Override
    public OWALChanges getChanges() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCacheEntryImpl that = (OCacheEntryImpl)o;
        if (this.fileId != that.fileId) {
            return false;
        }
        if (this.dirty != that.dirty) {
            return false;
        }
        if (this.pageIndex != that.pageIndex) {
            return false;
        }
        if (this.usagesCount.get() != that.usagesCount.get()) {
            return false;
        }
        return !(this.dataPointer != null ? !this.dataPointer.equals(that.dataPointer) : that.dataPointer != null);
    }

    public int hashCode() {
        int result = (int)(this.fileId ^ this.fileId >>> 32);
        result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        result = 31 * result + (this.dataPointer != null ? this.dataPointer.hashCode() : 0);
        result = 31 * result + (this.dirty ? 1 : 0);
        result = 31 * result + this.usagesCount.get();
        return result;
    }

    public String toString() {
        return "OReadCacheEntry{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + ", dataPointer=" + this.dataPointer + ", dirty=" + this.dirty + ", usagesCount=" + this.usagesCount + '}';
    }
}

