/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import com.orientechnologies.orient.core.sql.query.OLegacyResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OProjection
extends SimpleNode {
    protected boolean distinct = false;
    List<OProjectionItem> items;

    public OProjection(List<OProjectionItem> items, boolean distinct) {
        super(-1);
        this.items = items;
        this.distinct = distinct;
    }

    public OProjection(int id) {
        super(id);
    }

    public OProjection(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public List<OProjectionItem> getItems() {
        return this.items;
    }

    public void setItems(List<OProjectionItem> items) {
        this.items = items;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.items == null) {
            return;
        }
        boolean first = true;
        if (this.distinct) {
            builder.append("DISTINCT ");
        }
        for (OProjectionItem item : this.items) {
            if (!item.isAll()) continue;
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
        for (OProjectionItem item : this.items) {
            if (item.isAll()) continue;
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
    }

    public OResult calculateSingle(OCommandContext iContext, OResult iRecord) {
        if (this.isExpand()) {
            throw new IllegalStateException("This is an expand projection, it cannot be calculated as a single result" + this.toString());
        }
        if (this.items.size() == 0 || this.items.size() == 1 && this.items.get(0).isAll() && this.items.get((int)0).nestedProjection == null) {
            return iRecord;
        }
        OResultInternal result = new OResultInternal();
        for (OProjectionItem item : this.items) {
            if (item.isAll()) {
                for (String alias : iRecord.getPropertyNames()) {
                    result.setProperty(alias, iRecord.getProperty(alias));
                }
                if (iRecord.getElement().isPresent()) {
                    OElement x = iRecord.getElement().get();
                    result.setProperty("@rid", x.getIdentity());
                    result.setProperty("@version", x.getVersion());
                    result.setProperty("@class", x.getSchemaType().map(clazz -> clazz.getName()).orElse(null));
                }
                if (item.nestedProjection == null) continue;
                result = (OResultInternal)item.nestedProjection.apply(item.expression, result, iContext);
                continue;
            }
            result.setProperty(item.getProjectionAliasAsString(), item.execute(iRecord, iContext));
        }
        for (String key : iRecord.getMetadataKeys()) {
            if (result.getMetadataKeys().contains(key)) continue;
            result.setMetadata(key, iRecord.getMetadata(key));
        }
        return result;
    }

    public OLegacyResultSet calculateExpand(OCommandContext iContext, OResult iRecord) {
        if (!this.isExpand()) {
            throw new IllegalStateException("This is not an expand projection:" + this.toString());
        }
        throw new UnsupportedOperationException("Implement expand in projection");
    }

    public boolean isExpand() {
        return this.items != null && this.items.size() == 1 && this.items.get(0).isExpand();
    }

    public void validate() {
        if (this.items != null && this.items.size() > 1) {
            for (OProjectionItem item : this.items) {
                if (!item.isExpand()) continue;
                throw new OCommandSQLParsingException("Cannot execute a query with expand() together with other projections");
            }
        }
    }

    public OProjection getExpandContent() {
        OProjection result = new OProjection(-1);
        result.setItems(new ArrayList<OProjectionItem>());
        result.getItems().add(this.getItems().get(0).getExpandContent());
        return result;
    }

    public Set<String> getAllAliases() {
        return this.items.stream().map(i -> i.getProjectionAliasAsString()).collect(Collectors.toSet());
    }

    @Override
    public OProjection copy() {
        OProjection result = new OProjection(-1);
        if (this.items != null) {
            result.items = this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        }
        result.distinct = this.distinct;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OProjection that = (OProjection)o;
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.items != null) {
            for (OProjectionItem item : this.items) {
                item.extractSubQueries(collector);
            }
        }
    }

    public boolean refersToParent() {
        for (OProjectionItem item : this.items) {
            if (!item.refersToParent()) continue;
            return true;
        }
        return false;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("distinct", this.distinct);
        if (this.items != null) {
            result.setProperty("items", this.items.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.distinct = (Boolean)fromResult.getProperty("distinct");
        if (fromResult.getProperty("items") != null) {
            this.items = new ArrayList<OProjectionItem>();
            List ser = (List)fromResult.getProperty("items");
            for (OResult x : ser) {
                OProjectionItem item = new OProjectionItem(-1);
                item.deserialize(x);
                this.items.add(item);
            }
        }
    }

    public boolean isCacheable() {
        if (this.items != null) {
            for (OProjectionItem item : this.items) {
                if (item.isCacheable()) continue;
                return false;
            }
        }
        return true;
    }
}

