/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OCommandLineOption;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OOptimizeDatabaseStatement
extends OSimpleExecStatement {
    protected List<OCommandLineOption> options = new ArrayList<OCommandLineOption>();
    private int batch = 1000;

    public OOptimizeDatabaseStatement(int id) {
        super(id);
    }

    public OOptimizeDatabaseStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "optimize databae");
        if (this.isOptimizeEdges()) {
            String edges = this.optimizeEdges();
            result.setProperty("optimizeEdges", edges);
        }
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("OPTIMIZE DATABASE");
        for (OCommandLineOption option : this.options) {
            builder.append(" ");
            option.toString(params, builder);
        }
    }

    @Override
    public OOptimizeDatabaseStatement copy() {
        OOptimizeDatabaseStatement result = new OOptimizeDatabaseStatement(-1);
        result.options = this.options == null ? null : this.options.stream().map(OCommandLineOption::copy).collect(Collectors.toList());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String optimizeEdges() {
        ODatabaseDocumentInternal db = OOptimizeDatabaseStatement.getDatabase();
        db.declareIntent(new OIntentMassiveInsert());
        try {
            long transformed = 0L;
            if (db.getTransaction().isActive()) {
                db.commit();
            }
            db.begin();
            try {
                long totalEdges = db.countClass("E");
                long browsedEdges = 0L;
                long lastLapBrowsed = 0L;
                long lastLapTime = System.currentTimeMillis();
                for (ODocument doc : db.browseClass("E")) {
                    if (Thread.currentThread().isInterrupted()) break;
                    ++browsedEdges;
                    if (doc == null || doc.fields() != 2) continue;
                    ORID edgeIdentity = doc.getIdentity();
                    ODocument outV = (ODocument)doc.field("out");
                    ODocument inV = (ODocument)doc.field("in");
                    Object outField = outV.field("out_" + doc.getClassName());
                    if (outField instanceof ORidBag) {
                        Iterator<OIdentifiable> it = ((ORidBag)outField).iterator();
                        while (it.hasNext()) {
                            OIdentifiable v = it.next();
                            if (!edgeIdentity.equals(v)) continue;
                            it.remove();
                            ((ORidBag)outField).add(inV.getIdentity());
                            break;
                        }
                    }
                    outV.save();
                    Object inField = inV.field("in_" + doc.getClassName());
                    if (outField instanceof ORidBag) {
                        Iterator<OIdentifiable> it = ((ORidBag)inField).iterator();
                        while (it.hasNext()) {
                            OIdentifiable v = it.next();
                            if (!edgeIdentity.equals(v)) continue;
                            it.remove();
                            ((ORidBag)inField).add(outV.getIdentity());
                            break;
                        }
                    }
                    inV.save();
                    doc.delete();
                    if (++transformed % (long)this.batch == 0L) {
                        db.commit();
                        db.begin();
                    }
                    long now = System.currentTimeMillis();
                    if (!this.verbose() || now - lastLapTime <= 2000L) continue;
                    long elapsed = now - lastLapTime;
                    OLogManager.instance().info((Object)this, "Browsed %,d of %,d edges, transformed %,d so far (%,d edges/sec)", browsedEdges, totalEdges, transformed, (browsedEdges - lastLapBrowsed) * 1000L / elapsed);
                    lastLapTime = System.currentTimeMillis();
                    lastLapBrowsed = browsedEdges;
                }
                db.commit();
            }
            finally {
                if (db.getTransaction().isActive()) {
                    db.rollback();
                }
            }
            String string = "Transformed " + transformed + " regular edges in lightweight edges";
            return string;
        }
        finally {
            db.declareIntent(null);
        }
    }

    private boolean isOptimizeEdges() {
        for (OCommandLineOption option : this.options) {
            if (!option.name.getStringValue().equalsIgnoreCase("LWEDGES")) continue;
            return true;
        }
        return false;
    }

    private boolean verbose() {
        for (OCommandLineOption option : this.options) {
            if (!option.name.getStringValue().equalsIgnoreCase("NOVERBOSE")) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OOptimizeDatabaseStatement that = (OOptimizeDatabaseStatement)o;
        return !(this.options != null ? !this.options.equals(that.options) : that.options != null);
    }

    public int hashCode() {
        return this.options != null ? this.options.hashCode() : 0;
    }
}

