/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.db.document.OQueryLifecycleListener;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class OLocalResultSetLifecycleDecorator
implements OResultSet {
    private static final AtomicLong counter = new AtomicLong(0L);
    private OResultSet entity;
    private List<OQueryLifecycleListener> lifecycleListeners = new ArrayList<OQueryLifecycleListener>();
    private String queryId;
    private boolean hasNextPage;

    public OLocalResultSetLifecycleDecorator(OResultSet entity) {
        this.entity = entity;
        this.queryId = "" + System.currentTimeMillis() + "_" + counter.incrementAndGet();
    }

    public OLocalResultSetLifecycleDecorator(OInternalResultSet rsCopy, String queryId) {
        this.entity = rsCopy;
        this.queryId = queryId;
    }

    public void addLifecycleListener(OQueryLifecycleListener db) {
        this.lifecycleListeners.add(db);
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.entity.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    @Override
    public OResult next() {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        OResult result = this.entity.next();
        return result;
    }

    @Override
    public void close() {
        this.entity.close();
        this.lifecycleListeners.forEach(x -> x.queryClosed(this.getQueryId()));
        this.lifecycleListeners.clear();
    }

    @Override
    public Optional<OExecutionPlan> getExecutionPlan() {
        return this.entity.getExecutionPlan();
    }

    @Override
    public Map<String, Long> getQueryStats() {
        return this.entity.getQueryStats();
    }

    public String getQueryId() {
        return this.queryId;
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean b) {
        this.hasNextPage = b;
    }

    public boolean isDetached() {
        return this.entity instanceof OInternalResultSet;
    }
}

