/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OCollection;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFunctionCall;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Map;
import java.util.Set;

public class OLevelZeroIdentifier
extends SimpleNode {
    protected OFunctionCall functionCall;
    protected Boolean self;
    protected OCollection collection;

    public OLevelZeroIdentifier(int id) {
        super(id);
    }

    public OLevelZeroIdentifier(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.functionCall != null) {
            this.functionCall.toString(params, builder);
        } else if (Boolean.TRUE.equals(this.self)) {
            builder.append("@this");
        } else if (this.collection != null) {
            this.collection.toString(params, builder);
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.functionCall != null) {
            return this.functionCall.execute(iCurrentRecord, ctx);
        }
        if (this.collection != null) {
            return this.collection.execute(iCurrentRecord, ctx);
        }
        if (Boolean.TRUE.equals(this.self)) {
            return iCurrentRecord;
        }
        throw new UnsupportedOperationException();
    }

    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        if (this.functionCall != null) {
            return this.functionCall.execute(iCurrentRecord, ctx);
        }
        if (this.collection != null) {
            return this.collection.execute(iCurrentRecord, ctx);
        }
        if (Boolean.TRUE.equals(this.self)) {
            return iCurrentRecord;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isIndexedFunctionCall() {
        if (this.functionCall != null) {
            return this.functionCall.isIndexedFunctionCall();
        }
        return false;
    }

    public boolean isFunctionAny() {
        if (this.functionCall != null) {
            return this.functionCall.getName().getStringValue().equalsIgnoreCase("any") && this.functionCall.params.size() == 0;
        }
        return false;
    }

    public long estimateIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.functionCall != null) {
            return this.functionCall.estimateIndexedFunction(target, context, operator, right);
        }
        return -1L;
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.functionCall != null) {
            return this.functionCall.executeIndexedFunction(target, context, operator, right);
        }
        return null;
    }

    public boolean canExecuteIndexedFunctionWithoutIndex(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.functionCall == null) {
            return false;
        }
        return this.functionCall.canExecuteIndexedFunctionWithoutIndex(target, context, operator, right);
    }

    public boolean allowsIndexedFunctionExecutionOnTarget(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.functionCall == null) {
            return false;
        }
        return this.functionCall.allowsIndexedFunctionExecutionOnTarget(target, context, operator, right);
    }

    public boolean executeIndexedFunctionAfterIndexSearch(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.functionCall == null) {
            return false;
        }
        return this.functionCall.executeIndexedFunctionAfterIndexSearch(target, context, operator, right);
    }

    public boolean isExpand() {
        if (this.functionCall != null) {
            return this.functionCall.isExpand();
        }
        return false;
    }

    public OExpression getExpandContent() {
        if (this.functionCall.getParams().size() != 1) {
            throw new OCommandExecutionException("Invalid expand expression: " + this.functionCall.toString());
        }
        return this.functionCall.getParams().get(0);
    }

    public boolean needsAliases(Set<String> aliases) {
        if (this.functionCall != null && this.functionCall.needsAliases(aliases)) {
            return true;
        }
        return this.collection != null && this.collection.needsAliases(aliases);
    }

    public boolean isAggregate() {
        if (this.functionCall != null && this.functionCall.isAggregate()) {
            return true;
        }
        return this.collection != null && this.collection.isAggregate();
    }

    public boolean isCount() {
        return this.functionCall != null && this.functionCall.name.getStringValue().equalsIgnoreCase("count");
    }

    public boolean isEarlyCalculated(OCommandContext ctx) {
        if (this.functionCall != null && this.functionCall.isEarlyCalculated(ctx)) {
            return true;
        }
        if (Boolean.TRUE.equals(this.self)) {
            return false;
        }
        return this.collection != null && this.collection.isEarlyCalculated(ctx);
    }

    public SimpleNode splitForAggregation(AggregateProjectionSplit aggregateProj, OCommandContext ctx) {
        if (this.isAggregate()) {
            SimpleNode node;
            OLevelZeroIdentifier result = new OLevelZeroIdentifier(-1);
            if (this.functionCall != null) {
                node = this.functionCall.splitForAggregation(aggregateProj, ctx);
                if (!(node instanceof OFunctionCall)) {
                    return node;
                }
            } else {
                if (this.collection != null) {
                    result.collection = this.collection.splitForAggregation(aggregateProj, ctx);
                    return result;
                }
                throw new IllegalStateException();
            }
            result.functionCall = (OFunctionCall)node;
            return result;
        }
        return this;
    }

    public AggregationContext getAggregationContext(OCommandContext ctx) {
        if (this.isAggregate()) {
            OLevelZeroIdentifier result = new OLevelZeroIdentifier(-1);
            if (this.functionCall != null) {
                return this.functionCall.getAggregationContext(ctx);
            }
        }
        throw new OCommandExecutionException("cannot aggregate on " + this.toString());
    }

    @Override
    public OLevelZeroIdentifier copy() {
        OLevelZeroIdentifier result = new OLevelZeroIdentifier(-1);
        result.functionCall = this.functionCall == null ? null : this.functionCall.copy();
        result.self = this.self;
        result.collection = this.collection == null ? null : this.collection.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLevelZeroIdentifier that = (OLevelZeroIdentifier)o;
        if (this.functionCall != null ? !this.functionCall.equals(that.functionCall) : that.functionCall != null) {
            return false;
        }
        if (this.self != null ? !this.self.equals(that.self) : that.self != null) {
            return false;
        }
        return !(this.collection != null ? !this.collection.equals(that.collection) : that.collection != null);
    }

    public int hashCode() {
        int result = this.functionCall != null ? this.functionCall.hashCode() : 0;
        result = 31 * result + (this.self != null ? this.self.hashCode() : 0);
        result = 31 * result + (this.collection != null ? this.collection.hashCode() : 0);
        return result;
    }

    public void setCollection(OCollection collection) {
        this.collection = collection;
    }

    public boolean refersToParent() {
        if (this.functionCall != null && this.functionCall.refersToParent()) {
            return true;
        }
        return this.collection != null && this.collection.refersToParent();
    }

    public OFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public Boolean getSelf() {
        return this.self;
    }

    public OCollection getCollection() {
        return this.collection;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.functionCall != null) {
            result.setProperty("functionCall", this.functionCall.serialize());
        }
        result.setProperty("self", this.self);
        if (this.collection != null) {
            result.setProperty("collection", this.collection.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("functionCall") != null) {
            this.functionCall = new OFunctionCall(-1);
            this.functionCall.deserialize((OResult)fromResult.getProperty("functionCall"));
        }
        this.self = (Boolean)fromResult.getProperty("self");
        if (fromResult.getProperty("collection") != null) {
            this.collection = new OCollection(-1);
            this.collection.deserialize((OResult)fromResult.getProperty("collection"));
        }
    }

    public void extractSubQueries(OIdentifier letAlias, SubQueryCollector collector) {
        if (this.functionCall != null) {
            this.functionCall.extractSubQueries(letAlias, collector);
        }
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.functionCall != null) {
            this.functionCall.extractSubQueries(collector);
        }
    }

    public boolean isCacheable() {
        if (this.functionCall != null) {
            return this.functionCall.isCacheable();
        }
        if (this.collection != null) {
            return this.collection.isCacheable();
        }
        return false;
    }
}

