/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OIndexIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInsertBody;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.HashMap;
import java.util.Map;

public class OInsertStatement
extends OStatement {
    OIdentifier targetClass;
    OIdentifier targetClusterName;
    OCluster targetCluster;
    OIndexIdentifier targetIndex;
    OInsertBody insertBody;
    OProjection returnStatement;
    OSelectStatement selectStatement;
    boolean selectInParentheses = false;
    boolean selectWithFrom = false;
    boolean unsafe = false;

    public OInsertStatement(int id) {
        super(id);
    }

    public OInsertStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("INSERT INTO ");
        if (this.targetClass != null) {
            this.targetClass.toString(params, builder);
            if (this.targetClusterName != null) {
                builder.append(" CLUSTER ");
                this.targetClusterName.toString(params, builder);
            }
        }
        if (this.targetCluster != null) {
            this.targetCluster.toString(params, builder);
        }
        if (this.targetIndex != null) {
            this.targetIndex.toString(params, builder);
        }
        if (this.insertBody != null) {
            builder.append(" ");
            this.insertBody.toString(params, builder);
        }
        if (this.returnStatement != null) {
            builder.append(" RETURN ");
            this.returnStatement.toString(params, builder);
        }
        if (this.selectStatement != null) {
            builder.append(" ");
            if (this.selectWithFrom) {
                builder.append("FROM ");
            }
            if (this.selectInParentheses) {
                builder.append("(");
            }
            this.selectStatement.toString(params, builder);
            if (this.selectInParentheses) {
                builder.append(")");
            }
        }
        if (this.unsafe) {
            builder.append(" UNSAFE");
        }
    }

    @Override
    public OInsertStatement copy() {
        OInsertStatement result = new OInsertStatement(-1);
        result.targetClass = this.targetClass == null ? null : this.targetClass.copy();
        result.targetClusterName = this.targetClusterName == null ? null : this.targetClusterName.copy();
        result.targetCluster = this.targetCluster == null ? null : this.targetCluster.copy();
        result.targetIndex = this.targetIndex == null ? null : this.targetIndex.copy();
        result.insertBody = this.insertBody == null ? null : this.insertBody.copy();
        result.returnStatement = this.returnStatement == null ? null : this.returnStatement.copy();
        result.selectStatement = this.selectStatement == null ? null : this.selectStatement.copy();
        result.selectInParentheses = this.selectInParentheses;
        result.selectWithFrom = this.selectWithFrom;
        result.unsafe = this.unsafe;
        return result;
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OInsertExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OInsertExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OInsertExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OInsertExecutionPlanner planner = new OInsertExecutionPlanner(this);
        OInsertExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling);
        result.setStatement(this.originalStatement);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OInsertStatement that = (OInsertStatement)o;
        if (this.selectInParentheses != that.selectInParentheses) {
            return false;
        }
        if (this.selectWithFrom != that.selectWithFrom) {
            return false;
        }
        if (this.unsafe != that.unsafe) {
            return false;
        }
        if (this.targetClass != null ? !this.targetClass.equals(that.targetClass) : that.targetClass != null) {
            return false;
        }
        if (this.targetClusterName != null ? !this.targetClusterName.equals(that.targetClusterName) : that.targetClusterName != null) {
            return false;
        }
        if (this.targetCluster != null ? !this.targetCluster.equals(that.targetCluster) : that.targetCluster != null) {
            return false;
        }
        if (this.targetIndex != null ? !this.targetIndex.equals(that.targetIndex) : that.targetIndex != null) {
            return false;
        }
        if (this.insertBody != null ? !this.insertBody.equals(that.insertBody) : that.insertBody != null) {
            return false;
        }
        if (this.returnStatement != null ? !this.returnStatement.equals(that.returnStatement) : that.returnStatement != null) {
            return false;
        }
        return !(this.selectStatement != null ? !this.selectStatement.equals(that.selectStatement) : that.selectStatement != null);
    }

    public int hashCode() {
        int result = this.targetClass != null ? this.targetClass.hashCode() : 0;
        result = 31 * result + (this.targetClusterName != null ? this.targetClusterName.hashCode() : 0);
        result = 31 * result + (this.targetCluster != null ? this.targetCluster.hashCode() : 0);
        result = 31 * result + (this.targetIndex != null ? this.targetIndex.hashCode() : 0);
        result = 31 * result + (this.insertBody != null ? this.insertBody.hashCode() : 0);
        result = 31 * result + (this.returnStatement != null ? this.returnStatement.hashCode() : 0);
        result = 31 * result + (this.selectStatement != null ? this.selectStatement.hashCode() : 0);
        result = 31 * result + (this.selectInParentheses ? 1 : 0);
        result = 31 * result + (this.selectWithFrom ? 1 : 0);
        result = 31 * result + (this.unsafe ? 1 : 0);
        return result;
    }

    public OIdentifier getTargetClass() {
        return this.targetClass;
    }

    public OIdentifier getTargetClusterName() {
        return this.targetClusterName;
    }

    public OCluster getTargetCluster() {
        return this.targetCluster;
    }

    public OIndexIdentifier getTargetIndex() {
        return this.targetIndex;
    }

    public OInsertBody getInsertBody() {
        return this.insertBody;
    }

    public OProjection getReturnStatement() {
        return this.returnStatement;
    }

    public OSelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    public boolean isSelectInParentheses() {
        return this.selectInParentheses;
    }

    public boolean isSelectWithFrom() {
        return this.selectWithFrom;
    }

    public boolean isUnsafe() {
        return this.unsafe;
    }
}

