/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInsertSetExpression;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OInsertBody
extends SimpleNode {
    protected List<OIdentifier> identifierList;
    protected List<List<OExpression>> valueExpressions;
    protected List<OInsertSetExpression> setExpressions;
    protected OJson content;

    public OInsertBody(int id) {
        super(id);
    }

    public OInsertBody(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        boolean first;
        if (this.identifierList != null) {
            builder.append("(");
            first = true;
            for (OIdentifier oIdentifier : this.identifierList) {
                if (!first) {
                    builder.append(", ");
                }
                oIdentifier.toString(params, builder);
                first = false;
            }
            builder.append(") VALUES ");
            if (this.valueExpressions != null) {
                boolean firstList = true;
                for (List<OExpression> itemList : this.valueExpressions) {
                    if (firstList) {
                        builder.append("(");
                    } else {
                        builder.append("),(");
                    }
                    first = true;
                    for (OExpression item : itemList) {
                        if (!first) {
                            builder.append(", ");
                        }
                        item.toString(params, builder);
                        first = false;
                    }
                    firstList = false;
                }
            }
            builder.append(")");
        }
        if (this.setExpressions != null) {
            builder.append("SET ");
            first = true;
            for (OInsertSetExpression oInsertSetExpression : this.setExpressions) {
                if (!first) {
                    builder.append(", ");
                }
                oInsertSetExpression.toString(params, builder);
                first = false;
            }
        }
        if (this.content != null) {
            builder.append("CONTENT ");
            this.content.toString(params, builder);
        }
    }

    @Override
    public OInsertBody copy() {
        OInsertBody result = new OInsertBody(-1);
        result.identifierList = this.identifierList == null ? null : this.identifierList.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.valueExpressions = this.valueExpressions == null ? null : this.valueExpressions.stream().map(sub -> sub.stream().map(x -> x.copy()).collect(Collectors.toList())).collect(Collectors.toList());
        result.setExpressions = this.setExpressions == null ? null : this.setExpressions.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.content = this.content == null ? null : this.content.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OInsertBody that = (OInsertBody)o;
        if (this.identifierList != null ? !this.identifierList.equals(that.identifierList) : that.identifierList != null) {
            return false;
        }
        if (this.valueExpressions != null ? !this.valueExpressions.equals(that.valueExpressions) : that.valueExpressions != null) {
            return false;
        }
        if (this.setExpressions != null ? !this.setExpressions.equals(that.setExpressions) : that.setExpressions != null) {
            return false;
        }
        return !(this.content != null ? !this.content.equals(that.content) : that.content != null);
    }

    public int hashCode() {
        int result = this.identifierList != null ? this.identifierList.hashCode() : 0;
        result = 31 * result + (this.valueExpressions != null ? this.valueExpressions.hashCode() : 0);
        result = 31 * result + (this.setExpressions != null ? this.setExpressions.hashCode() : 0);
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        return result;
    }

    public List<OIdentifier> getIdentifierList() {
        return this.identifierList;
    }

    public List<List<OExpression>> getValueExpressions() {
        return this.valueExpressions;
    }

    public List<OInsertSetExpression> getSetExpressions() {
        return this.setExpressions;
    }

    public OJson getContent() {
        return this.content;
    }

    public boolean isCacheable() {
        if (this.valueExpressions != null) {
            for (List list : this.valueExpressions) {
                for (OExpression oExpression : list) {
                    if (oExpression.isCacheable()) continue;
                    return false;
                }
            }
        }
        if (this.setExpressions != null) {
            for (OInsertSetExpression oInsertSetExpression : this.setExpressions) {
                if (oInsertSetExpression.isCacheable()) continue;
                return false;
            }
        }
        return this.content == null || this.content.isCacheable();
    }
}

