/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.OCreateVertexExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInsertBody;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.HashMap;
import java.util.Map;

public class OCreateVertexStatement
extends OStatement {
    OIdentifier targetClass;
    OIdentifier targetClusterName;
    OCluster targetCluster;
    OProjection returnStatement;
    OInsertBody insertBody;

    public OCreateVertexStatement(int id) {
        super(id);
    }

    public OCreateVertexStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OInsertExecutionPlan executionPlan = (OInsertExecutionPlan)this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OInsertExecutionPlan executionPlan = (OInsertExecutionPlan)this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OInternalExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OCreateVertexExecutionPlanner planner = new OCreateVertexExecutionPlanner(this);
        OInsertExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling);
        result.setStatement(this.originalStatement);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE VERTEX ");
        if (this.targetClass != null) {
            this.targetClass.toString(params, builder);
            if (this.targetClusterName != null) {
                builder.append(" CLUSTER ");
                this.targetClusterName.toString(params, builder);
            }
        }
        if (this.targetCluster != null) {
            this.targetCluster.toString(params, builder);
        }
        if (this.returnStatement != null) {
            builder.append(" RETURN ");
            this.returnStatement.toString(params, builder);
        }
        if (this.insertBody != null) {
            if (this.targetClass != null || this.targetCluster != null || this.returnStatement != null) {
                builder.append(" ");
            }
            this.insertBody.toString(params, builder);
        }
    }

    @Override
    public OCreateVertexStatement copy() {
        OCreateVertexStatement result = null;
        try {
            result = (OCreateVertexStatement)this.getClass().getConstructor(Integer.TYPE).newInstance(-1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result.targetClass = this.targetClass == null ? null : this.targetClass.copy();
        result.targetClusterName = this.targetClusterName == null ? null : this.targetClusterName.copy();
        result.targetCluster = this.targetCluster == null ? null : this.targetCluster.copy();
        result.returnStatement = this.returnStatement == null ? null : this.returnStatement.copy();
        result.insertBody = this.insertBody == null ? null : this.insertBody.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateVertexStatement that = (OCreateVertexStatement)o;
        if (this.targetClass != null ? !this.targetClass.equals(that.targetClass) : that.targetClass != null) {
            return false;
        }
        if (this.targetClusterName != null ? !this.targetClusterName.equals(that.targetClusterName) : that.targetClusterName != null) {
            return false;
        }
        if (this.targetCluster != null ? !this.targetCluster.equals(that.targetCluster) : that.targetCluster != null) {
            return false;
        }
        if (this.returnStatement != null ? !this.returnStatement.equals(that.returnStatement) : that.returnStatement != null) {
            return false;
        }
        return !(this.insertBody != null ? !this.insertBody.equals(that.insertBody) : that.insertBody != null);
    }

    public int hashCode() {
        int result = this.targetClass != null ? this.targetClass.hashCode() : 0;
        result = 31 * result + (this.targetClusterName != null ? this.targetClusterName.hashCode() : 0);
        result = 31 * result + (this.targetCluster != null ? this.targetCluster.hashCode() : 0);
        result = 31 * result + (this.returnStatement != null ? this.returnStatement.hashCode() : 0);
        result = 31 * result + (this.insertBody != null ? this.insertBody.hashCode() : 0);
        return result;
    }

    public OIdentifier getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(OIdentifier targetClass) {
        this.targetClass = targetClass;
    }

    public OIdentifier getTargetClusterName() {
        return this.targetClusterName;
    }

    public void setTargetClusterName(OIdentifier targetClusterName) {
        this.targetClusterName = targetClusterName;
    }

    public OCluster getTargetCluster() {
        return this.targetCluster;
    }

    public void setTargetCluster(OCluster targetCluster) {
        this.targetCluster = targetCluster;
    }

    public OProjection getReturnStatement() {
        return this.returnStatement;
    }

    public void setReturnStatement(OProjection returnStatement) {
        this.returnStatement = returnStatement;
    }

    public OInsertBody getInsertBody() {
        return this.insertBody;
    }

    public void setInsertBody(OInsertBody insertBody) {
        this.insertBody = insertBody;
    }
}

