/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OBetweenCondition
extends OBooleanExpression {
    protected OExpression first;
    protected OExpression second;
    protected OExpression third;

    public OBetweenCondition(int id) {
        super(id);
    }

    public OBetweenCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        Object firstValue = this.first.execute(currentRecord, ctx);
        if (firstValue == null) {
            return false;
        }
        Object secondValue = this.second.execute(currentRecord, ctx);
        if (secondValue == null) {
            return false;
        }
        secondValue = OType.convert(secondValue, firstValue.getClass());
        Object thirdValue = this.third.execute(currentRecord, ctx);
        if (thirdValue == null) {
            return false;
        }
        thirdValue = OType.convert(thirdValue, firstValue.getClass());
        int leftResult = ((Comparable)firstValue).compareTo(secondValue);
        int rightResult = ((Comparable)firstValue).compareTo(thirdValue);
        return leftResult >= 0 && rightResult <= 0;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        Object firstValue = this.first.execute(currentRecord, ctx);
        if (firstValue == null) {
            return false;
        }
        Object secondValue = this.second.execute(currentRecord, ctx);
        if (secondValue == null) {
            return false;
        }
        secondValue = OType.convert(secondValue, firstValue.getClass());
        Object thirdValue = this.third.execute(currentRecord, ctx);
        if (thirdValue == null) {
            return false;
        }
        thirdValue = OType.convert(thirdValue, firstValue.getClass());
        int leftResult = ((Comparable)firstValue).compareTo(secondValue);
        int rightResult = ((Comparable)firstValue).compareTo(thirdValue);
        return leftResult >= 0 && rightResult <= 0;
    }

    public OExpression getFirst() {
        return this.first;
    }

    public void setFirst(OExpression first) {
        this.first = first;
    }

    public OExpression getSecond() {
        return this.second;
    }

    public void setSecond(OExpression second) {
        this.second = second;
    }

    public OExpression getThird() {
        return this.third;
    }

    public void setThird(OExpression third) {
        this.third = third;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.first.toString(params, builder);
        builder.append(" BETWEEN ");
        this.second.toString(params, builder);
        builder.append(" AND ");
        this.third.toString(params, builder);
    }

    @Override
    public boolean supportsBasicCalculation() {
        return true;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        return 0;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (this.first.needsAliases(aliases)) {
            return true;
        }
        if (this.second.needsAliases(aliases)) {
            return true;
        }
        return this.third.needsAliases(aliases);
    }

    @Override
    public OBooleanExpression copy() {
        OBetweenCondition result = new OBetweenCondition(-1);
        result.first = this.first.copy();
        result.second = this.second.copy();
        result.third = this.third.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.first.extractSubQueries(collector);
        this.second.extractSubQueries(collector);
        this.third.extractSubQueries(collector);
    }

    @Override
    public boolean refersToParent() {
        return this.first.refersToParent() || this.second.refersToParent() || this.third.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBetweenCondition that = (OBetweenCondition)o;
        if (this.first != null ? !this.first.equals(that.first) : that.first != null) {
            return false;
        }
        if (this.second != null ? !this.second.equals(that.second) : that.second != null) {
            return false;
        }
        return !(this.third != null ? !this.third.equals(that.third) : that.third != null);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        result = 31 * result + (this.third != null ? this.third.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> x = this.first.getMatchPatternInvolvedAliases();
        if (x != null) {
            result.addAll(x);
        }
        if ((x = this.second.getMatchPatternInvolvedAliases()) != null) {
            result.addAll(x);
        }
        if ((x = this.third.getMatchPatternInvolvedAliases()) != null) {
            result.addAll(x);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public void translateLuceneOperator() {
    }

    @Override
    public boolean isCacheable() {
        if (this.first != null && !this.first.isCacheable()) {
            return false;
        }
        if (this.second != null && !this.second.isCacheable()) {
            return false;
        }
        return this.third == null || this.third.isCacheable();
    }
}

