/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class OSQLFunctionDate
extends OSQLFunctionAbstract {
    public static final String NAME = "date";
    private Date date = new Date();
    private SimpleDateFormat format;

    public OSQLFunctionDate() {
        super(NAME, 0, 3);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (iParams.length == 0) {
            return this.date;
        }
        if (iParams[0] == null) {
            return null;
        }
        if (iParams[0] instanceof Number) {
            return new Date(((Number)iParams[0]).longValue());
        }
        if (this.format == null) {
            if (iParams.length > 1) {
                this.format = new SimpleDateFormat((String)iParams[1]);
                this.format.setTimeZone(ODateHelper.getDatabaseTimeZone());
            } else {
                this.format = ODatabaseRecordThreadLocal.instance().get().getStorage().getConfiguration().getDateTimeFormatInstance();
            }
            if (iParams.length == 3) {
                this.format.setTimeZone(TimeZone.getTimeZone(iParams[2].toString()));
            }
        }
        try {
            return this.format.parse((String)iParams[0]);
        }
        catch (ParseException e) {
            throw OException.wrapException(new OQueryParsingException("Error on formatting date '" + iParams[0] + "' using the format: " + this.format.toPattern()), e);
        }
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return false;
    }

    @Override
    public String getSyntax() {
        return "date([<date-as-string>] [,<format>] [,<timezone>])";
    }

    @Override
    public Object getResult() {
        this.format = null;
        return null;
    }
}

