/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.graph;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.functions.graph.HeuristicFormula;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public abstract class OSQLFunctionHeuristicPathFinderAbstract
extends OSQLFunctionMathAbstract {
    public static final String PARAM_DIRECTION = "direction";
    public static final String PARAM_EDGE_TYPE_NAMES = "edgeTypeNames";
    public static final String PARAM_VERTEX_AXIS_NAMES = "vertexAxisNames";
    public static final String PARAM_PARALLEL = "parallel";
    public static final String PARAM_MAX_DEPTH = "maxDepth";
    public static final String PARAM_HEURISTIC_FORMULA = "heuristicFormula";
    public static final String PARAM_CUSTOM_HEURISTIC_FORMULA = "customHeuristicFormula";
    public static final String PARAM_D_FACTOR = "dFactor";
    public static final String PARAM_TIE_BREAKER = "tieBreaker";
    public static final String PARAM_EMPTY_IF_MAX_DEPTH = "emptyIfMaxDepth";
    protected static Random rnd = new Random();
    protected Boolean paramParallel = false;
    protected Boolean paramTieBreaker = true;
    protected Boolean paramEmptyIfMaxDepth = false;
    protected String[] paramEdgeTypeNames = new String[0];
    protected String[] paramVertexAxisNames = new String[0];
    protected OVertex paramSourceVertex;
    protected OVertex paramDestinationVertex;
    protected HeuristicFormula paramHeuristicFormula = HeuristicFormula.MANHATAN;
    protected ODirection paramDirection = ODirection.OUT;
    protected long paramMaxDepth = Long.MAX_VALUE;
    protected double paramDFactor = 1.0;
    protected String paramCustomHeuristicFormula = "";
    protected OCommandContext context;
    protected List<OVertex> route = new LinkedList<OVertex>();
    protected static final float MIN = 0.0f;

    public OSQLFunctionHeuristicPathFinderAbstract(String iName, int iMinParams, int iMaxParams) {
        super(iName, iMinParams, iMaxParams);
    }

    public double gcdist(double lata, double longa, double latb, double longb) {
        double midlat = 0.5 * (lata + latb);
        double psi = 0.0174532925 * Math.sqrt(Math.pow(lata - latb, 2.0) + Math.pow((longa - longb) * Math.cos(0.0174532925 * midlat), 2.0));
        double dist = 6372.640112 * psi;
        return dist;
    }

    protected boolean isVariableEdgeWeight() {
        return false;
    }

    protected abstract double getDistance(OVertex var1, OVertex var2, OVertex var3);

    protected abstract double getHeuristicCost(OVertex var1, OVertex var2, OVertex var3, OCommandContext var4);

    protected LinkedList<OVertex> getPath() {
        LinkedList<OVertex> path = new LinkedList<OVertex>(this.route);
        return path;
    }

    protected Set<OVertex> getNeighbors(OVertex node) {
        this.context.incrementVariable("getNeighbors");
        HashSet<OVertex> neighbors = new HashSet<OVertex>();
        if (node != null) {
            for (OVertex v : node.getVertices(this.paramDirection, this.paramEdgeTypeNames)) {
                OVertex ov = v;
                if (ov == null) continue;
                neighbors.add(ov);
            }
        }
        return neighbors;
    }

    protected double getSimpleHeuristicCost(double x, double g, double dFactor) {
        double dx = Math.abs(x - g);
        return dFactor * dx;
    }

    protected double getManhatanHeuristicCost(double x, double y, double gx, double gy, double dFactor) {
        double dx = Math.abs(x - gx);
        double dy = Math.abs(y - gy);
        return dFactor * (dx + dy);
    }

    protected double getMaxAxisHeuristicCost(double x, double y, double gx, double gy, double dFactor) {
        double dx = Math.abs(x - gx);
        double dy = Math.abs(y - gy);
        return dFactor * Math.max(dx, dy);
    }

    protected double getDiagonalHeuristicCost(double x, double y, double gx, double gy, double dFactor) {
        double dx = Math.abs(x - gx);
        double dy = Math.abs(y - gy);
        double h_diagonal = Math.min(dx, dy);
        double h_straight = dx + dy;
        return dFactor * 2.0 * h_diagonal + dFactor * (h_straight - 2.0 * h_diagonal);
    }

    protected double getEuclideanHeuristicCost(double x, double y, double gx, double gy, double dFactor) {
        double dx = Math.abs(x - gx);
        double dy = Math.abs(y - gy);
        return dFactor * Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
    }

    protected double getEuclideanNoSQRHeuristicCost(double x, double y, double gx, double gy, double dFactor) {
        double dx = Math.abs(x - gx);
        double dy = Math.abs(y - gy);
        return dFactor * (Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
    }

    protected double getCustomHeuristicCost(String functionName, String[] vertextAxisNames, OVertex start, OVertex goal, OVertex current, OVertex parent, long depth, double dFactor, OCommandContext ctx) {
        double heuristic = 0.0;
        OFunction func = ctx.getDatabase().getMetadata().getFunctionLibrary().getFunction(functionName);
        Object fValue = func.executeInContext(this.context, vertextAxisNames, start, goal, current, parent, depth, dFactor);
        if (fValue != null && fValue instanceof Number) {
            heuristic = this.doubleOrDefault(fValue, heuristic);
        }
        return heuristic;
    }

    protected double getTieBreakingHeuristicCost(double x, double y, double sx, double sy, double gx, double gy, double heuristic) {
        double dx1 = x - gx;
        double dy1 = y - gy;
        double dx2 = sx - gx;
        double dy2 = sy - gy;
        double cross = Math.abs(dx1 * dy2 - dx2 * dy1);
        return heuristic += cross * 1.0E-4;
    }

    protected double getTieBreakingRandomHeuristicCost(double x, double y, double sx, double sy, double gx, double gy, double heuristic) {
        double dx1 = x - gx;
        double dy1 = y - gy;
        double dx2 = sx - gx;
        double dy2 = sy - gy;
        double cross = Math.abs(dx1 * dy2 - dx2 * dy1) + (double)rnd.nextFloat();
        heuristic += cross * heuristic;
        return heuristic;
    }

    protected double getManhatanHeuristicCost(String[] axisNames, Map<String, Double> slist, Map<String, Double> clist, Map<String, Double> plist, Map<String, Double> glist, long depth, double dFactor) {
        Double heuristic = 0.0;
        double res = 0.0;
        for (String str : axisNames) {
            res += Math.abs((clist.get(str) != null ? clist.get(str) : 0.0) - (glist.get(str) != null ? glist.get(str) : 0.0));
        }
        heuristic = dFactor * res;
        return heuristic;
    }

    protected double getMaxAxisHeuristicCost(String[] axisNames, Map<String, Double> slist, Map<String, Double> clist, Map<String, Double> plist, Map<String, Double> glist, long depth, double dFactor) {
        Double heuristic = 0.0;
        double res = 0.0;
        for (String str : axisNames) {
            res = Math.max(Math.abs((clist.get(str) != null ? clist.get(str) : 0.0) - (glist.get(str) != null ? glist.get(str) : 0.0)), res);
        }
        heuristic = dFactor * res;
        return heuristic;
    }

    protected double getDiagonalHeuristicCost(String[] axisNames, Map<String, Double> slist, Map<String, Double> clist, Map<String, Double> plist, Map<String, Double> glist, long depth, double dFactor) {
        Double heuristic = 0.0;
        double h_diagonal = 0.0;
        double h_straight = 0.0;
        for (String str : axisNames) {
            h_diagonal = Math.min(Math.abs((clist.get(str) != null ? clist.get(str) : 0.0) - (glist.get(str) != null ? glist.get(str) : 0.0)), h_diagonal);
            h_straight += Math.abs((clist.get(str) != null ? clist.get(str) : 0.0) - (glist.get(str) != null ? glist.get(str) : 0.0));
        }
        heuristic = dFactor * 2.0 * h_diagonal + dFactor * (h_straight - 2.0 * h_diagonal);
        return heuristic;
    }

    protected double getEuclideanHeuristicCost(String[] axisNames, Map<String, Double> slist, Map<String, Double> clist, Map<String, Double> plist, Map<String, Double> glist, long depth, double dFactor) {
        Double heuristic = 0.0;
        double res = 0.0;
        for (String str : axisNames) {
            res += Math.pow(Math.abs((clist.get(str) != null ? clist.get(str) : 0.0) - (glist.get(str) != null ? glist.get(str) : 0.0)), 2.0);
        }
        heuristic = Math.sqrt(res);
        return heuristic;
    }

    protected double getEuclideanNoSQRHeuristicCost(String[] axisNames, Map<String, Double> slist, Map<String, Double> clist, Map<String, Double> plist, Map<String, Double> glist, long depth, double dFactor) {
        Double heuristic = 0.0;
        double res = 0.0;
        for (String str : axisNames) {
            res += Math.pow(Math.abs((clist.get(str) != null ? clist.get(str) : 0.0) - (glist.get(str) != null ? glist.get(str) : 0.0)), 2.0);
        }
        heuristic = dFactor * res;
        return heuristic;
    }

    protected double getTieBreakingHeuristicCost(String[] axisNames, Map<String, Double> slist, Map<String, Double> clist, Map<String, Double> plist, Map<String, Double> glist, long depth, double heuristic) {
        double res = 0.0;
        for (String str : axisNames) {
            res += Math.abs((clist.get(str) != null ? clist.get(str) : 0.0) - (glist.get(str) != null ? glist.get(str) : 0.0));
        }
        double cross = res;
        return heuristic += cross * 1.0E-4;
    }

    protected String[] stringArray(Object fromObject) {
        if (fromObject == null) {
            return new String[0];
        }
        if (fromObject instanceof String) {
            String[] arr = fromObject.toString().replace("},{", " ,").split(",");
            return arr;
        }
        if (fromObject instanceof Object) {
            return (String[])fromObject;
        }
        return new String[0];
    }

    protected Boolean booleanOrDefault(Object fromObject, boolean defaultValue) {
        if (fromObject == null) {
            return defaultValue;
        }
        if (fromObject instanceof Boolean) {
            return (Boolean)fromObject;
        }
        if (fromObject instanceof String) {
            return Boolean.parseBoolean((String)fromObject);
        }
        return defaultValue;
    }

    protected String stringOrDefault(Object fromObject, String defaultValue) {
        if (fromObject == null) {
            return defaultValue;
        }
        return (String)fromObject;
    }

    protected Integer integerOrDefault(Object fromObject, int defaultValue) {
        if (fromObject == null) {
            return defaultValue;
        }
        if (fromObject instanceof Number) {
            return ((Number)fromObject).intValue();
        }
        if (fromObject instanceof String) {
            try {
                return Integer.parseInt(fromObject.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected Long longOrDefault(Object fromObject, long defaultValue) {
        if (fromObject == null) {
            return defaultValue;
        }
        if (fromObject instanceof Number) {
            return ((Number)fromObject).longValue();
        }
        if (fromObject instanceof String) {
            try {
                return Long.parseLong(fromObject.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected Double doubleOrDefault(Object fromObject, double defaultValue) {
        if (fromObject == null) {
            return defaultValue;
        }
        if (fromObject instanceof Number) {
            return ((Number)fromObject).doubleValue();
        }
        if (fromObject instanceof String) {
            try {
                return Double.parseDouble(fromObject.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

