/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.conversion;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.text.ParseException;
import java.util.Date;

public class OSQLMethodAsDate
extends OAbstractSQLMethod {
    public static final String NAME = "asdate";

    public OSQLMethodAsDate() {
        super(NAME, 0, 0);
    }

    @Override
    public String getSyntax() {
        return "asDate()";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iThis != null) {
            if (iThis instanceof Date) {
                return iThis;
            }
            if (iThis instanceof Number) {
                return new Date(((Number)iThis).longValue());
            }
            try {
                return ODatabaseRecordThreadLocal.instance().get().getStorage().getConfiguration().getDateFormatInstance().parse(iThis.toString());
            }
            catch (ParseException e) {
                OLogManager.instance().error(this, "Error during %s execution", e, NAME);
            }
        }
        return null;
    }
}

