/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.traverse.OTraverseRecordProcess;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionConfigurableAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class OSQLFunctionTraversedElement
extends OSQLFunctionConfigurableAbstract {
    public static final String NAME = "traversedElement";

    public OSQLFunctionTraversedElement() {
        super(NAME, 1, 2);
    }

    public OSQLFunctionTraversedElement(String name) {
        super(name, 1, 2);
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public boolean filterResult() {
        return true;
    }

    @Override
    public String getSyntax() {
        return this.getName() + "(<beginIndex> [,<items>])";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        return this.evaluate(iThis, iParams, iContext, null);
    }

    protected Object evaluate(Object iThis, Object[] iParams, OCommandContext iContext, String iClassName) {
        ArrayList<OIdentifiable> result;
        int beginIndex = (Integer)iParams[0];
        int items = iParams.length > 1 ? (Integer)iParams[1] : 1;
        Collection stack = (Collection)iContext.getVariable("stack");
        if (stack == null && iThis instanceof OResult) {
            stack = (Collection)((OResult)iThis).getMetadata("$stack");
        }
        if (stack == null) {
            throw new OCommandExecutionException("Cannot invoke " + this.getName() + "() against non traverse command");
        }
        ArrayList<OIdentifiable> arrayList = result = items > 1 ? new ArrayList<OIdentifiable>(items) : null;
        if (beginIndex < 0) {
            int i = -1;
            for (Object o : stack) {
                OIdentifiable record;
                if (o instanceof OTraverseRecordProcess) {
                    record = (OIdentifiable)((OTraverseRecordProcess)o).getTarget();
                    if (iClassName != null && !ODocumentInternal.getImmutableSchemaClass((ODocument)record.getRecord()).isSubClassOf(iClassName)) continue;
                    if (i <= beginIndex) {
                        if (items == 1) {
                            return record;
                        }
                        result.add(record);
                        if (result.size() >= items) break;
                    }
                    --i;
                    continue;
                }
                if (!(o instanceof OIdentifiable)) continue;
                record = (OIdentifiable)o;
                if (iClassName != null && !ODocumentInternal.getImmutableSchemaClass((ODocument)record.getRecord()).isSubClassOf(iClassName)) continue;
                if (i <= beginIndex) {
                    if (items == 1) {
                        return record;
                    }
                    result.add(record);
                    if (result.size() >= items) break;
                }
                --i;
            }
        } else {
            int i = 0;
            List listStack = this.stackToList(stack);
            for (int x = listStack.size(); x >= 0; --x) {
                OIdentifiable record;
                Object o = listStack.get(x);
                if (o instanceof OTraverseRecordProcess) {
                    record = (OIdentifiable)((OTraverseRecordProcess)o).getTarget();
                    if (iClassName != null && !ODocumentInternal.getImmutableSchemaClass((ODocument)record.getRecord()).isSubClassOf(iClassName)) continue;
                    if (i >= beginIndex) {
                        if (items == 1) {
                            return record;
                        }
                        result.add(record);
                        if (result.size() >= items) break;
                    }
                    ++i;
                    continue;
                }
                if (!(o instanceof OIdentifiable)) continue;
                record = (OIdentifiable)o;
                if (iClassName != null && !ODocumentInternal.getImmutableSchemaClass((ODocument)record.getRecord()).isSubClassOf(iClassName)) continue;
                if (i >= beginIndex) {
                    if (items == 1) {
                        return record;
                    }
                    result.add(record);
                    if (result.size() >= items) break;
                }
                ++i;
            }
        }
        if (items > 0 && result != null && !result.isEmpty()) {
            return result;
        }
        return null;
    }

    private List stackToList(Collection stack) {
        if (stack instanceof List) {
            return (List)stack;
        }
        return stack.stream().collect(Collectors.toList());
    }
}

